/*
 * Decompiled with CFR 0.152.
 */
package aadl;

import aadl.ImportUtility;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import uk.ac.reload.dweezil.gui.ErrorDialogBox;
import uk.ac.reload.dweezil.gui.ReloadProgressMonitor;
import uk.ac.reload.dweezil.util.ReloadUtils;
import uk.ac.reload.editor.ReloadEditor;
import uk.ac.reload.editor.ReloadEditorException;
import uk.ac.reload.editor.contentpackaging.ContentPackage;

public class ZiptoView {
    public static File askFileNameSave() {
        String string = ImportUtility.getValue("temp");
        String string2 = string + "\\reload\\course";
        File file = new File(string2 + ".zip");
        return file;
    }

    public static void zipContentPackage(ContentPackage contentPackage, File file) throws ReloadEditorException {
        try {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            ZipOutputStream zipOutputStream = new ZipOutputStream(bufferedOutputStream);
            ZiptoView.addFolderToZip(contentPackage.getProjectFolder(), contentPackage.getProjectFolder(), zipOutputStream, file);
            zipOutputStream.flush();
            zipOutputStream.close();
        }
        catch (Exception exception) {
            throw new ReloadEditorException("Could not zip");
        }
    }

    public static void addFolderToZip(File file, File file2, ZipOutputStream zipOutputStream, File file3) throws ReloadEditorException {
        File[] fileArray = file2.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i].isDirectory()) {
                ZiptoView.addFolderToZip(file, fileArray[i], zipOutputStream, file3);
                continue;
            }
            if (fileArray[i].equals(file3)) continue;
            String string = ReloadUtils.getRelativePath(file, fileArray[i]);
            ZiptoView.addFileToZip(fileArray[i], string, zipOutputStream);
        }
    }

    public static boolean addFileToZip(File file, String string, ZipOutputStream zipOutputStream) throws ReloadEditorException {
        if (file == null || !file.exists()) {
            return false;
        }
        byte[] byArray = new byte[1024];
        try {
            int n;
            ZipEntry zipEntry = new ZipEntry(string);
            zipEntry.setTime(file.lastModified());
            zipOutputStream.putNextEntry(zipEntry);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file), 1024);
            while ((n = bufferedInputStream.read(byArray)) != -1) {
                zipOutputStream.write(byArray, 0, n);
            }
            zipOutputStream.closeEntry();
            bufferedInputStream.close();
        }
        catch (Exception exception) {
            if (ReloadEditor.DEBUG) {
                exception.printStackTrace();
            }
            throw new ReloadEditorException("Could not add file to zip");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zipViewFile(ContentPackage contentPackage) {
        if (contentPackage != null) {
            ReloadProgressMonitor reloadProgressMonitor = null;
            try {
                File file = ZiptoView.askFileNameSave();
                if (file != null) {
                    reloadProgressMonitor = new ReloadProgressMonitor(ReloadEditor.getInstance(), "Zip Content Package", "Zipping...", "", true, null);
                    ZiptoView.zipContentPackage(contentPackage, file);
                }
            }
            catch (ReloadEditorException reloadEditorException) {
                if (ReloadEditor.DEBUG) {
                    reloadEditorException.printStackTrace();
                }
                ErrorDialogBox.showWarning("Zip Content Package", "Error zipping Package", reloadEditorException);
            }
            finally {
                if (reloadProgressMonitor != null) {
                    reloadProgressMonitor.close();
                }
            }
        }
    }
}

