/*
 * Decompiled with CFR 0.152.
 */
package net.cnri.simplexml;

import java.util.Vector;

public abstract class XUtil {
    private static final char[] HEX_VALUES = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static final String encodeString(String str) {
        StringBuffer sb = new StringBuffer();
        int n = str.length();
        for (int i = 0; i < n; ++i) {
            char ch = str.charAt(i);
            if (ch == '&') {
                sb.append("&amp;");
                continue;
            }
            if (ch == '<') {
                sb.append("&lt;");
                continue;
            }
            if (ch == '>') {
                sb.append("&gt;");
                continue;
            }
            if (ch >= '\u00ff') {
                sb.append("&#");
                sb.append((int)ch);
                sb.append(';');
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    public static final String decodeString(String str) {
        StringBuffer sb = new StringBuffer();
        int n = str.length();
        for (int i = 0; i < n; ++i) {
            char ch = str.charAt(i);
            if (ch == '&') {
                String entity = XUtil.readEntity(str, i);
                i += entity.length() - 1;
                sb.append(XUtil.decodeEntity(entity));
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    private static String decodeEntity(String entity) {
        String upper = entity.toUpperCase();
        if (upper.equals("&AMP;")) {
            return "&";
        }
        if (upper.equals("&LT;")) {
            return "<";
        }
        if (upper.equals("&GT;")) {
            return ">";
        }
        if (entity.startsWith("&#")) {
            try {
                return String.valueOf((char)Integer.parseInt(entity.substring(2, entity.length() - 1)));
            }
            catch (Exception e) {
                System.err.println("Error: invalid character encoding: " + entity.substring(2));
            }
        }
        System.err.println("Error: unidentified entity: " + entity);
        return entity;
    }

    private static String readEntity(String str, int index) {
        int eIndex;
        for (eIndex = index + 1; eIndex < str.length() && str.charAt(eIndex) != ';'; ++eIndex) {
        }
        eIndex = Math.min(str.length() - 1, eIndex);
        return str.substring(index, eIndex + 1);
    }

    public static final String encodeHex(byte[] buf, boolean breaklines) {
        if (buf == null || buf.length <= 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < buf.length; ++i) {
            if (breaklines && i > 0 && i % 16 == 0) {
                sb.append('\n');
            }
            sb.append(HEX_VALUES[(buf[i] & 0xF0) >>> 4]);
            sb.append(HEX_VALUES[buf[i] & 0xF]);
        }
        return sb.toString();
    }

    public static final byte[] decodeHex(String s) {
        int i;
        s = s.toUpperCase();
        byte[] buf = new byte[s.length() / 2 + 1];
        for (i = 0; i < buf.length; ++i) {
            buf[i] = 0;
        }
        i = 0;
        boolean lowNibble = false;
        for (int c = 0; c < s.length(); ++c) {
            char ch = s.charAt(c);
            if (ch >= '0' && ch <= '9') {
                if (lowNibble) {
                    int n = i++;
                    buf[n] = (byte)(buf[n] | ch - 48);
                } else {
                    buf[i] = (byte)(ch - 48 << 4);
                }
                lowNibble = !lowNibble;
                continue;
            }
            if (ch < 'A' || ch > 'F') continue;
            if (lowNibble) {
                int n = i++;
                buf[n] = (byte)(buf[n] | ch - 65 + 10);
            } else {
                buf[i] = (byte)(ch - 65 + 10 << 4);
            }
            lowNibble = !lowNibble;
        }
        byte[] realBuf = !lowNibble ? new byte[i] : new byte[i + 1];
        System.arraycopy(buf, 0, realBuf, 0, realBuf.length);
        return realBuf;
    }

    public static final String[] split(String str, char splitChar) {
        int numTokens = 0;
        int idx = -1;
        do {
            idx = str.indexOf(splitChar, idx + 1);
            ++numTokens;
        } while (idx >= 0);
        String[] tokens = new String[numTokens];
        idx = -1;
        for (int i = 0; i < numTokens; ++i) {
            int nidx = str.indexOf(splitChar, idx + 1);
            tokens[i] = nidx >= 0 ? str.substring(idx + 1, nidx) : str.substring(idx + 1);
            idx = nidx;
        }
        return tokens;
    }

    public static final String[] vectorToStringArray(Vector v) {
        String[] a = new String[v.size()];
        for (int i = 0; i < a.length; ++i) {
            a[i] = String.valueOf(v.elementAt(i));
        }
        return a;
    }

    public static final String getNLengthString(int width, char fillChar) {
        StringBuffer sb = new StringBuffer("");
        for (int i = 0; i < width; ++i) {
            sb.append(fillChar);
        }
        return sb.toString();
    }

    public static final String fillLeft(String str, int width, char fillChar) {
        if (str == null) {
            return XUtil.getNLengthString(width, fillChar);
        }
        int strLen = str.length();
        if (strLen >= width) {
            return str.substring(0, width);
        }
        return XUtil.getNLengthString(width - strLen, fillChar) + str;
    }

    public static final String fillRight(String str, int width, char fillChar) {
        if (str == null) {
            return XUtil.getNLengthString(width, fillChar);
        }
        int strLen = str.length();
        if (strLen >= width) {
            return str.substring(0, width);
        }
        return str + XUtil.getNLengthString(width - strLen, fillChar);
    }

    public static final String fieldIndex(String str, char delimiter, int n) {
        int thisIndex;
        int delimLoc = str.indexOf(delimiter);
        int currentField = 0;
        int lastIndex = 0;
        int strLen = str.length();
        String val = "";
        do {
            if (currentField == n) {
                thisIndex = str.indexOf(delimiter, lastIndex);
                if (thisIndex >= 0) {
                    return str.substring(lastIndex, thisIndex);
                }
                return str.substring(lastIndex, strLen);
            }
            thisIndex = str.indexOf(delimiter, lastIndex);
            if (thisIndex < 0) {
                return "";
            }
            ++currentField;
        } while ((lastIndex = thisIndex + 1) < strLen);
        return "";
    }

    public static final int countFields(String str, char delimiter) {
        if (str == null) {
            return 0;
        }
        int count = 0;
        int idx = -1;
        do {
            ++count;
        } while ((idx = str.indexOf(delimiter, idx + 1)) >= 0);
        return count;
    }

    public static final void sortStringArray(String[] array) {
        XUtil.quicksortAscending(array, 0, array.length - 1);
    }

    private static final void quicksortAscending(String[] array, int first, int last) {
        if (first < last) {
            int piv_index = XUtil.partitionAscending(array, first, last);
            XUtil.quicksortAscending(array, first, piv_index - 1);
            XUtil.quicksortAscending(array, piv_index, last);
        }
    }

    private static final int partitionAscending(String[] array, int first, int last) {
        String pivot = array[(first + last) / 2];
        while (first <= last) {
            while (array[first].compareTo(pivot) < 0) {
                ++first;
            }
            while (array[last].compareTo(pivot) > 0) {
                --last;
            }
            if (first > last) continue;
            String temp = array[first];
            array[first] = array[last];
            array[last] = temp;
            ++first;
            --last;
        }
        return first;
    }

    public static final String stripNonNumbers(String str, char decimalChar) {
        StringBuffer sb = new StringBuffer("");
        int len = str.length();
        boolean gotDec = false;
        boolean firstChar = true;
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (ch >= '0' && ch <= '9') {
                sb.append(ch);
                firstChar = false;
                continue;
            }
            if (ch == decimalChar && !gotDec) {
                gotDec = true;
                sb.append(ch);
                firstChar = false;
                continue;
            }
            if (ch != '-' || !firstChar) continue;
            sb.append(ch);
            firstChar = false;
        }
        return sb.toString();
    }

    public static final boolean isInteger(String str) {
        if ((str = str.trim()).length() <= 0) {
            return false;
        }
        for (int i = str.length() - 1; i >= 0; --i) {
            char ch = str.charAt(i);
            if (ch >= '0' && ch <= '9') continue;
            return false;
        }
        return true;
    }

    public static final boolean isAllNumber(String str) {
        int sz = str.length();
        for (int i = str.length() - 1; i >= 0; --i) {
            char ch = str.charAt(i);
            if (ch >= '0' && ch <= '9') continue;
            return false;
        }
        return sz > 0;
    }

    public static final String decodeURL(String str) {
        StringBuffer sb = new StringBuffer();
        int strLen = str.length();
        block6: for (int i = 0; i < strLen; ++i) {
            char ch = str.charAt(i);
            switch (ch) {
                case '+': {
                    sb.append(' ');
                    continue block6;
                }
                case '%': {
                    if (ch + 2 < strLen) {
                        try {
                            ch = (char)Integer.parseInt(str.substring(i + 1, i + 3), 16);
                            sb.append(ch);
                            i += 2;
                            continue block6;
                        }
                        catch (NumberFormatException e) {
                            // empty catch block
                        }
                    }
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }

    public static final String decode(String str) {
        int len = str.length();
        StringBuffer sb = new StringBuffer(str.length());
        for (int currPos = 0; currPos < len; ++currPos) {
            char ch = str.charAt(currPos);
            if (ch == '\\') {
                if (++currPos >= len) {
                    sb.append(ch);
                    break;
                }
                ch = str.charAt(currPos);
                if (ch == 'n') {
                    sb.append('\n');
                    continue;
                }
                if (ch == 't') {
                    sb.append('\t');
                    continue;
                }
                sb.append(ch);
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    public static final String encode(String str) {
        StringBuffer sb = new StringBuffer("");
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (ch == '\t') {
                sb.append("\\t");
                continue;
            }
            if (ch == '\n') {
                sb.append("\\n");
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    public static final String makeFileName(String str) {
        StringBuffer sb = new StringBuffer("");
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z' || ch >= '0' && ch <= '9' || ch == '.' || ch == '_') {
                sb.append(ch);
                continue;
            }
            sb.append('_');
        }
        return sb.toString();
    }

    private static boolean isOperator(Object o) {
        return o instanceof Character;
    }
}

