/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.simple;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.security.PrivateKey;
import net.handle.hdllib.AbstractResponse;
import net.handle.hdllib.AuthenticationInfo;
import net.handle.hdllib.HandleResolver;
import net.handle.hdllib.HandleValue;
import net.handle.hdllib.ModifyValueRequest;
import net.handle.hdllib.PublicKeyAuthenticationInfo;
import net.handle.hdllib.ResolutionRequest;
import net.handle.hdllib.ResolutionResponse;
import net.handle.hdllib.Util;

public class HDLSetTTL {
    public static void main(String[] argv) throws Exception {
        String hdl;
        if (argv.length < 4) {
            System.err.println("usage: java net.handle.apps.simple.HDLSetTTL <auth handle> <privkey> <new TTL> <handle file>");
            System.exit(-1);
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            int r;
            FileInputStream fs = new FileInputStream(new File(argv[1]));
            byte[] buf = new byte[1024];
            while ((r = fs.read(buf)) >= 0) {
                bout.write(buf, 0, r);
            }
        }
        catch (Throwable t) {
            System.err.println("Cannot read private key " + argv[1] + ": " + t);
            System.exit(-1);
        }
        byte[] key = bout.toByteArray();
        PrivateKey privkey = null;
        byte[] secKey = null;
        try {
            if (Util.requiresSecretKey(key)) {
                secKey = Util.getPassphrase("passphrase: ");
            }
            key = Util.decrypt(key, secKey);
            privkey = Util.getPrivateKeyFromBytes(key, 0);
        }
        catch (Throwable t) {
            System.err.println("Can't load private key in " + argv[1] + ": " + t);
            System.exit(-1);
        }
        PublicKeyAuthenticationInfo auth = new PublicKeyAuthenticationInfo(Util.encodeString(argv[0]), 300, privkey);
        int newTTL = Integer.parseInt(argv[2].trim());
        HandleResolver resolver = new HandleResolver();
        BufferedReader rdr = new BufferedReader(new FileReader(new File(argv[3])));
        while ((hdl = rdr.readLine()) != null) {
            if ((hdl = hdl.trim()).length() <= 0) continue;
            ResolutionRequest rreq = new ResolutionRequest(Util.encodeString(hdl), null, null, null);
            rreq.authoritative = true;
            AbstractResponse rresp = resolver.processRequest(rreq);
            Object servHdlvalue = null;
            HandleValue[] values = null;
            if (rresp != null && rresp instanceof ResolutionResponse) {
                values = ((ResolutionResponse)rresp).getHandleValues();
                for (int i = 0; values != null && i < values.length; ++i) {
                    if (values[i] == null) continue;
                    values[i].setTTL(newTTL);
                }
            } else {
                System.err.println("Error response for hdl '" + hdl + "': " + rresp);
                continue;
            }
            ModifyValueRequest modreq = new ModifyValueRequest(rreq.handle, values, (AuthenticationInfo)auth);
            AbstractResponse modresp = resolver.processRequest(modreq);
            if (modresp != null && modresp.responseCode == 1) {
                System.err.println("success: changed " + hdl);
                continue;
            }
            System.err.println("Error modifying handle '" + hdl + "': " + modresp);
        }
    }
}

