/*
 * Decompiled with CFR 0.152.
 */
package net.handle.hdllib;

import java.security.PublicKey;
import net.handle.hdllib.AbstractMessage;
import net.handle.hdllib.AuthenticationInfo;
import net.handle.hdllib.ClientSessionTracker;
import net.handle.hdllib.ClientSideSessionInfo;
import net.handle.hdllib.NamespaceInfo;
import net.handle.hdllib.Util;

public abstract class AbstractRequest
extends AbstractMessage {
    public byte[] handle;
    public boolean isAdminRequest = false;
    public boolean requiresConnection = false;
    public AuthenticationInfo authInfo = null;
    public int siteInfoSerial = -1;
    public ClientSideSessionInfo sessionInfo = null;
    public ClientSessionTracker sessionTracker = null;
    byte[] serverPubKeyBytes = null;
    PublicKey serverPubKey = null;
    public boolean streaming = false;
    private NamespaceInfo namespace = null;

    public AbstractRequest(byte[] handle, int opCode, AuthenticationInfo authInfo) {
        super(opCode);
        this.authInfo = authInfo;
        this.handle = handle;
        this.responseCode = 0;
    }

    public NamespaceInfo getNamespace() {
        return this.namespace;
    }

    public void setNamespace(NamespaceInfo namespace) {
        if (namespace != null) {
            namespace.setParentNamespace(this.namespace);
        }
        this.namespace = namespace;
    }

    public void clearBuffers() {
        this.namespace = null;
        super.clearBuffers();
    }

    public String toString() {
        return super.toString() + (this.isAdminRequest ? " adm" : "") + ' ' + Util.decodeString(this.handle);
    }
}

