/*
 * Decompiled with CFR 0.152.
 */
package net.handle.hdllib;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import net.handle.hdllib.AbstractResponse;
import net.handle.hdllib.Common;
import net.handle.hdllib.Encoder;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.HandleResolver;
import net.handle.hdllib.HandleValue;
import net.handle.hdllib.NamespaceInfo;
import net.handle.hdllib.ResolutionRequest;
import net.handle.hdllib.ResolutionResponse;
import net.handle.hdllib.RootInfoListener;
import net.handle.hdllib.SiteInfo;
import net.handle.hdllib.Util;

public class Configuration {
    private static Configuration defaultConfig = null;
    public static final int RM_GLOBAL = 0;
    public static final int RM_WITH_CACHE = 1;
    private HandleValue[] globalValues;
    private HandleValue[] cacheValues;
    private SiteInfo[] globalSites;
    private NamespaceInfo globalNamespace;
    private SiteInfo[] cacheSites;
    private HashMap localSites;
    private HashMap localAddresses;
    private int resolutionMethod;
    private boolean autoRefreshRootInfo;
    private File configDir;
    private File userDir;
    private File globalValuesFile;
    private boolean updatingRootInfo;
    private Vector rootInfoNotifications;

    public static final synchronized Configuration defaultConfiguration() {
        if (defaultConfig == null) {
            defaultConfig = new Configuration();
        }
        return defaultConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Configuration() {
        File localAddressesFile;
        block68: {
            InputStream in;
            block67: {
                block66: {
                    this.globalValues = null;
                    this.cacheValues = null;
                    this.globalSites = null;
                    this.globalNamespace = null;
                    this.cacheSites = null;
                    this.localSites = null;
                    this.localAddresses = null;
                    this.resolutionMethod = 0;
                    this.autoRefreshRootInfo = true;
                    this.configDir = null;
                    this.userDir = null;
                    this.globalValuesFile = null;
                    this.updatingRootInfo = false;
                    this.rootInfoNotifications = null;
                    try {
                        this.configDir = new File(".");
                        String userDirName = System.getProperty("user.home");
                        this.userDir = userDirName == null ? new File(System.getProperty("user.dir", File.separator)) : new File(userDirName);
                        this.configDir = new File(this.userDir, ".handle");
                        this.configDir.mkdirs();
                        this.globalValuesFile = new File(this.configDir, "root_info");
                        if (this.globalValuesFile.exists() && this.globalValuesFile.canRead()) {
                            in = new FileInputStream(this.globalValuesFile);
                            this.setGlobalValues(Encoder.decodeGlobalValues(in));
                            try {
                                ((FileInputStream)in).close();
                            }
                            catch (Exception e) {}
                        } else {
                            in = this.getClass().getResourceAsStream("/net/handle/etc/root_info");
                            this.setGlobalValues(Encoder.decodeGlobalValues(in));
                            try {
                                in.close();
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                        }
                        SiteInfo[] newSites = Util.getSitesFromValues(this.globalValues);
                        if (newSites != null) {
                            this.globalSites = newSites;
                            for (int i = this.globalSites.length - 1; i >= 0; --i) {
                                this.globalSites[i].isRoot = true;
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace(System.err);
                        System.err.println("Had trouble finding your \"home\" directory and/or your configuration settings.  Will use \"" + this.configDir + ".\"  ");
                    }
                    try {
                        File cacheValuesFile = new File(this.configDir, "resolver_service");
                        if (cacheValuesFile.exists() && cacheValuesFile.canRead()) {
                            in = new FileInputStream(cacheValuesFile);
                            try {
                                this.cacheValues = Encoder.decodeGlobalValues(in);
                            }
                            finally {
                                try {
                                    ((FileInputStream)in).close();
                                }
                                catch (Exception e) {}
                            }
                        }
                        if (this.cacheValues != null) {
                            this.cacheSites = Util.getSitesFromValues(this.cacheValues);
                            if (this.cacheSites != null && this.cacheSites.length > 0) {
                                this.resolutionMethod = 1;
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace(System.err);
                        System.err.println("Unable to load local cache/resolver service information:  " + e);
                    }
                    try {
                        File cacheSiteFile;
                        if (this.cacheSites != null && this.cacheSites.length > 0 || !(cacheSiteFile = new File(this.configDir, "resolver_site")).exists() || !cacheSiteFile.canRead()) break block66;
                        in = new FileInputStream(cacheSiteFile);
                        try {
                            int r;
                            byte[] siteBuf = new byte[(int)cacheSiteFile.length()];
                            for (int n = 0; n < siteBuf.length && (r = ((FileInputStream)in).read(siteBuf, n, siteBuf.length - n)) >= 0; n += r) {
                            }
                            SiteInfo cacheSite = new SiteInfo();
                            Encoder.decodeSiteInfoRecord(siteBuf, 0, cacheSite);
                            this.cacheSites = new SiteInfo[]{cacheSite};
                            if (this.cacheSites != null) {
                                this.resolutionMethod = 1;
                            }
                        }
                        finally {
                            try {
                                ((FileInputStream)in).close();
                            }
                            catch (Exception e) {}
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace(System.err);
                        System.err.println("Unable to load local cache/resolver site information.  Will use global resolution");
                    }
                }
                try {
                    File localNAFile;
                    if (this.cacheSites == null || this.cacheSites.length <= 0 || !(localNAFile = new File(this.configDir, "local_nas")).exists() || !localNAFile.canRead()) break block67;
                    BufferedReader rdr = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(localNAFile), "UTF8"));
                    try {
                        String line;
                        while ((line = rdr.readLine()) != null) {
                            if ((line = line.trim()).length() <= 0) continue;
                            if (this.localSites == null) {
                                this.localSites = new HashMap();
                            }
                            this.localSites.put(line.toUpperCase().trim(), this.cacheSites);
                        }
                    }
                    finally {
                        try {
                            rdr.close();
                        }
                        catch (Exception e) {}
                    }
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                    System.err.println("Error loading local naming authority list.");
                }
            }
            File localSitesFile = new File(this.configDir, "local_info");
            if (localSitesFile.exists() && localSitesFile.canRead()) {
                try {
                    FileInputStream f = new FileInputStream(localSitesFile);
                    this.localSites = Encoder.decodeLocalSites(f);
                    f.close();
                }
                catch (Exception e) {
                    System.err.println("Error reading " + localSitesFile.getPath());
                    if (this.localSites == null) {
                        this.localSites = new HashMap(0);
                    }
                    break block68;
                }
            }
            try {
                in = this.getClass().getResourceAsStream("/net/handle/etc/local_info");
                if (in != null) {
                    this.localSites = Encoder.decodeLocalSites(in);
                }
            }
            catch (Exception e) {
                System.err.println("warning: unable to read local info: " + e);
            }
        }
        if (this.localSites == null) {
            this.localSites = new HashMap(0);
        }
        if ((localAddressesFile = new File(this.configDir, "local_addresses")).exists() && localAddressesFile.canRead()) {
            FileInputStream fi = null;
            try {
                fi = new FileInputStream(localAddressesFile);
                this.setLocalAddressMap(Encoder.decodeLocalAddresses(fi));
            }
            catch (Exception e) {
                System.err.println("Error reading local address map: " + e);
                e.printStackTrace(System.err);
                this.setLocalAddressMap(null);
            }
            finally {
                try {
                    fi.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public void setLocalSites(String na, SiteInfo[] sites) {
        this.localSites.put(na.toUpperCase(), sites);
    }

    public void setLocalSites(byte[] na, SiteInfo[] sites) {
        this.localSites.put(Util.decodeString(na).toUpperCase(), sites);
    }

    public synchronized void setLocalAddressMap(Map localAddrMap) {
        if (localAddrMap == null) {
            this.localAddresses = null;
        } else {
            HashMap tmp = new HashMap();
            Iterator it = localAddrMap.keySet().iterator();
            while (it.hasNext()) {
                Object val;
                Object key = it.next();
                if (key == null || (val = localAddrMap.get(key)) == null) continue;
                try {
                    if (key instanceof InetAddress) {
                        key = ((InetAddress)key).getHostAddress();
                    }
                    if (!(val instanceof InetAddress)) {
                        val = InetAddress.getByName(String.valueOf(val));
                    }
                    tmp.put(key, val);
                }
                catch (Exception e) {
                    System.err.println("Invalid local address: " + key + " -> " + val);
                }
            }
            this.localAddresses = tmp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void saveLocalAddressMap() throws IOException {
        HashMap localAddr = this.localAddresses;
        File localAddressesFile = new File(this.configDir, "local_addresses");
        if (localAddr == null) {
            if (localAddressesFile.exists()) {
                localAddressesFile.delete();
            }
        } else {
            FileOutputStream fo = null;
            try {
                fo = new FileOutputStream(localAddressesFile);
                Encoder.writeLocalAddresses(localAddr, fo);
            }
            catch (Exception e) {
                System.err.println("Error saving local address map: " + e);
            }
            finally {
                try {
                    fo.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public synchronized Map getLocalAddressMap() {
        return this.localAddresses;
    }

    public InetAddress mapLocalAddress(InetAddress addr) {
        HashMap local = this.localAddresses;
        if (local == null) {
            return addr;
        }
        Object val = local.get(addr.getHostAddress());
        if (val != null) {
            try {
                if (val instanceof InetAddress) {
                    return (InetAddress)val;
                }
                return InetAddress.getByName(String.valueOf(val));
            }
            catch (Exception e) {
                System.err.println("Invalid address map: " + addr + " -> " + val);
            }
        }
        return addr;
    }

    public SiteInfo[] getLocalSites(String na) {
        return (SiteInfo[])this.localSites.get(na.toUpperCase());
    }

    public SiteInfo[] getLocalSites(byte[] na) {
        return (SiteInfo[])this.localSites.get(Util.decodeString(na).toUpperCase());
    }

    public synchronized void setGlobalValues(HandleValue[] globalValues) {
        this.globalValues = globalValues;
        this.globalNamespace = Util.getNamespaceFromValues(globalValues);
    }

    public void setGlobalValuesFile(File newGlobalValuesFile) {
        this.globalValuesFile = newGlobalValuesFile;
    }

    public void saveGlobalValues() {
        System.err.println("Saving global values to: " + this.globalValuesFile);
        try {
            FileOutputStream out = new FileOutputStream(this.globalValuesFile);
            ((OutputStream)out).write(Encoder.encodeGlobalValues(this.globalValues));
            try {
                ((OutputStream)out).close();
            }
            catch (Exception exception) {}
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setConfigDir(File newConfigDir) {
        this.configDir = newConfigDir;
    }

    public File getConfigDir() {
        return this.configDir;
    }

    public HandleValue[] getGlobalValues() {
        return this.globalValues;
    }

    public NamespaceInfo getGlobalNamespace() {
        return this.globalNamespace;
    }

    public void setGlobalSites(SiteInfo[] globalSites) {
        this.globalSites = globalSites;
        for (int i = this.globalSites.length - 1; i >= 0; --i) {
            this.globalSites[i].isRoot = true;
        }
    }

    public SiteInfo[] getGlobalSites() {
        return this.globalSites;
    }

    public void setCacheSites(SiteInfo[] cacheSites) {
        this.cacheSites = cacheSites;
    }

    public SiteInfo[] getCacheSites() {
        return this.cacheSites;
    }

    public int getResolutionMethod() {
        return this.resolutionMethod;
    }

    public void setResolutionMethod(int resolutionMethod) {
        this.resolutionMethod = resolutionMethod;
    }

    public synchronized void addRootInfoListener(RootInfoListener listener) {
        if (this.rootInfoNotifications == null) {
            this.rootInfoNotifications = new Vector();
        }
        this.rootInfoNotifications.addElement(listener);
    }

    public synchronized void removeRootInfoListener(RootInfoListener listener) {
        if (this.rootInfoNotifications == null) {
            return;
        }
        this.rootInfoNotifications.removeElement(listener);
    }

    public synchronized void notifyRootInfoOutdated() {
        if (this.rootInfoNotifications != null && this.rootInfoNotifications.size() > 0) {
            Enumeration enumeration = this.rootInfoNotifications.elements();
            while (enumeration.hasMoreElements()) {
                ((RootInfoListener)enumeration.nextElement()).rootInfoOutOfDate(this);
            }
        } else if (!this.updatingRootInfo) {
            this.updatingRootInfo = true;
            Thread t = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        Configuration.this.refreshRootInfoFromNet();
                    }
                    catch (Exception e) {
                        System.err.println("Error refreshing root info: " + e);
                        e.printStackTrace(System.err);
                    }
                    finally {
                        Configuration.this.updatingRootInfo = false;
                    }
                }
            });
            t.start();
        }
    }

    public void refreshRootInfoFromNet() throws HandleException {
        HandleResolver resolver = new HandleResolver();
        resolver.setCheckSignatures(true);
        ResolutionRequest req = new ResolutionRequest(Common.ROOT_HANDLE, null, null, null);
        req.certify = true;
        AbstractResponse resp = resolver.processRequest(req);
        if (resp.responseCode != 1) {
            throw new HandleException(1, "Unable to query root info");
        }
        ResolutionResponse rresp = (ResolutionResponse)resp;
        HandleValue[] newValues = rresp.getHandleValues();
        SiteInfo[] newSites = Util.getSitesFromValues(this.globalValues);
        if (newSites == null || newSites.length <= 0) {
            throw new HandleException(1, "Unable to extract root site information");
        }
        this.setGlobalValues(newValues);
        this.setGlobalSites(newSites);
        this.saveGlobalValues();
    }
}

