/*
 * Decompiled with CFR 0.152.
 */
package net.handle.hdllib;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.security.PublicKey;
import java.util.Hashtable;
import java.util.Random;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.interfaces.DHPublicKey;
import net.handle.hdllib.AbstractMessage;
import net.handle.hdllib.AbstractRequest;
import net.handle.hdllib.AbstractResponse;
import net.handle.hdllib.AuthenticationInfo;
import net.handle.hdllib.Cache;
import net.handle.hdllib.ChallengeAnswerRequest;
import net.handle.hdllib.ChallengeResponse;
import net.handle.hdllib.ClientSessionTracker;
import net.handle.hdllib.ClientSideSessionInfo;
import net.handle.hdllib.Common;
import net.handle.hdllib.Configuration;
import net.handle.hdllib.Encoder;
import net.handle.hdllib.ErrorResponse;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.HandleValue;
import net.handle.hdllib.Interface;
import net.handle.hdllib.MemCache;
import net.handle.hdllib.MessageEnvelope;
import net.handle.hdllib.NamespaceInfo;
import net.handle.hdllib.ResolutionRequest;
import net.handle.hdllib.ResolutionResponse;
import net.handle.hdllib.ResponseMessageCallback;
import net.handle.hdllib.ServerInfo;
import net.handle.hdllib.SessionExchangeKeyRequest;
import net.handle.hdllib.SessionSetupInfo;
import net.handle.hdllib.SessionSetupRequest;
import net.handle.hdllib.SessionSetupResponse;
import net.handle.hdllib.SiteInfo;
import net.handle.hdllib.TimedConnection;
import net.handle.hdllib.Util;
import net.handle.security.HdlSecurityProvider;
import net.handle.util.LRUCacheTable;

public class HandleResolver {
    public boolean traceMessages = false;
    private static final byte[] HTTP_ACCEPT_HEADER = Util.encodeString("Accept: application/x-hdl-message\r\n");
    private static final byte[] HTTP_AGENT_HEADER = Util.encodeString("User-Agent: CNRI-HCL 2.0\r\n");
    private static final byte[] HTTP_CONTENT_TYPE_HEADER = Util.encodeString("Content-Type: application/x-hdl-message\r\n");
    private static final byte[] HTTP_NEWLINE = Util.encodeString("\r\n");
    private static int nextRequestId = 1;
    private static int globalMessageId = Math.abs(new Random().nextInt());
    private Random random;
    private Configuration config = Configuration.defaultConfiguration();
    private int[] preferredProtocols = new int[]{0, 1, 2};
    private ClientSessionTracker resolverSessions = null;
    private int maxUDPDataSize = 492;
    private Cache secureCache = null;
    private Cache cache = null;
    private int[] udpRetryScheme = new int[]{1000, 2000, 3000};
    private int tcpTimeout = 60000;
    private boolean checkSignatures = true;
    private LRUCacheTable responseTimeTbl = new LRUCacheTable(64);
    private int preferredEncryptionAlgorithm = 1;

    public HandleResolver() {
        this.setCache(new MemCache());
        this.setCertifiedCache(new MemCache());
    }

    public int[] protocolsByPreference() {
        int[] protocolList = new int[this.preferredProtocols.length];
        for (int i = 0; i < this.preferredProtocols.length; ++i) {
            protocolList[i] = this.preferredProtocols[i];
        }
        return protocolList;
    }

    public byte[] retrieveHandleIndexData(byte[] handle, int index) throws Exception {
        ResolutionRequest req = new ResolutionRequest(handle, null, new int[]{index}, null);
        req.certify = true;
        AbstractResponse response = this.processRequest(req);
        if (!(response instanceof ResolutionResponse)) {
            throw new Exception("Unable to verify resolve the handle/index \n" + response);
        }
        HandleValue[] values = ((ResolutionResponse)response).getHandleValues();
        if (values == null || values.length < 1) {
            throw new Exception("The index specified does not exist\n");
        }
        return values[0].getData();
    }

    private SessionSetupRequest createSessionSetupRequest(AuthenticationInfo authInfo, SessionSetupInfo options) throws HandleException {
        if (options == null) {
            throw new HandleException(0, "Cannot create session setup request with null SessionSetupInfo");
        }
        SessionSetupRequest ssreq = new SessionSetupRequest();
        ssreq.keyExchangeMode = options.keyExchangeMode;
        if (authInfo != null) {
            ssreq.identityHandle = authInfo.getUserIdHandle();
            ssreq.identityIndex = authInfo.getUserIdIndex();
        }
        if (options.keyExchangeMode == 3) {
            ssreq.exchangeKeyHandle = options.exchangeKeyHandle;
            ssreq.exchangeKeyIndex = options.exchangeKeyIndex;
        } else if (options.keyExchangeMode == 1 || options.keyExchangeMode == 4) {
            ssreq.publicKey = options.publicExchangeKey;
        }
        ssreq.certify = true;
        ssreq.encrypt = false;
        ssreq.returnRequestDigest = true;
        ssreq.majorProtocolVersion = (byte)2;
        ssreq.minorProtocolVersion = (byte)2;
        ssreq.encryptAllSessionMsg = options.encrypted;
        ssreq.authAllSessionMsg = options.authenticated;
        if (options.timeout > 0) {
            ssreq.timeout = options.timeout;
        }
        return ssreq;
    }

    private synchronized int getNextRequestId() {
        return nextRequestId++;
    }

    public void setCache(Cache cache) {
        if (this.secureCache != null && this.secureCache == cache) {
            throw new RuntimeException("Error:  attempt to set the certified and regular cache to the same value");
        }
        this.cache = cache;
    }

    public void setCertifiedCache(Cache cache) {
        if (this.cache != null && this.cache == cache) {
            throw new RuntimeException("Error:  attempt to set the certified and regular cache to the same value");
        }
        this.secureCache = cache;
    }

    public void clearCaches() throws Exception {
        Cache c = this.secureCache;
        if (c != null) {
            c.clear();
        }
        if ((c = this.cache) != null) {
            c.clear();
        }
    }

    public void setSessionTracker(ClientSessionTracker sessionTracker) {
        this.resolverSessions = sessionTracker;
    }

    public ClientSessionTracker getSessionTracker() {
        return this.resolverSessions;
    }

    public void setConfiguration(Configuration config) {
        this.config = config;
    }

    public void setPreferredProtocols(int[] prefProtocols) {
        this.preferredProtocols = new int[prefProtocols.length];
        System.arraycopy(prefProtocols, 0, this.preferredProtocols, 0, this.preferredProtocols.length);
    }

    public void setMaxUDPDataSize(int newMaxUDPDataSize) {
        this.maxUDPDataSize = newMaxUDPDataSize;
    }

    public int getMaxUDPDataSize() {
        return this.maxUDPDataSize;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public void setTcpTimeout(int newTcpTimeout) {
        this.tcpTimeout = newTcpTimeout;
    }

    public int getTcpTimeout() {
        return this.tcpTimeout;
    }

    public int[] getUdpRetryScheme() {
        int[] urs = new int[this.udpRetryScheme.length];
        System.arraycopy(this.udpRetryScheme, 0, urs, 0, urs.length);
        return urs;
    }

    private void setUdpRetryScheme(int[] newudpRetryScheme) {
        this.udpRetryScheme = null;
        this.udpRetryScheme = new int[newudpRetryScheme.length];
        System.arraycopy(newudpRetryScheme, 0, this.udpRetryScheme, 0, this.udpRetryScheme.length);
    }

    public void setCheckSignatures(boolean checkSigs) {
        this.checkSignatures = checkSigs;
    }

    public HandleValue[] resolveHandle(String sHandle, String[] sTypes, int[] indexes) throws HandleException {
        if (sTypes == null) {
            sTypes = new String[]{};
        }
        if (indexes == null) {
            indexes = new int[]{};
        }
        byte[][] types = new byte[sTypes.length][];
        byte[] handle = Util.encodeString(sHandle);
        for (int i = 0; i < sTypes.length; ++i) {
            types[i] = Util.encodeString(sTypes[i]);
        }
        AbstractResponse response = this.processRequest(new ResolutionRequest(handle, types, indexes, null), null);
        if (response.responseCode == 100) {
            throw new HandleException(9);
        }
        if (response instanceof ErrorResponse) {
            String msg = Util.decodeString(((ErrorResponse)response).message);
            throw new HandleException(1, AbstractMessage.getResponseCodeMessage(response.responseCode) + ": " + msg);
        }
        HandleValue[] values = ((ResolutionResponse)response).getHandleValues();
        if (values == null) {
            return null;
        }
        if (sTypes.length <= 0 && indexes.length <= 0) {
            return values;
        }
        int numValues = values.length;
        for (int i = 0; i < values.length; ++i) {
            if (sTypes.length > 0 && Util.isInArray(types, values[i].type) || indexes.length > 0 && Util.isInArray(indexes, values[i].index)) continue;
            values[i] = null;
            --numValues;
        }
        if (numValues == values.length) {
            return values;
        }
        HandleValue[] filteredVals = new HandleValue[numValues];
        int j = 0;
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null) continue;
            filteredVals[j++] = values[i];
        }
        return filteredVals;
    }

    public HandleValue[] resolveHandle(String sHandle) throws HandleException {
        return this.resolveHandle(sHandle, null, null);
    }

    public AbstractResponse processRequest(AbstractRequest req, ResponseMessageCallback callback) throws HandleException {
        switch (this.config.getResolutionMethod()) {
            case 1: {
                SiteInfo[] cacheSites;
                if (req.isAdminRequest || req.requiresConnection || !req.ignoreRestrictedValues || (cacheSites = this.config.getCacheSites()) == null || cacheSites.length <= 0) break;
                return this.sendRequestToService(req, this.config.getCacheSites(), true, callback);
            }
        }
        return this.processRequestGlobally(req, callback);
    }

    public AbstractResponse processRequest(AbstractRequest req) throws HandleException {
        return this.processRequest(req, null);
    }

    private AbstractResponse processRequestGlobally(AbstractRequest req, ResponseMessageCallback callback) throws HandleException {
        return this.sendRequestToService(req, this.findLocalSites(req), true, callback);
    }

    public AbstractResponse processRequestGlobally(AbstractRequest req) throws HandleException {
        return this.processRequestGlobally(req, null);
    }

    public SiteInfo[] findLocalSites(AbstractRequest req) throws HandleException {
        req.setNamespace(this.config.getGlobalNamespace());
        SiteInfo[] sites = this.config.getLocalSites(Util.getNAHandle(req.handle));
        if (sites != null) {
            return sites;
        }
        if (Util.startsWithCI(req.handle, Common.GLOBAL_NA_PREFIX) || Util.startsWithCI(req.handle, Common.GLOBAL_NA)) {
            return this.config.getGlobalSites();
        }
        ResolutionRequest resReq = new ResolutionRequest(Util.getNAHandle(req.handle), Common.LOCATION_TYPES, null, null);
        resReq.takeValuesFrom(req);
        resReq.authoritative = false;
        resReq.sessionInfo = null;
        resReq.sessionTracker = null;
        resReq.recursionCount = req.recursionCount;
        resReq.recursionCount = (short)(resReq.recursionCount + 1);
        AbstractResponse resResponse = this.processRequest(resReq, null);
        if (resResponse.responseCode == 1) {
            HandleValue[] values = ((ResolutionResponse)resResponse).getHandleValues();
            NamespaceInfo nsInfo = Util.getNamespaceFromValues(values);
            if (nsInfo != null) {
                req.setNamespace(nsInfo);
            }
            if ((sites = Util.getSitesFromValues(values)) != null && sites.length <= 0) {
                sites = null;
            }
            if (sites == null) {
                HandleValue srvHdlValue = null;
                for (int i = 0; values != null && i < values.length; ++i) {
                    if (!Util.equals(values[i].type, Common.SERVICE_HANDLE_TYPE)) continue;
                    srvHdlValue = values[i];
                    break;
                }
                if (srvHdlValue != null) {
                    ResolutionRequest svcReq = new ResolutionRequest(srvHdlValue.data, Common.SITE_INFO_TYPES, null, null);
                    svcReq.takeValuesFrom(req);
                    svcReq.authoritative = false;
                    AbstractResponse svcRes = this.processRequest(svcReq, null);
                    if (svcRes.responseCode == 1) {
                        sites = Util.getSitesFromValues(((ResolutionResponse)svcRes).getHandleValues());
                    }
                }
            }
        }
        if (sites == null) {
            throw new HandleException(2, "Unable to find service for handle " + Util.decodeString(req.handle) + "; prefix resolution response: " + resResponse);
        }
        return sites;
    }

    public final AbstractResponse sendRequestToService(AbstractRequest req, SiteInfo[] sites, ResponseMessageCallback callback) throws HandleException {
        return this.sendRequestToService(req, sites, false, callback);
    }

    public AbstractResponse sendRequestToService(AbstractRequest req, SiteInfo[] sites) throws HandleException {
        return this.sendRequestToService(req, sites, null);
    }

    private AbstractResponse sendRequestToService(AbstractRequest req, SiteInfo[] sites, boolean cacheResult, ResponseMessageCallback callback) throws HandleException {
        int p;
        Cache cache;
        boolean isCacheable = false;
        byte[] handle = null;
        byte[][] types = null;
        int[] indexes = null;
        Cache cache2 = cache = req.certify ? this.secureCache : this.cache;
        if (cache != null && req.opCode == 1) {
            ResolutionRequest rreq = (ResolutionRequest)req;
            handle = rreq.handle;
            types = rreq.requestedTypes;
            indexes = rreq.requestedIndexes;
            boolean ignoreRestricted = rreq.ignoreRestrictedValues;
            if (cacheResult && ignoreRestricted) {
                isCacheable = true;
            }
            if (!req.authoritative && ignoreRestricted) {
                try {
                    byte[][] cachedVals = cache.getCachedValues(handle, types, indexes);
                    if (cachedVals != null) {
                        return new ResolutionResponse(req, req.handle, cachedVals);
                    }
                }
                catch (Throwable e) {
                    System.err.println("Cache get error: " + e);
                    e.printStackTrace(System.err);
                }
            }
        }
        AbstractResponse resp = null;
        boolean requestSent = false;
        if (req.isAdminRequest || req.authoritative) {
            block10: for (p = 0; p < this.preferredProtocols.length && !requestSent; ++p) {
                for (int i = 0; i < sites.length; ++i) {
                    if (!sites[i].isPrimary) continue;
                    try {
                        resp = this.sendRequestToSite(req, sites[i], this.preferredProtocols[p], callback);
                        if (resp == null) continue block10;
                        requestSent = true;
                        continue block10;
                    }
                    catch (HandleException e) {
                        if (p != this.preferredProtocols.length - 1) continue block10;
                        throw e;
                    }
                }
            }
            if (!requestSent) {
                throw new HandleException(3, "Cannot contact an acceptable interface");
            }
        } else {
            for (int i = 0; sites != null && i < sites.length; ++i) {
                if (sites[i].servers == null || sites[i].servers.length == 0) continue;
                String ip = sites[i].servers[0].getAddressString();
                Long l = (Long)this.responseTimeTbl.get(ip);
                sites[i].responseTime = l == null ? 0L : l;
            }
            sites = Util.orderSitesByPreference(sites);
            block13: for (p = 0; p < this.preferredProtocols.length && !requestSent; ++p) {
                for (int i = 0; i < sites.length; ++i) {
                    try {
                        resp = this.sendRequestToSite(req, sites[i], this.preferredProtocols[p], callback);
                        if (resp == null) continue;
                        requestSent = true;
                        continue block13;
                    }
                    catch (HandleException e) {
                        if (p != this.preferredProtocols.length - 1 || i != sites.length - 1) continue;
                        throw e;
                    }
                }
            }
            if (!requestSent) {
                throw new HandleException(3, "Cannot contact an acceptable interface");
            }
        }
        if (isCacheable && resp.responseCode == 1) {
            try {
                cache.setCachedValues(handle, ((ResolutionResponse)resp).getHandleValues(), types, indexes);
            }
            catch (Throwable e) {
                System.err.println("Cache set error: " + e);
                e.printStackTrace(System.err);
            }
        }
        if (isCacheable && resp.responseCode == 1) {
            try {
                cache.setCachedValues(handle, ((ResolutionResponse)resp).getHandleValues(), types, indexes);
            }
            catch (Throwable e) {
                System.err.println("Cache set error: " + e);
                e.printStackTrace(System.err);
            }
        }
        if (resp != null) {
            if (resp.responseCode == 300) {
                this.config.refreshRootInfoFromNet();
            }
            return resp;
        }
        throw new HandleException(2, "No acceptable site found in service");
    }

    public AbstractResponse sendRequestToSite(AbstractRequest req, SiteInfo site) throws HandleException {
        AbstractResponse resp = null;
        for (int p = 0; p < this.preferredProtocols.length; ++p) {
            try {
                resp = this.sendRequestToSite(req, site, this.preferredProtocols[p]);
                break;
            }
            catch (Exception e) {
                if (p != this.preferredProtocols.length - 1) continue;
                if (e instanceof HandleException) {
                    throw (HandleException)e;
                }
                throw new HandleException(7, "Unable to contact site on any interfaces: " + e);
            }
        }
        if (resp == null) {
            throw new HandleException(3, "Cannot contact an acceptable interface");
        }
        return resp;
    }

    public AbstractResponse sendRequestToSite(AbstractRequest req, SiteInfo site, int protocol) throws HandleException {
        return this.sendRequestToSite(req, site, protocol, null);
    }

    public AbstractResponse sendRequestToSite(AbstractRequest req, SiteInfo site, int protocol, ResponseMessageCallback callback) throws HandleException {
        AbstractResponse response;
        req.siteInfoSerial = site.serialNumber;
        if (site.majorProtocolVersion == 5 && site.minorProtocolVersion == 0 || site.majorProtocolVersion < 2 || site.majorProtocolVersion == 2 && site.minorProtocolVersion < 2) {
            req.majorProtocolVersion = site.majorProtocolVersion;
            req.minorProtocolVersion = site.minorProtocolVersion;
        } else {
            req.majorProtocolVersion = (byte)2;
            req.minorProtocolVersion = (byte)2;
        }
        long time1 = System.currentTimeMillis();
        try {
            response = this.sendRequestToServerByProtocol(req, site.determineServer(req.handle), protocol, callback);
            if (site.isRoot && response != null && response.siteInfoSerial > req.siteInfoSerial) {
                this.config.notifyRootInfoOutdated();
            }
        }
        catch (HandleException e) {
            throw e;
        }
        finally {
            long time2 = System.currentTimeMillis();
            site.responseTime = time2 - time1;
            Long l = new Long(time2 - time1);
            this.responseTimeTbl.put(site.servers[0].getAddressString(), l);
        }
        return response;
    }

    public AbstractResponse sendRequestToServer(AbstractRequest req, ServerInfo server) throws HandleException {
        return this.sendRequestToServer(req, server, null);
    }

    public AbstractResponse sendRequestToServer(AbstractRequest req, ServerInfo server, ResponseMessageCallback callback) throws HandleException {
        AbstractResponse response = null;
        for (int p = 0; p < this.preferredProtocols.length; ++p) {
            response = this.sendRequestToServerByProtocol(req, server, this.preferredProtocols[p], callback);
            if (response == null) continue;
            return response;
        }
        throw new HandleException(3, "There were no acceptable interfaces to server: " + server);
    }

    public AbstractResponse sendRequestToServerByProtocol(AbstractRequest req, ServerInfo server, int protocolToUse, ResponseMessageCallback callback) throws HandleException {
        ServerInfo origServer = server;
        AbstractResponse response = null;
        Exception exception = null;
        Interface interfce = null;
        ClientSideSessionInfo sessionInfo = req.sessionInfo;
        ClientSessionTracker sessionTracker = null;
        sessionTracker = req.sessionTracker;
        if (sessionTracker == null && req.isAdminRequest) {
            sessionTracker = this.resolverSessions;
        }
        if (sessionInfo != null && sessionInfo.hasExpired()) {
            sessionInfo = null;
        }
        if (sessionTracker != null && req.opCode != 400) {
            SessionSetupInfo setupInfo;
            sessionInfo = sessionTracker.getSession(server, req.authInfo);
            if (sessionInfo == null) {
                setupInfo = sessionTracker.getSessionSetupInfo();
                if (setupInfo != null) {
                    try {
                        sessionInfo = this.setupSessionWithServer(req.authInfo, setupInfo, server, callback);
                        sessionTracker.putSession(sessionInfo, server, req.authInfo);
                    }
                    catch (Exception e) {
                        String msg = "Error setting up session: " + e;
                        throw new HandleException(1, msg);
                    }
                }
            } else {
                setupInfo = sessionTracker.getSessionSetupInfo();
                if (setupInfo != null && ClientSessionTracker.sessionOptionChanged(sessionInfo, setupInfo)) {
                    try {
                        ClientSideSessionInfo newSessionInfo;
                        sessionInfo = newSessionInfo = this.setupSessionWithServer(req.authInfo, setupInfo, server, sessionInfo, callback);
                        sessionTracker.removeSession(sessionInfo);
                        sessionTracker.putSession(newSessionInfo, server, req.authInfo);
                    }
                    catch (Exception e) {
                        String msg = "Error modifying session: " + e;
                        throw new HandleException(1, msg);
                    }
                }
            }
        }
        if (sessionInfo != null) {
            req.sessionId = sessionInfo.sessionId;
            req.certify = req.certify || sessionInfo.getAuthenticateMessageFlag();
            boolean bl = req.encrypt = req.encrypt || sessionInfo.getEncryptedMesssageFlag();
            if (req.authInfo != null) {
                try {
                    req.signMessage(sessionInfo.getSessionKey());
                }
                catch (Exception e) {
                    if (e instanceof HandleException) {
                        throw (HandleException)e;
                    }
                    throw new HandleException(19, "Unable to sign original request with session key: " + e);
                }
            }
        }
        req.sessionInfo = sessionInfo;
        interfce = server.interfaceWithProtocol(protocolToUse, req);
        if (interfce != null) {
            response = null;
            try {
                response = this.sendRequestToInterface(req, server, interfce, callback);
            }
            catch (Exception e) {
                exception = e;
            }
            if (response != null && response.responseCode == 500 && sessionInfo != null && sessionTracker != null) {
                sessionTracker.removeSession(sessionInfo);
                sessionInfo = null;
            }
            if (response != null && response.getClass() == ChallengeResponse.class) {
                if (req.authInfo == null) {
                    throw new HandleException(8, "No authentication info provided");
                }
                ChallengeResponse challResponse = (ChallengeResponse)response;
                byte[] sig = req.authInfo.authenticate(challResponse, req);
                int challengeSessionID = response.sessionId;
                response = null;
                try {
                    ChallengeAnswerRequest answer = new ChallengeAnswerRequest(req.authInfo.getAuthType(), req.authInfo.getUserIdHandle(), req.authInfo.getUserIdIndex(), sig, req.authInfo);
                    answer.takeValuesFrom(req);
                    answer.sessionId = challengeSessionID;
                    answer.sessionInfo = req.sessionInfo;
                    response = this.sendRequestToInterface(answer, server, interfce, callback);
                }
                catch (Exception e) {
                    exception = e;
                }
            }
            if (response != null) {
                return response;
            }
        }
        if (exception != null) {
            if (exception instanceof HandleException) {
                throw (HandleException)exception;
            }
            exception.printStackTrace();
            throw new HandleException(7, "Got Exception: " + exception);
        }
        return null;
    }

    public ClientSideSessionInfo setupSessionWithServer(AuthenticationInfo authInfo, SessionSetupInfo sessionOptions, ServerInfo server, ResponseMessageCallback callback) throws Exception {
        return this.setupSessionWithServer(authInfo, sessionOptions, server, null, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientSideSessionInfo setupSessionWithServer(AuthenticationInfo authInfo, SessionSetupInfo sessionOptions, ServerInfo server, ClientSideSessionInfo currSession, ResponseMessageCallback callback) throws Exception {
        int identityIndex;
        byte[] identityHandle;
        int sessionKeyAlg;
        byte[] sessionKey;
        AbstractResponse response;
        block17: {
            response = null;
            sessionKey = null;
            sessionKeyAlg = 1;
            identityHandle = null;
            identityIndex = -1;
            if (authInfo != null) {
                identityHandle = authInfo.getUserIdHandle();
                identityIndex = authInfo.getUserIdIndex();
            }
            SessionSetupRequest sessionsetupReq = this.createSessionSetupRequest(authInfo, sessionOptions);
            if (currSession != null) {
                sessionsetupReq.sessionId = currSession.sessionId;
                sessionsetupReq.sessionInfo = currSession;
            }
            sessionsetupReq.certify = true;
            int oldTcpTimeout = this.getTcpTimeout();
            int[] oldUdpRetryScheme = this.getUdpRetryScheme();
            try {
                HdlSecurityProvider provider;
                block19: {
                    block18: {
                        provider = HdlSecurityProvider.getInstance();
                        this.setTcpTimeout(180000);
                        this.setUdpRetryScheme(new int[]{180000});
                        response = this.sendRequestToServer(sessionsetupReq, server, null);
                        if (response == null || !(response instanceof SessionSetupResponse)) break block18;
                        if (response.responseCode == 1) break block19;
                    }
                    throw new HandleException(25, response.toString());
                }
                SessionSetupResponse ssresp = (SessionSetupResponse)response;
                if (ssresp.keyExchangeMode == 1 || ssresp.keyExchangeMode == 3) {
                    sessionKey = Util.decrypt(sessionOptions.privateExchangeKey, ssresp.data);
                    if (ssresp.hasEqualOrGreaterVersion((byte)2, (byte)2)) {
                        sessionKeyAlg = Encoder.readInt(sessionKey, 0);
                        byte[] tmp = new byte[sessionKey.length - 4];
                        System.arraycopy(sessionKey, 4, tmp, 0, tmp.length);
                        sessionKey = tmp;
                    }
                    break block17;
                }
                if (ssresp.keyExchangeMode == 2) {
                    byte[] pubExchangeKey = ssresp.data;
                    boolean oldServer = !ssresp.hasEqualOrGreaterVersion((byte)2, (byte)2);
                    sessionKeyAlg = oldServer ? 1 : this.preferredEncryptionAlgorithm;
                    sessionKey = HdlSecurityProvider.getInstance().generateSecretKey(sessionKeyAlg);
                    byte[] encryptKey = Util.substring(sessionKey, 4);
                    if (oldServer) {
                        sessionKey = encryptKey;
                    }
                    PublicKey serverRSAPubKey = Util.getPublicKeyFromBytes(pubExchangeKey, 0);
                    byte[] key = Util.encrypt(serverRSAPubKey, encryptKey);
                    SessionExchangeKeyRequest sekr = new SessionExchangeKeyRequest(key);
                    sekr.takeValuesFrom(sessionsetupReq);
                    sekr.encrypt = false;
                    sekr.sessionId = ssresp.sessionId;
                    AbstractResponse rsp = this.sendRequestToServer(sekr, server, null);
                    if (rsp == null || rsp.responseCode != 1) {
                        throw new HandleException(25, "Server cipher key exchange failed.");
                    }
                    if (ssresp.hasEqualOrGreaterVersion((byte)2, (byte)2)) {
                        sessionKey = Util.substring(sessionKey, 4);
                    }
                    break block17;
                }
                if (ssresp.keyExchangeMode == 4) {
                    DHPublicKey pub = (DHPublicKey)Util.getPublicKeyFromBytes(ssresp.data, 0);
                    sessionKey = provider.getDESKeyFromDH(pub, (DHPrivateKey)sessionOptions.privateExchangeKey);
                    break block17;
                }
                throw new HandleException(25, "Unknown key exchange mode");
            }
            finally {
                this.setTcpTimeout(oldTcpTimeout);
                this.setUdpRetryScheme(oldUdpRetryScheme);
            }
        }
        ClientSideSessionInfo csinfo = new ClientSideSessionInfo(response.sessionId, sessionKey, identityHandle, identityIndex, server);
        csinfo.setEncryptionAlgorithmCode(sessionKeyAlg);
        csinfo.takeValuesFromOption(sessionOptions);
        return csinfo;
    }

    public AbstractResponse sendRequestToInterface(AbstractRequest req, ServerInfo server, Interface interfce) throws HandleException {
        return this.sendRequestToInterface(req, server, interfce, null);
    }

    public AbstractResponse sendRequestToInterface(AbstractRequest req, ServerInfo server, Interface interfce, ResponseMessageCallback callback) throws HandleException {
        if (req.certify && this.checkSignatures) {
            req.serverPubKey = null;
            req.serverPubKeyBytes = server.publicKey;
        }
        try {
            InetAddress addr = server.getInetAddress();
            int port = interfce.port;
            AbstractResponse response = null;
            switch (interfce.protocol) {
                case 0: {
                    response = this.sendHdlUdpRequest(req, addr, port, callback);
                    break;
                }
                case 1: {
                    response = this.sendHdlTcpRequest(req, addr, port, callback);
                    break;
                }
                case 2: {
                    response = this.sendHttpRequest(req, addr, port, callback);
                    break;
                }
                default: {
                    throw new HandleException(4, "unknown protocol: " + interfce.protocol);
                }
            }
            if (response != null) {
                if (response.responseCode == 2) {
                    throw new HandleException(15, Util.decodeString(((ErrorResponse)response).message));
                }
                if ((long)response.expiration < System.currentTimeMillis() / 1000L) {
                    throw new HandleException(17);
                }
            }
            return response;
        }
        catch (UnknownHostException e) {
            throw new HandleException(1, "Unknown host - should never happen!");
        }
    }

    private final boolean verifyResponse(AbstractRequest req, AbstractResponse response, InetAddress addr) throws HandleException {
        boolean veriPass = false;
        if (req == null || response == null || addr == null) {
            return false;
        }
        if (response.sessionId > 0) {
            try {
                if (req.sessionInfo != null) {
                    veriPass = response.verifyMessage(req.sessionInfo.getSessionKey());
                }
            }
            catch (Exception e) {
                if (e instanceof HandleException) {
                    if (((HandleException)e).getCode() == 16) {
                        veriPass = false;
                    }
                    throw (HandleException)e;
                }
                throw new HandleException(13, "Error verifying MAC code: " + e);
            }
        }
        return veriPass;
    }

    private static final void verifyResponse(AbstractRequest req, AbstractResponse response) throws HandleException {
        byte[] requestDigest;
        if (req.serverPubKey == null && req.serverPubKeyBytes == null) {
            throw new HandleException(10, "Unable to verify certified message: no pubkey associated with request");
        }
        PublicKey pubKey = req.serverPubKey;
        try {
            if (pubKey == null) {
                pubKey = req.serverPubKey = Util.getPublicKeyFromBytes(req.serverPubKeyBytes, 0);
            }
        }
        catch (Exception e) {
            throw new HandleException(0, "Unable to extract public key: " + e);
        }
        try {
            if (!response.verifyMessage(pubKey)) {
                throw new HandleException(13, "Verification failed.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new HandleException(13, "Unable to verify signature: '" + e.getMessage() + "' for message: " + response);
        }
        if (req.returnRequestDigest && !Util.equals(requestDigest = Util.doDigest(response.rdHashType, req.getEncodedMessageBody()), response.requestDigest)) {
            throw new HandleException(10, "Message came back with invalid request digest.");
        }
    }

    public AbstractResponse sendHdlUdpRequest(AbstractRequest req, InetAddress addr, int port) throws HandleException {
        return this.sendHdlUdpRequest(req, addr, port, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractResponse sendHdlUdpRequest(AbstractRequest req, InetAddress addr, int port, ResponseMessageCallback callback) throws HandleException {
        addr = this.config.mapLocalAddress(addr);
        DatagramSocket socket = null;
        MessageEnvelope sndEnvelope = new MessageEnvelope();
        if (req.majorProtocolVersion > 0 && req.minorProtocolVersion >= 0) {
            sndEnvelope.protocolMajorVersion = req.majorProtocolVersion;
            sndEnvelope.protocolMinorVersion = req.minorProtocolVersion;
        }
        if (globalMessageId < 0) {
            globalMessageId = 0;
        }
        sndEnvelope.requestId = globalMessageId++;
        sndEnvelope.sessionId = req.sessionId;
        req.requestId = sndEnvelope.requestId;
        byte[] requestBuf = req.getEncodedMessage();
        if (req.encrypt) {
            if (req.sessionInfo == null) {
                throw new HandleException(24, "Cannot encrypt messages without a session");
            }
            requestBuf = req.sessionInfo.encryptBuffer(requestBuf, 0, requestBuf.length);
        }
        sndEnvelope.messageLength = requestBuf.length;
        int numPackets = sndEnvelope.messageLength / this.maxUDPDataSize;
        if (sndEnvelope.messageLength % this.maxUDPDataSize != 0) {
            ++numPackets;
        }
        if (numPackets == 0) {
            throw new HandleException(1, "Cannot send empty request");
        }
        DatagramPacket[] packets = new DatagramPacket[numPackets];
        int bytesRemaining = sndEnvelope.messageLength;
        sndEnvelope.truncated = numPackets > 1;
        for (int packetNum = 0; packetNum < numPackets; ++packetNum) {
            int thisPacketSize = Math.min(this.maxUDPDataSize, bytesRemaining);
            byte[] buf = new byte[thisPacketSize + 20];
            sndEnvelope.messageId = packetNum;
            Encoder.encodeEnvelope(sndEnvelope, buf);
            System.arraycopy(requestBuf, requestBuf.length - bytesRemaining, buf, 20, buf.length - 20);
            packets[packetNum] = new DatagramPacket(buf, buf.length, addr, port);
            bytesRemaining -= thisPacketSize;
        }
        try {
            socket = new DatagramSocket();
        }
        catch (Exception e) {
            try {
                socket.close();
            }
            catch (Exception e2) {
                // empty catch block
            }
            throw new HandleException(1, String.valueOf(e) + " setting SO timeout");
        }
        MessageEnvelope rcvEnvelope = new MessageEnvelope();
        Throwable lastException = null;
        try {
            for (int attempt = 0; attempt < this.udpRetryScheme.length; ++attempt) {
                long whenToTimeout;
                if (this.traceMessages) {
                    System.err.println("  sending HDL-UDP request (" + req + ") to " + addr.getHostAddress() + ':' + port);
                }
                try {
                    socket.setSoTimeout(this.udpRetryScheme[attempt]);
                    for (int packet = 0; packet < packets.length; ++packet) {
                        socket.send(packets[packet]);
                    }
                    whenToTimeout = System.currentTimeMillis() + (long)this.udpRetryScheme[attempt];
                }
                catch (Exception e) {
                    throw new HandleException(1, String.valueOf(e) + " sending UDP request to " + addr.getHostAddress());
                }
                byte[] returnMessage = null;
                boolean[] packetsReceived = null;
                boolean haveAllPackets = false;
                while (!haveAllPackets && System.currentTimeMillis() <= whenToTimeout) {
                    DatagramPacket rspnsPkt = new DatagramPacket(new byte[this.maxUDPDataSize + 20], this.maxUDPDataSize + 20);
                    try {
                        socket.receive(rspnsPkt);
                        if (rspnsPkt.getLength() <= 0) continue;
                        byte[] rspnsPktData = rspnsPkt.getData();
                        int rspnsPktDataLen = rspnsPkt.getLength();
                        Encoder.decodeEnvelope(rspnsPktData, rcvEnvelope);
                        if (rcvEnvelope.requestId != req.requestId) continue;
                        if (packetsReceived == null) {
                            int numPkts = rcvEnvelope.messageLength / this.maxUDPDataSize;
                            if (rcvEnvelope.messageLength % this.maxUDPDataSize != 0) {
                                ++numPkts;
                            }
                            packetsReceived = new boolean[numPkts];
                            for (int pr = 0; pr < packetsReceived.length; ++pr) {
                                packetsReceived[pr] = false;
                            }
                            returnMessage = new byte[rcvEnvelope.messageLength];
                        }
                        packetsReceived[rcvEnvelope.messageId] = true;
                        System.arraycopy(rspnsPktData, 20, returnMessage, rcvEnvelope.messageId * this.maxUDPDataSize, rspnsPktDataLen - 20);
                        haveAllPackets = true;
                        for (int pr = 0; pr < packetsReceived.length; ++pr) {
                            if (packetsReceived[pr]) continue;
                            haveAllPackets = false;
                            pr = packetsReceived.length;
                        }
                        if (!haveAllPackets) continue;
                        if (rcvEnvelope.encrypted) {
                            ClientSideSessionInfo sessionInfo = req.sessionInfo;
                            if (sessionInfo == null) {
                                throw new HandleException(24, "Cannot decrypt message without a session");
                            }
                            if (this.traceMessages) {
                                System.err.println("Decrypting UDP message: " + rcvEnvelope);
                            }
                            if (sessionInfo == null) {
                                returnMessage = sessionInfo.decryptBuffer(returnMessage, 0, returnMessage.length);
                            }
                        }
                        AbstractResponse response = (AbstractResponse)Encoder.decodeMessage(returnMessage, 0, rcvEnvelope);
                        if (this.traceMessages) {
                            System.err.println("    received HDL-UDP response: " + response);
                        }
                        if (req.certify && this.checkSignatures) {
                            boolean veriPass = false;
                            if (response.sessionId > 0) {
                                veriPass = this.verifyResponse(req, response, addr);
                            }
                            if (!veriPass) {
                                HandleResolver.verifyResponse(req, response);
                            }
                        }
                        if (callback != null) {
                            callback.handleResponse(response);
                        }
                        AbstractResponse abstractResponse = response;
                        return abstractResponse;
                    }
                    catch (Exception e) {
                        lastException = e;
                    }
                }
            }
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (Exception e) {}
            }
        }
        if (lastException != null) {
            if (lastException instanceof HandleException) {
                throw (HandleException)lastException;
            }
            throw new HandleException(7, addr + ": " + lastException.toString());
        }
        throw new HandleException(7, "Unable to connect to server: " + addr);
    }

    public AbstractResponse sendHdlTcpRequest(AbstractRequest req, InetAddress addr, int port) throws HandleException {
        return this.sendHdlTcpRequest(req, addr, port, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AbstractResponse sendHdlTcpRequest(AbstractRequest req, InetAddress addr, int port, ResponseMessageCallback callback) throws HandleException {
        Socket socket = null;
        OutputStream out = null;
        InputStream in = null;
        addr = this.config.mapLocalAddress(addr);
        MessageEnvelope sndEnvelope = new MessageEnvelope();
        if (req.majorProtocolVersion > 0 && req.minorProtocolVersion >= 0) {
            sndEnvelope.protocolMajorVersion = req.majorProtocolVersion;
            sndEnvelope.protocolMinorVersion = req.minorProtocolVersion;
        }
        if (globalMessageId < 0) {
            globalMessageId = 0;
        }
        sndEnvelope.requestId = globalMessageId++;
        sndEnvelope.sessionId = req.sessionId;
        req.requestId = sndEnvelope.requestId;
        byte[] requestBuf = req.getEncodedMessage();
        if (req.encrypt) {
            if (req.sessionInfo == null) {
                throw new HandleException(24, "Cannot encrypt messages without a session");
            }
            requestBuf = req.sessionInfo.encryptBuffer(requestBuf, 0, requestBuf.length);
        }
        sndEnvelope.messageLength = requestBuf.length;
        if (this.traceMessages) {
            System.err.println("  sending HDL-TCP request (" + req + ") to " + addr.getHostAddress() + ':' + port);
        }
        try {
            socket = TimedConnection.getSocket(addr, port, this.tcpTimeout);
            socket.setSoTimeout(this.tcpTimeout);
            socket.setSoLinger(false, 0);
        }
        catch (Exception e) {
            try {
                socket.close();
                throw new HandleException(7, addr + ": " + String.valueOf(e));
            }
            catch (Exception e2) {
                // empty catch block
            }
            throw new HandleException(7, addr + ": " + String.valueOf(e));
        }
        MessageEnvelope rcvEnvelope = new MessageEnvelope();
        AbstractResponse response = null;
        try {
            byte[] envBuf = new byte[20];
            try {
                out = socket.getOutputStream();
                Encoder.encodeEnvelope(sndEnvelope, envBuf);
                out.write(envBuf, 0, 20);
                out.write(requestBuf, 0, requestBuf.length);
                out.flush();
                in = socket.getInputStream();
            }
            catch (Exception e) {
                throw new HandleException(7, String.valueOf(e) + " sending TCP request to " + addr.getHostAddress());
            }
            while (true) {
                block52: {
                    AbstractResponse abstractResponse;
                    block53: {
                        block51: {
                            int n;
                            int r;
                            for (n = 0; n < 20 && (r = in.read(envBuf, n, 20 - n)) >= 0; n += r) {
                            }
                            Encoder.decodeEnvelope(envBuf, rcvEnvelope);
                            if (rcvEnvelope.requestId != req.requestId) {
                                throw new HandleException(10, "Message came back with different ID: " + req.requestId + "!=" + rcvEnvelope.requestId);
                            }
                            byte[] messageBuf = new byte[rcvEnvelope.messageLength];
                            for (n = 0; n < rcvEnvelope.messageLength && (r = in.read(messageBuf, n, rcvEnvelope.messageLength - n)) >= 0; n += r) {
                            }
                            if (rcvEnvelope.encrypted) {
                                ClientSideSessionInfo csinfo = req.sessionInfo;
                                if (csinfo == null) {
                                    throw new HandleException(24, "Cannot decrypt messages without a session");
                                }
                                if (this.traceMessages) {
                                    System.err.println("Decrypting TCP message: " + rcvEnvelope);
                                }
                                messageBuf = csinfo.decryptBuffer(messageBuf, 0, messageBuf.length);
                            }
                            response = (AbstractResponse)Encoder.decodeMessage(messageBuf, 0, rcvEnvelope);
                            if (response.streaming) {
                                response.stream = in;
                            }
                            if (req.certify && this.checkSignatures) {
                                boolean veriPass = false;
                                if (response.sessionId > 0) {
                                    veriPass = this.verifyResponse(req, response, addr);
                                }
                                if (!veriPass) {
                                    HandleResolver.verifyResponse(req, response);
                                }
                            }
                            if (this.traceMessages) {
                                System.err.println("    received HDL-TCP response: " + response);
                            }
                            if (callback == null || response.responseCode != 1) break block51;
                            callback.handleResponse(response);
                            if (response.continuous) break block52;
                            break block53;
                        }
                        abstractResponse = response;
                        return abstractResponse;
                    }
                    abstractResponse = response;
                    return abstractResponse;
                }
                continue;
                break;
            }
        }
        catch (IOException e) {
            if (!this.traceMessages) throw new HandleException(7, "Error talking to " + addr.getHostAddress());
            e.printStackTrace(System.err);
            throw new HandleException(7, "Error talking to " + addr.getHostAddress());
        }
        finally {
            if (!(socket == null || response != null && response.streaming)) {
                try {
                    in.close();
                }
                catch (Exception e) {}
                try {
                    out.close();
                }
                catch (Exception e) {}
                try {
                    socket.close();
                }
                catch (Exception e) {}
            }
        }
    }

    private static final String encodeHandleAsUri(byte[] handle) {
        return "/" + URLEncoder.encode(Util.decodeString(handle));
    }

    public AbstractResponse sendHttpRequest(AbstractRequest req, InetAddress addr, int port) throws HandleException {
        return this.sendHttpRequest(req, addr, port, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AbstractResponse sendHttpRequest(AbstractRequest req, InetAddress addr, int port, ResponseMessageCallback callback) throws HandleException {
        Socket socket = null;
        BufferedOutputStream out = null;
        InputStream in = null;
        addr = this.config.mapLocalAddress(addr);
        MessageEnvelope sndEnvelope = new MessageEnvelope();
        if (req.majorProtocolVersion > 0 && req.minorProtocolVersion >= 0) {
            sndEnvelope.protocolMajorVersion = req.majorProtocolVersion;
            sndEnvelope.protocolMinorVersion = req.minorProtocolVersion;
        }
        if (globalMessageId < 0) {
            globalMessageId = 0;
        }
        sndEnvelope.requestId = globalMessageId++;
        sndEnvelope.sessionId = req.sessionId;
        req.requestId = sndEnvelope.requestId;
        byte[] requestBuf = req.getEncodedMessage();
        sndEnvelope.messageLength = requestBuf.length;
        if (this.traceMessages) {
            System.err.println("  sending HDL-HTTP request (" + req + ") to " + addr.getHostAddress() + ':' + port);
        }
        try {
            socket = TimedConnection.getSocket(addr, port, this.tcpTimeout);
            socket.setSoTimeout(this.tcpTimeout);
        }
        catch (Exception e) {
            try {
                socket.close();
                throw new HandleException(7, addr.getHostAddress() + ": " + String.valueOf(e));
            }
            catch (Exception e2) {
                // empty catch block
            }
            throw new HandleException(7, addr.getHostAddress() + ": " + String.valueOf(e));
        }
        MessageEnvelope rcvEnvelope = new MessageEnvelope();
        AbstractResponse response = null;
        try {
            byte[] envBuf = new byte[20];
            try {
                out = new BufferedOutputStream(socket.getOutputStream(), 512);
                Encoder.encodeEnvelope(sndEnvelope, envBuf);
                ((OutputStream)out).write(Util.encodeString("POST " + HandleResolver.encodeHandleAsUri(req.handle) + " HTTP/1.0\r\n"));
                ((OutputStream)out).write(HTTP_ACCEPT_HEADER);
                ((OutputStream)out).write(HTTP_AGENT_HEADER);
                ((OutputStream)out).write(HTTP_CONTENT_TYPE_HEADER);
                ((OutputStream)out).write(Util.encodeString("Content-Length: " + (envBuf.length + requestBuf.length) + "\r\n"));
                ((OutputStream)out).write(HTTP_NEWLINE);
                ((OutputStream)out).write(envBuf, 0, 20);
                ((OutputStream)out).write(requestBuf, 0, requestBuf.length);
                ((OutputStream)out).flush();
                in = new BufferedInputStream(socket.getInputStream(), 512);
            }
            catch (Exception e) {
                throw new HandleException(7, String.valueOf(e) + " sending HTTP request to " + addr.getHostAddress());
            }
            Hashtable<String, String> headers = new Hashtable<String, String>();
            DataInputStream din = new DataInputStream(in);
            while (true) {
                String line;
                if ((line = din.readLine()) == null) {
                    throw new HandleException(7, addr.getHostAddress() + ": Unexpected end of HTTP message during headers");
                }
                if ((line = line.trim()).length() <= 0) break;
                int colIdx = line.indexOf(59);
                if (colIdx < 0) {
                    headers.put(line.toUpperCase(), "");
                    continue;
                }
                headers.put(line.substring(0, colIdx), line.substring(colIdx + 1));
            }
            int n = 0;
            while (true) {
                AbstractResponse abstractResponse;
                int r;
                int r2;
                for (n = 0; n < 20 && (r2 = in.read(envBuf, n, 20 - n)) >= 0; n += r2) {
                }
                Encoder.decodeEnvelope(envBuf, rcvEnvelope);
                if (rcvEnvelope.requestId != req.requestId) {
                    throw new HandleException(10, "Message came back with different ID: " + req.requestId + "!=" + rcvEnvelope.requestId);
                }
                byte[] messageBuf = new byte[rcvEnvelope.messageLength];
                for (n = 0; n < rcvEnvelope.messageLength && (r = in.read(messageBuf, n, rcvEnvelope.messageLength - n)) >= 0; n += r) {
                }
                if (rcvEnvelope.encrypted) {
                    if (rcvEnvelope.sessionId <= 0) throw new HandleException(10, "Invalid response session id.  Cannot decrypt response.");
                    ClientSideSessionInfo csinfo = req.sessionInfo;
                    if (csinfo == null) {
                        throw new HandleException(24, "Cannot encrypt messages without a session");
                    }
                    messageBuf = csinfo.decryptBuffer(messageBuf, 0, messageBuf.length);
                }
                response = (AbstractResponse)Encoder.decodeMessage(messageBuf, 0, rcvEnvelope);
                if (response.streaming) {
                    response.stream = in;
                }
                if (req.certify && this.checkSignatures) {
                    boolean veriPass = false;
                    if (response.sessionId > 0) {
                        veriPass = this.verifyResponse(req, response, addr);
                    }
                    if (!veriPass) {
                        HandleResolver.verifyResponse(req, response);
                    }
                }
                if (callback == null) {
                    abstractResponse = response;
                    return abstractResponse;
                }
                callback.handleResponse(response);
                if (!response.continuous) {
                    abstractResponse = response;
                    return abstractResponse;
                }
                continue;
                break;
            }
        }
        catch (IOException e) {
            if (!this.traceMessages) throw new HandleException(7, "Error talking to " + addr.getHostAddress());
            e.printStackTrace(System.err);
            throw new HandleException(7, "Error talking to " + addr.getHostAddress());
        }
        finally {
            if (!(socket == null || response != null && response.streaming)) {
                try {
                    in.close();
                }
                catch (Exception e) {}
                try {
                    ((OutputStream)out).close();
                }
                catch (Exception e) {}
                try {
                    socket.close();
                }
                catch (Exception e) {}
            }
        }
    }
}

