/*
 * Decompiled with CFR 0.152.
 */
package net.handle.hdllib;

import java.util.Date;
import net.handle.hdllib.Common;
import net.handle.hdllib.Util;
import net.handle.hdllib.ValueReference;

public class HandleValue {
    public static final byte SUBTYPE_SEPARATOR = 46;
    public static final byte TTL_TYPE_RELATIVE = 0;
    public static final byte TTL_TYPE_ABSOLUTE = 1;
    public static final int MAX_RECOGNIZED_TTL = 172800;
    int index = -1;
    byte[] type = Common.EMPTY_BYTE_ARRAY;
    byte[] data = Common.EMPTY_BYTE_ARRAY;
    byte ttlType = 0;
    int ttl = 86400;
    int timestamp = 0;
    ValueReference[] references = null;
    boolean adminRead = true;
    boolean adminWrite = true;
    boolean publicRead = true;
    boolean publicWrite = false;
    byte[] cachedBuf = null;
    int cachedBufOffset = 0;
    int cachedBufLength = 0;

    public HandleValue() {
    }

    public HandleValue(int index, byte[] type, byte[] data) {
        this.index = index;
        this.type = type;
        this.data = data;
    }

    public HandleValue(int index, byte[] type, byte[] data, byte ttlType, int ttl, int timestamp, ValueReference[] references, boolean adminRead, boolean adminWrite, boolean publicRead, boolean publicWrite) {
        this.index = index;
        this.type = type;
        this.data = data;
        this.ttl = ttl;
        this.timestamp = timestamp;
        this.references = references;
        this.adminRead = adminRead;
        this.adminWrite = adminWrite;
        this.publicRead = publicRead;
        this.publicWrite = publicWrite;
    }

    public final String getPermissionString() {
        return new String(new char[]{this.adminRead ? (char)'r' : '-', this.adminWrite ? (char)'w' : '-', this.publicRead ? (char)'r' : '-', this.publicWrite ? (char)'w' : '-'});
    }

    public String toString() {
        return " index=" + this.index + " type=" + (this.type == null ? "" : new String(this.type)) + " " + this.getPermissionString() + " \"" + (this.data == null ? "" : (Util.looksLikeBinary(this.data) ? Util.decodeHexString(this.data, false) : new String(this.data))) + '\"';
    }

    public boolean isExpired(int now, int timeRetrieved) {
        switch (this.ttlType) {
            case 0: {
                return Math.min(this.ttl, 172800) < now - timeRetrieved;
            }
            case 1: {
                return 172800 > now - timeRetrieved || this.ttl > now;
            }
        }
        System.err.println("Unknown ttl type: " + this.ttlType);
        return true;
    }

    public final boolean hasType(byte[] someType) {
        return Util.equalsCI(this.type, someType) || someType.length < this.type.length && this.type[someType.length] == 46 && Util.startsWithCI(this.type, someType);
    }

    public final String getDataAsString() {
        if (this.data == null) {
            return "";
        }
        if (Util.looksLikeBinary(this.data)) {
            return Util.decodeHexString(this.data, false);
        }
        return Util.decodeString(this.data);
    }

    public final String getTypeAsString() {
        return this.type == null ? "" : Util.decodeString(this.type);
    }

    public final String getTimestampAsString() {
        return this.timestamp <= 0 ? "NA" : new Date((long)this.timestamp * 1000L).toString();
    }

    public final String getNicerTimestampAsString() {
        String str;
        String string = str = this.timestamp <= 0 ? "NA" : new Date((long)this.timestamp * 1000L).toString();
        if (str != null && str.length() >= 28) {
            String anotherStr = str.substring(0, 11) + str.substring(24, 28) + " " + str.substring(11, 19) + " " + str.substring(20, 23);
            return anotherStr;
        }
        return str;
    }

    public final Date getTimestampAsDate() {
        return this.timestamp <= 0 ? null : new Date((long)this.timestamp * 1000L);
    }

    public final int getIndex() {
        return this.index;
    }

    public final void setIndex(int newIndex) {
        this.index = newIndex;
        this.cachedBuf = null;
    }

    public final byte[] getType() {
        return this.type;
    }

    public final void setType(byte[] newType) {
        this.type = newType;
        this.cachedBuf = null;
    }

    public final byte[] getData() {
        return this.data;
    }

    public final void setData(byte[] newData) {
        this.data = newData;
        this.cachedBuf = null;
    }

    public final byte getTTLType() {
        return this.ttlType;
    }

    public final void setTTLType(byte newTTLType) {
        this.ttlType = newTTLType;
        this.cachedBuf = null;
    }

    public final int getTTL() {
        return this.ttl;
    }

    public final void setTTL(int newTTL) {
        this.ttl = newTTL;
        this.cachedBuf = null;
    }

    public final int getTimestamp() {
        return this.timestamp;
    }

    public final void setTimestamp(int newTimestamp) {
        this.timestamp = newTimestamp;
    }

    public final ValueReference[] getReferences() {
        return this.references;
    }

    public final void setReferences(ValueReference[] newReferences) {
        this.references = newReferences;
        this.cachedBuf = null;
    }

    public final boolean getAdminCanRead() {
        return this.adminRead;
    }

    public final void setAdminCanRead(boolean newAdminRead) {
        this.adminRead = newAdminRead;
        this.cachedBuf = null;
    }

    public final boolean getAdminCanWrite() {
        return this.adminWrite;
    }

    public final void setAdminCanWrite(boolean newAdminWrite) {
        this.adminWrite = newAdminWrite;
        this.cachedBuf = null;
    }

    public final boolean getAnyoneCanRead() {
        return this.publicRead;
    }

    public final void setAnyoneCanRead(boolean newPublicRead) {
        this.publicRead = newPublicRead;
        this.cachedBuf = null;
    }

    public final boolean getAnyoneCanWrite() {
        return this.publicWrite;
    }

    public final void setAnyoneCanWrite(boolean newPublicWrite) {
        this.publicWrite = newPublicWrite;
        this.cachedBuf = null;
    }

    public HandleValue duplicate() {
        ValueReference[] newRefs = null;
        ValueReference[] myRefs = this.references;
        if (myRefs != null) {
            newRefs = new ValueReference[myRefs.length];
            for (int i = 0; i < newRefs.length; ++i) {
                newRefs[i] = new ValueReference(myRefs[i].handle, myRefs[i].index);
            }
        }
        return new HandleValue(this.index, Util.duplicateByteArray(this.type), Util.duplicateByteArray(this.data), this.ttlType, this.ttl, this.timestamp, newRefs, this.adminRead, this.adminWrite, this.publicRead, this.publicWrite);
    }
}

