/*
 * Decompiled with CFR 0.152.
 */
package net.handle.hdllib;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.PublicKey;
import java.util.ArrayList;
import net.cnri.simplexml.XParser;
import net.cnri.simplexml.XTag;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.HandleValue;
import net.handle.hdllib.Util;

public class NamespaceInfo {
    public static final String STATUS_ACTIVE = "active";
    public static final String STATUS_INACTIVE = "inactive";
    public static final String PUBKEY_TAG = "pubkey";
    public static final String CONTACT_TAG = "contact";
    public static final String STATUS_MSG_TAG = "statusmsg";
    public static final String STATUS_TAG = "status";
    public static final String DELEGATE_SUBNAMESPACES_TAG = "delegate";
    public static final String DELEGATION_DELIM_TAG = "delimiter";
    public static final char DEFAULT_DELEGATION_DELIMITER = '/';
    private static XParser xmlParser = new XParser();
    private static final NamespaceInfo nsInfo = new NamespaceInfo();
    private XTag xmlInfo = null;
    private NamespaceInfo parentNamespace = null;

    public NamespaceInfo(HandleValue namespaceValue) throws HandleException {
        this(namespaceValue.getData());
    }

    public NamespaceInfo(byte[] rawInfo) throws HandleException {
        try {
            this.xmlInfo = xmlParser.parse(new InputStreamReader((InputStream)new ByteArrayInputStream(rawInfo), "UTF8"), false);
        }
        catch (Exception e) {
            if (e instanceof HandleException) {
                throw (HandleException)e;
            }
            throw new HandleException(0, "Error parsing namespace information: " + e);
        }
    }

    public NamespaceInfo() {
        this.xmlInfo = new XTag("NAMESPACE");
    }

    public void setParentNamespace(NamespaceInfo parent) {
        this.parentNamespace = parent;
    }

    public NamespaceInfo getParentNamespace() {
        return this.parentNamespace;
    }

    public String getResponsiblePartyContactAddress() {
        return this.xmlInfo.getStrSubTag(CONTACT_TAG, null);
    }

    public String getStatusMessage() {
        return this.xmlInfo.getStrSubTag(STATUS_MSG_TAG, null);
    }

    public String getNamespaceStatus() {
        return this.xmlInfo.getStrSubTag(STATUS_TAG, STATUS_ACTIVE);
    }

    public boolean getAllowDelegation() {
        return this.xmlInfo.getBoolSubTag(DELEGATE_SUBNAMESPACES_TAG, false);
    }

    public char getDelegationDelimeter() {
        String delStr = this.xmlInfo.getStrSubTag(DELEGATION_DELIM_TAG, null);
        if (delStr == null || delStr.length() <= 0) {
            return '/';
        }
        return delStr.charAt(0);
    }

    public PublicKey[] getPublicKeys() {
        ArrayList<PublicKey> keys = new ArrayList<PublicKey>();
        for (int i = this.xmlInfo.getSubTagCount() - 1; i >= 0; --i) {
            XTag tag = this.xmlInfo.getSubTag(i);
            if (!tag.getName().equalsIgnoreCase(PUBKEY_TAG)) continue;
            try {
                PublicKey key = Util.getPublicKeyFromBytes(Util.encodeHexString(tag.getStrValue()), 0);
                if (key == null) continue;
                keys.add(key);
                continue;
            }
            catch (Exception e) {
                System.err.println("Error parsing public key from namespace info: " + e + "\n" + tag);
            }
        }
        return keys.toArray(new PublicKey[keys.size()]);
    }
}

