/*
 * Decompiled with CFR 0.152.
 */
package net.handle.hdllib;

import javax.crypto.Cipher;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.Util;
import net.handle.security.HdlSecurityProvider;

public class SessionInfo {
    private static int defaultTimeout = 86400;
    public int timeOut = 86400;
    public int sessionId;
    public byte[] sessionKey;
    public boolean encryptMessage = false;
    public boolean authenticateMessage = false;
    private int algorithmCode = 1;
    public byte[] identityKeyHandle = null;
    public int identityKeyIndex = -1;
    private int lastTransactionTime;
    private Cipher encryptCipher = null;
    private Cipher decryptCipher = null;

    public SessionInfo(int sessionid, byte[] sessionkey) {
        this.sessionId = sessionid;
        this.sessionKey = sessionkey;
        this.lastTransactionTime = (int)(System.currentTimeMillis() / 1000L);
        this.timeOut = defaultTimeout;
    }

    public SessionInfo(int sessionid, byte[] sessionkey, byte[] idenHandle, int idenIndex) {
        this.identityKeyHandle = idenHandle;
        this.identityKeyIndex = idenIndex;
        this.sessionId = sessionid;
        this.sessionKey = sessionkey;
        this.lastTransactionTime = (int)(System.currentTimeMillis() / 1000L);
        this.timeOut = defaultTimeout;
    }

    public int getEncryptionAlgorithmCode() {
        return this.algorithmCode;
    }

    public void setEncryptionAlgorithmCode(int algCode) {
        switch (algCode) {
            case 1: 
            case 2: 
            case 3: {
                this.encryptCipher = null;
                this.decryptCipher = null;
                this.algorithmCode = algCode;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid algorithm ID: " + algCode);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] encryptBuffer(byte[] buf, int offset, int len) throws HandleException {
        try {
            SessionInfo sessionInfo = this;
            synchronized (sessionInfo) {
                if (this.encryptCipher == null) {
                    HdlSecurityProvider provider = HdlSecurityProvider.getInstance();
                    if (provider == null) {
                        throw new HandleException(14, "Encryption/Key generation engine missing");
                    }
                    this.encryptCipher = provider.getCipher(this.algorithmCode, this.sessionKey, 1);
                }
            }
            return this.encryptCipher.doFinal(buf, offset, len);
        }
        catch (Exception e) {
            if (e instanceof HandleException) {
                throw (HandleException)e;
            }
            throw new HandleException(26, "Error encrypting buffer: " + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] decryptBuffer(byte[] buf, int offset, int len) throws HandleException {
        try {
            SessionInfo sessionInfo = this;
            synchronized (sessionInfo) {
                if (this.decryptCipher == null) {
                    HdlSecurityProvider provider = HdlSecurityProvider.getInstance();
                    if (provider == null) {
                        throw new HandleException(14, "Encryption/Key generation engine missing");
                    }
                    this.decryptCipher = provider.getCipher(this.algorithmCode, this.sessionKey, 2);
                }
            }
            return this.decryptCipher.doFinal(buf, offset, len);
        }
        catch (Exception e) {
            if (e instanceof HandleException) {
                throw (HandleException)e;
            }
            throw new HandleException(26, "Error decrypting buffer: " + e);
        }
    }

    public boolean isSessionAnonymous() {
        return this.identityKeyHandle == null || this.identityKeyIndex == -1;
    }

    public void setTimeOut(int newTimeout) {
        if (newTimeout > 0) {
            this.timeOut = newTimeout;
        }
    }

    public int getTimeOut() {
        return this.timeOut;
    }

    public byte[] getSessionKey() {
        return this.sessionKey;
    }

    public void setSessionKey(byte[] sessionkey) {
        this.sessionKey = sessionkey;
    }

    public boolean getEncryptedMesssageFlag() {
        return this.encryptMessage;
    }

    public boolean getAuthenticateMessageFlag() {
        return this.authenticateMessage;
    }

    public void setEncryptedMesssageFlag(boolean flag) {
        this.encryptMessage = flag;
    }

    public void setAuthenticateMessageFlag(boolean flag) {
        this.authenticateMessage = flag;
    }

    public void touch() {
        this.lastTransactionTime = (int)(System.currentTimeMillis() / 1000L);
    }

    public final boolean hasExpired() {
        return (long)this.lastTransactionTime < System.currentTimeMillis() / 1000L - (long)this.timeOut;
    }

    public static void setDefaultTimeout(int maxSessionTimeout) {
        defaultTimeout = maxSessionTimeout;
    }

    public static int getDefaultTimeout() {
        return defaultTimeout;
    }

    public int getSessionID() {
        return this.sessionId;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        SessionInfo info = (SessionInfo)obj;
        if (this.timeOut != info.getTimeOut()) {
            return false;
        }
        if (this.sessionId != info.getSessionID()) {
            return false;
        }
        if (!Util.equals(this.sessionKey, info.getSessionKey())) {
            return false;
        }
        if (this.encryptMessage != info.getEncryptedMesssageFlag()) {
            return false;
        }
        if (this.authenticateMessage != info.getAuthenticateMessageFlag()) {
            return false;
        }
        if (this.identityKeyIndex != info.identityKeyIndex) {
            return false;
        }
        return Util.equals(this.identityKeyHandle, info.identityKeyHandle);
    }
}

