/*
 * Decompiled with CFR 0.152.
 */
package net.handle.hdllib;

import java.io.IOException;
import java.io.OutputStream;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import net.handle.hdllib.Common;
import net.handle.hdllib.Encoder;
import net.handle.hdllib.Util;

public class SignedOutputStream
extends OutputStream {
    private OutputStream out;
    private Signature sig;

    public SignedOutputStream(PrivateKey sourceKey, OutputStream out) throws Exception {
        this.out = out;
        byte[] streamTypeBuf = new byte[4];
        Encoder.writeInt(streamTypeBuf, 0, 0);
        out.write(streamTypeBuf);
        byte[] hashID = Common.HASH_ALG_SHA1;
        byte[] hashIDLen = new byte[4];
        Encoder.writeInt(hashIDLen, 0, hashID.length);
        out.write(hashIDLen);
        out.write(hashID);
        this.sig = Signature.getInstance(Util.getSigIdFromHashAlgId(hashID, sourceKey.getAlgorithm()));
        this.sig.initSign(sourceKey);
    }

    public void write(int b) throws IOException {
        try {
            this.sig.update((byte)b);
        }
        catch (SignatureException e) {
            throw new IOException("Error updating signature: " + e);
        }
        this.out.write(b);
    }

    public void signBlock() throws IOException, SignatureException {
        byte[] lenbuf = new byte[4];
        byte[] sigBytes = this.sig.sign();
        Encoder.writeInt(lenbuf, 0, sigBytes.length);
        this.out.write(lenbuf);
        this.out.write(sigBytes);
    }

    public void flush() throws IOException {
        this.out.flush();
    }
}

