/*
 * Decompiled with CFR 0.152.
 */
package net.handle.hdllib;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.Socket;

public class TimedConnection {
    private static final int POLL_DELAY = 100;

    public static Socket getSocket(InetAddress addr, int port, int delay) throws InterruptedIOException, IOException {
        SocketThread t = new SocketThread(addr, port);
        t.start();
        int timer = 0;
        do {
            if (t.isConnected()) {
                return t.getSocket();
            }
            if (t.isError()) {
                throw t.getException();
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
        } while ((timer += 100) <= delay);
        throw new InterruptedIOException("Connection timed out.");
    }

    static class SocketThread
    extends Thread {
        private volatile Socket socket = null;
        private InetAddress addr = null;
        private int port = 0;
        private IOException exception = null;

        public SocketThread(InetAddress addr, int port) {
            this.addr = addr;
            this.port = port;
            this.setDaemon(true);
        }

        public void run() {
            Socket sock = null;
            try {
                sock = new Socket(this.addr, this.port);
            }
            catch (IOException e) {
                this.exception = e;
                return;
            }
            this.socket = sock;
        }

        public boolean isConnected() {
            return this.socket != null;
        }

        public boolean isError() {
            return this.exception != null;
        }

        public Socket getSocket() {
            return this.socket;
        }

        public IOException getException() {
            return this.exception;
        }
    }
}

