/*
 * Decompiled with CFR 0.152.
 */
package net.handle.jdb;

import net.handle.jdb.Block;
import net.handle.jdb.LongTable;

class BlockCache {
    private int maxSize;
    private boolean purging = false;
    private LongTable blocks;

    BlockCache(int size) {
        this.blocks = new LongTable(size);
        this.maxSize = size;
    }

    void clear() {
        this.blocks.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void putBlock(Block block) {
        long time;
        long oldKey = block.thisRecord;
        this.blocks.put(oldKey, block);
        block.lastTouched = time = System.currentTimeMillis();
        if (this.blocks.size() < this.maxSize || this.purging) {
            return;
        }
        BlockCache blockCache = this;
        synchronized (blockCache) {
            if (this.purging) {
                return;
            }
            this.purging = true;
            try {
                this.blocks.clear();
            }
            catch (Exception e) {
                System.err.println("error purging cache: " + e);
                e.printStackTrace(System.err);
            }
            finally {
                this.purging = false;
            }
            System.gc();
        }
    }

    Block getBlock(long blockNum) {
        Block b = this.blocks.get(blockNum);
        return b;
    }

    void removeBlock(long blockNum) {
        this.blocks.remove(blockNum);
    }
}

