/*
 * Decompiled with CFR 0.152.
 */
package net.handle.security.provider;

import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.spec.KeySpec;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPrivateKeySpec;
import javax.crypto.spec.DHPublicKeySpec;
import javax.crypto.spec.SecretKeySpec;
import net.handle.hdllib.Encoder;
import net.handle.hdllib.Util;
import net.handle.security.HdlSecurityProvider;

public final class GenericProvider
extends HdlSecurityProvider {
    private static MessageDigest md5digest = null;
    private static MessageDigest sha1digest = null;
    Cipher rsaCipher;
    private KeyGenerator aesKeygen = null;
    private KeyGenerator desKeygen = null;
    private KeyGenerator desedeKeygen = null;

    public Cipher getCipher(int algorithm, byte[] secretKey, int direction) throws Exception {
        KeySpec spec;
        String cipherAlg;
        String keyAlg;
        Cipher cipher = null;
        SecretKey key = null;
        switch (algorithm) {
            case 1: {
                keyAlg = "DES";
                cipherAlg = "DES/ECB/PKCS5Padding";
                spec = new DESKeySpec(secretKey);
                break;
            }
            case 3: {
                keyAlg = "AES";
                cipherAlg = "AES";
                spec = new SecretKeySpec(secretKey, "AES");
                break;
            }
            case 2: {
                keyAlg = "DESede";
                cipherAlg = "DESede/ECB/PKCS5Padding";
                spec = new DESedeKeySpec(secretKey);
                break;
            }
            default: {
                throw new Exception("Invalid encryption algorithm code: " + algorithm);
            }
        }
        SecretKeyFactory factory = SecretKeyFactory.getInstance(keyAlg);
        key = factory.generateSecret(spec);
        cipher = Cipher.getInstance(cipherAlg);
        cipher.init(direction, key);
        return cipher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] generateSecretKey(int keyAlg) throws Exception {
        KeyGenerator kgen = null;
        GenericProvider genericProvider = this;
        synchronized (genericProvider) {
            switch (keyAlg) {
                case 1: {
                    if (this.desKeygen == null) {
                        this.desKeygen = KeyGenerator.getInstance("DES");
                    }
                    kgen = this.desKeygen;
                    break;
                }
                case 2: {
                    if (this.desedeKeygen == null) {
                        this.desedeKeygen = KeyGenerator.getInstance("DESEDE");
                    }
                    kgen = this.desedeKeygen;
                    break;
                }
                case 3: {
                    if (this.aesKeygen == null) {
                        this.aesKeygen = KeyGenerator.getInstance("AES");
                    }
                    kgen = this.aesKeygen;
                    break;
                }
                default: {
                    throw new Exception("Invalid encryption algorithm code: " + keyAlg);
                }
            }
        }
        byte[] tmp = kgen.generateKey().getEncoded();
        byte[] encKey = new byte[tmp.length + 4];
        Encoder.writeInt(encKey, 0, keyAlg);
        System.arraycopy(tmp, 0, encKey, 4, tmp.length);
        return encKey;
    }

    public byte[] encrypt_DES_ECB_PKCS5(byte[] cleartext, int offset, int len, byte[] secretKey) throws Exception {
        Cipher cipher = this.getCipher(1, secretKey, 1);
        return cipher.doFinal(cleartext, offset, len);
    }

    public byte[] decrypt_DES_ECB_PKCS5(byte[] ciphertext, int offset, int len, byte[] secretKey) throws Exception {
        Cipher cipher = this.getCipher(1, secretKey, 2);
        return cipher.doFinal(ciphertext, offset, len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] md5hash(byte[] bytesToHash, int offset, int len) throws Exception {
        if (md5digest == null) {
            md5digest = MessageDigest.getInstance("MD5");
        }
        MessageDigest messageDigest = md5digest;
        synchronized (messageDigest) {
            md5digest.reset();
            md5digest.update(bytesToHash, offset, len);
            byte[] toReturn = md5digest.digest();
            md5digest.reset();
            return toReturn;
        }
    }

    public byte[] getDESKeyFromDH(DHPublicKey pub, DHPrivateKey priv) throws Exception {
        KeyFactory kf = KeyFactory.getInstance("DH");
        DHParameterSpec dhSpec = priv.getParams();
        DHPrivateKeySpec privSpec = new DHPrivateKeySpec(priv.getX(), dhSpec.getP(), dhSpec.getG());
        dhSpec = pub.getParams();
        DHPublicKeySpec pubSpec = new DHPublicKeySpec(pub.getY(), dhSpec.getP(), dhSpec.getG());
        KeyAgreement ka = KeyAgreement.getInstance("DH");
        ka.init(kf.generatePrivate(privSpec));
        ka.doPhase(kf.generatePublic(pubSpec), true);
        SecretKey secretKey = ka.generateSecret("DES");
        return secretKey.getEncoded();
    }

    public byte[] getKeyFromDH(DHPublicKey pub, DHPrivateKey priv, int algorithm) throws Exception {
        String algStr;
        KeyFactory kf = KeyFactory.getInstance("DH");
        DHParameterSpec dhSpec = priv.getParams();
        DHPrivateKeySpec privSpec = new DHPrivateKeySpec(priv.getX(), dhSpec.getP(), dhSpec.getG());
        dhSpec = pub.getParams();
        DHPublicKeySpec pubSpec = new DHPublicKeySpec(pub.getY(), dhSpec.getP(), dhSpec.getG());
        KeyAgreement ka = KeyAgreement.getInstance("DH");
        ka.init(kf.generatePrivate(privSpec));
        ka.doPhase(kf.generatePublic(pubSpec), true);
        switch (algorithm) {
            case 1: {
                algStr = "DES";
                break;
            }
            case 3: {
                algStr = "AES";
                break;
            }
            case 2: {
                algStr = "DESede";
                break;
            }
            default: {
                throw new Exception("Unknown algorithm code: " + algorithm);
            }
        }
        byte[] rawKey = ka.generateSecret(algStr).getEncoded();
        byte[] key = new byte[rawKey.length + 4];
        Encoder.writeInt(key, 0, algorithm);
        System.arraycopy(rawKey, 0, key, 4, rawKey.length);
        return key;
    }

    public KeyPair generateDHKeyPair(int keySize) throws Exception {
        KeyPairGenerator kpg = KeyPairGenerator.getInstance("DH");
        kpg.initialize(keySize);
        KeyPair kp = kpg.generateKeyPair();
        return kp;
    }

    public KeyPair generateDHKeyPair(BigInteger p, BigInteger g) throws Exception {
        KeyPairGenerator kpg = KeyPairGenerator.getInstance("DH");
        kpg.initialize(new DHParameterSpec(p, g));
        KeyPair kp = kpg.generateKeyPair();
        return kp;
    }

    public static void main(String[] argv) throws Exception {
        byte[] toEncrypt = "Hello, there".getBytes();
        GenericProvider provider = new GenericProvider();
        byte[] secKey = provider.generateSecretKey(1);
        System.err.println("Secret key: " + Util.decodeHexString(secKey, false));
        byte[] encrypted = provider.encrypt_DES_ECB_PKCS5(toEncrypt, 0, toEncrypt.length, secKey);
        System.err.println("Encrypted: " + Util.decodeHexString(encrypted, false));
        System.err.println("Un-encrypted: " + new String(provider.decrypt_DES_ECB_PKCS5(encrypted, 0, encrypted.length, secKey)));
    }
}

