/*
 * Decompiled with CFR 0.152.
 */
package net.handle.server;

import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Hashtable;
import java.util.Vector;
import net.handle.server.HdlHttpRequestHandler;
import net.handle.server.Main;
import net.handle.server.NetworkInterface;
import net.handle.server.RequestHandlerPool;

public class HdlHttpInterface
extends NetworkInterface {
    private InetAddress bindAddress;
    private int bindPort = 8000;
    private int backlog;
    private int numThreads = 10;
    private int threadLife = 200;
    private int maxHandlers = 200;
    private boolean logAccesses = false;
    private boolean trackThreads = false;
    private ServerSocket socket = null;
    private boolean keepServing = true;
    private String sfxCookieName = null;
    private String responsePage = null;
    private String queryPage = null;
    private String errorPage = null;
    private Vector virtualHosts = new Vector();

    public byte getProtocol() {
        return 2;
    }

    public int getPort() {
        return this.bindPort;
    }

    public HdlHttpInterface(Main main, Hashtable config) throws Exception {
        super(main);
        this.init(config);
    }

    private void init(Hashtable config) throws Exception {
        Object bindAddressStr = config.get("bind_address");
        this.bindAddress = bindAddressStr == null ? null : InetAddress.getByName(String.valueOf(bindAddressStr));
        this.bindPort = Integer.parseInt((String)config.get("bind_port"));
        this.backlog = Integer.parseInt((String)config.get("backlog"));
        try {
            this.numThreads = Integer.parseInt((String)config.get("num_threads"));
        }
        catch (Exception e) {
            this.main.logError(50, "unspecified thread count, using default: " + this.numThreads);
        }
        try {
            this.maxHandlers = Integer.parseInt((String)config.get("max_handlers"));
        }
        catch (Exception e) {
            this.main.logError(50, "unspecified max_handlers count, using default: " + this.maxHandlers);
        }
        try {
            if (config.containsKey("thread_life")) {
                this.threadLife = Integer.parseInt((String)config.get("thread_life"));
            }
        }
        catch (Exception e) {
            this.main.logError(50, "Invalid thread life, using default: " + this.threadLife);
        }
        this.trackThreads = config.containsKey("track_threads") && "yes".equals(config.get("track_threads"));
        this.logAccesses = config.containsKey("log_accesses") && "yes".equals(config.get("log_accesses"));
        this.sfxCookieName = (String)config.get("sfx_cookie");
        this.queryPage = (String)config.get("query_page");
        this.responsePage = (String)config.get("response_page");
        this.errorPage = (String)config.get("error_page");
        Object ob = config.get("virtual_hosts");
        if (ob instanceof Vector) {
            Vector v;
            this.virtualHosts = v = (Vector)ob;
        } else if (ob instanceof Hashtable) {
            Hashtable virtualHt = (Hashtable)ob;
            this.virtualHosts.addElement(virtualHt);
        }
        super.initialize();
    }

    protected void stopService() {
        this.keepServing = false;
        try {
            this.socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void serveRequests() {
        try {
            this.socket = this.bindAddress == null ? new ServerSocket(this.bindPort, this.backlog) : new ServerSocket(this.bindPort, this.backlog, this.bindAddress);
        }
        catch (Exception e) {
            this.main.logError(100, String.valueOf(this.getClass()) + ": Error setting up server socket: " + e);
            return;
        }
        System.out.println("HTTP handle Request Listener:");
        System.out.println("   address: " + (this.bindAddress == null ? "ANY" : "" + this.bindAddress));
        System.out.println("      port: " + this.bindPort);
        this.handlerPool = new RequestHandlerPool(this.trackThreads ? "HTTP" : null);
        this.handlerPool.setHandlerLife(this.threadLife);
        this.handlerPool.setMaxPossibleHandlers(this.maxHandlers);
        System.out.print("Starting HTTP request handlers: ");
        for (int threadNum = 0; threadNum < this.numThreads; ++threadNum) {
            System.out.print('.');
            this.handlerPool.addHandler(new HdlHttpRequestHandler(this.main, this, this.handlerPool, this.logAccesses, this.sfxCookieName, this.queryPage, this.responsePage, this.errorPage, this.virtualHosts));
        }
        System.out.println("");
        try {
            System.out.flush();
        }
        catch (Exception e) {
            // empty catch block
        }
        long reqCount = 0L;
        long recvTime = 0L;
        Socket newsock = null;
        while (this.keepServing) {
            try {
                newsock = this.socket.accept();
                recvTime = System.currentTimeMillis();
                ((HdlHttpRequestHandler)this.handlerPool.getHandler()).serviceRequest(newsock, recvTime);
                if (++reqCount <= 1000L) continue;
                this.needsGC = true;
                reqCount = 0L;
            }
            catch (Throwable e) {
                this.main.logError(75, String.valueOf(this.getClass()) + ": Error handling request: " + e);
                e.printStackTrace(System.err);
            }
        }
        try {
            this.socket.close();
        }
        catch (Exception e) {
            // empty catch block
        }
    }
}

