/*
 * Decompiled with CFR 0.152.
 */
package net.handle.server;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import net.handle.hdllib.AbstractMessage;
import net.handle.hdllib.AbstractRequest;
import net.handle.hdllib.AbstractResponse;
import net.handle.hdllib.Encoder;
import net.handle.hdllib.ErrorResponse;
import net.handle.hdllib.MessageEnvelope;
import net.handle.hdllib.ResponseMessageCallback;
import net.handle.hdllib.Util;
import net.handle.server.AbstractServer;
import net.handle.server.HandleServer;
import net.handle.server.HdlTcpInterface;
import net.handle.server.Main;
import net.handle.server.RequestHandler;
import net.handle.server.RequestHandlerPool;
import net.handle.server.ServerSideSessionInfo;

public class HdlTcpRequestHandler
implements Runnable,
RequestHandler,
ResponseMessageCallback {
    private static final int DEFAULT_MAX_MESSAGE_LENGTH = 1024;
    private Socket socket = null;
    private AbstractServer server;
    private Main main;
    private boolean isActive = true;
    private int invocations = 0;
    private Thread handlerThread;
    private boolean isRunning = false;
    private boolean logAccesses = false;
    private RequestHandlerPool handlerPool = null;
    private MessageEnvelope envelope = new MessageEnvelope();
    private byte[] envelopeBuf = new byte[20];
    private byte[] messageBuf = new byte[1024];
    public static final String ACCESS_TYPE = "TCP:HDL";
    public static final byte[] MSG_INVALID_MSG_SIZE = Util.encodeString("Invalid message length");
    private long recvTime = 0L;
    private AbstractRequest currentRequest;
    private HdlTcpInterface interfc;

    public HdlTcpRequestHandler(Main main, HdlTcpInterface ifc, RequestHandlerPool handlerPool, boolean logAccesses) {
        this.main = main;
        this.interfc = ifc;
        this.server = main.getServer();
        this.handlerPool = handlerPool;
        this.logAccesses = logAccesses;
        this.handlerThread = new Thread(this);
        this.handlerThread.start();
    }

    public RequestHandler newHandler() {
        return new HdlTcpRequestHandler(this.main, this.interfc, this.handlerPool, this.logAccesses);
    }

    public void resetState() {
        this.isRunning = false;
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public synchronized void deactivate() {
        this.isActive = false;
        this.resetState();
    }

    public int getInvocationCount() {
        return this.invocations;
    }

    public synchronized void serviceRequest(Socket socket, long recvTime) {
        this.recvTime = recvTime;
        this.socket = socket;
        this.isRunning = true;
        ++this.invocations;
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        while (this.isActive) {
            HdlTcpRequestHandler hdlTcpRequestHandler = this;
            synchronized (hdlTcpRequestHandler) {
                while (!this.isRunning && this.isActive) {
                    try {
                        this.wait();
                        if (this.isRunning) continue;
                        this.main.logError(75, "hdl-tcp error: invalid handler thread state");
                    }
                    catch (Exception e) {
                        this.main.logError(75, String.valueOf(this.getClass()) + "Got exception: " + e);
                    }
                }
                if (!this.isActive) continue;
            }
            InputStream in = null;
            try {
                int n;
                int r;
                in = this.socket.getInputStream();
                for (n = 0; n < 20 && (r = in.read(this.envelopeBuf, n, 20 - n)) >= 0; n += r) {
                }
                Encoder.decodeEnvelope(this.envelopeBuf, this.envelope);
                if (this.envelope.messageLength > 262144 || this.envelope.messageLength < 0) {
                    this.handleResponse(new ErrorResponse(0, 2, MSG_INVALID_MSG_SIZE));
                    this.close(in);
                    return;
                }
                if (this.messageBuf.length < this.envelope.messageLength) {
                    this.messageBuf = new byte[this.envelope.messageLength];
                }
                int r2 = 0;
                for (n = 0; n < this.envelope.messageLength && (r2 = in.read(this.messageBuf, n, this.envelope.messageLength - n)) >= 0; n += r2) {
                }
                if (n < this.envelope.messageLength) {
                    throw new Exception("Expecting " + this.envelope.messageLength + " bytes, " + "only received " + n);
                }
                if (this.envelope.encrypted) {
                    if (this.envelope.sessionId <= 0) {
                        this.main.logError(75, "Invalid session id. Request message not decrypted.");
                        System.err.println("Invalid session id. Request message not decrypted.");
                        this.handleResponse(new ErrorResponse(0, 501, Util.encodeString("Invalid session id. Unable to decrypt request message.")));
                        this.close(in);
                        return;
                    }
                    ServerSideSessionInfo sssinfo = null;
                    if (!(this.server instanceof HandleServer)) {
                        this.main.logError(75, "Session manager not available. Unable to decrypt request message.");
                        System.err.println("Session manager not available. Request message not decrypted.");
                        this.handleResponse(new ErrorResponse(0, 501, Util.encodeString("Session manager not available. Unable to decrypt request message.")));
                        this.close(in);
                        return;
                    }
                    sssinfo = ((HandleServer)this.server).getSession(this.envelope.sessionId);
                    if (sssinfo == null) {
                        this.main.logError(75, "Session information not available or time out. Unable to decrypt request message");
                        System.err.println("Session information not available or time out. Unable to decrypt request message.");
                        this.handleResponse(new ErrorResponse(0, 500, Util.encodeString("Session information not available or time out. Unable to decrypt request message.")));
                        this.close(in);
                        return;
                    }
                    try {
                        this.messageBuf = AbstractMessage.decryptMessage(this.messageBuf, sssinfo.getSessionKey());
                    }
                    catch (Exception e) {
                        this.main.logError(75, "Exception decrypting request: " + e);
                        System.err.println("Exception decrypting request with session key: " + e.getMessage());
                        this.handleResponse(new ErrorResponse(0, 501, Util.encodeString("Exception decrypting request with session key " + e)));
                        this.close(in);
                        this.close(in);
                        return;
                    }
                }
                this.currentRequest = (AbstractRequest)Encoder.decodeMessage(this.messageBuf, 0, this.envelope);
                String errMsg = this.interfc.canProcessMsg(this.currentRequest);
                if (errMsg != null) {
                    this.main.logError(75, errMsg);
                    this.handleResponse(new ErrorResponse(this.currentRequest.opCode, 4, Util.encodeString(errMsg)));
                    return;
                }
                this.server.processRequest(this.currentRequest, this);
            }
            catch (Throwable e) {
                this.main.logError(75, String.valueOf(this.getClass()) + ": Exception processing request: " + e);
            }
            finally {
                this.close(in);
            }
        }
    }

    private void close(InputStream in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.socket = null;
        }
        this.handlerPool.returnHandler(this);
    }

    public void handleResponseError(String error) {
        this.main.logError(50, String.valueOf(this.getClass()) + ": Server error: " + error);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleResponse(AbstractResponse response) {
        OutputStream out = null;
        boolean keepSocketOpen = response.continuous;
        try {
            byte[] msg = response.getEncodedMessage();
            boolean encrypted = false;
            if (response.encrypt && response.sessionId > 0) {
                ServerSideSessionInfo sssinfo = null;
                if (this.server instanceof HandleServer) {
                    sssinfo = ((HandleServer)this.server).getSession(response.sessionId);
                    if (sssinfo != null && sssinfo.lastRequestId > 0) {
                        try {
                            msg = AbstractMessage.encryptMessage(msg, sssinfo.getSessionKey());
                            encrypted = true;
                        }
                        catch (Exception e) {
                            this.main.logError(50, "Exception encrypting response: " + e);
                            System.err.println("Exception encrypting message with session key: " + e.getMessage());
                            encrypted = false;
                        }
                    }
                } else {
                    this.main.logError(50, "Session manager not available. Message not encrypted.");
                    System.err.println("Session manager not available. Message not encrypted.");
                    encrypted = false;
                }
            }
            this.envelope.encrypted = encrypted;
            this.envelope.messageLength = msg.length;
            this.envelope.messageId = 0;
            this.envelope.sessionId = response.sessionId;
            this.envelope.protocolMajorVersion = response.majorProtocolVersion;
            this.envelope.protocolMinorVersion = response.minorProtocolVersion;
            Encoder.encodeEnvelope(this.envelope, this.envelopeBuf);
            out = this.socket.getOutputStream();
            out.write(this.envelopeBuf);
            out.write(msg);
            long respTime = System.currentTimeMillis() - this.recvTime;
            if (this.logAccesses && this.currentRequest != null) {
                this.main.logAccess(ACCESS_TYPE, this.socket.getInetAddress(), this.currentRequest.opCode, response != null ? response.responseCode : 2, Util.decodeString(this.currentRequest.handle), respTime);
            }
            if (response.streaming) {
                response.streamResponse(out);
            }
        }
        catch (Exception e) {
            this.main.logError(50, String.valueOf(this.getClass()) + ": Exception sending response: " + e);
        }
        finally {
            if (out != null && !keepSocketOpen) {
                try {
                    out.flush();
                }
                catch (Exception e) {}
                try {
                    out.close();
                }
                catch (Exception e) {}
            }
        }
    }
}

