/*
 * Decompiled with CFR 0.152.
 */
package net.handle.server;

import java.io.File;
import java.util.Enumeration;
import net.handle.hdllib.Encoder;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.HandleStorage;
import net.handle.hdllib.HandleValue;
import net.handle.hdllib.ScanCallback;
import net.handle.hdllib.Util;
import net.handle.jdb.DBHash;
import net.handle.server.DBTransactionLog;
import net.handle.util.StreamTable;

public final class JDBHandleStorage
implements HandleStorage {
    public static final String USE_TEMPLATES_CONFIG_KEY = "use_templates";
    public static final String TEMPLATE_DELIM_CONFIG_KEY = "template_delimiter";
    private File serverDir;
    private DBHash db;
    private DBHash naDB;
    private boolean logTxns = true;
    private DBTransactionLog txnLog;
    private boolean useTemplates = false;
    private char templateDelimiter = (char)45;
    private final String WRITE_LOCK = "WRITE_LOCK";
    private final String READ_LOCK = "READ_LOCK";
    private boolean readOnly = false;
    private static final byte[] BLANK_BYTES = new byte[0];
    private static final HandleValue[] BLANK_VALUE = new HandleValue[0];

    public JDBHandleStorage(File serverDir, boolean logTxns) throws Exception {
        this.serverDir = serverDir;
        this.db = new DBHash(new File(serverDir, "handles.jdb"), 5000, 1000);
        this.naDB = new DBHash(new File(serverDir, "nas.jdb"), 1000, 500);
        this.logTxns = logTxns;
        if (logTxns) {
            this.txnLog = new DBTransactionLog(new File(serverDir, "dbtxns.log"));
        }
    }

    public void init(StreamTable config) {
        this.useTemplates = config.getBoolean(USE_TEMPLATES_CONFIG_KEY, this.useTemplates);
        String templateDelimStr = config.getStr(TEMPLATE_DELIM_CONFIG_KEY, "").trim();
        if (templateDelimStr.length() > 0) {
            this.templateDelimiter = templateDelimStr.charAt(0);
        }
    }

    public final boolean haveNA(byte[] authHandle) throws HandleException {
        try {
            return this.naDB.getValue(Util.upperCase(authHandle)) != null;
        }
        catch (Exception e) {
            throw new HandleException(1, "Error accessing NA data");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setHaveNA(byte[] authHandle, boolean flag) throws HandleException {
        String string = "WRITE_LOCK";
        synchronized ("WRITE_LOCK") {
            if (this.readOnly) {
                throw new HandleException(18);
            }
            try {
                byte[] handle = Util.upperCase(authHandle);
                if (flag) {
                    if (this.logTxns) {
                        this.txnLog.log((byte)2, handle, BLANK_BYTES);
                    }
                    this.naDB.setValue(handle, BLANK_BYTES);
                } else {
                    if (this.logTxns) {
                        this.txnLog.log((byte)3, handle, BLANK_BYTES);
                    }
                    this.naDB.deleteValue(handle);
                }
            }
            catch (HandleException e1) {
                throw e1;
            }
            catch (Exception e) {
                throw new HandleException(1, "Error accessing NA data");
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void createHandle(byte[] inHandle, HandleValue[] values) throws HandleException {
        String string = "WRITE_LOCK";
        synchronized ("WRITE_LOCK") {
            String string2 = "READ_LOCK";
            synchronized ("READ_LOCK") {
                if (this.readOnly) {
                    throw new HandleException(18);
                }
                byte[] handle = inHandle;
                byte[] existingValue = null;
                try {
                    existingValue = this.db.getValue(handle);
                }
                catch (Exception e) {
                    throw new HandleException(1, "Error checking for existing handle");
                }
                if (existingValue != null) {
                    throw new HandleException(5, "Handle already exists");
                }
                int totalSize = 4;
                for (int i = 0; i < values.length; ++i) {
                    totalSize += Encoder.calcStorageSize(values[i]) + 4;
                }
                byte[] data = new byte[totalSize];
                int offst = 0;
                offst += Encoder.writeInt(data, offst, values.length);
                for (int i = 0; i < values.length; ++i) {
                    int clumpLen = Encoder.encodeHandleValue(data, offst + 4, values[i]);
                    offst += Encoder.writeInt(data, offst, clumpLen);
                    offst += clumpLen;
                }
                try {
                    if (this.logTxns) {
                        this.txnLog.log((byte)0, handle, data);
                    }
                    this.db.setValue(handle, data);
                }
                catch (HandleException e1) {
                    throw e1;
                }
                catch (Exception e) {
                    throw new HandleException(1, "Error creating handle");
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean deleteHandle(byte[] inHandle) throws HandleException {
        String string = "WRITE_LOCK";
        synchronized ("WRITE_LOCK") {
            boolean deleted;
            if (this.readOnly) {
                throw new HandleException(18);
            }
            byte[] handle = inHandle;
            try {
                if (this.logTxns) {
                    this.txnLog.log((byte)1, handle, BLANK_BYTES);
                }
                deleted = this.db.deleteValue(handle);
            }
            catch (HandleException e1) {
                throw e1;
            }
            catch (Exception e) {
                throw new HandleException(1, "Error deleting handle");
            }
            return deleted;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final byte[][] getRawHandleValues(byte[] inHandle, int[] indexList, byte[][] typeList) throws HandleException {
        byte[] handle = inHandle;
        String string = "READ_LOCK";
        synchronized ("READ_LOCK") {
            int clumpIndex;
            byte[] clumpType;
            byte[] value;
            try {
                value = this.db.getValue(handle);
            }
            catch (Exception e) {
                throw new HandleException(1, "Error retrieving handle");
            }
            if (this.useTemplates && value == null) {
                boolean gotSlash = false;
                for (int i = 0; i < inHandle.length; ++i) {
                    if (!gotSlash) {
                        if (inHandle[i] != 47) continue;
                        gotSlash = true;
                        continue;
                    }
                    if (inHandle[i] != this.templateDelimiter) continue;
                    byte[] baseHandle = new byte[i];
                    System.arraycopy(inHandle, 0, baseHandle, 0, i);
                    return this.getRawHandleValues(baseHandle, indexList, typeList);
                }
                return null;
            }
            if (value == null) {
                return null;
            }
            int bufPos = 0;
            boolean allValues = !(indexList != null && indexList.length != 0 || typeList != null && typeList.length != 0);
            int numValues = Encoder.readInt(value, bufPos);
            int origBufPos = bufPos += 4;
            int matches = 0;
            if (allValues) {
                matches = numValues;
            } else {
                for (int i = 0; i < numValues; ++i) {
                    int clumpLen = Encoder.readInt(value, bufPos);
                    clumpType = Encoder.getHandleValueType(value, bufPos += 4);
                    clumpIndex = Encoder.getHandleValueIndex(value, bufPos);
                    if (Util.isParentTypeInArray(typeList, clumpType) || Util.isInArray(indexList, clumpIndex)) {
                        ++matches;
                    }
                    bufPos += clumpLen;
                }
            }
            byte[][] clumps = new byte[matches][];
            int clumpNum = 0;
            bufPos = origBufPos;
            for (int i = 0; i < numValues; ++i) {
                int clumpLen = Encoder.readInt(value, bufPos);
                clumpType = Encoder.getHandleValueType(value, bufPos += 4);
                clumpIndex = Encoder.getHandleValueIndex(value, bufPos);
                if (allValues || Util.isParentTypeInArray(typeList, clumpType) || Util.isInArray(indexList, clumpIndex)) {
                    clumps[clumpNum] = new byte[clumpLen];
                    System.arraycopy(value, bufPos, clumps[clumpNum], 0, clumpLen);
                    ++clumpNum;
                }
                bufPos += clumpLen;
            }
            return clumps;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void updateValue(byte[] inHandle, HandleValue[] values) throws HandleException {
        String string = "WRITE_LOCK";
        synchronized ("WRITE_LOCK") {
            if (this.readOnly) {
                throw new HandleException(18);
            }
            byte[] handle = inHandle;
            byte[] existingValue = null;
            try {
                existingValue = this.db.getValue(handle);
            }
            catch (Exception e) {
                throw new HandleException(1, "Error checking for existing handle");
            }
            if (existingValue == null) {
                throw new HandleException(9, "Cannot modify non-existent handle");
            }
            int totalSize = 4;
            for (int i = 0; i < values.length; ++i) {
                totalSize += Encoder.calcStorageSize(values[i]) + 4;
            }
            byte[] data = new byte[totalSize];
            int offst = 0;
            offst += Encoder.writeInt(data, offst, values.length);
            for (int i = 0; i < values.length; ++i) {
                int clumpLen = Encoder.encodeHandleValue(data, offst + 4, values[i]);
                offst += Encoder.writeInt(data, offst, clumpLen);
                offst += clumpLen;
            }
            try {
                if (this.logTxns) {
                    this.txnLog.log((byte)0, handle, data);
                }
                this.db.setValue(handle, data);
            }
            catch (HandleException e1) {
                throw e1;
            }
            catch (Exception e) {
                throw new HandleException(1, "Error updating handle");
            }
            return;
        }
    }

    public final void scanHandles(ScanCallback callback) throws HandleException {
        Enumeration recs = this.db.getEnumerator();
        while (recs.hasMoreElements()) {
            byte[][] record = (byte[][])recs.nextElement();
            callback.scanHandle(record[0]);
        }
    }

    public void scanNAs(ScanCallback callback) throws HandleException {
        Enumeration recs = this.naDB.getEnumerator();
        while (recs.hasMoreElements()) {
            byte[][] record = (byte[][])recs.nextElement();
            callback.scanHandle(record[0]);
        }
    }

    public final Enumeration getHandlesForNA(byte[] naHdl) throws HandleException {
        if (!this.haveNA(naHdl)) {
            throw new HandleException(0, "The requested naming authority doesn't live here");
        }
        return new HdlsForNAEnum(this.db.getEnumerator(), Util.getIDPart(naHdl));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void deleteAllRecords() throws HandleException {
        String string = "WRITE_LOCK";
        synchronized ("WRITE_LOCK") {
            if (this.readOnly) {
                throw new HandleException(18);
            }
            try {
                if (this.logTxns) {
                    this.txnLog.log((byte)4, BLANK_BYTES, BLANK_BYTES);
                }
                this.db.deleteAllRecords();
                this.naDB.deleteAllRecords();
            }
            catch (HandleException e1) {
                throw e1;
            }
            catch (Exception e) {
                throw new HandleException(1, String.valueOf(e));
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void checkpointDatabase() throws HandleException {
        if (!this.logTxns) {
            throw new HandleException(0, "Transaction logging not enabled");
        }
        String string = "WRITE_LOCK";
        synchronized ("WRITE_LOCK") {
            if (this.readOnly) {
                throw new HandleException(18);
            }
            this.readOnly = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            Thread th = null;
            try {
                th = new Thread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            JDBHandleStorage.this.naDB.copyTo(new File(JDBHandleStorage.this.serverDir, "nas.bak"));
                            JDBHandleStorage.this.db.copyTo(new File(JDBHandleStorage.this.serverDir, "handles.bak"));
                            JDBHandleStorage.this.txnLog.reset();
                        }
                        catch (Exception e) {
                            System.err.println("ERROR: Unable to backup JDB database: " + e);
                            e.printStackTrace(System.err);
                        }
                        finally {
                            JDBHandleStorage.this.readOnly = false;
                        }
                    }
                });
            }
            catch (Throwable t) {
                this.readOnly = false;
                throw new HandleException(1, "Error creating backup thread: " + t);
            }
            try {
                th.start();
            }
            catch (Throwable t) {
                this.readOnly = false;
                System.err.println("Unable to start checkpoint process: " + t);
                t.printStackTrace(System.err);
                throw new HandleException(1, String.valueOf(t));
            }
            return;
        }
    }

    public final void shutdown() {
        try {
            this.db.close();
        }
        catch (Throwable e) {
            // empty catch block
        }
        try {
            this.naDB.close();
        }
        catch (Throwable e) {
            // empty catch block
        }
        try {
            if (this.logTxns) {
                this.txnLog.shutdown();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void finalize() {
        this.shutdown();
    }

    private final class HdlsForNAEnum
    implements Enumeration {
        private byte[] prefix;
        private byte[] nextHdl = null;
        private Enumeration dbEnum;

        HdlsForNAEnum(Enumeration dbEnum, byte[] na) {
            this.prefix = Util.encodeString(Util.decodeString(na) + '/');
            this.dbEnum = dbEnum;
            this.seekNextValue();
        }

        private final void seekNextValue() {
            this.nextHdl = null;
            while (this.dbEnum.hasMoreElements()) {
                byte[][] tmpRecord = (byte[][])this.dbEnum.nextElement();
                if (!Util.startsWithCI(tmpRecord[0], this.prefix)) continue;
                this.nextHdl = tmpRecord[0];
                return;
            }
        }

        public final boolean hasMoreElements() {
            return this.nextHdl != null;
        }

        public final Object nextElement() {
            byte[] thisHdl = this.nextHdl;
            this.seekNextValue();
            return thisHdl;
        }
    }
}

