/*
 * Decompiled with CFR 0.152.
 */
package net.handle.util;

import java.util.NoSuchElementException;

public class IntTable {
    private transient TableEntry[] table;
    private transient int count;
    private int threshold;
    private float loadFactor;

    public IntTable(int initialCapacity, float loadFactor) {
        if (initialCapacity <= 0 || (double)loadFactor <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.loadFactor = loadFactor;
        this.table = new TableEntry[initialCapacity];
        this.threshold = (int)((float)initialCapacity * loadFactor);
    }

    public IntTable(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public IntTable() {
        this(101, 0.75f);
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public synchronized IntTableEnumerator keys() {
        return new IntTableEnumerator();
    }

    public synchronized boolean contains(Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        TableEntry[] tab = this.table;
        int i = tab.length;
        while (i-- > 0) {
            TableEntry e = tab[i];
            while (e != null) {
                if (e.value.equals(value)) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    public synchronized boolean containsKey(int key) {
        TableEntry[] tab = this.table;
        int hash = (int)((long)(key & 0xFFFFFFFF) | ((long)key & 0xFFFFFFFF00000000L) >> 32);
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        TableEntry e = tab[index];
        while (e != null) {
            if (e.key == key && e.hash == hash) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    public synchronized Object get(int key) {
        TableEntry[] tab = this.table;
        int hash = (int)((long)(key & 0xFFFFFFFF) | ((long)key & 0xFFFFFFFF00000000L) >> 32);
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        TableEntry e = tab[index];
        while (e != null) {
            if (e.key == key && e.hash == hash) {
                return e.value;
            }
            e = e.next;
        }
        return null;
    }

    protected void rehash() {
        int oldCapacity = this.table.length;
        TableEntry[] oldTable = this.table;
        int newCapacity = oldCapacity * 2 + 1;
        TableEntry[] newTable = new TableEntry[newCapacity];
        this.threshold = (int)((float)newCapacity * this.loadFactor);
        this.table = newTable;
        int i = oldCapacity;
        while (i-- > 0) {
            TableEntry old = oldTable[i];
            while (old != null) {
                TableEntry e = old;
                old = old.next;
                int index = (e.hash & Integer.MAX_VALUE) % newCapacity;
                e.next = newTable[index];
                newTable[index] = e;
            }
        }
    }

    public synchronized void put(int key, Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        TableEntry[] tab = this.table;
        int hash = (int)((long)(key & 0xFFFFFFFF) | ((long)key & 0xFFFFFFFF00000000L) >> 32);
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        TableEntry e = tab[index];
        while (e != null) {
            if (e.key == key && e.hash == hash) {
                e.value = value;
                return;
            }
            e = e.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            this.put(key, value);
            return;
        }
        e = new TableEntry();
        e.hash = hash;
        e.key = key;
        e.value = value;
        e.next = tab[index];
        tab[index] = e;
        ++this.count;
    }

    public synchronized void remove(int key) {
        TableEntry[] tab = this.table;
        int hash = (int)((long)(key & 0xFFFFFFFF) | ((long)key & 0xFFFFFFFF00000000L) >> 32);
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        TableEntry e = tab[index];
        TableEntry prev = null;
        while (e != null) {
            if (e.key == key && e.hash == hash) {
                if (prev != null) {
                    prev.next = e.next;
                } else {
                    tab[index] = e.next;
                }
                --this.count;
                return;
            }
            prev = e;
            e = e.next;
        }
    }

    public synchronized void clear() {
        TableEntry[] tab = this.table;
        int index = tab.length;
        while (--index >= 0) {
            tab[index] = null;
        }
        this.count = 0;
    }

    private class TableEntry {
        int hash;
        int key;
        Object value;
        TableEntry next;

        private TableEntry() {
        }

        protected Object clone() {
            TableEntry entry = new TableEntry();
            entry.hash = this.hash;
            entry.key = this.key;
            entry.value = this.value;
            entry.next = this.next != null ? (TableEntry)this.next.clone() : null;
            return entry;
        }
    }

    public class IntTableEnumerator {
        private int index;
        private TableEntry entry;

        public IntTableEnumerator() {
            this.index = IntTable.this.table.length;
            this.entry = null;
        }

        public boolean hasMoreElements() {
            if (this.entry != null) {
                return true;
            }
            while (--this.index >= 0) {
                this.entry = IntTable.this.table[this.index];
                if (this.entry == null) continue;
                return true;
            }
            return false;
        }

        public int nextKey() {
            if (this.entry == null) {
                while (this.index-- > 0 && (this.entry = IntTable.this.table[this.index]) == null) {
                }
            }
            if (this.entry != null) {
                TableEntry e = this.entry;
                this.entry = e.next;
                return e.key;
            }
            throw new NoSuchElementException("IntTableEnumerator");
        }
    }
}

