/*
 * Decompiled with CFR 0.152.
 */
package net.handle.util;

import java.util.Comparator;
import java.util.Hashtable;
import java.util.TreeSet;

public class LRUCacheTable
extends Hashtable {
    private int maxsize;
    private TreeSet lru;

    public LRUCacheTable(int maxsize) {
        super(maxsize);
        this.maxsize = maxsize;
        this.lru = new TreeSet(new Comparator(){

            public int compare(Object o1, Object o2) {
                return (int)(((Entry)o1).atime - ((Entry)o2).atime);
            }

            public boolean equals(Object o1, Object o2) {
                return this.compare(o1, o2) == 0;
            }
        });
    }

    public int getSize() {
        return this.maxsize;
    }

    public void setSize(int newsize) {
        this.maxsize = newsize;
    }

    public synchronized Object put(Object key, Object val) {
        Entry oldentry = (Entry)super.get(key);
        Entry newentry = new Entry();
        newentry.key = key;
        newentry.val = val;
        newentry.atime = System.currentTimeMillis();
        super.put(key, newentry);
        if (oldentry != null) {
            this.lru.remove(oldentry);
        }
        this.lru.add(newentry);
        this.evict();
        if (oldentry == null) {
            return null;
        }
        return oldentry.val;
    }

    private synchronized void evict() {
        while (this.size() > this.maxsize) {
            Entry e = (Entry)this.lru.first();
            this.remove(e.key);
            this.lru.remove(e);
        }
    }

    public synchronized Object getLruKey() {
        Entry e = (Entry)this.lru.first();
        return e.key;
    }

    public synchronized Object get(Object key) {
        Entry entry = (Entry)super.get(key);
        if (entry == null) {
            return null;
        }
        this.lru.remove(entry);
        entry.atime = System.currentTimeMillis();
        this.lru.add(entry);
        return entry.val;
    }

    class Entry {
        long atime;
        Object key;
        Object val;

        Entry() {
        }
    }
}

