/*
 * Decompiled with CFR 0.152.
 */
package net.handle.util;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import net.handle.util.DeepClone;
import net.handle.util.StreamObject;
import net.handle.util.StreamUtil;
import net.handle.util.StreamVector;
import net.handle.util.StringEncodingException;

public class StreamTable
extends Hashtable
implements StreamObject,
DeepClone {
    public boolean isStreamTable() {
        return true;
    }

    public boolean isStreamVector() {
        return false;
    }

    public char startingDelimiter() {
        return '{';
    }

    public void merge(Hashtable ht) {
        Enumeration e = ht.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            this.put(key, ht.get(key));
        }
    }

    public Object deepClone() {
        StreamTable newTable = new StreamTable();
        Enumeration e = this.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            Object value = this.get(key);
            try {
                if (key instanceof DeepClone) {
                    key = ((DeepClone)key).deepClone();
                }
            }
            catch (Exception ex) {
                System.out.println("Exception cloning key in StreamTable: " + ex);
            }
            try {
                if (value instanceof DeepClone) {
                    value = ((DeepClone)value).deepClone();
                }
            }
            catch (Exception ex) {
                System.out.println("Exception cloning value in StreamTable: " + ex);
            }
            newTable.put(key, value);
        }
        return newTable;
    }

    public Object get(Object key, Object defaultVal) {
        Object o = super.get(key);
        if (o == null) {
            return defaultVal;
        }
        return o;
    }

    public String getStr(Object key, String defaultVal) {
        Object o = super.get(key);
        if (o == null) {
            return defaultVal;
        }
        return String.valueOf(o);
    }

    public String getStr(Object key) {
        return this.getStr(key, null);
    }

    public boolean getBoolean(Object key, boolean defaultVal) {
        String val = this.getStr(key, defaultVal ? "yes" : "no").toLowerCase();
        if (val.startsWith("y") || val.startsWith("t")) {
            return true;
        }
        if (val.startsWith("n") || val.startsWith("f")) {
            return false;
        }
        return defaultVal;
    }

    public boolean getBoolean(Object key) {
        return this.getBoolean(key, false);
    }

    public long getLong(Object key, long defaultVal) {
        Object val = this.get(key);
        if (val == null) {
            return defaultVal;
        }
        try {
            return Long.parseLong(String.valueOf(val));
        }
        catch (Exception e) {
            System.err.println("Invalid long value: " + val);
            return defaultVal;
        }
    }

    public int getInt(Object key, int defaultVal) {
        Object val = this.get(key);
        if (val == null) {
            return defaultVal;
        }
        try {
            return Integer.parseInt(String.valueOf(val));
        }
        catch (Exception e) {
            System.err.println("Invalid int value: " + val);
            return defaultVal;
        }
    }

    public void readFrom(InputStream in) throws StringEncodingException, IOException {
        this.readFrom(new InputStreamReader(in));
    }

    public void readFrom(String str) throws StringEncodingException {
        StringReader in = new StringReader(str);
        try {
            this.readFrom(in);
        }
        catch (IOException e) {
            throw new StringEncodingException("IO exception: " + e.toString());
        }
    }

    public void readFrom(Reader str) throws StringEncodingException, IOException {
        char ch = StreamUtil.getNonWhitespace(str);
        if (ch != '{') {
            throw new StringEncodingException("Expected {, got " + ch);
        }
        this.readTheRest(str);
    }

    public void readFromFile(File file) throws StringEncodingException, IOException {
        FileReader in = new FileReader(file);
        this.readFrom(in);
        ((Reader)in).close();
    }

    public String[] getStringKeys() {
        Vector stringKeyVect = new Vector();
        Enumeration enumeration = this.keys();
        while (enumeration.hasMoreElements()) {
            Object obj = enumeration.nextElement();
            if (!(obj instanceof String)) continue;
            stringKeyVect.addElement(obj);
        }
        Object[] stringKeys = new String[stringKeyVect.size()];
        stringKeyVect.copyInto(stringKeys);
        return stringKeys;
    }

    public void readFromFile(String fileName) throws StringEncodingException, IOException {
        this.readFromFile(new File(fileName));
    }

    public void writeToFile(String fileName) throws StringEncodingException, IOException {
        this.writeToFile(new File(fileName));
    }

    public void writeToFile(File file) throws StringEncodingException, IOException {
        FileWriter out = new FileWriter(file);
        this.writeTo(out);
        ((Writer)out).close();
    }

    public void readTheRest(Reader str) throws StringEncodingException, IOException {
        this.clear();
        while (true) {
            Object obj;
            String key;
            char ch;
            if ((ch = StreamUtil.getNonWhitespace(str)) == '\"') {
                key = StreamUtil.readString(str);
            } else {
                if (ch == '}') {
                    return;
                }
                if (ch == '\uffffffff') {
                    throw new StringEncodingException("Unexpected end of input in StreamTable.");
                }
                key = StreamUtil.readUndelimitedString(str, ch);
            }
            ch = StreamUtil.getNonWhitespace(str);
            if (ch != '=') {
                throw new StringEncodingException("Expected \"=\" ");
            }
            ch = StreamUtil.getNonWhitespace(str);
            if (ch == '\"') {
                obj = StreamUtil.readString(str);
            } else if (ch == '{') {
                StreamTable valTable = new StreamTable();
                valTable.readTheRest(str);
                obj = valTable;
            } else if (ch == '(') {
                StreamVector vector = new StreamVector();
                vector.readTheRest(str);
                obj = vector;
            } else {
                if (ch == '\uffffffff') {
                    throw new StringEncodingException("Unexpected end of input: Expected value for key: '" + key + "'");
                }
                obj = StreamUtil.readUndelimitedString(str, ch);
            }
            this.put(key, obj);
        }
    }

    public void put(String key, boolean boolVal) {
        this.put(key, boolVal ? "yes" : "no");
    }

    public void put(String key, int intVal) {
        this.put(key, String.valueOf(intVal));
    }

    public String toString() {
        return this.writeToString();
    }

    public String writeToString() {
        StringWriter out = new StringWriter();
        try {
            this.writeTo(out);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        return out.toString();
    }

    public void writeTo(Writer out) throws IOException {
        out.write("{\n");
        Enumeration en = this.keys();
        while (en.hasMoreElements()) {
            Object key = en.nextElement();
            StreamUtil.writeEncodedString(out, String.valueOf(key));
            out.write(" = ");
            Object val = this.get(key);
            if (val instanceof StreamObject) {
                ((StreamObject)val).writeTo(out);
            } else {
                StreamUtil.writeEncodedString(out, String.valueOf(val));
            }
            out.write("\n");
        }
        out.write("}\n");
    }
}

