/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.math.BigDecimal;
import java.util.StringTokenizer;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.DurationValue;
import net.sf.saxon.value.Whitespace;

public final class MonthDurationValue
extends DurationValue
implements Comparable {
    static /* synthetic */ Class class$net$sf$saxon$value$DurationValue;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$CharSequence;
    static /* synthetic */ Class class$java$lang$Object;

    private MonthDurationValue() {
    }

    public MonthDurationValue(CharSequence charSequence) throws XPathException {
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(((Object)Whitespace.trimWhitespace(charSequence)).toString(), "-+PYM", true);
        try {
            String string;
            if (!stringTokenizer.hasMoreElements()) {
                this.badDuration("empty string", charSequence);
            }
            if ("+".equals(string = (String)stringTokenizer.nextElement())) {
                this.badDuration("+ sign not allowed in a duration", charSequence);
            } else if ("-".equals(string)) {
                this.negative = true;
                string = (String)stringTokenizer.nextElement();
            }
            if (!"P".equals(string)) {
                this.badDuration("missing 'P'", charSequence);
            }
            int n2 = 0;
            block6: while (stringTokenizer.hasMoreElements()) {
                string = (String)stringTokenizer.nextElement();
                int n3 = Integer.parseInt(string);
                if (!stringTokenizer.hasMoreElements()) {
                    this.badDuration("missing unit letter at end", charSequence);
                }
                char c = ((String)stringTokenizer.nextElement()).charAt(0);
                switch (c) {
                    case 'Y': {
                        if (n2 > 0) {
                            this.badDuration("Y is out of sequence", charSequence);
                        }
                        this.years = n3;
                        ++n;
                        n2 = 1;
                        continue block6;
                    }
                    case 'M': {
                        if (n2 == 0 || n2 == 1) {
                            this.months = n3;
                            ++n;
                            n2 = 2;
                            continue block6;
                        }
                        this.badDuration("M is out of sequence", charSequence);
                    }
                }
                this.badDuration("misplaced " + c, charSequence);
            }
            if (n == 0) {
                this.badDuration("Duration specifies no components", charSequence);
            }
            this.normalize();
        }
        catch (NumberFormatException numberFormatException) {
            this.badDuration("non-numeric component", charSequence);
        }
    }

    public CharSequence getStringValueCS() {
        int n = this.years * 12 + this.months;
        int n2 = n / 12;
        int n3 = n % 12;
        FastStringBuffer fastStringBuffer = new FastStringBuffer(32);
        if (this.negative) {
            fastStringBuffer.append('-');
        }
        fastStringBuffer.append('P');
        if (n2 != 0) {
            fastStringBuffer.append(n2 + "Y");
        }
        if (n3 != 0 || n2 == 0) {
            fastStringBuffer.append(n3 + "M");
        }
        return fastStringBuffer;
    }

    public void normalize() {
        if (this.months >= 12) {
            this.years += this.months / 12;
            this.months %= 12;
        }
        this.normalizeZeroDuration();
        this.normalized = true;
    }

    public int getLengthInMonths() {
        return (this.years * 12 + this.months) * (this.negative ? -1 : 1);
    }

    public static MonthDurationValue fromMonths(int n) {
        MonthDurationValue monthDurationValue = new MonthDurationValue();
        monthDurationValue.negative = n < 0;
        monthDurationValue.months = n < 0 ? -n : n;
        monthDurationValue.normalize();
        return monthDurationValue;
    }

    public DurationValue multiply(double d) throws XPathException {
        if (Double.isNaN(d)) {
            DynamicError dynamicError = new DynamicError("Cannot multiply/divide a duration by NaN");
            dynamicError.setErrorCode("FOCA0005");
            throw dynamicError;
        }
        double d2 = this.getLengthInMonths();
        double d3 = d * d2;
        if (Double.isInfinite(d3) || d3 > 2.147483647E9 || d3 < -2.147483648E9) {
            DynamicError dynamicError = new DynamicError("Overflow when multiplying/dividing a duration by a number");
            dynamicError.setErrorCode("FODT0002");
            throw dynamicError;
        }
        return MonthDurationValue.fromMonths((int)Math.round(d3));
    }

    public DecimalValue divide(DurationValue durationValue) throws XPathException {
        if (durationValue instanceof MonthDurationValue) {
            BigDecimal bigDecimal = BigDecimal.valueOf(this.getLengthInMonths());
            BigDecimal bigDecimal2 = BigDecimal.valueOf(((MonthDurationValue)durationValue).getLengthInMonths());
            if (bigDecimal2.signum() == 0) {
                DynamicError dynamicError = new DynamicError("Divide by zero (durations)");
                dynamicError.setErrorCode("FOAR0001");
                throw dynamicError;
            }
            return new DecimalValue(bigDecimal.divide(bigDecimal2, 20, 6));
        }
        throw new DynamicError("Cannot divide two durations of different type");
    }

    public DurationValue add(DurationValue durationValue) throws XPathException {
        if (durationValue instanceof MonthDurationValue) {
            return MonthDurationValue.fromMonths(this.getLengthInMonths() + ((MonthDurationValue)durationValue).getLengthInMonths());
        }
        DynamicError dynamicError = new DynamicError("Cannot add two durations of different type");
        dynamicError.setErrorCode("XPTY0004");
        throw dynamicError;
    }

    public DurationValue subtract(DurationValue durationValue) throws XPathException {
        if (durationValue instanceof MonthDurationValue) {
            return MonthDurationValue.fromMonths(this.getLengthInMonths() - ((MonthDurationValue)durationValue).getLengthInMonths());
        }
        DynamicError dynamicError = new DynamicError("Cannot subtract two durations of different type");
        dynamicError.setErrorCode("XPTY0004");
        throw dynamicError;
    }

    public DurationValue negate() {
        return MonthDurationValue.fromMonths(-this.getLengthInMonths());
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        return Type.YEAR_MONTH_DURATION_TYPE;
    }

    public Object convertToJava(Class clazz, XPathContext xPathContext) throws XPathException {
        if (clazz.isAssignableFrom(class$net$sf$saxon$value$DurationValue == null ? (class$net$sf$saxon$value$DurationValue = MonthDurationValue.class$("net.sf.saxon.value.DurationValue")) : class$net$sf$saxon$value$DurationValue)) {
            return this;
        }
        if (clazz == (class$java$lang$String == null ? (class$java$lang$String = MonthDurationValue.class$("java.lang.String")) : class$java$lang$String) || clazz == (class$java$lang$CharSequence == null ? (class$java$lang$CharSequence = MonthDurationValue.class$("java.lang.CharSequence")) : class$java$lang$CharSequence)) {
            return this.getStringValue();
        }
        if (clazz == (class$java$lang$Object == null ? (class$java$lang$Object = MonthDurationValue.class$("java.lang.Object")) : class$java$lang$Object)) {
            return this.getStringValue();
        }
        throw new DynamicError("Conversion of yearMonthDuration to " + clazz.getName() + " is not supported");
    }

    public int compareTo(Object object) {
        if (object instanceof MonthDurationValue) {
            return this.getLengthInMonths() - ((MonthDurationValue)object).getLengthInMonths();
        }
        throw new ClassCastException("Cannot compare a yearMonthDuration to an object of class " + object.getClass());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

