/*
 * Decompiled with CFR 0.152.
 */
package netscape.applet;

import java.awt.Component;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Vector;
import java.util.zip.ZipFile;
import netscape.applet.AppletClassLoader;
import netscape.security.AppletSecurityException;
import netscape.security.PrivilegeManager;
import netscape.security.Target;

public final class CastanetChannelInfo {
    private static final boolean debug = false;
    private int pathlen;
    private URL[] urls;
    private String[] zips;
    private ZipFile[] openZips;
    private String host;
    private String readPath;
    private String writePath;
    private static String workspacePath = null;
    private ThreadGroup group;
    private AppletClassLoader loader;
    private Vector windows = new Vector();

    public CastanetChannelInfo(int n, String string, String string2, String string3, URL[] uRLArray, String[] stringArray, ThreadGroup threadGroup, URL uRL) {
        PrivilegeManager privilegeManager = PrivilegeManager.getPrivilegeManager();
        Target target = Target.findTarget("MarimbaInternalTarget");
        privilegeManager.checkPrivilegeEnabled(target);
        this.pathlen = n;
        if (uRLArray == null && stringArray == null) {
            this.pathlen = 0;
        }
        this.readPath = CastanetChannelInfo.makeCanonicalPath(string);
        this.writePath = CastanetChannelInfo.makeCanonicalPath(string2);
        if (workspacePath == null) {
            workspacePath = CastanetChannelInfo.makeCanonicalPath(string3);
        }
        this.urls = uRLArray;
        this.zips = stringArray;
        if (stringArray != null) {
            int n2 = 0;
            while (n2 < this.zips.length) {
                if (this.zips[n2] != null) {
                    this.zips[n2] = CastanetChannelInfo.makeCanonicalPath(this.zips[n2]);
                }
                ++n2;
            }
            this.openZips = new ZipFile[stringArray.length];
        }
        this.group = threadGroup;
        this.host = uRL.getHost();
        this.loader = new AppletClassLoader(uRL, this);
    }

    public static void setWorkspacePath(String string) {
        if (workspacePath != null) {
            return;
        }
        PrivilegeManager privilegeManager = PrivilegeManager.getPrivilegeManager();
        Target target = Target.findTarget("MarimbaAppContextTarget");
        privilegeManager.checkPrivilegeEnabled(target);
        workspacePath = CastanetChannelInfo.makeCanonicalPath(string);
    }

    public static boolean marimbaCheckAccess(String string, ClassLoader classLoader, boolean bl, boolean bl2) {
        if (bl2) {
            return CastanetChannelInfo.checkFileAccess(string, workspacePath, bl, true);
        }
        try {
            AppletClassLoader appletClassLoader = (AppletClassLoader)classLoader;
            if (bl) {
                return appletClassLoader.marimbaCheckRead(string, bl2);
            }
            return appletClassLoader.marimbaCheckWrite(string, bl2);
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public static boolean checkThreadGroup(ClassLoader classLoader, ThreadGroup threadGroup) {
        if (classLoader == null) {
            return true;
        }
        try {
            AppletClassLoader appletClassLoader = (AppletClassLoader)classLoader;
            return appletClassLoader.marimbaCheckThreadGroup(threadGroup);
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public static void checkTopLevelWindow(ClassLoader classLoader, Object object) {
        if (classLoader == null) {
            return;
        }
        try {
            AppletClassLoader appletClassLoader = (AppletClassLoader)classLoader;
            appletClassLoader.marimbaCheckTopLevelWindow(object);
            return;
        }
        catch (ClassCastException classCastException) {
            return;
        }
    }

    public static String marimbaGetHost(ClassLoader classLoader) {
        if (classLoader == null) {
            return null;
        }
        try {
            AppletClassLoader appletClassLoader = (AppletClassLoader)classLoader;
            return appletClassLoader.marimbaGetHost();
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    public void close() {
        this.loader.close();
    }

    public Class loadClass(String string) throws ClassNotFoundException {
        return this.loader.loadClass(string);
    }

    public Class classFromBytes(byte[] byArray, String string) {
        return this.loader.classFromBytes(byArray, string);
    }

    boolean checkRead(String string, boolean bl) {
        return CastanetChannelInfo.checkFileAccess(string, this.readPath, true, bl);
    }

    boolean checkWrite(String string, boolean bl) {
        return CastanetChannelInfo.checkFileAccess(string, this.writePath, false, bl);
    }

    boolean checkThreadGroup(ThreadGroup threadGroup) {
        return threadGroup == this.group;
    }

    void checkTopLevelWindow(Object object) {
        try {
            this.windows.addElement((Window)object);
            return;
        }
        catch (ClassCastException classCastException) {
            return;
        }
    }

    int getPathlen() {
        return this.pathlen;
    }

    URL getURL(int n) {
        if (this.urls == null) {
            return null;
        }
        return this.urls[n];
    }

    ZipFile getZip(int n) {
        if (this.zips == null || this.zips[n] == null) {
            return null;
        }
        if (this.openZips[n] == null) {
            PrivilegeManager privilegeManager = PrivilegeManager.getPrivilegeManager();
            Target target = Target.findTarget("MarimbaAppContextTarget");
            try {
                privilegeManager.enablePrivilege(target);
                this.openZips[n] = new ZipFile(this.zips[n]);
            }
            catch (IOException iOException) {}
            privilegeManager.disablePrivilege(target);
        }
        return this.openZips[n];
    }

    synchronized void closeZips() {
        int n;
        if (this.windows != null) {
            n = this.windows.size();
            int n2 = 0;
            while (n2 < n) {
                Window window = (Window)this.windows.elementAt(n2);
                ((Component)window).hide();
                window.dispose();
                ++n2;
            }
        }
        if (this.openZips != null) {
            n = 0;
            while (n < this.openZips.length) {
                if (this.openZips[n] != null) {
                    try {
                        this.openZips[n].close();
                    }
                    catch (IOException iOException) {}
                    this.openZips[n] = null;
                }
                ++n;
            }
        }
        this.pathlen = 0;
        this.urls = null;
        this.zips = null;
        this.openZips = null;
        this.host = null;
        this.readPath = null;
        this.writePath = null;
        this.group = null;
        this.loader = null;
        this.windows = null;
    }

    String getHost() {
        return this.host;
    }

    private static String makeCanonicalPath(String string) {
        String string2 = null;
        if (File.separatorChar == '\\' && string.indexOf(47) != -1) {
            string = string.replace('/', '\\');
        }
        try {
            SecurityManager.enablePrivilege((String)"UniversalFileRead");
            SecurityManager.enablePrivilege((String)"UniversalPropertyRead");
            string2 = new File(string).getCanonicalPath();
            SecurityManager.revertPrivilege();
        }
        catch (IOException iOException) {
            throw new AppletSecurityException(String.valueOf(iOException.getMessage()) + ", \"" + string + "\"");
        }
        return string2;
    }

    private static boolean checkFileAccess(String string, String string2, boolean bl, boolean bl2) {
        if (string == null) {
            return false;
        }
        if (bl2) {
            return CastanetChannelInfo.checkFileAccess(string, workspacePath, bl, false);
        }
        if (string2 == null) {
            return false;
        }
        if ((string = CastanetChannelInfo.makeCanonicalPath(string)).startsWith(string2)) {
            int n = 0;
            int n2 = string2.length();
            int n3 = string.length();
            while (n2 < n3) {
                int n4 = string.indexOf(File.separatorChar, n2);
                if (n4 < 0) {
                    n4 = n3;
                }
                if (n2 == n4) {
                    ++n2;
                    continue;
                }
                if (n2 + 1 == n4 && string.charAt(n2) == File.separatorChar) {
                    n2 += 2;
                    continue;
                }
                if (n2 + 1 == n4 && string.charAt(n2) == '.') {
                    n2 += 2;
                    continue;
                }
                if (n2 + 2 == n4 && string.charAt(n2) == '.' && string.charAt(n2 + 1) == '.') {
                    if (--n < 0) {
                        return false;
                    }
                    n2 += 3;
                    continue;
                }
                ++n;
                n2 = n4 + 1;
            }
            return true;
        }
        return false;
    }
}

