/*
 * Decompiled with CFR 0.152.
 */
package netscape.debug;

import java.io.IOException;
import netscape.debug.DebugManager;

public class Debugger {
    static DebugManager debugMgr;
    static Process debuggerProcess;

    public static void debugBreak() {
        if (!Debugger.launchDebugger()) {
            return;
        }
        if (debugMgr != null) {
            debugMgr.debugBreak();
        }
    }

    public static boolean uncaughtException(Thread thread, Throwable throwable) {
        if (!Debugger.launchDebugger()) {
            return false;
        }
        if (debugMgr != null) {
            debugMgr.uncaughtException(thread, throwable);
            return true;
        }
        return false;
    }

    public static void setDebugManager(DebugManager debugManager) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSetFactory();
        }
        debugMgr = debugManager;
    }

    public static DebugManager getDebugManager() {
        return debugMgr;
    }

    public static void debuggerStartHook() {
    }

    static boolean launchDebugger() {
        if (debugMgr == null) {
            SecurityManager.enablePrivilege((String)"Debugger");
            String string = System.getProperty("java.debugger");
            if (string == null) {
                return false;
            }
            try {
                Runtime runtime = Runtime.getRuntime();
                debuggerProcess = runtime.exec(string);
                Runtime runtime2 = runtime;
                synchronized (runtime2) {
                    try {
                        runtime.wait(10000L);
                    }
                    catch (InterruptedException interruptedException) {
                        System.out.println(interruptedException.toString());
                    }
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return false;
            }
        }
        return true;
    }
}

