/*
 * Decompiled with CFR 0.152.
 */
package netscape.plugin.composer.io;

import java.util.Enumeration;
import java.util.Hashtable;
import netscape.plugin.composer.io.FooStringBuffer;
import netscape.plugin.composer.io.Token;

public class Tag
extends Token {
    private String name;
    private boolean open;
    private Hashtable attributes;
    private static String emptyString = "";

    public Tag(String string) {
        this(string, true);
    }

    public Tag(String string, boolean bl) {
        this.name = string.toUpperCase();
        this.open = bl;
    }

    public Object clone() {
        Tag tag = null;
        try {
            tag = (Tag)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
        }
        if (tag.attributes != null) {
            tag.attributes = (Hashtable)tag.attributes.clone();
        }
        return tag;
    }

    public String getName() {
        return this.name;
    }

    public boolean isOpen() {
        return this.open;
    }

    public boolean isClose() {
        return !this.open;
    }

    public void clearAttributes() {
        if (this.attributes != null) {
            this.attributes.clear();
        }
    }

    public String addAttribute(String string, String string2) {
        string = string.toUpperCase();
        if (this.attributes == null) {
            this.attributes = new Hashtable(7);
        }
        if (string2 == null || string2.length() == 0) {
            string2 = emptyString;
        }
        return this.attributes.put(string, string2);
    }

    public String removeAttribute(String string) {
        if (this.attributes == null) {
            return null;
        }
        return (String)this.attributes.remove(string);
    }

    public String lookupAttribute(String string) {
        if (this.attributes == null) {
            return null;
        }
        return (String)this.attributes.get(string);
    }

    public boolean containsAttribute(String string) {
        if (this.attributes == null) {
            return false;
        }
        return this.attributes.get(string) != null;
    }

    public Enumeration getAttributes() {
        if (this.attributes == null) {
            this.attributes = new Hashtable();
        }
        return this.attributes.keys();
    }

    public boolean hasAttributes() {
        if (this.attributes == null) {
            return false;
        }
        return !this.attributes.isEmpty();
    }

    public String toString() {
        FooStringBuffer fooStringBuffer = new FooStringBuffer();
        fooStringBuffer.append('<');
        if (!this.open) {
            fooStringBuffer.append('/');
        }
        fooStringBuffer.append(this.name.toString());
        if (this.attributes != null) {
            Enumeration enumeration = this.attributes.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                fooStringBuffer.append(' ');
                fooStringBuffer.append(string.toString());
                String string2 = (String)this.attributes.get(string);
                if (string2 == emptyString) continue;
                fooStringBuffer.append('=');
                fooStringBuffer.append(Tag.QuoteValue(string2));
            }
        }
        fooStringBuffer.append('>');
        return fooStringBuffer.toString();
    }

    public int hashCode() {
        int n = this.name.hashCode() + (this.open ? 1 : 0);
        if (this.attributes != null) {
            Enumeration enumeration = this.attributes.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = (String)this.attributes.get(string);
                n = n ^ string.hashCode() << 3 ^ string2.hashCode() << 13;
            }
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof Tag) {
            Tag tag = (Tag)object;
            if (!this.name.equals(tag.name)) {
                return false;
            }
            if (this.attributes != null && tag.attributes == null || this.attributes == null && tag.attributes != null) {
                return false;
            }
            if (this.attributes == null) {
                return true;
            }
            if (this.attributes.size() != tag.attributes.size()) {
                return false;
            }
            Enumeration enumeration = this.attributes.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = (String)this.attributes.get(string);
                String string3 = (String)tag.attributes.get(string);
                if (!(string2 != null ? !string2.equals(string3) : string3 != null)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static String QuoteValue(String string) {
        return "\"" + string + "\"";
    }
}

