/*
 * Decompiled with CFR 0.152.
 */
package org.adl.api.ecmascript;

import java.util.Enumeration;
import java.util.Hashtable;

public class APIErrorManager {
    public static final int SCORM_1_2_API = 1;
    public static final int SCORM_2004_API = 2;
    private static int mCurrentErrorCode = 0;
    private Hashtable mErrorCodes;
    private Hashtable mErrorMessages;
    private Hashtable mErrorDiagnostics;
    private Hashtable mAbstErrors;

    public APIErrorManager(int iAPIVersion) {
        mCurrentErrorCode = 0;
        this.mErrorCodes = new Hashtable(211);
        this.mErrorMessages = new Hashtable(59);
        this.mErrorDiagnostics = new Hashtable(59);
        this.mAbstErrors = new Hashtable(59);
        if (iAPIVersion == 2) {
            this.mErrorCodes.put(new Integer(0), new String("0"));
            this.mErrorCodes.put(new Integer(101), new String("101"));
            this.mErrorCodes.put(new Integer(102), new String("102"));
            this.mErrorCodes.put(new Integer(103), new String("103"));
            this.mErrorCodes.put(new Integer(104), new String("104"));
            this.mErrorCodes.put(new Integer(111), new String("111"));
            this.mErrorCodes.put(new Integer(112), new String("112"));
            this.mErrorCodes.put(new Integer(113), new String("113"));
            this.mErrorCodes.put(new Integer(122), new String("122"));
            this.mErrorCodes.put(new Integer(123), new String("123"));
            this.mErrorCodes.put(new Integer(132), new String("132"));
            this.mErrorCodes.put(new Integer(133), new String("133"));
            this.mErrorCodes.put(new Integer(142), new String("142"));
            this.mErrorCodes.put(new Integer(143), new String("143"));
            this.mErrorCodes.put(new Integer(201), new String("201"));
            this.mErrorCodes.put(new Integer(301), new String("301"));
            this.mErrorCodes.put(new Integer(351), new String("351"));
            this.mErrorCodes.put(new Integer(391), new String("391"));
            this.mErrorCodes.put(new Integer(401), new String("401"));
            this.mErrorCodes.put(new Integer(402), new String("402"));
            this.mErrorCodes.put(new Integer(403), new String("403"));
            this.mErrorCodes.put(new Integer(404), new String("404"));
            this.mErrorCodes.put(new Integer(405), new String("405"));
            this.mErrorCodes.put(new Integer(406), new String("406"));
            this.mErrorCodes.put(new Integer(407), new String("407"));
            this.mErrorCodes.put(new Integer(408), new String("408"));
            this.mErrorCodes.put(new Integer(1000), new String("301"));
            this.mErrorCodes.put(new Integer(1001), new String("301"));
            this.mErrorCodes.put(new Integer(1002), new String("301"));
            this.mErrorCodes.put(new Integer(1003), new String("351"));
            this.mErrorCodes.put(new Integer(1004), new String("301"));
            this.mErrorCodes.put(new Integer(1005), new String("351"));
            this.mErrorCodes.put(new Integer(1006), new String("351"));
            this.mErrorCodes.put(new Integer(1007), new String("351"));
            this.mErrorCodes.put(new Integer(2000), new String("404"));
            this.mErrorCodes.put(new Integer(9000), new String("401"));
            this.mErrorCodes.put(new Integer(1008), new String("301"));
            this.mErrorCodes.put(new Integer(1009), new String("351"));
            this.mErrorMessages.put(new Integer(0), new String("No Error"));
            this.mErrorMessages.put(new Integer(101), new String("General Exception"));
            this.mErrorMessages.put(new Integer(102), new String("General Initialization Error"));
            this.mErrorMessages.put(new Integer(103), new String("Already Initialized"));
            this.mErrorMessages.put(new Integer(104), new String("Content Instance Terminated"));
            this.mErrorMessages.put(new Integer(111), new String("General Termination Failure"));
            this.mErrorMessages.put(new Integer(112), new String("Termination Before Initialization"));
            this.mErrorMessages.put(new Integer(113), new String("Termination After Termination"));
            this.mErrorMessages.put(new Integer(122), new String("Retrieve Data Before Initialization"));
            this.mErrorMessages.put(new Integer(123), new String("Retrieve Data After Termination"));
            this.mErrorMessages.put(new Integer(132), new String("Store Data Before Initialization"));
            this.mErrorMessages.put(new Integer(133), new String("Store Data After Termination"));
            this.mErrorMessages.put(new Integer(142), new String("Commit Before Initialization"));
            this.mErrorMessages.put(new Integer(143), new String("Commit After Termination"));
            this.mErrorMessages.put(new Integer(201), new String("General Argument Error"));
            this.mErrorMessages.put(new Integer(301), new String("General Get Failure"));
            this.mErrorMessages.put(new Integer(351), new String("General Set Failure"));
            this.mErrorMessages.put(new Integer(391), new String("General Commit Failure"));
            this.mErrorMessages.put(new Integer(401), new String("Undefined Data Model Element"));
            this.mErrorMessages.put(new Integer(402), new String("Unimplemented Data Model Element"));
            this.mErrorMessages.put(new Integer(403), new String("Data Model Element Value Not Initialized"));
            this.mErrorMessages.put(new Integer(404), new String("Data Model Element Is Read Only"));
            this.mErrorMessages.put(new Integer(405), new String("Data Model Element Is Write Only"));
            this.mErrorMessages.put(new Integer(406), new String("Data Model Element Type Mismatch"));
            this.mErrorMessages.put(new Integer(407), new String("Data Model Element Value Out Of Range"));
            this.mErrorMessages.put(new Integer(408), new String("Data Model Dependency Not Established"));
            this.mErrorMessages.put(new Integer(1000), new String("General Get Failure"));
            this.mErrorMessages.put(new Integer(1001), new String("General Get Failure"));
            this.mErrorMessages.put(new Integer(1002), new String("General Get Failure"));
            this.mErrorMessages.put(new Integer(1003), new String("General Set Failure"));
            this.mErrorMessages.put(new Integer(1004), new String("General Get Failure"));
            this.mErrorMessages.put(new Integer(1005), new String("General Get Failure"));
            this.mErrorMessages.put(new Integer(1006), new String("General Set Failure"));
            this.mErrorMessages.put(new Integer(1007), new String("General Set Failure"));
            this.mErrorMessages.put(new Integer(2000), new String("Data Model Element Is Read Only"));
            this.mErrorMessages.put(new Integer(9000), new String("Undefined Data Model Element"));
            this.mErrorMessages.put(new Integer(1008), new String("General Get Failure"));
            this.mErrorMessages.put(new Integer(1009), new String("General Set Failure"));
            this.mErrorDiagnostics.put(new Integer(0), new String("No Error"));
            this.mErrorDiagnostics.put(new Integer(101), new String("General Exception"));
            this.mErrorDiagnostics.put(new Integer(102), new String("General Initialization Error"));
            this.mErrorDiagnostics.put(new Integer(103), new String("Already Initialized"));
            this.mErrorDiagnostics.put(new Integer(104), new String("Content Instance Terminated"));
            this.mErrorDiagnostics.put(new Integer(111), new String("General Termination Failure"));
            this.mErrorDiagnostics.put(new Integer(112), new String("Termination Before Initialization"));
            this.mErrorDiagnostics.put(new Integer(113), new String("Termination After Termination"));
            this.mErrorDiagnostics.put(new Integer(122), new String("Retrieve Data Before Initialization"));
            this.mErrorDiagnostics.put(new Integer(123), new String("Retrieve Data After Termination"));
            this.mErrorDiagnostics.put(new Integer(132), new String("Store Data Before Initialization"));
            this.mErrorDiagnostics.put(new Integer(133), new String("Store Data After Termination"));
            this.mErrorDiagnostics.put(new Integer(142), new String("Commit Before Initialization"));
            this.mErrorDiagnostics.put(new Integer(143), new String("Commit After Termination"));
            this.mErrorDiagnostics.put(new Integer(201), new String("General Argument Error"));
            this.mErrorDiagnostics.put(new Integer(301), new String("General Get Failure"));
            this.mErrorDiagnostics.put(new Integer(351), new String("General Set Failure"));
            this.mErrorDiagnostics.put(new Integer(391), new String("General Commit Failure"));
            this.mErrorDiagnostics.put(new Integer(401), new String("Undefined Data Model Element"));
            this.mErrorDiagnostics.put(new Integer(402), new String("Unimplemented Data Model Element"));
            this.mErrorDiagnostics.put(new Integer(403), new String("Data Model Element Value Not Initialized"));
            this.mErrorDiagnostics.put(new Integer(404), new String("Data Model Element Is Read Only"));
            this.mErrorDiagnostics.put(new Integer(405), new String("Data Model Element Is Write Only"));
            this.mErrorDiagnostics.put(new Integer(406), new String("Data Model Element Type Mismatch"));
            this.mErrorDiagnostics.put(new Integer(407), new String("Data Model Element Value Out Of Range"));
            this.mErrorDiagnostics.put(new Integer(408), new String("Data Model Dependency Not Established"));
            this.mErrorDiagnostics.put(new Integer(1000), new String("Data Model Element does not have Children"));
            this.mErrorDiagnostics.put(new Integer(1001), new String("Data Model Element does not have Count"));
            this.mErrorDiagnostics.put(new Integer(1002), new String("Data Model Element does not have Version"));
            this.mErrorDiagnostics.put(new Integer(1003), new String("Data Model Array Set out of Order"));
            this.mErrorDiagnostics.put(new Integer(1004), new String("Value Out of Range"));
            this.mErrorDiagnostics.put(new Integer(1005), new String("No Element Specified"));
            this.mErrorDiagnostics.put(new Integer(1006), new String("Value is not Unique"));
            this.mErrorDiagnostics.put(new Integer(1007), new String("Error - Maximum Exceeded"));
            this.mErrorDiagnostics.put(new Integer(2000), new String("Data Model Element Is a Keyword"));
            this.mErrorDiagnostics.put(new Integer(9000), new String("Request was Invalid"));
            this.mErrorDiagnostics.put(new Integer(1008), new String("Invalid Argument Error"));
            this.mErrorDiagnostics.put(new Integer(1009), new String("Attempt to overwrite Objective ID"));
            this.mAbstErrors.put(new String("0"), new Integer(0));
            this.mAbstErrors.put(new String("101"), new Integer(101));
            this.mAbstErrors.put(new String("102"), new Integer(102));
            this.mAbstErrors.put(new String("103"), new Integer(103));
            this.mAbstErrors.put(new String("104"), new Integer(104));
            this.mAbstErrors.put(new String("111"), new Integer(111));
            this.mAbstErrors.put(new String("112"), new Integer(112));
            this.mAbstErrors.put(new String("113"), new Integer(113));
            this.mAbstErrors.put(new String("122"), new Integer(122));
            this.mAbstErrors.put(new String("123"), new Integer(123));
            this.mAbstErrors.put(new String("132"), new Integer(132));
            this.mAbstErrors.put(new String("133"), new Integer(133));
            this.mAbstErrors.put(new String("142"), new Integer(142));
            this.mAbstErrors.put(new String("143"), new Integer(143));
            this.mAbstErrors.put(new String("201"), new Integer(201));
            this.mAbstErrors.put(new String("301"), new Integer(301));
            this.mAbstErrors.put(new String("351"), new Integer(351));
            this.mAbstErrors.put(new String("391"), new Integer(391));
            this.mAbstErrors.put(new String("401"), new Integer(401));
            this.mAbstErrors.put(new String("402"), new Integer(402));
            this.mAbstErrors.put(new String("403"), new Integer(403));
            this.mAbstErrors.put(new String("404"), new Integer(404));
            this.mAbstErrors.put(new String("405"), new Integer(405));
            this.mAbstErrors.put(new String("406"), new Integer(406));
            this.mAbstErrors.put(new String("407"), new Integer(407));
            this.mAbstErrors.put(new String("408"), new Integer(408));
        } else if (iAPIVersion == 1) {
            this.mErrorCodes.put(new Integer(0), new String("0"));
            this.mErrorCodes.put(new Integer(101), new String("101"));
            this.mErrorCodes.put(new Integer(102), new String("101"));
            this.mErrorCodes.put(new Integer(103), new String("101"));
            this.mErrorCodes.put(new Integer(104), new String("101"));
            this.mErrorCodes.put(new Integer(111), new String("101"));
            this.mErrorCodes.put(new Integer(112), new String("301"));
            this.mErrorCodes.put(new Integer(113), new String("101"));
            this.mErrorCodes.put(new Integer(122), new String("301"));
            this.mErrorCodes.put(new Integer(123), new String("101"));
            this.mErrorCodes.put(new Integer(132), new String("301"));
            this.mErrorCodes.put(new Integer(133), new String("101"));
            this.mErrorCodes.put(new Integer(142), new String("301"));
            this.mErrorCodes.put(new Integer(143), new String("101"));
            this.mErrorCodes.put(new Integer(201), new String("201"));
            this.mErrorCodes.put(new Integer(301), new String("101"));
            this.mErrorCodes.put(new Integer(351), new String("101"));
            this.mErrorCodes.put(new Integer(391), new String("101"));
            this.mErrorCodes.put(new Integer(401), new String("401"));
            this.mErrorCodes.put(new Integer(402), new String("401"));
            this.mErrorCodes.put(new Integer(403), new String("301"));
            this.mErrorCodes.put(new Integer(404), new String("403"));
            this.mErrorCodes.put(new Integer(405), new String("404"));
            this.mErrorCodes.put(new Integer(406), new String("405"));
            this.mErrorCodes.put(new Integer(407), new String("405"));
            this.mErrorCodes.put(new Integer(408), new String("405"));
            this.mErrorCodes.put(new Integer(1000), new String("101"));
            this.mErrorCodes.put(new Integer(1001), new String("101"));
            this.mErrorCodes.put(new Integer(1002), new String("101"));
            this.mErrorCodes.put(new Integer(1003), new String("101"));
            this.mErrorCodes.put(new Integer(1004), new String("101"));
            this.mErrorCodes.put(new Integer(1005), new String("101"));
            this.mErrorCodes.put(new Integer(1006), new String("101"));
            this.mErrorCodes.put(new Integer(1007), new String("405"));
            this.mErrorCodes.put(new Integer(2000), new String("402"));
            this.mErrorCodes.put(new Integer(9000), new String("401"));
            this.mErrorMessages.put(new Integer(0), new String("No Error"));
            this.mErrorMessages.put(new Integer(101), new String("General Exception"));
            this.mErrorMessages.put(new Integer(102), new String("General Exception"));
            this.mErrorMessages.put(new Integer(103), new String("General Exception"));
            this.mErrorMessages.put(new Integer(104), new String("General Exception"));
            this.mErrorMessages.put(new Integer(111), new String("General Exception"));
            this.mErrorMessages.put(new Integer(112), new String("Not Initialized"));
            this.mErrorMessages.put(new Integer(113), new String("General Exception"));
            this.mErrorMessages.put(new Integer(122), new String("Not Initialized"));
            this.mErrorMessages.put(new Integer(123), new String("General Exception"));
            this.mErrorMessages.put(new Integer(132), new String("Not Initialized"));
            this.mErrorMessages.put(new Integer(133), new String("General Exception"));
            this.mErrorMessages.put(new Integer(142), new String("Not Initialized"));
            this.mErrorMessages.put(new Integer(143), new String("General Exception"));
            this.mErrorMessages.put(new Integer(201), new String("Invalid Argument Error"));
            this.mErrorMessages.put(new Integer(301), new String("General Exception"));
            this.mErrorMessages.put(new Integer(351), new String("General Exception"));
            this.mErrorMessages.put(new Integer(391), new String("General Exception"));
            this.mErrorMessages.put(new Integer(401), new String("Not Implemented Error"));
            this.mErrorMessages.put(new Integer(402), new String("Not Implemented Error"));
            this.mErrorMessages.put(new Integer(403), new String("Not Initialized"));
            this.mErrorMessages.put(new Integer(404), new String("Element is Read Only"));
            this.mErrorMessages.put(new Integer(405), new String("Element is Write Only"));
            this.mErrorMessages.put(new Integer(406), new String("Incorrect Data Type"));
            this.mErrorMessages.put(new Integer(407), new String("Incorrect Data Type"));
            this.mErrorMessages.put(new Integer(408), new String("Incorrect Data Type"));
            this.mErrorMessages.put(new Integer(1000), new String("General Exception"));
            this.mErrorMessages.put(new Integer(1001), new String("General Exception"));
            this.mErrorMessages.put(new Integer(1002), new String("General Exception"));
            this.mErrorMessages.put(new Integer(1003), new String("General Exception"));
            this.mErrorMessages.put(new Integer(1004), new String("General Exception"));
            this.mErrorMessages.put(new Integer(1005), new String("General Exception"));
            this.mErrorMessages.put(new Integer(1006), new String("General Exception"));
            this.mErrorMessages.put(new Integer(1007), new String("Incorrect Data Type"));
            this.mErrorMessages.put(new Integer(2000), new String("Invalid Set Value.  Element is a Keyword"));
            this.mErrorMessages.put(new Integer(9000), new String("Not Implemented Error"));
            this.mErrorDiagnostics.put(new Integer(0), new String("No Error"));
            this.mErrorDiagnostics.put(new Integer(101), new String("General Exception"));
            this.mErrorDiagnostics.put(new Integer(102), new String("General Initialization Error"));
            this.mErrorDiagnostics.put(new Integer(103), new String("Already Initialized"));
            this.mErrorDiagnostics.put(new Integer(104), new String("Content Instance Terminated"));
            this.mErrorDiagnostics.put(new Integer(111), new String("General Termination Failure"));
            this.mErrorDiagnostics.put(new Integer(112), new String("Termination Before Initialization"));
            this.mErrorDiagnostics.put(new Integer(113), new String("Termination After Termination"));
            this.mErrorDiagnostics.put(new Integer(122), new String("Retrieve Data Before Initialization"));
            this.mErrorDiagnostics.put(new Integer(123), new String("Retrieve Data After Termination"));
            this.mErrorDiagnostics.put(new Integer(132), new String("Store Data Before Initialization"));
            this.mErrorDiagnostics.put(new Integer(133), new String("Store Data After Termination"));
            this.mErrorDiagnostics.put(new Integer(142), new String("Commit Before Initialization"));
            this.mErrorDiagnostics.put(new Integer(143), new String("Commit After Termination"));
            this.mErrorDiagnostics.put(new Integer(201), new String("General Argument Error"));
            this.mErrorDiagnostics.put(new Integer(301), new String("General Get Failure"));
            this.mErrorDiagnostics.put(new Integer(351), new String("General Set Failure"));
            this.mErrorDiagnostics.put(new Integer(391), new String("General Commit Failure"));
            this.mErrorDiagnostics.put(new Integer(401), new String("Undefined Data Model Element"));
            this.mErrorDiagnostics.put(new Integer(402), new String("Unimplemented Data Model Element"));
            this.mErrorDiagnostics.put(new Integer(403), new String("Data Model Element Value Not Initialized"));
            this.mErrorDiagnostics.put(new Integer(404), new String("Data Model Element Is Read Only"));
            this.mErrorDiagnostics.put(new Integer(405), new String("Data Model Element Is Write Only"));
            this.mErrorDiagnostics.put(new Integer(406), new String("Data Model Element Type Mismatch"));
            this.mErrorDiagnostics.put(new Integer(407), new String("Data Model Element Value Out Of Range"));
            this.mErrorDiagnostics.put(new Integer(408), new String("Data Model Dependency Not Established"));
            this.mErrorDiagnostics.put(new Integer(1000), new String("Data Model Element does not have Children"));
            this.mErrorDiagnostics.put(new Integer(1001), new String("Data Model Element does not have Count"));
            this.mErrorDiagnostics.put(new Integer(1002), new String("Data Model Element does not have Version"));
            this.mErrorDiagnostics.put(new Integer(1003), new String("Data Model Array Set out of Order"));
            this.mErrorDiagnostics.put(new Integer(1004), new String("Value Out of Range"));
            this.mErrorDiagnostics.put(new Integer(1005), new String("No Element Specified"));
            this.mErrorDiagnostics.put(new Integer(1006), new String("Value is not Unique"));
            this.mErrorDiagnostics.put(new Integer(1007), new String("Error - Maximum Exceeded"));
            this.mErrorDiagnostics.put(new Integer(2000), new String("Data Model Element Is a Keyword"));
            this.mErrorDiagnostics.put(new Integer(9000), new String("Request was Invalid"));
            this.mAbstErrors.put(new String("0"), new Integer(0));
            this.mAbstErrors.put(new String("101"), new Integer(101));
            this.mAbstErrors.put(new String("201"), new Integer(201));
            this.mAbstErrors.put(new String("202"), new Integer(1000));
            this.mAbstErrors.put(new String("203"), new Integer(1003));
            this.mAbstErrors.put(new String("301"), new Integer(403));
            this.mAbstErrors.put(new String("401"), new Integer(402));
            this.mAbstErrors.put(new String("402"), new Integer(351));
            this.mAbstErrors.put(new String("403"), new Integer(404));
            this.mAbstErrors.put(new String("404"), new Integer(405));
            this.mAbstErrors.put(new String("405"), new Integer(406));
        }
    }

    public String getCurrentErrorCode() {
        Integer errInt = new Integer(mCurrentErrorCode);
        String err = (String)this.mErrorCodes.get(errInt);
        if (err == null) {
            err = new String("0");
        }
        return err;
    }

    public void setCurrentErrorCode(int iCode) {
        mCurrentErrorCode = iCode;
    }

    public void clearCurrentErrorCode() {
        mCurrentErrorCode = 0;
    }

    public String getErrorDescription(String iCode) {
        String message = "";
        if (iCode != null && !iCode.equals("")) {
            Integer errInt = (Integer)this.mAbstErrors.get(iCode);
            if (errInt != null) {
                message = (String)this.mErrorMessages.get(errInt);
                if (message == null) {
                    message = "";
                }
            } else {
                message = "";
            }
        }
        return message;
    }

    public String getErrorDescription() {
        Integer errInt = new Integer(mCurrentErrorCode);
        return (String)this.mErrorMessages.get(errInt);
    }

    public String getErrorDiagnostic(String iCode) {
        String diagnostic = "";
        if (iCode != null && !iCode.equals("")) {
            String tempDiagnostic;
            Integer errInt = (Integer)this.mAbstErrors.get(iCode);
            if (errInt != null && (tempDiagnostic = (String)this.mErrorDiagnostics.get(errInt)) != null) {
                diagnostic = tempDiagnostic;
            }
        } else {
            Integer errInt = new Integer(mCurrentErrorCode);
            String tempDiagnostic = (String)this.mErrorDiagnostics.get(errInt);
            if (tempDiagnostic != null) {
                diagnostic = tempDiagnostic;
            }
        }
        return diagnostic;
    }

    public String getErrorDiagnostic() {
        Integer errInt = new Integer(mCurrentErrorCode);
        return (String)this.mErrorDiagnostics.get(errInt);
    }

    public boolean isValidErrorCode(String iErrorCode) {
        boolean result = false;
        Enumeration enumOfErrorCodes = this.mErrorCodes.elements();
        while (!result && enumOfErrorCodes.hasMoreElements()) {
            String comp = (String)enumOfErrorCodes.nextElement();
            if (!comp.equals(iErrorCode)) continue;
            result = true;
        }
        return result;
    }
}

