/*
 * Decompiled with CFR 0.152.
 */
package org.adl.datamodels;

import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;
import org.adl.datamodels.DMElement;
import org.adl.datamodels.DMProcessingInfo;
import org.adl.datamodels.DMRequest;
import org.adl.datamodels.RequestToken;

public class Children
extends DMElement {
    private String mBinding = "_children";
    private Vector mChildrenList = null;
    private boolean mRandomize = true;

    public Children(Vector iChildren, boolean iRandom) {
        if (iChildren.size() <= 0) {
            throw new IllegalArgumentException("No Children Specified");
        }
        this.mChildrenList = iChildren;
        this.mRandomize = iRandom;
    }

    public Children(Vector iChildren) {
        if (iChildren.size() <= 0) {
            throw new IllegalArgumentException("No Children Specified");
        }
        this.mChildrenList = iChildren;
    }

    @Override
    public int equals(RequestToken iValue, boolean iValidate) {
        int result = 9500;
        if (iValue != null) {
            if (iValue.getDelimiterCount() == 0) {
                result = 9501;
                StringTokenizer st = new StringTokenizer(iValue.getValue(), ",");
                if (st.countTokens() == this.mChildrenList.size()) {
                    Vector<Boolean> found = new Vector<Boolean>();
                    for (int i = 0; i < this.mChildrenList.size(); ++i) {
                        found.add(new Boolean(false));
                    }
                    boolean located = true;
                    while (st.hasMoreTokens() && located) {
                        String tok = st.nextToken();
                        located = false;
                        for (int i = 0; i < this.mChildrenList.size(); ++i) {
                            String child = (String)this.mChildrenList.elementAt(i);
                            if (!tok.trim().equals(child.trim())) continue;
                            Boolean already = (Boolean)found.elementAt(i);
                            if (already.booleanValue()) break;
                            found.setElementAt(new Boolean(true), i);
                            located = true;
                            already = (Boolean)found.elementAt(i);
                            break;
                        }
                        if (located) continue;
                        result = 9502;
                        break;
                    }
                    if (result != 9502) {
                        for (int i = 0; i < this.mChildrenList.size(); ++i) {
                            Boolean ok = (Boolean)found.elementAt(i);
                            if (ok.booleanValue()) continue;
                            result = 9502;
                            break;
                        }
                    }
                } else {
                    result = 9502;
                }
            } else {
                result = 9502;
            }
        }
        return result;
    }

    @Override
    public String getDMElementBindingString() {
        return this.mBinding;
    }

    @Override
    public int getValue(RequestToken iArguments, boolean iAdmin, boolean iDelimiters, DMProcessingInfo oInfo) {
        oInfo.mValue = new String("");
        if (this.mRandomize) {
            Random gen = new Random();
            int rand = -1;
            int num = -1;
            Vector<Integer> usedSet = new Vector<Integer>();
            boolean ok = false;
            for (int i = 0; i < this.mChildrenList.size(); ++i) {
                ok = false;
                while (!ok) {
                    rand = gen.nextInt();
                    num = Math.abs(rand % this.mChildrenList.size());
                    int lookUp = usedSet.indexOf(new Integer(num));
                    if (lookUp != -1) continue;
                    usedSet.add(new Integer(num));
                    if (oInfo.mValue.equals("")) {
                        oInfo.mValue = oInfo.mValue + (String)this.mChildrenList.elementAt(num);
                    } else {
                        oInfo.mValue = oInfo.mValue + ",";
                        oInfo.mValue = oInfo.mValue + (String)this.mChildrenList.elementAt(num);
                    }
                    ok = true;
                }
            }
        } else {
            for (int i = 0; i < this.mChildrenList.size(); ++i) {
                if (oInfo.mValue.equals("")) {
                    oInfo.mValue = oInfo.mValue + (String)this.mChildrenList.elementAt(i);
                    continue;
                }
                oInfo.mValue = oInfo.mValue + ",";
                oInfo.mValue = oInfo.mValue + (String)this.mChildrenList.elementAt(i);
            }
        }
        return 0;
    }

    @Override
    public int processRequest(DMRequest ioRequest, DMProcessingInfo oInfo) {
        int error = 0;
        error = ioRequest.hasMoreTokens() ? 401 : 9001;
        return error;
    }

    @Override
    public int setValue(RequestToken iValue, boolean iAdmin) {
        return 2000;
    }

    @Override
    public int validate(RequestToken iValue) {
        return 0;
    }
}

