/*
 * Decompiled with CFR 0.152.
 */
package org.adl.datamodels;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;
import org.adl.datamodels.DMDelimiter;
import org.adl.datamodels.DMElementDescriptor;
import org.adl.datamodels.DMProcessingInfo;
import org.adl.datamodels.DMRequest;
import org.adl.datamodels.DataModel;
import org.adl.datamodels.RequestToken;

public abstract class DMElement
implements Serializable {
    protected DMElementDescriptor mDescription = null;
    protected DMElement mParent = null;
    protected Vector mChildrenBindings = null;
    protected Hashtable mChildren = null;
    protected Vector mRecords = null;
    protected String mValue = null;
    protected Vector mDelimiters = null;
    protected boolean mInitialized = false;
    protected boolean mTruncSPM = false;
    protected boolean mSetBySCO = false;

    public String getDMElementBindingString() {
        return this.mDescription.mBinding;
    }

    public boolean isInitialized() {
        return this.mInitialized;
    }

    public DMElementDescriptor getDescription() {
        return this.mDescription;
    }

    public void setDescription(DMElementDescriptor iDescription) {
        this.mDescription = iDescription;
    }

    public void putChild(String iName, DMElement iElement) {
        if (this.mChildren == null) {
            this.mChildren = new Hashtable();
        }
        this.mChildren.put(iName, iElement);
    }

    public abstract int getValue(RequestToken var1, boolean var2, boolean var3, DMProcessingInfo var4);

    public abstract int setValue(RequestToken var1, boolean var2);

    public abstract int equals(RequestToken var1, boolean var2);

    public int equals(RequestToken iValue) {
        return this.equals(iValue, true);
    }

    public abstract int validate(RequestToken var1);

    public abstract int processRequest(DMRequest var1, DMProcessingInfo var2);

    protected String getDotNotation(DataModel iDM) {
        String name = "";
        if (this.mParent != null) {
            name = name + this.mParent.getDotNotation(iDM);
            if (this.mDescription != null) {
                if (this.mDescription.mBinding != null) {
                    name = name + "." + this.mDescription.mBinding;
                    if (this.mDescription.mOldSPM > 0) {
                        name = name + ".n";
                    }
                } else {
                    name = "ERROR";
                }
            } else {
                name = "ERROR";
            }
        } else {
            name = iDM.getDMBindingString();
        }
        return name;
    }

    public void setBySCO(boolean iSetBySCO) {
        this.mSetBySCO = iSetBySCO;
    }

    protected int doGeneralGet(boolean iAdmin, boolean iDelimiters, DMProcessingInfo oInfo) {
        int result = 0;
        if (this.mDescription.mSPM == -1) {
            if (this.mDescription.mIsReadable || iAdmin) {
                if (this.mInitialized) {
                    oInfo.mValue = "";
                    if (this.mDelimiters != null) {
                        for (int i = 0; i < this.mDelimiters.size(); ++i) {
                            DMDelimiter del = (DMDelimiter)this.mDelimiters.elementAt(i);
                            oInfo.mValue = oInfo.mValue + del.getDotNotation(iDelimiters);
                        }
                    }
                    oInfo.mValue = oInfo.mValue + this.mValue;
                } else {
                    result = 403;
                }
            } else {
                result = 405;
            }
        } else {
            result = 401;
        }
        return result;
    }
}

