/*
 * Decompiled with CFR 0.152.
 */
package org.adl.datamodels;

import java.util.StringTokenizer;
import java.util.Vector;
import org.adl.datamodels.RequestDelimiter;
import org.adl.datamodels.RequestToken;

public class DMRequest {
    public static final int NO_MORE_TOKENS = -1;
    private boolean mAdmin = false;
    private int mCurToken = -1;
    private boolean mDefDelimiters = false;
    private boolean mGetValue = false;
    private Vector mTokens = null;

    public DMRequest(String iElement, boolean iAdmin, boolean iDefDelimiters) {
        if (iElement != null) {
            this.mAdmin = iAdmin;
            this.mDefDelimiters = iDefDelimiters;
            this.mGetValue = true;
            this.parseElement(iElement);
        } else {
            throw new NullPointerException("Element name not specified");
        }
    }

    public DMRequest(String iElement) {
        if (iElement != null) {
            this.mGetValue = true;
            this.parseElement(iElement);
        } else {
            throw new NullPointerException();
        }
    }

    public DMRequest(String iElement, String iValue, boolean iAdmin) {
        if (iElement != null) {
            this.mAdmin = iAdmin;
            this.parseElement(iElement);
            this.parseValue(iValue);
        } else {
            throw new NullPointerException();
        }
    }

    public DMRequest(String iRequest, String iValue) {
        if (iRequest != null) {
            this.parseElement(iRequest);
            this.parseValue(iValue);
        } else {
            throw new NullPointerException();
        }
    }

    public RequestToken getCurToken() {
        RequestToken token = null;
        if (this.mTokens != null && this.mCurToken < this.mTokens.size()) {
            token = (RequestToken)this.mTokens.elementAt(this.mCurToken);
        }
        return token;
    }

    public int getCurTokenCount() {
        int count = -1;
        if (this.mTokens != null && this.mCurToken < this.mTokens.size()) {
            count = this.mCurToken;
        }
        return count;
    }

    public RequestToken getNextToken() {
        RequestToken token = null;
        if (this.mTokens != null && this.mCurToken < this.mTokens.size()) {
            token = (RequestToken)this.mTokens.elementAt(this.mCurToken);
            ++this.mCurToken;
        }
        return token;
    }

    public RequestToken getToken(int iIndex) {
        RequestToken token = null;
        if (this.mTokens != null && iIndex >= 0 && iIndex < this.mTokens.size()) {
            token = (RequestToken)this.mTokens.elementAt(iIndex);
        }
        return token;
    }

    public boolean hasMoreTokens() {
        boolean more = false;
        if (this.mTokens != null && this.mCurToken != -1 && this.mCurToken < this.mTokens.size()) {
            more = true;
        }
        return more;
    }

    public boolean isAdminRequest() {
        return this.mAdmin;
    }

    public boolean isGetValueRequest() {
        return this.mGetValue;
    }

    public int numTokens() {
        int numberOfTokens = -1;
        if (this.mTokens != null) {
            numberOfTokens = this.mTokens.size();
        }
        return numberOfTokens;
    }

    public String showDotNotation() {
        String dot = "";
        Vector dels = null;
        if (this.mTokens != null) {
            block6: for (int i = 0; i < this.mTokens.size(); ++i) {
                RequestToken tok = (RequestToken)this.mTokens.elementAt(i);
                switch (tok.getType()) {
                    case 4: {
                        RequestDelimiter del;
                        int j;
                        dot = dot + ".";
                        dels = tok.getDelimiters();
                        for (j = 0; j < dels.size(); ++j) {
                            del = (RequestDelimiter)dels.elementAt(j);
                            dot = dot + del.showDotNotation();
                        }
                        continue block6;
                    }
                    case 0: {
                        dot = dot + tok.getValue();
                        continue block6;
                    }
                    case 1: 
                    case 2: {
                        dot = dot + "." + tok.getValue();
                        continue block6;
                    }
                    case 3: {
                        RequestDelimiter del;
                        int j;
                        dot = dot + ",";
                        dels = tok.getDelimiters();
                        if (dels != null) {
                            for (j = 0; j < dels.size(); ++j) {
                                del = (RequestDelimiter)dels.elementAt(j);
                                dot = dot + del.showDotNotation();
                            }
                        }
                        dot = dot + tok.getValue();
                        continue block6;
                    }
                }
            }
        }
        return dot;
    }

    public boolean supplyDefaultDelimiters() {
        return this.mDefDelimiters;
    }

    public void reset() {
        this.mCurToken = this.mTokens != null ? 0 : -1;
    }

    private void parseElement(String iElement) {
        this.mTokens = new Vector();
        this.mCurToken = 0;
        RequestToken tok = null;
        StringTokenizer st = new StringTokenizer(iElement, ".");
        String name = null;
        try {
            name = st.nextToken();
            if (name.length() <= 0) {
                throw new IllegalArgumentException("Empty token");
            }
            tok = new RequestToken(name, 0);
            this.mTokens.add(tok);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Data Model improperly specified");
        }
        while (st.hasMoreTokens()) {
            name = st.nextToken();
            try {
                if (name.length() <= 0) {
                    throw new IllegalArgumentException("Empty token");
                }
                tok = new RequestToken(name, false);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Element improperly specified");
            }
            this.mTokens.add(tok);
        }
    }

    private void parseValue(String iValue) {
        if (this.mTokens != null) {
            RequestToken tok = new RequestToken(iValue, true);
            this.mTokens.add(tok);
        }
    }
}

