/*
 * Decompiled with CFR 0.152.
 */
package org.adl.datamodels;

import java.util.Vector;
import org.adl.datamodels.RequestDelimiter;

public class RequestToken {
    public static final int TOKEN_UNKNOWN = -1;
    public static final int TOKEN_DATA_MODEL = 0;
    public static final int TOKEN_ELEMENT = 1;
    public static final int TOKEN_INDEX = 2;
    public static final int TOKEN_VALUE = 3;
    public static final int TOKEN_ARGUMENT = 4;
    private int mType;
    private String mValue;
    private Vector mDelimiters;

    public RequestToken(String iValue, boolean iIsValue) {
        block14: {
            this.mType = -1;
            this.mValue = null;
            this.mDelimiters = null;
            if (!iIsValue) {
                if (iValue.charAt(0) == '{') {
                    this.createRequestToken(iValue, 4);
                }
                try {
                    Integer.parseInt(iValue);
                    this.createRequestToken(iValue, 2);
                    break block14;
                }
                catch (NumberFormatException nf) {
                    this.createRequestToken(iValue, 1);
                    break block14;
                }
            }
            if (iValue != null) {
                int endDelimit = 0;
                try {
                    endDelimit = this.parseDelimiters(iValue);
                }
                catch (IllegalArgumentException iae) {
                    // empty catch block
                }
                if (this.mDelimiters != null) {
                    iValue = iValue.substring(endDelimit);
                }
            }
            this.mType = 3;
            this.mValue = iValue;
        }
    }

    public RequestToken(String iValue, int iType) {
        this.mType = -1;
        this.mValue = null;
        this.mDelimiters = null;
        this.createRequestToken(iValue, iType);
    }

    public int getType() {
        return this.mType;
    }

    public Vector getDelimiters() {
        return this.mDelimiters;
    }

    public int getDelimiterCount() {
        int count = 0;
        if (this.mDelimiters != null) {
            count = this.mDelimiters.size();
        }
        return count;
    }

    public int getDelimiterIndex(String iName) {
        int index = -1;
        if (this.mDelimiters != null) {
            for (int i = 0; i < this.mDelimiters.size(); ++i) {
                RequestDelimiter del = (RequestDelimiter)this.mDelimiters.elementAt(i);
                if (!del.getName().equals(iName)) continue;
                index = i;
                break;
            }
        }
        return index;
    }

    public String getDelimiterValue(String iName) {
        String val = null;
        if (this.mDelimiters != null) {
            for (int i = 0; i < this.mDelimiters.size(); ++i) {
                RequestDelimiter del = (RequestDelimiter)this.mDelimiters.elementAt(i);
                if (!del.getName().equals(iName)) continue;
                val = del.getValue();
                break;
            }
        }
        return val;
    }

    public String getDelimiterValueAt(int iIndex) {
        String val = null;
        if (this.mDelimiters != null && iIndex < this.mDelimiters.size()) {
            RequestDelimiter del = (RequestDelimiter)this.mDelimiters.elementAt(iIndex);
            val = del.getValue();
        }
        return val;
    }

    public RequestDelimiter getDelimiterAt(int iIndex) {
        RequestDelimiter del = null;
        if (this.mDelimiters != null && iIndex < this.mDelimiters.size()) {
            del = (RequestDelimiter)this.mDelimiters.elementAt(iIndex);
        }
        return del;
    }

    public String getValue() {
        String val = null;
        if (this.mType != -1) {
            val = this.mValue;
        }
        return val;
    }

    private void createRequestToken(String iValue, int iType) {
        switch (iType) {
            case 4: {
                this.parseDelimiters(iValue);
                this.mType = iType;
                this.mValue = null;
                break;
            }
            case 0: 
            case 1: {
                try {
                    Integer.parseInt(iValue);
                    throw new IllegalArgumentException("Element name cannot be an integer");
                }
                catch (NumberFormatException nf) {
                    this.mType = iType;
                    this.mValue = iValue;
                    break;
                }
            }
            case 2: {
                int i = Integer.parseInt(iValue);
                if (i < 0) {
                    throw new NumberFormatException("Negative Index");
                }
                this.mType = iType;
                this.mValue = iValue;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown token type");
            }
        }
    }

    private int parseDelimiters(String iValue) {
        String consider;
        RequestDelimiter del = null;
        int start = -1;
        int end = -1;
        int equals = -1;
        int lookAt = 0;
        while (lookAt != -1 && lookAt < iValue.length() && iValue.charAt(lookAt) == '{' && (end = iValue.indexOf(125, start = lookAt)) != -1 && (equals = (consider = iValue.substring(start + 1, end)).indexOf("=")) != -1) {
            try {
                del = new RequestDelimiter(consider.substring(0, equals), consider.substring(equals + 1));
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e.getMessage());
            }
            if (this.mDelimiters == null) {
                this.mDelimiters = new Vector();
            }
            this.mDelimiters.add(del);
            lookAt = end + 1;
        }
        return lookAt;
    }
}

