/*
 * Decompiled with CFR 0.152.
 */
package org.adl.datamodels.datatypes;

import java.io.Serializable;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Vector;
import org.adl.datamodels.DMTypeValidator;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class DateTimeValidator
extends DMTypeValidator
implements Serializable {
    private static final int SECOND_UPPER_BOUND = 59;
    private static final int MIN_UPPER_BOUND = 59;
    private static final int HOUR_UPPER_BOUND = 23;
    private static final int MONTH_UPPER_BOUND = 11;
    private static final int YEAR_LOWER_BOUND = 1970;
    private static final int YEAR_UPPER_BOUND = 2038;
    private boolean mIncludeSubSecs = true;

    public DateTimeValidator(boolean iInclude) {
        this.mIncludeSubSecs = iInclude;
    }

    @Override
    public boolean compare(String iFirst, String iSecond, Vector iDelimiters) {
        boolean equal = true;
        DateTimeFormatter dtp = ISODateTimeFormat.dateTimeParser();
        try {
            DateTime dt1 = dtp.parseDateTime(iFirst);
            dt1 = new DateTime(dt1.getYear(), dt1.getMonthOfYear(), dt1.getDayOfMonth(), dt1.getHourOfDay(), dt1.getMinuteOfHour(), dt1.getSecondOfMinute(), 0);
            DateTime dt2 = dtp.parseDateTime(iSecond);
            dt2 = new DateTime(dt2.getYear(), dt2.getMonthOfYear(), dt2.getDayOfMonth(), dt2.getHourOfDay(), dt2.getMinuteOfHour(), dt2.getSecondOfMinute(), 0);
            equal = dt1.equals(dt2);
        }
        catch (Exception e) {
            equal = false;
        }
        return equal;
    }

    @Override
    public int validate(String iValue) {
        int valid = 0;
        int idx = -1;
        boolean done = false;
        int year = 0;
        int month = 0;
        int day = 0;
        int tempLength = 0;
        if (iValue == null) {
            valid = 9001;
            done = true;
        }
        if (!done) {
            tempLength = iValue.length();
            if (tempLength < 4) {
                valid = 406;
                return valid;
            }
            try {
                year = Integer.parseInt(iValue.substring(0, 4));
                if (year < 1970 || year > 2038) {
                    valid = 406;
                    return valid;
                }
            }
            catch (Exception e) {
                valid = 406;
                done = true;
            }
            if (!done) {
                if ((idx += 5) != iValue.length()) {
                    if (iValue.charAt(idx) == '-') {
                        ++idx;
                        month = 0;
                        try {
                            month = Integer.parseInt(iValue.substring(idx, idx + 2));
                            if (--month < 0 || month > 11) {
                                valid = 406;
                                done = true;
                            }
                        }
                        catch (Exception e) {
                            valid = 406;
                            done = true;
                        }
                    } else {
                        valid = 406;
                        done = true;
                    }
                } else {
                    valid = 0;
                    done = true;
                }
            }
            if (!done && (idx += 2) != iValue.length()) {
                if (iValue.charAt(idx) == '-') {
                    ++idx;
                    try {
                        day = Integer.parseInt(iValue.substring(idx, idx + 2));
                        GregorianCalendar cal = new GregorianCalendar(year, month, 1);
                        int days = ((Calendar)cal).getActualMaximum(5);
                        if (day < 1 || day > days) {
                            valid = 406;
                            done = true;
                        } else if ((idx += 2) == iValue.length()) {
                            done = true;
                        } else if (iValue.charAt(idx) != 'T') {
                            valid = 406;
                            done = true;
                        }
                    }
                    catch (Exception e) {
                        valid = 406;
                        done = true;
                    }
                } else {
                    valid = 406;
                    done = true;
                }
            }
        }
        if (!done && (idx = iValue.indexOf("T")) != -1) {
            ++idx;
            int hour = -1;
            try {
                hour = Integer.parseInt(iValue.substring(idx, idx + 2));
                if (hour < 0 || hour > 23) {
                    valid = 406;
                    done = true;
                }
            }
            catch (Exception e) {
                valid = 406;
                done = true;
            }
            if (!done) {
                if ((idx += 2) != iValue.length()) {
                    if (iValue.charAt(idx) == ':') {
                        ++idx;
                        int minutes = -1;
                        try {
                            minutes = Integer.parseInt(iValue.substring(idx, idx + 2));
                            if (minutes < 0 || minutes > 59) {
                                valid = 406;
                                done = true;
                            }
                        }
                        catch (Exception e) {
                            valid = 406;
                            done = true;
                        }
                    } else {
                        valid = 406;
                        done = true;
                    }
                } else {
                    done = true;
                }
                if (!done) {
                    if ((idx += 2) != iValue.length()) {
                        if (iValue.charAt(idx) == ':') {
                            ++idx;
                            int seconds = -1;
                            try {
                                seconds = Integer.parseInt(iValue.substring(idx, idx + 2));
                                if (seconds < 0 || seconds > 59) {
                                    valid = 406;
                                    done = true;
                                }
                            }
                            catch (Exception e) {
                                valid = 406;
                                done = true;
                            }
                        } else {
                            valid = 406;
                            done = true;
                        }
                    } else {
                        done = true;
                    }
                }
                int sub = -1;
                if (!done && this.mIncludeSubSecs && (idx += 2) != iValue.length()) {
                    if (iValue.charAt(idx) == '.') {
                        sub = ++idx;
                        int lengthCounter = 0;
                        while (sub < iValue.length() && iValue.charAt(sub) != 'Z' && iValue.charAt(sub) != 'z' && iValue.charAt(sub) != '+' && iValue.charAt(sub) != '-') {
                            ++sub;
                            ++lengthCounter;
                        }
                        if (lengthCounter == 0 || lengthCounter > 2) {
                            valid = 406;
                            done = true;
                        } else {
                            try {
                                Integer.parseInt(iValue.substring(idx, sub));
                                idx = sub;
                            }
                            catch (Exception e) {
                                valid = 406;
                                done = true;
                            }
                        }
                    } else {
                        valid = 406;
                    }
                }
                if (!done && idx < iValue.length()) {
                    if (iValue.charAt(idx) == 'Z' || iValue.charAt(idx) == 'z') {
                        if (idx != iValue.length() - 1) {
                            valid = 406;
                            done = true;
                        }
                        idx = -1;
                    } else if (iValue.charAt(idx) == '-' || iValue.charAt(idx) == '+') {
                        ++idx;
                    } else {
                        valid = 406;
                        done = true;
                        idx = -1;
                    }
                    if (idx != -1) {
                        if (iValue.length() >= idx + 2) {
                            hour = -1;
                            try {
                                hour = Integer.parseInt(iValue.substring(idx, idx + 2));
                                if (hour < 0 || hour > 23) {
                                    valid = 406;
                                    done = true;
                                }
                            }
                            catch (Exception e) {
                                valid = 406;
                                done = true;
                            }
                        } else {
                            valid = 406;
                            done = true;
                        }
                        if (!done && (idx += 2) != iValue.length()) {
                            if (iValue.charAt(idx) == ':') {
                                ++idx;
                                int minutes = -1;
                                try {
                                    minutes = Integer.parseInt(iValue.substring(idx, idx + 2));
                                    if (minutes < 0 || minutes > 59 || (idx += 2) != iValue.length()) {
                                        valid = 406;
                                    }
                                }
                                catch (Exception e) {
                                    valid = 406;
                                }
                            } else {
                                valid = 406;
                            }
                        }
                    }
                }
            }
        }
        return valid;
    }
}

