/*
 * Decompiled with CFR 0.152.
 */
package org.adl.datamodels.datatypes;

import java.io.Serializable;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.adl.datamodels.DMTypeValidator;

public class DurationValidator
extends DMTypeValidator
implements Serializable {
    @Override
    public boolean compare(String iFirst, String iSecond, Vector iDelimiters) {
        boolean equal = true;
        if (iFirst == null || iSecond == null) {
            equal = false;
        } else if (iDelimiters != null) {
            equal = false;
        } else {
            Double secs1 = this.numSec(iFirst);
            Double secs2 = this.numSec(iSecond);
            equal = secs1 != null && secs2 != null ? Double.compare(secs1, secs2) == 0 : false;
        }
        return equal;
    }

    @Override
    public int validate(String iValue) {
        int valid = 406;
        if (iValue != null) {
            String durExp = "P(([0-9]+Y)?([0-9]+M)?([0-9]+D)?)?(T([0-9]+H)?([0-9]+M)?([0-9]+(\\.[0-9]{1,2})?S)?)?";
            Pattern pattern = Pattern.compile(durExp);
            Matcher matcher = pattern.matcher(iValue);
            if (matcher.matches() && !iValue.endsWith("P") && !iValue.endsWith("T") && iValue.length() != 1) {
                valid = 0;
            }
        } else {
            valid = 9001;
        }
        return valid;
    }

    private Double numSec(String iValue) {
        long secs = 0L;
        Double total = null;
        int curIdx = 1;
        int tIdx = iValue.indexOf(84);
        int nextIdx = -1;
        String val = null;
        boolean done = false;
        nextIdx = iValue.indexOf(89);
        if (nextIdx != -1) {
            val = iValue.substring(curIdx, nextIdx);
            curIdx = nextIdx + 1;
            try {
                secs += Long.parseLong(val, 10) * 31536000L;
            }
            catch (NumberFormatException nfe) {
                done = true;
            }
        }
        nextIdx = iValue.indexOf(77);
        if (tIdx > -1 && nextIdx >= tIdx) {
            nextIdx = -1;
        }
        if (!done && nextIdx != -1) {
            val = iValue.substring(curIdx, nextIdx);
            curIdx = nextIdx + 1;
            try {
                secs += Long.parseLong(val, 10) * 2628029L;
            }
            catch (NumberFormatException nfe) {
                done = true;
            }
        }
        nextIdx = iValue.indexOf(68);
        if (!done && nextIdx != -1) {
            val = iValue.substring(curIdx, nextIdx);
            curIdx = nextIdx + 1;
            try {
                secs += Long.parseLong(val, 10) * 86400L;
            }
            catch (NumberFormatException nfe) {
                done = true;
            }
        }
        nextIdx = iValue.indexOf(72);
        if (!done && nextIdx != -1) {
            val = iValue.substring(curIdx, nextIdx);
            if (val.startsWith("T")) {
                val = val.substring(1);
            }
            curIdx = nextIdx + 1;
            try {
                secs += Long.parseLong(val, 10) * 3600L;
            }
            catch (NumberFormatException e) {
                done = true;
            }
        }
        nextIdx = -1;
        if (tIdx != -1) {
            nextIdx = iValue.indexOf(77, tIdx);
        }
        if (!done && nextIdx != -1) {
            val = iValue.substring(curIdx, nextIdx);
            if (val.startsWith("T")) {
                val = val.substring(1);
            }
            curIdx = nextIdx + 1;
            try {
                secs += Long.parseLong(val, 10) * 60L;
            }
            catch (NumberFormatException nfe) {
                done = true;
            }
        }
        double subSec = Double.NaN;
        nextIdx = iValue.indexOf(83);
        if (!done && nextIdx != -1) {
            val = iValue.substring(curIdx, nextIdx);
            if (val.startsWith("T")) {
                val = val.substring(1);
            }
            try {
                subSec = Double.parseDouble(val);
            }
            catch (NumberFormatException nfe) {
                subSec = Double.NaN;
                done = true;
            }
        }
        if (!done && secs >= 0L) {
            double sec = Double.parseDouble(Long.toString(secs, 10));
            if (Double.compare(Double.NaN, subSec) != 0) {
                subSec = Math.floor(subSec * 100.0) / 100.0;
                total = new Double(subSec + sec);
            } else {
                total = new Double(sec);
            }
        }
        return total;
    }
}

