/*
 * Decompiled with CFR 0.152.
 */
package org.adl.datamodels.datatypes;

import java.io.Serializable;
import java.util.Vector;
import org.adl.datamodels.DMTypeValidator;

public class IntRangeValidator
extends DMTypeValidator
implements Serializable {
    private int mMax = 0;
    private int mMin = 0;

    public IntRangeValidator() {
    }

    public IntRangeValidator(int iMax) {
        this.mMax = iMax;
    }

    public IntRangeValidator(int iMin, int iMax) {
        this.mMax = iMax;
        this.mMin = iMin;
    }

    @Override
    public boolean compare(String iFirst, String iSecond, Vector iDelimiters) {
        boolean equal = true;
        boolean done = false;
        int val1 = 0;
        int val2 = 0;
        try {
            val1 = Integer.parseInt(iFirst);
            val2 = Integer.parseInt(iSecond);
        }
        catch (NumberFormatException nfe) {
            equal = false;
            done = true;
        }
        if (!done) {
            equal = val1 == val2;
        }
        return equal;
    }

    @Override
    public int validate(String iValue) {
        int valid = 0;
        if (iValue == null) {
            return 9001;
        }
        try {
            int value = Integer.parseInt(iValue);
            if (value < this.mMin || value > this.mMax) {
                valid = 406;
            }
        }
        catch (NumberFormatException nfe) {
            valid = 406;
        }
        return valid;
    }
}

