/*
 * Decompiled with CFR 0.152.
 */
package org.adl.datamodels.datatypes;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Vector;
import org.adl.datamodels.DMDelimiter;
import org.adl.datamodels.DMTypeValidator;
import org.adl.datamodels.datatypes.InteractionTrunc;
import org.adl.datamodels.datatypes.LangStringValidator;
import org.adl.datamodels.datatypes.RealRangeValidator;
import org.adl.datamodels.datatypes.SPMRangeValidator;
import org.adl.datamodels.datatypes.URIValidator;
import org.adl.logging.DetailedLogMessageCollection;
import org.adl.util.LogMessage;
import org.adl.util.Messages;

public class InteractionValidator
extends DMTypeValidator
implements Serializable {
    public static final int MULTIPLE_CHOICE = 1;
    public static final int FILL_IN = 2;
    public static final int LONG_FILL_IN = 3;
    public static final int LIKERT = 4;
    public static final int MATCHING = 5;
    public static final int PERFORMANCE = 6;
    public static final int SEQUENCING = 7;
    public static final int NUMERIC = 8;
    public static final int UNKNOWN_TYPE = 9;
    private int mInteractionType = 9;
    private String mElement = null;
    private boolean mAllowEmpty = true;

    public InteractionValidator(int iType, String iElement) {
        this.mInteractionType = iType;
        this.mType = iElement;
        this.mElement = iElement;
    }

    public InteractionValidator(int iType, boolean iAllowEmpty, String iElement) {
        this.mInteractionType = iType;
        this.mAllowEmpty = iAllowEmpty;
        this.mType = iElement;
        this.mElement = iElement;
    }

    public int getType() {
        return this.mInteractionType;
    }

    @Override
    public String trunc(String iValue) {
        return InteractionTrunc.trunc(iValue, this.mInteractionType);
    }

    @Override
    public boolean compare(String iFirst, String iSecond, Vector iDelimiters) {
        boolean equal = true;
        String comma = "\\[,\\]";
        LangStringValidator langValidator = new LangStringValidator();
        RealRangeValidator realValidator = new RealRangeValidator();
        URIValidator uriValidator = new URIValidator(250, "short_identifier_type");
        int idx = -1;
        switch (this.mInteractionType) {
            case 1: {
                int i;
                String[] choices1 = iFirst.split(comma);
                String[] choices2 = iSecond.split(comma);
                HashSet<String> set1 = new HashSet<String>();
                HashSet<String> set2 = new HashSet<String>();
                boolean added = false;
                for (i = 0; i < choices1.length; ++i) {
                    added = set1.add(choices1[i]);
                }
                for (i = 0; i < choices2.length; ++i) {
                    added = set2.add(choices2[i]);
                }
                equal = set1.equals(set2);
                break;
            }
            case 2: {
                boolean caseMatters = false;
                boolean orderMatters = true;
                String[] matchText1 = iFirst.split(comma);
                String[] matchText2 = iSecond.split(comma);
                if (matchText1.length == matchText2.length) {
                    if (iDelimiters != null) {
                        for (int i = 0; i < iDelimiters.size(); ++i) {
                            DMDelimiter del = (DMDelimiter)iDelimiters.elementAt(i);
                            if (del.mDescription.mName.equals("order_matters")) {
                                if (del.mValue == null) continue;
                                orderMatters = false;
                                continue;
                            }
                            if (!del.mDescription.mName.equals("case_matters") || del.mValue == null) continue;
                            caseMatters = true;
                        }
                    }
                    String matchString1 = null;
                    String matchString2 = null;
                    String langString1 = "en";
                    String langString2 = "en";
                    if (orderMatters) {
                        for (int i = 0; i < matchText1.length && equal; ++i) {
                            if (matchText1[i].startsWith("{lang=")) {
                                idx = matchText1[i].indexOf(125);
                                if (idx != -1) {
                                    matchString1 = matchText1[i].substring(idx + 1);
                                    langString1 = matchText1[i].substring(6, idx);
                                } else {
                                    langString1 = "en";
                                    matchString1 = matchText1[i];
                                }
                            } else {
                                langString1 = "en";
                                matchString1 = matchText1[i];
                            }
                            if (matchText2[i].startsWith("{lang=")) {
                                idx = matchText2[i].indexOf(125);
                                if (idx != -1) {
                                    matchString2 = matchText2[i].substring(idx + 1);
                                    langString2 = matchText2[i].substring(6, idx);
                                } else {
                                    langString2 = "en";
                                    matchString2 = matchText2[i];
                                }
                            } else {
                                langString2 = "en";
                                matchString2 = matchText2[i];
                            }
                            equal = langValidator.compare(langString1, langString2, null);
                            if (equal) {
                                if (caseMatters) {
                                    equal = matchString1.equals(matchString2);
                                    continue;
                                }
                                equal = matchString1.equalsIgnoreCase(matchString2);
                                continue;
                            }
                            equal = false;
                        }
                    } else {
                        Vector<Boolean> matched = new Vector<Boolean>();
                        for (int i = 0; i < matchText1.length; ++i) {
                            matched.add(new Boolean(false));
                        }
                        boolean found = false;
                        for (int i = 0; i < matchText1.length && equal; ++i) {
                            matchString1 = null;
                            matchString2 = null;
                            langString1 = "en";
                            langString2 = "en";
                            if (matchText1[i].startsWith("{lang=")) {
                                idx = matchText1[i].indexOf(125);
                                if (idx != -1) {
                                    matchString1 = matchText1[i].substring(idx + 1);
                                    langString1 = matchText1[i].substring(6, idx);
                                } else {
                                    langString1 = "en";
                                    matchString1 = matchText1[i];
                                }
                            } else {
                                langString1 = "en";
                                matchString1 = matchText1[i];
                            }
                            found = false;
                            for (int j = 0; j < matchText2.length && !found; ++j) {
                                if (matchText2[j].startsWith("{lang=")) {
                                    idx = matchText2[j].indexOf(125);
                                    if (idx != -1) {
                                        matchString2 = matchText2[j].substring(idx + 1);
                                        langString2 = matchText2[j].substring(6, idx);
                                    } else {
                                        langString2 = "en";
                                        matchString2 = matchText2[j];
                                    }
                                } else {
                                    langString2 = "en";
                                    matchString2 = matchText2[j];
                                }
                                equal = langValidator.compare(langString1, langString2, null);
                                if (equal) {
                                    found = caseMatters ? matchString1.equals(matchString2) : matchString1.equalsIgnoreCase(matchString2);
                                }
                                if (!found) continue;
                                boolean used = (Boolean)matched.elementAt(j);
                                if (!used) {
                                    matched.set(j, new Boolean(true));
                                    continue;
                                }
                                found = false;
                            }
                            if (found) continue;
                            equal = false;
                        }
                    }
                    break;
                }
                equal = false;
                break;
            }
            case 3: {
                boolean caseMatters = false;
                if (iDelimiters != null) {
                    for (int i = 0; i < iDelimiters.size(); ++i) {
                        DMDelimiter del = (DMDelimiter)iDelimiters.elementAt(i);
                        if (!del.mDescription.mName.equals("case_matters") || del.mValue == null) continue;
                        caseMatters = true;
                    }
                }
                if (caseMatters) {
                    equal = iFirst.equals(iSecond);
                    break;
                }
                equal = iFirst.equalsIgnoreCase(iSecond);
                break;
            }
            case 4: {
                equal = uriValidator.compare(iFirst, iSecond, null);
                break;
            }
            case 5: {
                String[] pairs2;
                if (this.mAllowEmpty && (iFirst.trim().equals("") || iSecond.trim().equals(""))) {
                    equal = iFirst.trim().equals(iSecond.trim());
                    break;
                }
                String[] pairs1 = iFirst.split(comma);
                if (pairs1.length == (pairs2 = iSecond.split(comma)).length) {
                    Vector<Boolean> matched = new Vector<Boolean>();
                    for (int i = 0; i < pairs1.length; ++i) {
                        matched.add(new Boolean(false));
                    }
                    boolean found = false;
                    for (int i = 0; i < pairs1.length && equal; ++i) {
                        idx = pairs1[i].indexOf("[.]");
                        String source1 = pairs1[i].substring(0, idx);
                        String target1 = pairs1[i].substring(idx + 3, pairs1[i].length());
                        found = false;
                        for (int j = 0; j < pairs2.length && !found; ++j) {
                            idx = pairs2[i].indexOf("[.]");
                            String source2 = pairs2[i].substring(0, idx);
                            String target2 = pairs2[i].substring(idx + 3, pairs2[i].length());
                            found = uriValidator.compare(source1, source2, null);
                            if (found) {
                                found = uriValidator.compare(target1, target2, null);
                            }
                            if (!found) continue;
                            boolean used = (Boolean)matched.elementAt(j);
                            if (!used) {
                                matched.set(j, new Boolean(true));
                                continue;
                            }
                            found = false;
                        }
                        if (found) continue;
                        equal = false;
                    }
                    break;
                }
                equal = false;
                break;
            }
            case 6: {
                if (this.mAllowEmpty && (iFirst.trim().equals("") || iSecond.trim().equals(""))) {
                    equal = iFirst.trim().equals(iSecond.trim());
                    break;
                }
                String[] records1 = iFirst.split(comma);
                String[] records2 = iSecond.split(comma);
                boolean orderMatters = true;
                if (records1.length == records2.length) {
                    int i;
                    if (iDelimiters != null) {
                        for (i = 0; i < iDelimiters.size(); ++i) {
                            DMDelimiter del = (DMDelimiter)iDelimiters.elementAt(i);
                            if (!del.mDescription.mName.equals("order_matters") || del.mValue == null) continue;
                            orderMatters = false;
                        }
                    }
                    if (orderMatters) {
                        for (i = 0; i < records1.length && equal; ++i) {
                            equal = records1[i].equals(records2[i]);
                        }
                    } else {
                        Vector<Boolean> matched = new Vector<Boolean>();
                        for (int i2 = 0; i2 < records1.length; ++i2) {
                            matched.add(new Boolean(false));
                        }
                        boolean found = false;
                        for (int i3 = 0; i3 < records1.length && equal; ++i3) {
                            found = false;
                            for (int j = 0; j < records2.length && !found; ++j) {
                                found = records1[i3].equals(records2[j]);
                                if (!found) continue;
                                boolean used = (Boolean)matched.elementAt(j);
                                if (!used) {
                                    matched.set(j, new Boolean(true));
                                    continue;
                                }
                                found = false;
                            }
                            if (found) continue;
                            equal = false;
                        }
                    }
                    break;
                }
                equal = false;
                break;
            }
            case 7: {
                String[] seq1 = iFirst.split(comma);
                String[] seq2 = iSecond.split(comma);
                if (seq1.length == seq2.length) {
                    for (int i = 0; i < seq1.length && equal; ++i) {
                        equal = uriValidator.compare(seq1[i], seq2[i], null);
                    }
                    break;
                }
                equal = false;
                break;
            }
            case 8: {
                if (this.mElement.equals("cmi.interactions.n.correct_responses.n.pattern")) {
                    String minString1 = null;
                    String maxString1 = null;
                    String minString2 = null;
                    String maxString2 = null;
                    idx = iFirst.indexOf("[:]");
                    if (idx != -1) {
                        minString1 = iFirst.substring(0, idx);
                        maxString1 = iFirst.substring(idx + 3);
                    }
                    if ((idx = iSecond.indexOf("[:]")) != -1) {
                        minString2 = iSecond.substring(0, idx);
                        maxString2 = iSecond.substring(idx + 3);
                    }
                    if (minString1.trim().length() > 0 || minString2.trim().length() > 0) {
                        equal = realValidator.compare(minString1, minString2, null);
                    }
                    if (!equal || maxString1.trim().length() <= 0 && maxString2.trim().length() <= 0) break;
                    equal = realValidator.compare(maxString1, maxString2, null);
                    break;
                }
                equal = realValidator.compare(iFirst, iSecond, null);
                break;
            }
        }
        return equal;
    }

    @Override
    public int validate(String iValue) {
        int valid = 0;
        if (iValue == null) {
            return 9001;
        }
        RealRangeValidator realValidator = new RealRangeValidator();
        LangStringValidator langValidator = new LangStringValidator();
        SPMRangeValidator shortSPMValidator = new SPMRangeValidator(250);
        SPMRangeValidator longSPMValidator = new SPMRangeValidator(4000);
        URIValidator uriValidator = new URIValidator(250, "short_identifier_type");
        String comma = "\\[,\\]";
        String warn = null;
        int idx = -1;
        int result = 0;
        block2 : switch (this.mInteractionType) {
            case 1: {
                if (iValue.length() == 0) break;
                String check = iValue.trim();
                idx = check.lastIndexOf("[,]");
                if (idx != -1 && idx == check.length() - 3) {
                    valid = 406;
                    break;
                }
                String[] choices = iValue.split(comma);
                if (choices.length > 36) {
                    warn = Messages.getString("InteractionValidator.0", this.mElement);
                    DetailedLogMessageCollection.getInstance().addMessage(new LogMessage(1, warn));
                }
                HashSet<String> set = new HashSet<String>();
                boolean added = false;
                for (int i = 0; i < choices.length; ++i) {
                    if (choices[i].trim().equals("")) {
                        valid = 406;
                        break block2;
                    }
                    result = uriValidator.validate(choices[i]);
                    if (result == 9002) {
                        warn = Messages.getString("InteractionValidator.39", this.mElement, i);
                        DetailedLogMessageCollection.getInstance().addMessage(new LogMessage(1, warn));
                    }
                    if (result == 0 || result == 9002) {
                        added = set.add(choices[i]);
                        if (added) continue;
                        valid = 406;
                        break block2;
                    }
                    valid = result;
                    break block2;
                }
                break;
            }
            case 2: {
                String[] matchText = iValue.split(comma);
                if (matchText.length > 10) {
                    warn = Messages.getString("InteractionValidator.41", this.mElement);
                    DetailedLogMessageCollection.getInstance().addMessage(new LogMessage(1, warn));
                }
                for (int i = 0; i < matchText.length; ++i) {
                    String matchString = null;
                    String langString = null;
                    if (matchText[i].startsWith("{lang=")) {
                        idx = matchText[i].indexOf(125);
                        if (idx != -1) {
                            matchString = matchText[i].substring(idx + 1);
                            langString = matchText[i].substring(6, idx);
                            result = langValidator.validate(langString);
                            if (result == 9002) {
                                warn = Messages.getString("InteractionValidator.43", this.mElement, i);
                                DetailedLogMessageCollection.getInstance().addMessage(new LogMessage(1, warn));
                            } else if (result != 0) {
                                valid = result;
                                break block2;
                            }
                        } else {
                            matchString = matchText[i];
                        }
                    } else {
                        matchString = matchText[i];
                    }
                    result = shortSPMValidator.validate(matchString);
                    if (result == 9002) {
                        warn = Messages.getString("InteractionValidator.45", this.mElement, i);
                        DetailedLogMessageCollection.getInstance().addMessage(new LogMessage(1, warn));
                        continue;
                    }
                    if (result == 0) continue;
                    valid = result;
                    break block2;
                }
                break;
            }
            case 3: {
                result = longSPMValidator.validate(iValue);
                if (result == 9002) {
                    warn = Messages.getString("InteractionValidator.47", this.mElement);
                    DetailedLogMessageCollection.getInstance().addMessage(new LogMessage(1, warn));
                    break;
                }
                if (result == 0) break;
                valid = result;
                break;
            }
            case 4: {
                result = uriValidator.validate(iValue);
                if (result == 9002) {
                    warn = Messages.getString("InteractionValidator.48", this.mElement);
                    DetailedLogMessageCollection.getInstance().addMessage(new LogMessage(1, warn));
                    break;
                }
                if (result == 0) break;
                valid = result;
                break;
            }
            case 5: {
                String check;
                if (!this.mAllowEmpty) {
                    if (iValue.trim().length() == 0) {
                        valid = 406;
                        break;
                    }
                } else if (iValue.trim().length() == 0) break;
                if ((idx = (check = iValue.trim()).lastIndexOf("[,]")) != -1 && idx == check.length() - 3) {
                    valid = 406;
                    break;
                }
                String[] commas = iValue.split(comma);
                if (commas.length > 36) {
                    warn = Messages.getString("InteractionValidator.50", this.mElement);
                    DetailedLogMessageCollection.getInstance().addMessage(new LogMessage(1, warn));
                }
                for (int i = 0; i < commas.length; ++i) {
                    if (commas[i].length() == 0) {
                        valid = 406;
                        break block2;
                    }
                    idx = commas[i].indexOf("[.]");
                    if (idx == -1) {
                        valid = 406;
                        break block2;
                    }
                    int second = commas[i].indexOf("[.]", idx + 2);
                    if (second != -1) {
                        valid = 406;
                        break block2;
                    }
                    String target = commas[i].substring(0, idx);
                    String source = commas[i].substring(idx + 3, commas[i].length());
                    if (target.length() == 0 || source.length() == 0) {
                        valid = 406;
                        break block2;
                    }
                    result = uriValidator.validate(source);
                    if (result == 9002) {
                        warn = Messages.getString("InteractionValidator.53", this.mElement, i);
                        DetailedLogMessageCollection.getInstance().addMessage(new LogMessage(1, warn));
                    }
                    if (result != 406) {
                        result = uriValidator.validate(target);
                        if (result == 9002) {
                            warn = Messages.getString("InteractionValidator.55", this.mElement, i);
                            DetailedLogMessageCollection.getInstance().addMessage(new LogMessage(1, warn));
                        } else if (result != 0) {
                            valid = result;
                        }
                    } else {
                        valid = 406;
                    }
                    if (valid == 406) break block2;
                }
                break;
            }
            case 6: {
                String check = iValue.trim();
                idx = check.lastIndexOf("[,]");
                if (idx != -1 && idx == check.length() - 3) {
                    valid = 406;
                    break;
                }
                String[] commaCheck = iValue.split(comma);
                if (commaCheck.length > 125) {
                    warn = Messages.getString("InteractionValidator.58", this.mElement);
                    DetailedLogMessageCollection.getInstance().addMessage(new LogMessage(1, warn));
                }
                for (int i = 0; i < commaCheck.length; ++i) {
                    if (commaCheck[i].length() == 0) {
                        valid = 406;
                        break block2;
                    }
                    idx = commaCheck[i].indexOf("[.]");
                    if (idx == -1) {
                        valid = 406;
                        break block2;
                    }
                    int second = commaCheck[i].indexOf("[.]", idx + 3);
                    if (second != -1) {
                        valid = 406;
                        break block2;
                    }
                    String sn = commaCheck[i].substring(0, idx);
                    String sa = commaCheck[i].substring(idx + 3, commaCheck[i].length());
                    if (sn.length() == 0 && sa.length() == 0) {
                        valid = 406;
                        break block2;
                    }
                    if (sn.length() > 0) {
                        result = uriValidator.validate(sn);
                        if (result == 9002) {
                            warn = Messages.getString("InteractionValidator.61", this.mElement, i);
                            DetailedLogMessageCollection.getInstance().addMessage(new LogMessage(1, warn));
                        } else if (result != 0) {
                            valid = result;
                        }
                    }
                    if (valid == 406) continue;
                    idx = sa.indexOf("[:]");
                    if (idx != -1) {
                        int sec = sa.indexOf("[:]", idx + 3);
                        if (sec != -1) {
                            valid = 406;
                            continue;
                        }
                        String minString = sa.substring(0, idx);
                        String maxString = sa.substring(idx + 3);
                        try {
                            Double min = null;
                            Double max = null;
                            if (minString.trim().length() > 0) {
                                min = new Double(minString);
                            }
                            if (maxString.trim().length() > 0) {
                                max = new Double(maxString);
                            }
                            if (min == null || max == null || !(min > max)) continue;
                            valid = 406;
                        }
                        catch (NumberFormatException nfe) {
                            valid = 406;
                        }
                        continue;
                    }
                    result = shortSPMValidator.validate(sa);
                    if (result == 9002) {
                        warn = Messages.getString("InteractionValidator.65", this.mElement, i);
                        DetailedLogMessageCollection.getInstance().addMessage(new LogMessage(1, warn));
                        continue;
                    }
                    if (result == 0) continue;
                    valid = result;
                }
                break;
            }
            case 7: {
                String[] array = iValue.split(comma);
                if (array.length == 0) {
                    valid = 406;
                    break;
                }
                if (iValue.lastIndexOf("[,]") == iValue.length() - 3) {
                    valid = 406;
                    break;
                }
                if (array.length > 36) {
                    warn = Messages.getString("InteractionValidator.68", this.mElement);
                    DetailedLogMessageCollection.getInstance().addMessage(new LogMessage(1, warn));
                }
                if (array.length != 1 || array[0].length() != 0) {
                    for (int i = 0; i < array.length; ++i) {
                        result = uriValidator.validate(array[i]);
                        if (result == 9002) {
                            warn = Messages.getString("InteractionValidator.69", this.mElement, i);
                            DetailedLogMessageCollection.getInstance().addMessage(new LogMessage(1, warn));
                            continue;
                        }
                        if (result == 0) continue;
                        valid = result;
                    }
                    break;
                }
                valid = 406;
                break;
            }
            case 8: {
                if (this.mElement.equals("cmi.interactions.n.correct_responses.n.pattern")) {
                    idx = iValue.indexOf("[:]");
                    if (idx != -1) {
                        int sec = iValue.indexOf("[:]", idx + 3);
                        if (sec != -1) {
                            valid = 406;
                            break;
                        }
                        String minString = iValue.substring(0, idx);
                        String maxString = iValue.substring(idx + 3);
                        try {
                            Double min = null;
                            Double max = null;
                            if (minString.trim().length() > 0) {
                                min = new Double(minString);
                            }
                            if (maxString.trim().length() > 0) {
                                max = new Double(maxString);
                            }
                            if (min == null || max == null || !(min > max)) break;
                            valid = 406;
                        }
                        catch (NumberFormatException e) {
                            valid = 406;
                        }
                        break;
                    }
                    valid = 406;
                    break;
                }
                valid = realValidator.validate(iValue);
                break;
            }
            case 9: {
                valid = 9001;
                break;
            }
            default: {
                valid = 9001;
            }
        }
        return valid;
    }
}

