/*
 * Decompiled with CFR 0.152.
 */
package org.adl.datamodels.datatypes;

import java.io.Serializable;
import java.util.Vector;
import org.adl.datamodels.DMTypeValidator;

public class RealRangeValidator
extends DMTypeValidator
implements Serializable {
    private Double mMax = null;
    private Double mMin = null;

    public RealRangeValidator() {
    }

    public RealRangeValidator(Double iMin, Double iMax) {
        this.mMax = iMax;
        this.mMin = iMin;
    }

    @Override
    public boolean compare(String iFirst, String iSecond, Vector iDelimiters) {
        boolean equal = true;
        boolean done = false;
        double val1 = Double.NaN;
        double val2 = Double.NaN;
        try {
            val1 = Double.parseDouble(iFirst);
            val2 = Double.parseDouble(iSecond);
        }
        catch (NumberFormatException nfe) {
            equal = false;
            done = true;
        }
        if (!done) {
            boolean bl = equal = Double.compare(val1 = Math.floor(val1 * 1000000.0) / 1000000.0, val2 = Math.floor(val2 * 1000000.0) / 1000000.0) == 0;
            if (!equal) {
                val1 = Double.parseDouble(iFirst);
                val2 = Double.parseDouble(iSecond);
                equal = Double.compare(val1 = (double)Math.round(val1 * 1000000.0) / 1000000.0, val2 = (double)Math.round(val2 * 1000000.0) / 1000000.0) == 0;
            }
        }
        return equal;
    }

    @Override
    public int validate(String iValue) {
        int valid = 0;
        boolean done = false;
        if (iValue == null) {
            return 9001;
        }
        try {
            double value = Double.parseDouble(iValue);
            if (this.mMin == null && this.mMax == null) {
                done = true;
            }
            if (!done) {
                if (this.mMin != null && this.mMax == null) {
                    if (value < this.mMin) {
                        valid = 407;
                    }
                } else if (this.mMin == null && this.mMax != null) {
                    if (value < 0.0 || value > this.mMax) {
                        valid = 407;
                    }
                } else if (this.mMin != null && this.mMax != null && (value < this.mMin || value > this.mMax)) {
                    valid = 407;
                }
            }
        }
        catch (NumberFormatException nfe) {
            valid = 406;
        }
        return valid;
    }
}

