/*
 * Decompiled with CFR 0.152.
 */
package org.adl.datamodels.datatypes;

import java.io.Serializable;
import java.util.Vector;
import org.adl.datamodels.DMTypeValidator;

public class ResultValidator
extends DMTypeValidator
implements Serializable {
    private String[] mVocabList = null;

    public ResultValidator() {
    }

    public ResultValidator(String[] iVocab) {
        this.mVocabList = iVocab;
    }

    public boolean compare(String iFirst, String iSecond) {
        boolean equal = true;
        boolean done = false;
        double val1 = Double.NaN;
        double val2 = Double.NaN;
        try {
            val1 = Double.parseDouble(iFirst);
            val2 = Double.parseDouble(iSecond);
        }
        catch (NumberFormatException nfe) {
            equal = iFirst.equals(iSecond);
            done = true;
        }
        if (!done) {
            equal = Double.compare(val1 = Math.floor(val1 * 1000000.0) / 1000000.0, val2 = Math.floor(val2 * 1000000.0) / 1000000.0) == 0;
        }
        return equal;
    }

    @Override
    public boolean compare(String iFirst, String iSecond, Vector iDelimiters) {
        boolean equal = super.compare(iFirst, iSecond, iDelimiters);
        if (!equal) {
            equal = this.compare(iFirst, iSecond);
        }
        return equal;
    }

    @Override
    public int validate(String iValue) {
        int valid = 406;
        boolean done = false;
        if (this.mVocabList == null || iValue == null) {
            valid = 9001;
            done = true;
        }
        if (!done) {
            for (int i = 0; i < this.mVocabList.length; ++i) {
                String tmpVocab = this.mVocabList[i];
                if (!tmpVocab.equals(iValue)) continue;
                valid = 0;
                done = true;
                break;
            }
            if (!done) {
                try {
                    double value = Double.parseDouble(iValue);
                    valid = 0;
                }
                catch (NumberFormatException nfe) {
                    valid = 406;
                }
            }
        }
        return valid;
    }
}

