/*
 * Decompiled with CFR 0.152.
 */
package org.adl.datamodels.datatypes;

import java.io.Serializable;
import org.adl.datamodels.DMTypeValidator;

public class SPMRangeValidator
extends DMTypeValidator
implements Serializable {
    private int mSPM = -1;

    public SPMRangeValidator() {
        this.mType = "characterstring";
    }

    public SPMRangeValidator(int iSPM) {
        this.mSPM = iSPM;
        this.mType = "characterstring";
    }

    @Override
    public String trunc(String iValue) {
        String trunc = iValue;
        if (this.mSPM > 0 && iValue.length() > this.mSPM) {
            trunc = trunc.substring(0, this.mSPM);
        }
        return trunc;
    }

    @Override
    public int validate(String iValue) {
        int valid = 0;
        if (iValue != null) {
            int spmLength = iValue.length();
            if (this.mSPM > -1 && spmLength > this.mSPM) {
                valid = 9002;
            }
        } else {
            valid = 9001;
        }
        return valid;
    }
}

