/*
 * Decompiled with CFR 0.152.
 */
package org.adl.datamodels.datatypes;

import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Vector;
import org.adl.datamodels.DMTypeValidator;

public class URIValidator
extends DMTypeValidator
implements Serializable {
    private int mSPM = -1;

    public URIValidator() {
        this.mType = "URI";
    }

    public URIValidator(int iSPM, String iType) {
        this.mSPM = iSPM;
        this.mType = iType;
    }

    @Override
    public boolean compare(String iFirst, String iSecond, Vector iDelimiters) {
        boolean equal = true;
        if (iFirst == null || iFirst.trim().equals("")) {
            equal = false;
        } else if (iSecond == null || iSecond.trim().equals("")) {
            equal = false;
        } else {
            try {
                URI uri1 = new URI(iFirst);
                URI uri2 = new URI(iSecond);
                equal = uri1.equals(uri2);
            }
            catch (URISyntaxException use) {
                equal = false;
            }
        }
        return equal;
    }

    @Override
    public String trunc(String iValue) {
        String trunc = iValue;
        if (this.mSPM > 0 && iValue.length() > this.mSPM) {
            trunc = trunc.substring(0, this.mSPM);
        }
        return trunc;
    }

    @Override
    public int validate(String iValue) {
        int valid = 0;
        if (iValue == null) {
            return 9001;
        }
        if (iValue.trim().equals("")) {
            valid = 406;
        } else {
            try {
                URI newURI = new URI(iValue);
                if (this.mSPM > -1 && iValue.length() > this.mSPM) {
                    valid = 9002;
                }
            }
            catch (URISyntaxException use) {
                valid = 406;
            }
        }
        return valid;
    }
}

