/*
 * Decompiled with CFR 0.152.
 */
package org.adl.datamodels.ieee;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;
import org.adl.datamodels.DMDelimiterDescriptor;
import org.adl.datamodels.DMElement;
import org.adl.datamodels.DMElementDescriptor;
import org.adl.datamodels.DMProcessingInfo;
import org.adl.datamodels.DMRequest;
import org.adl.datamodels.DMTimeUtility;
import org.adl.datamodels.DataModel;
import org.adl.datamodels.RequestDelimiter;
import org.adl.datamodels.RequestToken;
import org.adl.datamodels.datatypes.DateTimeValidator;
import org.adl.datamodels.datatypes.DurationValidator;
import org.adl.datamodels.datatypes.LangStringValidator;
import org.adl.datamodels.datatypes.RealRangeValidator;
import org.adl.datamodels.datatypes.ResultValidator;
import org.adl.datamodels.datatypes.SPMRangeValidator;
import org.adl.datamodels.datatypes.URIValidator;
import org.adl.datamodels.datatypes.VocabularyValidator;
import org.adl.datamodels.ieee.SCORM_2004_DMElement;
import org.adl.datamodels.ieee.Version;
import org.adl.util.MessageCollection;

public class SCORM_2004_DM
extends DataModel
implements Serializable {
    public static final int SUSPEND_DATA_SPM = 64000;
    public static final int COMMENTS_FROM_LMS_SPM = 100;
    public static final int LOCATION_SPM = 1000;
    public static final int OBJECTIVES_SPM = 100;
    private String mBinding = "cmi";
    private Hashtable mElements = null;

    public SCORM_2004_DM() {
        Vector<DMElementDescriptor> children = null;
        Vector<DMElementDescriptor> subchildren = null;
        SCORM_2004_DMElement element = null;
        DMElementDescriptor desc = null;
        DMDelimiterDescriptor del = null;
        this.mElements = new Hashtable();
        Version version = new Version("1.0");
        desc = new DMElementDescriptor("_version", null, null);
        version.setDescription(desc);
        this.mElements.put(version.getDMElementBindingString(), version);
        children = new Vector<DMElementDescriptor>();
        desc = new DMElementDescriptor("comment", null, 4000, new SPMRangeValidator(4000));
        del = new DMDelimiterDescriptor("lang", "en", 250, new LangStringValidator());
        desc.mDelimiters = new Vector();
        desc.mDelimiters.add(del);
        children.add(desc);
        desc = new DMElementDescriptor("location", null, 250, new SPMRangeValidator(250));
        children.add(desc);
        desc = new DMElementDescriptor("timestamp", null, new DateTimeValidator(true));
        children.add(desc);
        desc = new DMElementDescriptor("comments_from_learner", children, 250);
        element = new SCORM_2004_DMElement(desc, null, this);
        this.mElements.put(desc.mBinding, element);
        children = new Vector();
        desc = new DMElementDescriptor("comment", null, 4000, new SPMRangeValidator(4000));
        del = new DMDelimiterDescriptor("lang", "en", 250, new LangStringValidator());
        desc.mDelimiters = new Vector();
        desc.mDelimiters.add(del);
        desc.mIsWriteable = false;
        children.add(desc);
        desc = new DMElementDescriptor("location", null, 250, new SPMRangeValidator(250));
        desc.mIsWriteable = false;
        children.add(desc);
        desc = new DMElementDescriptor("timestamp", null, new DateTimeValidator(true));
        desc.mIsWriteable = false;
        children.add(desc);
        desc = new DMElementDescriptor("comments_from_lms", children, 100);
        element = new SCORM_2004_DMElement(desc, null, this);
        this.mElements.put(desc.mBinding, element);
        String[] vocab = new String[]{"unknown", "completed", "not attempted", "incomplete"};
        desc = new DMElementDescriptor("completion_status", "unknown", new VocabularyValidator(vocab));
        element = new SCORM_2004_DMElement(desc, null, this);
        this.mElements.put(desc.mBinding, element);
        desc = new DMElementDescriptor("completion_threshold", null, new RealRangeValidator(new Double(0.0), new Double(1.0)));
        desc.mIsWriteable = false;
        element = new SCORM_2004_DMElement(desc, null, this);
        this.mElements.put(desc.mBinding, element);
        String[] creditFormat = new String[]{"credit", "no-credit"};
        desc = new DMElementDescriptor("credit", "credit", new VocabularyValidator(creditFormat));
        desc.mIsWriteable = false;
        element = new SCORM_2004_DMElement(desc, null, this);
        this.mElements.put(desc.mBinding, element);
        String[] entryFormat = new String[]{"ab-initio", "resume", ""};
        desc = new DMElementDescriptor("entry", "ab-initio", new VocabularyValidator(entryFormat));
        desc.mIsWriteable = false;
        element = new SCORM_2004_DMElement(desc, null, this);
        this.mElements.put(desc.mBinding, element);
        String[] exitFormat = new String[]{"time-out", "suspend", "logout", "normal", ""};
        desc = new DMElementDescriptor("exit", "", new VocabularyValidator(exitFormat));
        desc.mIsReadable = false;
        element = new SCORM_2004_DMElement(desc, null, this);
        this.mElements.put(desc.mBinding, element);
        children = new Vector();
        desc = new DMElementDescriptor("id", null, 4000, new URIValidator(4000, "long_identifier_type"));
        children.add(desc);
        String[] typeFormat = new String[]{"true-false", "choice", "fill-in", "long-fill-in", "matching", "performance", "sequencing", "likert", "numeric", "other"};
        desc = new DMElementDescriptor("type", null, new VocabularyValidator(typeFormat));
        desc.mDependentOn = new Vector();
        desc.mDependentOn.add(new String("id"));
        children.add(desc);
        subchildren = new Vector<DMElementDescriptor>();
        desc = new DMElementDescriptor("id", null, 4000, new URIValidator(4000, "long_identifier_type"));
        desc.mIsUnique = true;
        subchildren.add(desc);
        desc = new DMElementDescriptor("objectives", subchildren, 10);
        desc.mShowChildren = false;
        desc.mDependentOn = new Vector();
        desc.mDependentOn.add(new String("id"));
        children.add(desc);
        desc = new DMElementDescriptor("timestamp", null, new DateTimeValidator(true));
        desc.mDependentOn = new Vector();
        desc.mDependentOn.add(new String("id"));
        children.add(desc);
        subchildren = new Vector();
        desc = new DMElementDescriptor("pattern", null, null);
        subchildren.add(desc);
        desc = new DMElementDescriptor("correct_responses", subchildren, 250);
        desc.mShowChildren = false;
        desc.mDependentOn = new Vector();
        desc.mDependentOn.add(new String("type"));
        children.add(desc);
        desc = new DMElementDescriptor("weighting", null, new RealRangeValidator(null, null));
        desc.mDependentOn = new Vector();
        desc.mDependentOn.add(new String("id"));
        children.add(desc);
        desc = new DMElementDescriptor("learner_response", null, null);
        desc.mDependentOn = new Vector();
        desc.mDependentOn.add(new String("type"));
        children.add(desc);
        String[] resultFormat = new String[]{"correct", "incorrect", "unanticipated", "neutral"};
        desc = new DMElementDescriptor("result", null, new ResultValidator(resultFormat));
        desc.mDependentOn = new Vector();
        desc.mDependentOn.add(new String("id"));
        children.add(desc);
        desc = new DMElementDescriptor("latency", null, new DurationValidator());
        desc.mDependentOn = new Vector();
        desc.mDependentOn.add(new String("id"));
        children.add(desc);
        desc = new DMElementDescriptor("description", null, 250, new SPMRangeValidator(250));
        del = new DMDelimiterDescriptor("lang", "en", 250, new LangStringValidator());
        desc.mDelimiters = new Vector();
        desc.mDelimiters.add(del);
        desc.mDependentOn = new Vector();
        desc.mDependentOn.add(new String("id"));
        children.add(desc);
        desc = new DMElementDescriptor("interactions", children, 250);
        element = new SCORM_2004_DMElement(desc, null, this);
        this.mElements.put(desc.mBinding, element);
        desc = new DMElementDescriptor("launch_data", null, 4000, new SPMRangeValidator(4000));
        desc.mIsWriteable = false;
        element = new SCORM_2004_DMElement(desc, null, this);
        this.mElements.put(desc.mBinding, element);
        desc = new DMElementDescriptor("learner_id", null, 4000, new URIValidator(4000, "long_identifier_type"));
        desc.mIsWriteable = false;
        element = new SCORM_2004_DMElement(desc, null, this);
        this.mElements.put(desc.mBinding, element);
        desc = new DMElementDescriptor("learner_name", null, 250, new SPMRangeValidator(250));
        del = new DMDelimiterDescriptor("lang", "en", 250, new LangStringValidator());
        desc.mDelimiters = new Vector();
        desc.mDelimiters.add(del);
        desc.mIsWriteable = false;
        element = new SCORM_2004_DMElement(desc, null, this);
        this.mElements.put(desc.mBinding, element);
        children = new Vector();
        desc = new DMElementDescriptor("audio_level", "1", new RealRangeValidator(new Double(0.0), null));
        children.add(desc);
        desc = new DMElementDescriptor("language", "", 250, new LangStringValidator(true));
        children.add(desc);
        desc = new DMElementDescriptor("delivery_speed", "1", new RealRangeValidator(new Double(0.0), null));
        children.add(desc);
        String[] audioFormat = new String[]{"-1", "0", "1"};
        desc = new DMElementDescriptor("audio_captioning", "0", new VocabularyValidator(audioFormat));
        children.add(desc);
        desc = new DMElementDescriptor("learner_preference", children);
        element = new SCORM_2004_DMElement(desc, null, this);
        this.mElements.put(desc.mBinding, element);
        desc = new DMElementDescriptor("location", null, 1000, new SPMRangeValidator(1000));
        element = new SCORM_2004_DMElement(desc, null, this);
        this.mElements.put(desc.mBinding, element);
        desc = new DMElementDescriptor("max_time_allowed", null, new DurationValidator());
        desc.mIsWriteable = false;
        element = new SCORM_2004_DMElement(desc, null, this);
        this.mElements.put(desc.mBinding, element);
        String[] modeFormat = new String[]{"browse", "normal", "review"};
        desc = new DMElementDescriptor("mode", "normal", new VocabularyValidator(modeFormat));
        desc.mIsWriteable = false;
        element = new SCORM_2004_DMElement(desc, null, this);
        this.mElements.put(desc.mBinding, element);
        children = new Vector();
        desc = new DMElementDescriptor("id", null, 4000, new URIValidator(4000, "long_identifier_type"));
        desc.mWriteOnce = true;
        desc.mIsUnique = true;
        children.add(desc);
        subchildren = new Vector();
        desc = new DMElementDescriptor("scaled", null, new RealRangeValidator(new Double(-1.0), new Double(1.0)));
        subchildren.add(desc);
        desc = new DMElementDescriptor("raw", null, new RealRangeValidator(null, null));
        subchildren.add(desc);
        desc = new DMElementDescriptor("min", null, new RealRangeValidator(null, null));
        subchildren.add(desc);
        desc = new DMElementDescriptor("max", null, new RealRangeValidator(null, null));
        subchildren.add(desc);
        desc = new DMElementDescriptor("score", subchildren);
        desc.mDependentOn = new Vector();
        desc.mDependentOn.add(new String("id"));
        children.add(desc);
        String[] successFormat = new String[]{"passed", "failed", "unknown"};
        desc = new DMElementDescriptor("success_status", "unknown", new VocabularyValidator(successFormat));
        desc.mDependentOn = new Vector();
        desc.mDependentOn.add(new String("id"));
        children.add(desc);
        String[] completionFormat = new String[]{"completed", "incomplete", "not attempted", "unknown"};
        desc = new DMElementDescriptor("completion_status", "unknown", new VocabularyValidator(completionFormat));
        desc.mDependentOn = new Vector();
        desc.mDependentOn.add(new String("id"));
        children.add(desc);
        desc = new DMElementDescriptor("progress_measure", null, new RealRangeValidator(new Double(0.0), new Double(1.0)));
        desc.mDependentOn = new Vector();
        desc.mDependentOn.add(new String("id"));
        children.add(desc);
        desc = new DMElementDescriptor("description", null, 250, new SPMRangeValidator(250));
        del = new DMDelimiterDescriptor("lang", "en", 250, new LangStringValidator());
        desc.mDelimiters = new Vector();
        desc.mDelimiters.add(del);
        desc.mDependentOn = new Vector();
        desc.mDependentOn.add(new String("id"));
        children.add(desc);
        desc = new DMElementDescriptor("objectives", children, 100);
        element = new SCORM_2004_DMElement(desc, null, this);
        this.mElements.put(desc.mBinding, element);
        desc = new DMElementDescriptor("progress_measure", null, new RealRangeValidator(new Double(0.0), new Double(1.0)));
        element = new SCORM_2004_DMElement(desc, null, this);
        this.mElements.put(desc.mBinding, element);
        desc = new DMElementDescriptor("scaled_passing_score", null, new RealRangeValidator(new Double(-1.0), new Double(1.0)));
        desc.mIsWriteable = false;
        element = new SCORM_2004_DMElement(desc, null, this);
        this.mElements.put(desc.mBinding, element);
        children = new Vector();
        desc = new DMElementDescriptor("scaled", null, new RealRangeValidator(new Double(-1.0), new Double(1.0)));
        children.add(desc);
        desc = new DMElementDescriptor("raw", null, new RealRangeValidator(null, null));
        children.add(desc);
        desc = new DMElementDescriptor("min", null, new RealRangeValidator(null, null));
        children.add(desc);
        desc = new DMElementDescriptor("max", null, new RealRangeValidator(null, null));
        children.add(desc);
        desc = new DMElementDescriptor("score", children);
        element = new SCORM_2004_DMElement(desc, null, this);
        this.mElements.put(desc.mBinding, element);
        desc = new DMElementDescriptor("session_time", null, new DurationValidator());
        desc.mIsReadable = false;
        element = new SCORM_2004_DMElement(desc, null, this);
        this.mElements.put(desc.mBinding, element);
        desc = new DMElementDescriptor("success_status", "unknown", new VocabularyValidator(successFormat));
        element = new SCORM_2004_DMElement(desc, null, this);
        this.mElements.put(desc.mBinding, element);
        desc = new DMElementDescriptor("suspend_data", null, 64000, new SPMRangeValidator(64000));
        element = new SCORM_2004_DMElement(desc, null, this);
        this.mElements.put(desc.mBinding, element);
        String[] actionFormat = new String[]{"exit,message", "continue,message", "exit,no message", "continue,no message"};
        desc = new DMElementDescriptor("time_limit_action", "continue,no message", new VocabularyValidator(actionFormat));
        desc.mIsWriteable = false;
        element = new SCORM_2004_DMElement(desc, null, this);
        this.mElements.put(desc.mBinding, element);
        desc = new DMElementDescriptor("total_time", "PT0H0M0S", new DurationValidator());
        desc.mIsWriteable = false;
        element = new SCORM_2004_DMElement(desc, null, this);
        this.mElements.put(desc.mBinding, element);
    }

    @Override
    public int equals(DMRequest iRequest, boolean iValidate) {
        int result = 0;
        DMProcessingInfo pi = new DMProcessingInfo();
        result = this.findElement(iRequest, pi);
        if (result == 0) {
            RequestToken tok = iRequest.getNextToken();
            result = !iRequest.hasMoreTokens() ? (tok.getType() == 3 ? pi.mElement.equals(tok, iValidate) : 9000) : 9000;
        }
        return result;
    }

    @Override
    public String getDMBindingString() {
        return this.mBinding;
    }

    @Override
    public DMElement getDMElement(String iElement) {
        DMElement element = (DMElement)this.mElements.get(iElement);
        return element;
    }

    @Override
    public int getValue(DMRequest iRequest, DMProcessingInfo oInfo) {
        int result = 0;
        DMProcessingInfo pi = new DMProcessingInfo();
        result = this.findElement(iRequest, pi);
        if (result == 0) {
            RequestToken tok = iRequest.getNextToken();
            result = !iRequest.hasMoreTokens() ? pi.mElement.getValue(tok, iRequest.isAdminRequest(), iRequest.supplyDefaultDelimiters(), oInfo) : 9000;
        }
        return result;
    }

    @Override
    public int initialize() {
        return 0;
    }

    @Override
    public int setValue(DMRequest iRequest) {
        return this.setValue(iRequest, false);
    }

    @Override
    public int setValue(DMRequest iRequest, boolean iSetBySCO) {
        int result = 0;
        DMProcessingInfo pi = new DMProcessingInfo();
        result = this.findElement(iRequest, pi);
        if (result == 0) {
            RequestToken tok = iRequest.getNextToken();
            if (!iRequest.hasMoreTokens()) {
                if (tok.getType() == 3) {
                    if (pi.mElement.getDescription() != null) {
                        if (pi.mElement.getDescription().mIsUnique && !this.confirmUniqueness(iRequest, tok)) {
                            result = 1006;
                            if (pi.mElement.isInitialized() && ((SCORM_2004_DMElement)pi.mElement).getInternalValue().equals(tok.getValue())) {
                                result = 0;
                            }
                            if (result != 0 && pi.mRecords != null) {
                                pi.mRecords.remove(pi.mRecords.size() - 1);
                            }
                        }
                        if (result == 0 && pi.mElement.getDescription().mWriteOnce && pi.mElement.isInitialized() && !((SCORM_2004_DMElement)pi.mElement).getInternalValue().equals(tok.getValue())) {
                            result = 1009;
                        }
                    }
                    if (result == 0) {
                        result = pi.mElement.setValue(tok, iRequest.isAdminRequest());
                        if (result == 0) {
                            pi.mElement.setBySCO(iSetBySCO);
                        }
                        if (pi.mRecords != null && result != 0 && result != 9002) {
                            pi.mRecords.remove(pi.mRecords.size() - 1);
                        }
                    }
                } else {
                    result = 9000;
                }
            } else {
                result = 9000;
            }
        }
        return result;
    }

    @Override
    public void showAllElements() {
    }

    @Override
    public int terminate() {
        DMRequest req = null;
        DMProcessingInfo dmInfo = null;
        int err = 0;
        req = new DMRequest("cmi.total_time");
        req.getNextToken();
        dmInfo = new DMProcessingInfo();
        err = this.getValue(req, dmInfo);
        String totalTime = dmInfo.mValue;
        req = new DMRequest("cmi.session_time", true, false);
        req.getNextToken();
        dmInfo = new DMProcessingInfo();
        err = this.getValue(req, dmInfo);
        if (err == 0) {
            String sessionTime = dmInfo.mValue;
            String addedTime = DMTimeUtility.add(totalTime, sessionTime);
            req = new DMRequest("cmi.total_time", addedTime, true);
            req.getNextToken();
            err = this.setValue(req);
        }
        req = new DMRequest("cmi.progress_measure");
        req.getNextToken();
        dmInfo = new DMProcessingInfo();
        err = this.getValue(req, dmInfo);
        String progress = dmInfo.mValue;
        req = new DMRequest("cmi.completion_threshold");
        req.getNextToken();
        dmInfo = new DMProcessingInfo();
        err = this.getValue(req, dmInfo);
        String threshold = dmInfo.mValue;
        if (progress != null && threshold != null && !progress.equals("") && !threshold.equals("")) {
            if (Double.parseDouble(progress) >= Double.parseDouble(threshold)) {
                req = new DMRequest("cmi.completion_status", "completed", true);
                req.getNextToken();
                err = this.setValue(req);
            } else if (Double.parseDouble(progress) < Double.parseDouble(threshold)) {
                req = new DMRequest("cmi.completion_status", "incomplete", true);
                req.getNextToken();
                err = this.setValue(req);
            }
        }
        req = new DMRequest("cmi.score.scaled");
        req.getNextToken();
        dmInfo = new DMProcessingInfo();
        err = this.getValue(req, dmInfo);
        progress = dmInfo.mValue;
        req = new DMRequest("cmi.scaled_passing_score");
        req.getNextToken();
        dmInfo = new DMProcessingInfo();
        err = this.getValue(req, dmInfo);
        threshold = dmInfo.mValue;
        if (threshold != null && !threshold.equals("")) {
            if (progress != null && !progress.equals("")) {
                if (Double.parseDouble(progress) >= Double.parseDouble(threshold)) {
                    req = new DMRequest("cmi.success_status", "passed", true);
                    req.getNextToken();
                    err = this.setValue(req);
                } else {
                    req = new DMRequest("cmi.success_status", "failed", true);
                    req.getNextToken();
                    err = this.setValue(req);
                }
            } else {
                req = new DMRequest("cmi.success_status", "unknown", true);
                req.getNextToken();
                err = this.setValue(req);
            }
        }
        req = new DMRequest("cmi.exit", true, false);
        req.getNextToken();
        dmInfo = new DMProcessingInfo();
        err = this.getValue(req, dmInfo);
        if (dmInfo.mValue.equals("suspend") || dmInfo.mValue.equals("logout")) {
            req = new DMRequest("cmi.entry", "resume", true);
            req.getNextToken();
            err = this.setValue(req);
            DMElementDescriptor desc = new DMElementDescriptor("session_time", null, new DurationValidator());
            desc.mIsReadable = false;
            SCORM_2004_DMElement element = new SCORM_2004_DMElement(desc, null, this);
            this.mElements.put(desc.mBinding, element);
        } else {
            req = new DMRequest("cmi.entry", "", true);
            req.getNextToken();
            err = this.setValue(req);
        }
        req = new DMRequest("cmi.exit", "", true);
        req.getNextToken();
        err = this.setValue(req);
        return 0;
    }

    @Override
    public int validate(DMRequest iRequest) {
        int result = 0;
        DMProcessingInfo pi = new DMProcessingInfo();
        result = this.findElement(iRequest, pi);
        if (result == 0) {
            RequestToken tok = iRequest.getNextToken();
            result = !iRequest.hasMoreTokens() ? (tok.getType() == 3 ? pi.mElement.validate(tok) : 9000) : 9000;
        }
        return result;
    }

    private boolean confirmUniqueness(DMRequest ioRequest, RequestToken iValue) {
        int i;
        boolean unique = true;
        MessageCollection.getInstance().pause(true);
        int depth = 0;
        ioRequest.reset();
        while (ioRequest.hasMoreTokens()) {
            RequestToken next = ioRequest.getCurToken();
            if (next.getType() == 2) {
                ++depth;
            }
            next = ioRequest.getNextToken();
        }
        ioRequest.reset();
        String request = new String("");
        RequestToken tok = ioRequest.getNextToken();
        request = request + tok.getValue();
        tok = ioRequest.getNextToken();
        request = request + "." + tok.getValue();
        DMProcessingInfo pi = new DMProcessingInfo();
        int result = 0;
        int idxCount = 0;
        while (ioRequest.hasMoreTokens() && result == 0) {
            RequestToken next = ioRequest.getCurToken();
            if (next.getType() != 2) {
                request = request + "." + next.getValue();
                next = ioRequest.getNextToken();
                continue;
            }
            if (++idxCount == depth) break;
            request = request + "." + next.getValue();
            next = ioRequest.getNextToken();
        }
        tok = ioRequest.getNextToken();
        tok = ioRequest.getNextToken();
        int count = 0;
        pi = new DMProcessingInfo();
        String newRequest = request + "._count";
        DMRequest req = null;
        try {
            req = new DMRequest(newRequest);
            req.getNextToken();
            result = this.getValue(req, pi);
            if (result == 0) {
                count = Integer.parseInt(pi.mValue);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String value = iValue.getValue();
        for (i = 0; i < iValue.getDelimiterCount(); ++i) {
            RequestDelimiter del = iValue.getDelimiterAt(i);
            value = value + del.showDotNotation();
        }
        for (i = 0; i < count - 1; ++i) {
            newRequest = request + "." + String.valueOf(i) + "." + tok.getValue();
            try {
                req = new DMRequest(newRequest, value);
                req.getNextToken();
                result = this.equals(req, false);
                if (result != 9501) continue;
                unique = false;
                break;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        MessageCollection.getInstance().pause(false);
        return unique;
    }

    private int findElement(DMRequest iRequest, DMProcessingInfo oInfo) {
        int result = 0;
        RequestToken tok = iRequest.getNextToken();
        if (tok != null && tok.getType() == 1) {
            DMElement element = (DMElement)this.mElements.get(tok.getValue());
            if (element != null) {
                oInfo.mElement = element;
                tok = iRequest.getCurToken();
                boolean done = false;
                if (tok != null) {
                    if (iRequest.isGetValueRequest()) {
                        if (tok.getType() == 4) {
                            done = true;
                        } else if (tok.getType() == 3) {
                            result = 9000;
                            done = true;
                        }
                    } else if (tok.getType() == 3) {
                        done = true;
                    } else if (tok.getType() == 4) {
                        result = 9000;
                        done = true;
                    }
                }
                while (!done && iRequest.hasMoreTokens() && result == 0) {
                    result = element.processRequest(iRequest, oInfo);
                    if (result == 0) {
                        element = oInfo.mElement;
                    } else {
                        oInfo.mElement = null;
                    }
                    if ((tok = iRequest.getCurToken()) == null) continue;
                    if (iRequest.isGetValueRequest()) {
                        if (tok.getType() == 4) {
                            done = true;
                            continue;
                        }
                        if (tok.getType() != 3) continue;
                        result = 9000;
                        done = true;
                        continue;
                    }
                    if (tok.getType() == 3) {
                        done = true;
                        continue;
                    }
                    if (tok.getType() != 4) continue;
                    result = 9000;
                    done = true;
                }
            } else {
                result = 401;
            }
        } else {
            result = 9000;
        }
        if (result == 0 && oInfo.mElement.getDescription().mChildren != null) {
            result = 401;
        }
        return result;
    }
}

