/*
 * Decompiled with CFR 0.152.
 */
package org.adl.datamodels.ieee;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;
import org.adl.datamodels.Children;
import org.adl.datamodels.Count;
import org.adl.datamodels.DMDelimiter;
import org.adl.datamodels.DMDelimiterDescriptor;
import org.adl.datamodels.DMElement;
import org.adl.datamodels.DMElementDescriptor;
import org.adl.datamodels.DMProcessingInfo;
import org.adl.datamodels.DMRequest;
import org.adl.datamodels.DataModel;
import org.adl.datamodels.RequestDelimiter;
import org.adl.datamodels.RequestToken;
import org.adl.datamodels.datatypes.InteractionTrunc;
import org.adl.datamodels.datatypes.InteractionValidator;
import org.adl.datamodels.datatypes.LangStringValidator;
import org.adl.datamodels.datatypes.SPMRangeValidator;
import org.adl.datamodels.datatypes.VocabularyValidator;
import org.adl.logging.DetailedLogMessageCollection;
import org.adl.util.LogMessage;

public class SCORM_2004_DMElement
extends DMElement
implements Serializable {
    private DataModel mDM = null;

    public SCORM_2004_DMElement() {
    }

    public SCORM_2004_DMElement(DMElementDescriptor iDescription, DMElement iParent, DataModel iDM) {
        this.mDescription = iDescription;
        this.mParent = iParent;
        this.mDM = iDM;
        if (this.mDescription.mSPM != -1 && this.mDescription.mChildren != null) {
            this.mRecords = new Vector();
        }
        if (this.mDescription.mChildren != null) {
            this.mChildrenBindings = new Vector();
            for (int i = 0; i < this.mDescription.mChildren.size(); ++i) {
                DMElementDescriptor desc = (DMElementDescriptor)this.mDescription.mChildren.elementAt(i);
                this.mChildrenBindings.add(desc.mBinding);
                if (this.mRecords != null) continue;
                if (this.mChildren == null) {
                    this.mChildren = new Hashtable();
                }
                SCORM_2004_DMElement element = new SCORM_2004_DMElement(desc, this, this.mDM);
                this.mChildren.put(desc.mBinding, element);
            }
        } else {
            if (this.mDescription.mDelimiters != null) {
                this.mDelimiters = new Vector();
                for (int i = 0; i < this.mDescription.mDelimiters.size(); ++i) {
                    DMDelimiterDescriptor desc = (DMDelimiterDescriptor)this.mDescription.mDelimiters.elementAt(i);
                    DMDelimiter delimit = new DMDelimiter(desc);
                    this.mDelimiters.add(delimit);
                }
            }
            if (this.mDescription.mInitial != null) {
                this.mValue = this.mDescription.mInitial;
                this.mInitialized = true;
            } else {
                this.mInitialized = false;
                this.mValue = "";
            }
        }
    }

    @Override
    public int equals(RequestToken iValue, boolean iValidate) {
        int result = 9500;
        if (this.mValue != null && iValue != null) {
            boolean equal = true;
            if (iValidate) {
                result = this.validate(iValue);
            }
            if (result == 406) {
                equal = false;
            }
            if (equal) {
                int i = 0;
                if (this.mDelimiters != null) {
                    DMDelimiter toCheck;
                    Vector<Boolean> checked = new Vector<Boolean>();
                    for (int j = 0; j < this.mDelimiters.size(); ++j) {
                        checked.add(new Boolean(false));
                    }
                    boolean found = true;
                    while (i < iValue.getDelimiterCount() && equal) {
                        RequestDelimiter del = iValue.getDelimiterAt(i);
                        found = false;
                        for (int j = 0; j < this.mDelimiters.size() && equal; ++j) {
                            toCheck = (DMDelimiter)this.mDelimiters.elementAt(j);
                            if (!toCheck.mDescription.mName.equals(del.getName())) continue;
                            boolean alreadyChecked = (Boolean)checked.elementAt(j);
                            if (alreadyChecked) break;
                            found = true;
                            checked.set(j, new Boolean(true));
                            if (toCheck.mValue == null) {
                                if (toCheck.mDescription.mDefault != null) {
                                    if (toCheck.mDescription.mValidator == null) {
                                        equal = equal && toCheck.mDescription.mDefault.equals(del.getValue());
                                        break;
                                    }
                                    equal = equal && toCheck.mDescription.mValidator.compare(toCheck.mDescription.mDefault, del.getValue(), this.mDelimiters);
                                    break;
                                }
                                equal = false;
                                break;
                            }
                            if (toCheck.mDescription.mValidator == null) {
                                equal = equal && toCheck.mValue.equals(del.getValue());
                                break;
                            }
                            boolean bl = equal = equal && toCheck.mDescription.mValidator.compare(toCheck.mValue, del.getValue(), this.mDelimiters);
                            if (equal) break;
                            equal = toCheck.mDescription.mValidator.compare(toCheck.mDescription.mValidator.trunc(toCheck.mValue), del.getValue(), this.mDelimiters);
                            break;
                        }
                        if (!found) break;
                        ++i;
                    }
                    if (equal) {
                        for (int j = 0; j < this.mDelimiters.size() && equal; ++j) {
                            boolean check;
                            boolean bl = check = (Boolean)checked.elementAt(j) == false;
                            if (!check) continue;
                            toCheck = (DMDelimiter)this.mDelimiters.elementAt(j);
                            if (toCheck.mValue == null) continue;
                            equal = toCheck.mDescription.mValidator != null ? equal && toCheck.mDescription.mValidator.compare(toCheck.mDescription.mDefault, toCheck.mValue, this.mDelimiters) : false;
                        }
                    }
                }
                if (equal) {
                    String compareWith = "";
                    while (i < iValue.getDelimiterCount()) {
                        RequestDelimiter del = iValue.getDelimiterAt(i);
                        compareWith = compareWith + del.showDotNotation();
                        ++i;
                    }
                    compareWith = compareWith + iValue.getValue();
                    if (this.mDescription.mValidator == null) {
                        equal = compareWith.equals(this.mValue);
                    } else {
                        equal = this.mDescription.mValidator.compare(compareWith, this.mValue, this.mDelimiters);
                        if (!equal) {
                            equal = this.mDescription.mValidator.compare(compareWith, this.mDescription.mValidator.trunc(this.mValue), this.mDelimiters);
                        }
                    }
                }
            }
            result = equal ? 9501 : 9502;
        }
        return result;
    }

    @Override
    public int getValue(RequestToken iArguments, boolean iAdmin, boolean iDelimiters, DMProcessingInfo oInfo) {
        int result = 0;
        oInfo.mInitialized = this.mInitialized;
        oInfo.mSetBySCO = this.mSetBySCO;
        result = iArguments != null ? 9000 : this.doGeneralGet(iAdmin, iDelimiters, oInfo);
        return result;
    }

    String getInternalValue() {
        return this.mValue;
    }

    @Override
    public int processRequest(DMRequest ioRequest, DMProcessingInfo oInfo) {
        int result = 0;
        if (ioRequest.hasMoreTokens()) {
            RequestToken tok = ioRequest.getNextToken();
            if (tok.getType() == 1) {
                if (tok.getValue().equals("_children")) {
                    if (this.mDescription.mChildren != null) {
                        if (this.mDescription.mShowChildren) {
                            oInfo.mElement = new Children(this.mChildrenBindings);
                            DMElementDescriptor desc = new DMElementDescriptor("_children", null, null);
                            oInfo.mElement.setDescription(desc);
                        } else {
                            result = 1000;
                        }
                    } else {
                        result = 1000;
                    }
                } else if (tok.getValue().equals("_count")) {
                    if (this.mRecords != null) {
                        oInfo.mElement = new Count(this.mRecords.size());
                        DMElementDescriptor desc = new DMElementDescriptor("_count", null, null);
                        oInfo.mElement.setDescription(desc);
                    } else {
                        result = 1001;
                    }
                } else if (tok.getValue().equals("_version")) {
                    result = 1002;
                } else if (this.mRecords != null) {
                    result = 401;
                } else if (this.mChildrenBindings != null) {
                    int idx = this.mChildrenBindings.indexOf(tok.getValue());
                    if (idx != -1) {
                        DMElement element = (DMElement)this.mChildren.get(tok.getValue());
                        DMElementDescriptor desc = element.getDescription();
                        if (ioRequest.isGetValueRequest()) {
                            oInfo.mElement = element;
                        } else {
                            boolean ok = true;
                            if (desc.mDependentOn != null) {
                                for (int i = 0; i < desc.mDependentOn.size(); ++i) {
                                    String check = (String)desc.mDependentOn.elementAt(i);
                                    DMElement e = (DMElement)this.mChildren.get(check);
                                    if (e != null) {
                                        if (e.isInitialized()) continue;
                                        result = 408;
                                        ok = false;
                                        break;
                                    }
                                    result = 9001;
                                    ok = false;
                                    break;
                                }
                            }
                            if (ok) {
                                oInfo.mElement = element;
                            }
                        }
                    } else {
                        result = 401;
                    }
                } else {
                    result = 401;
                }
            } else if (tok.getType() == 2) {
                int idx = Integer.parseInt(tok.getValue());
                if (ioRequest.isGetValueRequest()) {
                    if (idx < this.mRecords.size()) {
                        oInfo.mElement = (DMElement)this.mRecords.elementAt(idx);
                    } else {
                        result = 1004;
                    }
                } else if (idx >= this.mRecords.size()) {
                    if (!(idx != this.mRecords.size() || this.mDescription.mMaximum && this.mRecords.size() == this.mDescription.mSPM)) {
                        DMElementDescriptor desc;
                        boolean ok = true;
                        RequestToken lookAt = ioRequest.getCurToken();
                        boolean found = false;
                        boolean isWriteable = true;
                        if (lookAt != null) {
                            desc = null;
                            for (int i = 0; i < this.mDescription.mChildren.size(); ++i) {
                                desc = (DMElementDescriptor)this.mDescription.mChildren.elementAt(i);
                                if (!desc.mBinding.equals(lookAt.getValue())) continue;
                                found = true;
                                isWriteable = desc.mIsWriteable;
                                break;
                            }
                            if (!found) {
                                result = 401;
                                ok = false;
                            } else if (desc.mDependentOn != null) {
                                result = 408;
                                ok = false;
                            }
                        } else {
                            result = 401;
                            ok = false;
                        }
                        if (ok) {
                            if (isWriteable || ioRequest.isAdminRequest()) {
                                desc = (DMElementDescriptor)this.mDescription.clone();
                                desc.mOldSPM = desc.mSPM;
                                desc.mSPM = -1;
                                SCORM_2004_DMElement element = new SCORM_2004_DMElement(desc, this, this.mDM);
                                this.mRecords.add(element);
                                oInfo.mElement = element;
                                oInfo.mRecords = this.mRecords;
                                if (this.mRecords.size() > this.mDescription.mSPM) {
                                    String dn = this.getDotNotation(this.mDM);
                                    String warn = "Collection SPM exceeded";
                                    DetailedLogMessageCollection.getInstance().addMessage(new LogMessage(1, warn));
                                }
                            } else {
                                result = 404;
                            }
                        }
                    } else {
                        result = this.mRecords.size() == this.mDescription.mSPM && this.mDescription.mMaximum ? 1007 : 1003;
                    }
                } else {
                    oInfo.mElement = (DMElement)this.mRecords.elementAt(idx);
                }
            } else {
                result = 9001;
            }
        } else {
            result = 9001;
        }
        return result;
    }

    @Override
    public int setValue(RequestToken iValue, boolean iAdmin) {
        String oldValue = null;
        int result = 0;
        if (this.mDescription.mSPM != -1) {
            result = 401;
        } else if (!iAdmin) {
            result = this.mDescription.mIsWriteable ? this.validate(iValue) : 404;
        }
        if (result == 0) {
            oldValue = this.mValue;
            this.mValue = "";
            int i = 0;
            if (this.mDelimiters != null) {
                boolean found = true;
                Vector<Boolean> set = new Vector<Boolean>();
                for (int j = 0; j < this.mDelimiters.size(); ++j) {
                    DMDelimiter del = (DMDelimiter)this.mDelimiters.elementAt(j);
                    del.mValue = null;
                    set.add(new Boolean(false));
                }
                while (i < iValue.getDelimiterCount() && found) {
                    RequestDelimiter del = iValue.getDelimiterAt(i);
                    found = false;
                    for (int j = 0; j < this.mDelimiters.size() && !found; ++j) {
                        DMDelimiter toSet = (DMDelimiter)this.mDelimiters.elementAt(j);
                        if (!toSet.mDescription.mName.equals(del.getName())) continue;
                        boolean setAlready = (Boolean)set.elementAt(j);
                        if (setAlready) break;
                        found = true;
                        set.add(j, new Boolean(false));
                        if (toSet.mDescription.mDefault != null) {
                            if (!toSet.mDescription.mDefault.equals(del.getValue())) {
                                String val = del.getValue();
                                if (this.mTruncSPM && toSet.mDescription.mValueSPM != -1) {
                                    val = val.substring(0, toSet.mDescription.mValueSPM - 1);
                                }
                                toSet.mValue = val;
                                break;
                            }
                            toSet.mValue = null;
                            break;
                        }
                        toSet.mValue = del.getValue();
                        break;
                    }
                    ++i;
                }
                if (!found) {
                    --i;
                }
            }
            while (i < iValue.getDelimiterCount()) {
                RequestDelimiter del = iValue.getDelimiterAt(i);
                this.mValue = this.mValue + del.showDotNotation();
                ++i;
            }
            this.mValue = this.mValue + iValue.getValue();
            if (this.mTruncSPM && this.mDescription.mValueSPM != -1) {
                if (this.mDescription.mValueSPM == -2) {
                    this.mValue = InteractionTrunc.trunc(this.mValue, ((InteractionValidator)this.mDescription.mValidator).getType());
                } else if (this.mValue.length() > this.mDescription.mValueSPM) {
                    this.mValue = this.mValue.substring(0, this.mDescription.mValueSPM);
                }
            }
            this.mInitialized = true;
            if (!(!this.mDescription.mBinding.equals("type") || this.mInitialized && this.mValue.equals(oldValue))) {
                DMElementDescriptor desc = this.mParent.getDescription();
                for (int j = 0; j < desc.mChildren.size(); ++j) {
                    SCORM_2004_DMElement element;
                    DMElementDescriptor curChild = (DMElementDescriptor)desc.mChildren.elementAt(j);
                    DMElementDescriptor child = null;
                    if (curChild.mBinding.equals("correct_responses")) {
                        child = (DMElementDescriptor)curChild.clone();
                        this.handleCorrectResponses(child);
                        element = new SCORM_2004_DMElement(child, this.mParent, this.mDM);
                        this.mParent.putChild(child.mBinding, element);
                        continue;
                    }
                    if (!curChild.mBinding.equals("learner_response")) continue;
                    child = (DMElementDescriptor)curChild.clone();
                    this.handleLearnerResponse(child);
                    element = new SCORM_2004_DMElement(child, this.mParent, this.mDM);
                    this.mParent.putChild(child.mBinding, element);
                }
            }
        }
        return result;
    }

    @Override
    public int validate(RequestToken iValue) {
        int result = 0;
        String toValidate = null;
        int i = 0;
        if (this.mDelimiters != null) {
            Vector<Boolean> checked = new Vector<Boolean>();
            for (int j = 0; j < this.mDelimiters.size(); ++j) {
                checked.add(new Boolean(false));
            }
            boolean found = true;
            while (i < iValue.getDelimiterCount() && found) {
                RequestDelimiter del = iValue.getDelimiterAt(i);
                found = false;
                String trim = del.getName();
                boolean ws = trim.length() != del.getName().length();
                for (int j = 0; j < this.mDelimiters.size() && !found; ++j) {
                    DMDelimiter toCheck = (DMDelimiter)this.mDelimiters.elementAt(j);
                    if (!toCheck.mDescription.mName.equals(trim)) continue;
                    boolean alreadyChecked = (Boolean)checked.elementAt(j);
                    if (alreadyChecked) break;
                    if (ws) {
                        result = 406;
                        break;
                    }
                    found = true;
                    checked.set(j, new Boolean(true));
                    if (toCheck.mDescription.mValidator != null && (result = toCheck.mDescription.mValidator.validate(del.getValue())) != 0) break;
                }
                if (result != 0) break;
                ++i;
            }
            if (!found) {
                --i;
            }
        }
        if (result == 0) {
            toValidate = "";
            while (i < iValue.getDelimiterCount()) {
                RequestDelimiter del = iValue.getDelimiterAt(i);
                toValidate = toValidate + del.showDotNotation();
                ++i;
            }
            toValidate = toValidate + iValue.getValue();
            if (this.mDescription.mValidator != null && (result = this.mDescription.mValidator.validate(toValidate)) == 9002) {
                String warn = this.mDescription.mValidator.getTypeName() + " SPM exceeded";
                DetailedLogMessageCollection.getInstance().addMessage(new LogMessage(1, warn));
                result = 0;
            }
        }
        return result;
    }

    private void handleLearnerResponse(DMElementDescriptor ioChild) {
        String e = "cmi.interactions.n.learner_response";
        DMDelimiterDescriptor del = null;
        if (this.mValue.equals("true-false")) {
            String[] boolVocab = new String[]{"true", "false"};
            ioChild.mValidator = new VocabularyValidator(boolVocab);
        } else if (this.mValue.equals("choice")) {
            ioChild.mValidator = new InteractionValidator(1, e);
        } else if (this.mValue.equals("fill-in")) {
            ioChild.mValueSPM = -2;
            ioChild.mValidator = new InteractionValidator(2, e);
        } else if (this.mValue.equals("long-fill-in")) {
            del = new DMDelimiterDescriptor("lang", "en", 250, new LangStringValidator());
            ioChild.mDelimiters = new Vector();
            ioChild.mDelimiters.add(del);
            ioChild.mValueSPM = -2;
            ioChild.mValidator = new InteractionValidator(3, e);
        } else if (this.mValue.equals("likert")) {
            ioChild.mValueSPM = -2;
            ioChild.mValidator = new InteractionValidator(4, e);
        } else if (this.mValue.equals("matching")) {
            ioChild.mValueSPM = -2;
            ioChild.mValidator = new InteractionValidator(5, e);
        } else if (this.mValue.equals("performance")) {
            ioChild.mValueSPM = -2;
            ioChild.mValidator = new InteractionValidator(6, false, e);
        } else if (this.mValue.equals("sequencing")) {
            ioChild.mValueSPM = -2;
            ioChild.mValidator = new InteractionValidator(7, e);
        } else if (this.mValue.equals("numeric")) {
            ioChild.mValueSPM = -2;
            ioChild.mValidator = new InteractionValidator(8, e);
        } else if (this.mValue.equals("other")) {
            ioChild.mValueSPM = 4000;
            ioChild.mValidator = new SPMRangeValidator(4000);
        }
    }

    private void handleCorrectResponses(DMElementDescriptor ioChild) {
        String e = "cmi.interactions.n.correct_responses.n.pattern";
        DMDelimiterDescriptor del = null;
        DMElementDescriptor curPattern = (DMElementDescriptor)ioChild.mChildren.elementAt(0);
        DMElementDescriptor pattern = (DMElementDescriptor)curPattern.clone();
        pattern.mIsUnique = false;
        pattern.mDelimiters = null;
        pattern.mValidator = null;
        if (pattern.mBinding.equals("pattern")) {
            if (this.mValue.equals("true-false")) {
                ioChild.mSPM = 1;
                ioChild.mMaximum = true;
                String[] boolVocab = new String[]{"true", "false"};
                pattern.mValidator = new VocabularyValidator(boolVocab);
            } else if (this.mValue.equals("choice")) {
                ioChild.mSPM = 10;
                ioChild.mMaximum = false;
                pattern.mIsUnique = true;
                pattern.mValueSPM = -2;
                pattern.mValidator = new InteractionValidator(1, e);
            } else if (this.mValue.equals("fill-in")) {
                String[] boolVocab = new String[]{"true", "false"};
                del = new DMDelimiterDescriptor("case_matters", "false", new VocabularyValidator(boolVocab));
                pattern.mDelimiters = new Vector();
                pattern.mDelimiters.add(del);
                del = new DMDelimiterDescriptor("order_matters", "true", new VocabularyValidator(boolVocab));
                pattern.mDelimiters.add(del);
                pattern.mValueSPM = -2;
                pattern.mValidator = new InteractionValidator(2, e);
                ioChild.mSPM = 5;
                ioChild.mMaximum = false;
            } else if (this.mValue.equals("long-fill-in")) {
                String[] boolVocab = new String[]{"true", "false"};
                del = new DMDelimiterDescriptor("case_matters", "false", new VocabularyValidator(boolVocab));
                pattern.mDelimiters = new Vector();
                pattern.mDelimiters.add(del);
                del = new DMDelimiterDescriptor("lang", "en", new LangStringValidator());
                pattern.mDelimiters.add(del);
                pattern.mValueSPM = -2;
                pattern.mValidator = new InteractionValidator(3, e);
                ioChild.mSPM = 5;
                ioChild.mMaximum = false;
            } else if (this.mValue.equals("likert")) {
                ioChild.mSPM = 1;
                ioChild.mMaximum = true;
                pattern.mValueSPM = -2;
                pattern.mValidator = new InteractionValidator(4, e);
            } else if (this.mValue.equals("matching")) {
                ioChild.mSPM = 5;
                ioChild.mMaximum = false;
                pattern.mValueSPM = -2;
                pattern.mValidator = new InteractionValidator(5, false, e);
            } else if (this.mValue.equals("performance")) {
                String[] boolVocab = new String[]{"true", "false"};
                del = new DMDelimiterDescriptor("order_matters", "true", new VocabularyValidator(boolVocab));
                pattern.mDelimiters = new Vector();
                pattern.mDelimiters.add(del);
                pattern.mValueSPM = -2;
                pattern.mValidator = new InteractionValidator(6, false, e);
                ioChild.mSPM = 5;
                ioChild.mMaximum = false;
            } else if (this.mValue.equals("sequencing")) {
                ioChild.mSPM = 5;
                ioChild.mMaximum = false;
                pattern.mIsUnique = true;
                pattern.mValueSPM = -2;
                pattern.mValidator = new InteractionValidator(7, e);
            } else if (this.mValue.equals("numeric")) {
                ioChild.mSPM = 1;
                ioChild.mMaximum = true;
                pattern.mValueSPM = -2;
                pattern.mValidator = new InteractionValidator(8, e);
            } else if (this.mValue.equals("other")) {
                ioChild.mSPM = 1;
                ioChild.mMaximum = true;
                pattern.mValueSPM = 4000;
                pattern.mValidator = new SPMRangeValidator(4000);
            }
        }
        ioChild.mChildren.removeElementAt(0);
        ioChild.mChildren.insertElementAt(pattern, 0);
    }
}

