/*
 * Decompiled with CFR 0.152.
 */
package org.adl.datamodels.nav;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;
import org.adl.datamodels.DMDelimiterDescriptor;
import org.adl.datamodels.DMElement;
import org.adl.datamodels.DMElementDescriptor;
import org.adl.datamodels.DMProcessingInfo;
import org.adl.datamodels.DMRequest;
import org.adl.datamodels.DataModel;
import org.adl.datamodels.RequestToken;
import org.adl.datamodels.datatypes.SPMRangeValidator;
import org.adl.datamodels.datatypes.URIValidator;
import org.adl.datamodels.datatypes.VocabularyValidator;
import org.adl.datamodels.nav.SCORM_2004_NAV_DMElement;
import org.adl.sequencer.ADLValidRequests;

public class SCORM_2004_NAV_DM
extends DataModel
implements Serializable {
    public static final int DATA_STORE_SPM = 64000;
    public static final int DATA_SPM = 250;
    ADLValidRequests mNavRequests = null;
    String mCurRequest = null;
    String mJumpLocation = null;
    private String mBinding = "adl";
    private Hashtable mElements = null;

    public SCORM_2004_NAV_DM() {
        Vector<DMElementDescriptor> children = null;
        SCORM_2004_NAV_DMElement element = null;
        DMElementDescriptor desc = null;
        DMDelimiterDescriptor del = null;
        this.mElements = new Hashtable();
        children = new Vector<DMElementDescriptor>();
        String[] vocab = new String[]{"continue", "previous", "choice", "exit", "exitAll", "abandon", "abandonAll", "suspendAll", "_none_", "jump"};
        desc = new DMElementDescriptor("request", "_none_", new VocabularyValidator(vocab));
        del = new DMDelimiterDescriptor("target", null, new URIValidator());
        desc.mDelimiters = new Vector();
        desc.mDelimiters.add(del);
        children.add(desc);
        Vector<DMElementDescriptor> subChildren = new Vector<DMElementDescriptor>();
        String[] status = new String[]{"true", "false", "unknown"};
        desc = new DMElementDescriptor("continue", "unknown", new VocabularyValidator(status));
        desc.mIsWriteable = false;
        subChildren.add(desc);
        desc = new DMElementDescriptor("previous", "unknown", new VocabularyValidator(status));
        desc.mIsWriteable = false;
        subChildren.add(desc);
        desc = new DMElementDescriptor("choice", "unknown", new VocabularyValidator(status));
        desc.mIsWriteable = false;
        subChildren.add(desc);
        desc = new DMElementDescriptor("jump", "unknown", new VocabularyValidator(status));
        desc.mIsWriteable = false;
        subChildren.add(desc);
        desc = new DMElementDescriptor("request_valid", subChildren);
        children.add(desc);
        desc = new DMElementDescriptor("nav", children);
        element = new SCORM_2004_NAV_DMElement(desc, null, this);
        this.mElements.put(desc.mBinding, element);
        children = new Vector();
        desc = new DMElementDescriptor("id", null, 4000, new URIValidator(4000, "long_identifier_type"));
        desc.mIsWriteable = false;
        desc.mIsUnique = true;
        children.add(desc);
        desc = new DMElementDescriptor("store", null, 64000, new SPMRangeValidator(64000));
        desc.mDependentOn = new Vector();
        desc.mDependentOn.add(new String("id"));
        children.add(desc);
        desc = new DMElementDescriptor("data", children, 250);
        element = new SCORM_2004_NAV_DMElement(desc, null, this);
        this.mElements.put(desc.mBinding, element);
    }

    @Override
    public int equals(DMRequest iRequest, boolean iValidate) {
        int result = 0;
        DMProcessingInfo pi = new DMProcessingInfo();
        result = this.findElement(iRequest, pi);
        if (result == 0) {
            RequestToken tok = iRequest.getNextToken();
            result = !iRequest.hasMoreTokens() ? (tok.getType() == 3 ? pi.mElement.equals(tok) : 9000) : 9000;
        }
        return result;
    }

    @Override
    public String getDMBindingString() {
        return this.mBinding;
    }

    @Override
    public DMElement getDMElement(String iElement) {
        DMElement element = (DMElement)this.mElements.get(iElement);
        return element;
    }

    public String getNavRequest() {
        String request = null;
        int navEvent = 0;
        if (this.mCurRequest != null) {
            if (this.mCurRequest.equals("continue")) {
                navEvent = 3;
            } else if (this.mCurRequest.equals("previous")) {
                navEvent = 4;
            } else if (this.mCurRequest.equals("exit")) {
                navEvent = 8;
            } else if (this.mCurRequest.equals("exitAll")) {
                navEvent = 9;
            } else if (this.mCurRequest.equals("abandon")) {
                navEvent = 5;
            } else if (this.mCurRequest.equals("abandonAll")) {
                navEvent = 6;
            } else if (this.mCurRequest.equals("suspendAll")) {
                navEvent = 7;
            } else if (this.mCurRequest.equals("_none_")) {
                navEvent = 0;
            } else if (this.mCurRequest.equals("jump")) {
                navEvent = 10;
            } else {
                request = this.mCurRequest;
            }
        }
        if (request == null) {
            request = Integer.toString(navEvent);
        }
        return request;
    }

    @Override
    public int getValue(DMRequest iRequest, DMProcessingInfo oInfo) {
        int result = 0;
        DMProcessingInfo pi = new DMProcessingInfo();
        result = this.findElement(iRequest, pi);
        if (result == 0) {
            RequestToken tok = iRequest.getNextToken();
            result = !iRequest.hasMoreTokens() ? pi.mElement.getValue(tok, iRequest.isAdminRequest(), iRequest.supplyDefaultDelimiters(), oInfo) : 9000;
        }
        return result;
    }

    @Override
    public int initialize() {
        return 0;
    }

    public void setValidRequests(ADLValidRequests iValid) {
        this.mNavRequests = iValid;
    }

    @Override
    public int setValue(DMRequest iRequest) {
        return this.setValue(iRequest, false);
    }

    @Override
    public int setValue(DMRequest iRequest, boolean iSetBySCO) {
        int result = 0;
        DMProcessingInfo pi = new DMProcessingInfo();
        result = this.findElement(iRequest, pi);
        if (result == 0) {
            RequestToken tok = iRequest.getNextToken();
            if (tok == null && pi.mValue.equals("_access")) {
                return result;
            }
            if (!iRequest.hasMoreTokens()) {
                if (tok.getType() == 3) {
                    if (result == 0 && (result = pi.mElement.setValue(tok, iRequest.isAdminRequest())) == 0) {
                        pi.mElement.setBySCO(iSetBySCO);
                    }
                } else {
                    result = 9000;
                }
            } else {
                result = 9000;
            }
        }
        return result;
    }

    @Override
    public void showAllElements() {
    }

    @Override
    public int terminate() {
        DMRequest req = new DMRequest("adl.nav.request", "_none_", true);
        req.getNextToken();
        this.setValue(req);
        this.mCurRequest = null;
        this.mNavRequests = null;
        return 0;
    }

    @Override
    public int validate(DMRequest iRequest) {
        int result = 0;
        DMProcessingInfo pi = new DMProcessingInfo();
        result = this.findElement(iRequest, pi);
        if (result == 0) {
            RequestToken tok = iRequest.getNextToken();
            result = !iRequest.hasMoreTokens() ? (tok.getType() == 3 ? pi.mElement.validate(tok) : 9000) : 9000;
        }
        return result;
    }

    public String getJumpLocation() {
        return this.mJumpLocation;
    }

    private int findElement(DMRequest iRequest, DMProcessingInfo oInfo) {
        int result = 0;
        RequestToken tok = iRequest.getNextToken();
        if (tok != null && tok.getType() == 1) {
            DMElement element = (DMElement)this.mElements.get(tok.getValue());
            if (element != null) {
                oInfo.mElement = element;
                tok = iRequest.getCurToken();
                boolean done = false;
                if (tok != null) {
                    if (iRequest.isGetValueRequest()) {
                        if (tok.getType() == 4) {
                            done = true;
                        } else if (tok.getType() == 3) {
                            result = 9000;
                            done = true;
                        }
                    } else if (tok.getType() == 3) {
                        done = true;
                    } else if (tok.getType() == 4) {
                        result = 9000;
                        done = true;
                    }
                }
                while (!done && iRequest.hasMoreTokens() && result == 0) {
                    result = element.processRequest(iRequest, oInfo);
                    if (result == 0) {
                        element = oInfo.mElement;
                    } else {
                        oInfo.mElement = null;
                    }
                    if ((tok = iRequest.getCurToken()) == null) continue;
                    if (iRequest.isGetValueRequest()) {
                        if (tok.getType() == 4) {
                            done = true;
                            continue;
                        }
                        if (tok.getType() != 3) continue;
                        result = 9000;
                        done = true;
                        continue;
                    }
                    if (tok.getType() == 3) {
                        done = true;
                        continue;
                    }
                    if (tok.getType() != 4) continue;
                    result = 9000;
                    done = true;
                }
            } else {
                result = 401;
            }
        } else {
            result = 9000;
        }
        if (result == 0 && oInfo.mElement.getDescription().mChildren != null) {
            result = 401;
        }
        return result;
    }
}

