/*
 * Decompiled with CFR 0.152.
 */
package org.adl.datamodels.nav;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;
import org.adl.datamodels.Children;
import org.adl.datamodels.Count;
import org.adl.datamodels.DMDelimiter;
import org.adl.datamodels.DMDelimiterDescriptor;
import org.adl.datamodels.DMElement;
import org.adl.datamodels.DMElementDescriptor;
import org.adl.datamodels.DMProcessingInfo;
import org.adl.datamodels.DMRequest;
import org.adl.datamodels.RequestDelimiter;
import org.adl.datamodels.RequestToken;
import org.adl.datamodels.datatypes.URIValidator;
import org.adl.datamodels.nav.SCORM_2004_NAV_DM;
import org.adl.sequencer.ADLTOC;

public class SCORM_2004_NAV_DMElement
extends DMElement
implements Serializable {
    private SCORM_2004_NAV_DM mDM = null;

    public SCORM_2004_NAV_DMElement() {
    }

    public SCORM_2004_NAV_DMElement(DMElementDescriptor iDescription, DMElement iParent, SCORM_2004_NAV_DM iDM) {
        this.mDescription = iDescription;
        this.mParent = iParent;
        this.mDM = iDM;
        if (this.mDescription.mSPM != -1 && this.mDescription.mChildren != null) {
            this.mRecords = new Vector();
        }
        if (this.mDescription.mChildren != null) {
            this.mChildrenBindings = new Vector();
            for (int i = 0; i < this.mDescription.mChildren.size(); ++i) {
                DMElementDescriptor desc = (DMElementDescriptor)this.mDescription.mChildren.elementAt(i);
                this.mChildrenBindings.add(desc.mBinding);
                if (this.mRecords != null) continue;
                if (this.mChildren == null) {
                    this.mChildren = new Hashtable();
                }
                SCORM_2004_NAV_DMElement element = new SCORM_2004_NAV_DMElement(desc, this, iDM);
                this.mChildren.put(desc.mBinding, element);
            }
        } else {
            if (this.mDescription.mDelimiters != null) {
                this.mDelimiters = new Vector();
                for (int i = 0; i < this.mDescription.mDelimiters.size(); ++i) {
                    DMDelimiterDescriptor desc = (DMDelimiterDescriptor)this.mDescription.mDelimiters.elementAt(i);
                    DMDelimiter delimit = new DMDelimiter(desc);
                    this.mDelimiters.add(delimit);
                }
            }
            if (this.mDescription.mInitial != null) {
                this.mValue = this.mDescription.mInitial;
                this.mInitialized = true;
            } else {
                this.mInitialized = false;
                this.mValue = new String("");
            }
        }
    }

    @Override
    public int equals(RequestToken iValue, boolean iValidate) {
        int result = 9500;
        if (this.mValue != null && iValue != null) {
            boolean equal = true;
            result = this.validate(iValue);
            if (result == 406) {
                equal = false;
            }
            if (equal) {
                int i = 0;
                if (this.mDelimiters != null) {
                    DMDelimiter toCheck;
                    Vector<Boolean> checked = new Vector<Boolean>();
                    for (int j = 0; j < this.mDelimiters.size(); ++j) {
                        checked.add(new Boolean(false));
                    }
                    boolean found = true;
                    while (i < iValue.getDelimiterCount() && found && equal) {
                        RequestDelimiter del = iValue.getDelimiterAt(i);
                        found = false;
                        for (int j = 0; j < this.mDelimiters.size(); ++j) {
                            toCheck = (DMDelimiter)this.mDelimiters.elementAt(j);
                            if (!toCheck.mDescription.mName.equals(del.getName())) continue;
                            boolean alreadyChecked = (Boolean)checked.elementAt(j);
                            if (alreadyChecked) break;
                            found = true;
                            checked.set(j, new Boolean(true));
                            if (toCheck.mValue == null) {
                                if (toCheck.mDescription.mDefault != null) {
                                    if (toCheck.mDescription.mValidator == null) {
                                        equal = equal && toCheck.mDescription.mDefault.equals(del.getValue());
                                        break;
                                    }
                                    equal = equal && toCheck.mDescription.mValidator.compare(toCheck.mDescription.mDefault, del.getValue(), null);
                                    break;
                                }
                                equal = false;
                                break;
                            }
                            if (toCheck.mDescription.mValidator == null) {
                                equal = equal && toCheck.mValue.equals(del.getValue());
                                break;
                            }
                            equal = equal && toCheck.mDescription.mValidator.compare(toCheck.mValue, del.getValue(), null);
                            break;
                        }
                        ++i;
                    }
                    if (equal) {
                        for (int j = 0; j < this.mDelimiters.size() && equal; ++j) {
                            boolean check;
                            boolean bl = check = (Boolean)checked.elementAt(j) == false;
                            if (!check) continue;
                            toCheck = (DMDelimiter)this.mDelimiters.elementAt(j);
                            if (toCheck.mValue == null) continue;
                            equal = false;
                        }
                    }
                }
                if (equal) {
                    String compareWith = iValue.getValue();
                    while (i < iValue.getDelimiterCount()) {
                        RequestDelimiter del = iValue.getDelimiterAt(i);
                        compareWith = compareWith + del.showDotNotation();
                        ++i;
                    }
                    equal = this.mDescription.mValidator == null ? compareWith.equals(this.mValue) : this.mDescription.mValidator.compare(compareWith, this.mValue, null);
                }
            }
            result = equal ? 9501 : 9502;
        }
        return result;
    }

    @Override
    public int getValue(RequestToken iArguments, boolean iAdmin, boolean iDelimiters, DMProcessingInfo oInfo) {
        Object del;
        int result = 0;
        boolean done = false;
        String target = null;
        oInfo.mValue = "";
        if (iArguments != null) {
            if (this.mDescription.mBinding.equals("request")) {
                result = 9000;
            } else if (this.mDescription.mBinding.equals("choice") || this.mDescription.mBinding.equals("jump")) {
                if (iArguments.getDelimiterCount() == 1) {
                    del = iArguments.getDelimiterAt(0);
                    if (((RequestDelimiter)del).getName().equals("target")) {
                        target = ((RequestDelimiter)del).getValue();
                        URIValidator uri = new URIValidator();
                        result = uri.validate(target);
                    } else {
                        result = 1008;
                    }
                } else {
                    result = 1008;
                }
            } else {
                result = 401;
            }
        } else if (this.mParent.getDMElementBindingString().equals("data")) {
            result = this.doGeneralGet(iAdmin, iDelimiters, oInfo);
            boolean bl = done = 0 == result;
        }
        if (!(done || result != 0 && result != 9002)) {
            if (this.mDescription.mBinding.equals("request")) {
                oInfo.mValue = "";
                if (this.mValue.equals("choice") || this.mValue.equals("jump")) {
                    if (this.mDelimiters != null) {
                        del = (DMDelimiter)this.mDelimiters.elementAt(0);
                        oInfo.mValue = oInfo.mValue + ((DMDelimiter)del).getDotNotation(iDelimiters);
                    } else {
                        result = 9001;
                    }
                }
                oInfo.mValue = oInfo.mValue + this.mValue;
            } else if (this.mDescription.mBinding.equals("choice") && target == null) {
                result = 1008;
            } else if (this.mValue != null) {
                oInfo.mValue = "unknown";
                if (this.mDM.mNavRequests != null) {
                    if (this.mDescription.mBinding.equals("continue")) {
                        oInfo.mValue = this.mDM.mNavRequests.mContinue || this.mDM.mNavRequests.mContinueExit ? "true" : "false";
                    } else if (this.mDescription.mBinding.equals("previous")) {
                        oInfo.mValue = this.mDM.mNavRequests.mPrevious ? "true" : "false";
                    } else if (this.mDescription.mBinding.equals("jump")) {
                        if (this.mDM != null && this.mDM.mNavRequests.mJump != null) {
                            boolean ok = this.mDM.mNavRequests.mJump.containsKey(target);
                            oInfo.mValue = ok ? "true" : "false";
                        }
                    } else if (this.mDM != null && this.mDM.mNavRequests.mChoice != null) {
                        boolean ok;
                        boolean bl = ok = (ADLTOC)this.mDM.mNavRequests.mChoice.get(target) != null;
                        oInfo.mValue = ok ? "true" : "false";
                    }
                }
            } else {
                result = 401;
            }
        }
        return result;
    }

    @Override
    public int processRequest(DMRequest ioRequest, DMProcessingInfo oInfo) {
        int result = 0;
        if (ioRequest.hasMoreTokens()) {
            RequestToken tok = ioRequest.getNextToken();
            if (tok.getType() == 1) {
                if (tok.getValue().equals("_children")) {
                    if (this.mDescription.mChildren != null) {
                        if (this.mDescription.mShowChildren) {
                            oInfo.mElement = new Children(this.mChildrenBindings);
                            DMElementDescriptor desc = new DMElementDescriptor("_children", null, null);
                            oInfo.mElement.setDescription(desc);
                        } else {
                            result = 1000;
                        }
                    } else {
                        result = 1000;
                    }
                } else if (tok.getValue().equals("_count")) {
                    if (this.mRecords != null) {
                        oInfo.mElement = new Count(this.mRecords.size());
                        DMElementDescriptor desc = new DMElementDescriptor("_count", null, null);
                        oInfo.mElement.setDescription(desc);
                    } else {
                        result = 1001;
                    }
                } else if (tok.getValue().equals("_version")) {
                    result = 401;
                } else if (tok.getValue().equals("_access")) {
                    RequestToken val = ioRequest.getNextToken();
                    if (val.getType() == 3 && ioRequest.isAdminRequest()) {
                        String[] value = val.getValue().split("<>");
                        if (value.length == 2) {
                            Vector dep = this.mDescription.mDependentOn;
                            this.mDescription = new DMElementDescriptor(this.mDescription.mBinding, null, this.mDescription.mSPM, this.mDescription.mValidator);
                            this.mDescription.mDependentOn = dep;
                            this.mDescription.mIsReadable = Boolean.valueOf(value[0]);
                            this.mDescription.mIsWriteable = Boolean.valueOf(value[1]);
                            oInfo.mValue = "_access";
                        } else {
                            result = 351;
                        }
                    } else {
                        result = 401;
                    }
                } else if (this.mRecords != null) {
                    result = 401;
                } else if (this.mChildrenBindings != null) {
                    int idx = this.mChildrenBindings.indexOf(tok.getValue());
                    if (idx != -1) {
                        DMElement element = (DMElement)this.mChildren.get(tok.getValue());
                        DMElementDescriptor desc = element.getDescription();
                        if (ioRequest.isGetValueRequest()) {
                            oInfo.mElement = element;
                        } else {
                            boolean ok = true;
                            if (desc.mDependentOn != null) {
                                for (int i = 0; i < desc.mDependentOn.size(); ++i) {
                                    String check = (String)desc.mDependentOn.elementAt(i);
                                    DMElement e = (DMElement)this.mChildren.get(check);
                                    if (e != null) {
                                        if (e.isInitialized()) continue;
                                        result = 408;
                                        ok = false;
                                        break;
                                    }
                                    result = 9001;
                                    ok = false;
                                    break;
                                }
                            }
                            if (ok) {
                                oInfo.mElement = element;
                            }
                        }
                    } else {
                        result = 401;
                    }
                } else {
                    result = 401;
                }
            } else if (tok.getType() == 2) {
                int idx = Integer.parseInt(tok.getValue());
                if (ioRequest.isGetValueRequest()) {
                    if (idx < this.mRecords.size()) {
                        oInfo.mElement = (DMElement)this.mRecords.elementAt(idx);
                    } else {
                        result = 1004;
                    }
                } else if (idx >= this.mRecords.size()) {
                    boolean ok = true;
                    if (idx >= this.mRecords.size() && this.mDescription.mBinding.equals("data") && !ioRequest.isAdminRequest()) {
                        ok = false;
                        result = 351;
                    } else if (!(idx != this.mRecords.size() || this.mDescription.mMaximum && this.mRecords.size() == this.mDescription.mSPM)) {
                        DMElementDescriptor desc;
                        RequestToken lookAt = ioRequest.getCurToken();
                        boolean found = false;
                        boolean isWriteable = true;
                        if (lookAt != null) {
                            desc = null;
                            for (int i = 0; i < this.mDescription.mChildren.size(); ++i) {
                                desc = (DMElementDescriptor)this.mDescription.mChildren.elementAt(i);
                                if (!desc.mBinding.equals(lookAt.getValue())) continue;
                                found = true;
                                isWriteable = desc.mIsWriteable;
                                break;
                            }
                            if (!found) {
                                result = 401;
                                ok = false;
                            } else if (desc.mDependentOn != null) {
                                result = 408;
                                ok = false;
                            }
                        } else {
                            result = 401;
                            ok = false;
                        }
                        if (ok) {
                            if (isWriteable || ioRequest.isAdminRequest()) {
                                desc = (DMElementDescriptor)this.mDescription.clone();
                                desc.mSPM = -1;
                                SCORM_2004_NAV_DMElement element = new SCORM_2004_NAV_DMElement(desc, this, this.mDM);
                                this.mRecords.add(element);
                                if (this.mRecords.size() > this.mDescription.mSPM) {
                                    result = 9002;
                                }
                                oInfo.mElement = element;
                            } else {
                                result = 404;
                            }
                        }
                    } else {
                        result = this.mRecords.size() == this.mDescription.mSPM && this.mDescription.mMaximum ? 1007 : 1003;
                    }
                } else {
                    oInfo.mElement = (DMElement)this.mRecords.elementAt(idx);
                }
            } else {
                result = 9001;
            }
        } else {
            result = 9001;
        }
        return result;
    }

    @Override
    public int setValue(RequestToken iValue, boolean iAdmin) {
        String oldValue = null;
        int result = 0;
        if (!iAdmin) {
            result = this.mDescription.mIsWriteable ? this.validate(iValue) : 404;
        }
        if (result == 0 || result == 9002) {
            if (this.mDescription.mBinding.equals("store") && iValue.getValue().equals("")) {
                this.mInitialized = false;
                this.mValue = iValue.getValue();
            } else {
                oldValue = this.mValue;
                this.mValue = new String("");
                int i = 0;
                if (this.mDelimiters != null) {
                    boolean found = true;
                    Vector<Boolean> set = new Vector<Boolean>();
                    for (int j = 0; j < this.mDelimiters.size(); ++j) {
                        DMDelimiter del = (DMDelimiter)this.mDelimiters.elementAt(j);
                        del.mValue = null;
                        set.add(new Boolean(false));
                    }
                    while (i < iValue.getDelimiterCount() && found) {
                        RequestDelimiter del = iValue.getDelimiterAt(i);
                        found = false;
                        for (int j = 0; j < this.mDelimiters.size(); ++j) {
                            DMDelimiter toSet = (DMDelimiter)this.mDelimiters.elementAt(j);
                            if (!toSet.mDescription.mName.equals(del.getName())) continue;
                            boolean setAlready = (Boolean)set.elementAt(j);
                            if (setAlready) break;
                            found = true;
                            set.add(j, new Boolean(false));
                            if (toSet.mDescription.mDefault != null) {
                                if (!toSet.mDescription.mDefault.equals(del.getValue())) {
                                    toSet.mValue = del.getValue();
                                    break;
                                }
                                toSet.mValue = null;
                                break;
                            }
                            toSet.mValue = del.getValue();
                            break;
                        }
                        ++i;
                    }
                }
                while (i < iValue.getDelimiterCount()) {
                    RequestDelimiter del = iValue.getDelimiterAt(i);
                    this.mValue = this.mValue + del.showDotNotation();
                    ++i;
                }
                this.mValue = this.mValue + iValue.getValue();
                this.mInitialized = true;
                if (this.mDescription.mBinding.equals("request")) {
                    DMDelimiter target = (DMDelimiter)this.mDelimiters.elementAt(0);
                    if (this.mValue.equals("choice")) {
                        this.mDM.mCurRequest = target.mValue;
                    } else if (this.mValue.equals("jump")) {
                        this.mDM.mCurRequest = this.mValue;
                        this.mDM.mJumpLocation = target.mValue;
                    } else {
                        this.mDM.mCurRequest = this.mValue;
                    }
                }
            }
        }
        return result;
    }

    @Override
    public int validate(RequestToken iValue) {
        int i;
        int result = 0;
        String toValidate = null;
        if (this.mDescription.mDelimiters != null) {
            boolean found = true;
            for (i = 0; i < iValue.getDelimiterCount() && found; ++i) {
                RequestDelimiter del = iValue.getDelimiterAt(i);
                found = false;
                for (int j = 0; j < this.mDescription.mDelimiters.size(); ++j) {
                    DMDelimiterDescriptor desc = (DMDelimiterDescriptor)this.mDescription.mDelimiters.elementAt(j);
                    if (!desc.mName.equals(del.getName())) continue;
                    found = true;
                    if (desc.mValidator == null) break;
                    result = desc.mValidator.validate(del.getValue());
                    break;
                }
                if (result != 0) break;
            }
        }
        if (result == 0) {
            toValidate = new String("");
            while (i < iValue.getDelimiterCount()) {
                RequestDelimiter del = iValue.getDelimiterAt(i);
                toValidate = toValidate + del.showDotNotation();
                ++i;
            }
            toValidate = toValidate + iValue.getValue();
            if (this.mDescription.mValidator != null) {
                result = this.mDescription.mValidator.validate(toValidate);
            }
        }
        return result;
    }
}

