/*
 * Decompiled with CFR 0.152.
 */
package org.adl.logging;

import java.util.LinkedList;
import java.util.List;
import org.adl.util.LogMessage;

public class ADLMessageCollection {
    private final transient List<LogMessage> mMessages = new LinkedList<LogMessage>();
    private transient boolean isWaiting = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessage(LogMessage iMessage) {
        ADLMessageCollection aDLMessageCollection = this;
        synchronized (aDLMessageCollection) {
            this.mMessages.add(iMessage);
            if (this.isWaiting) {
                this.notifyAll();
                this.isWaiting = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAll(List<LogMessage> iMessages) {
        ADLMessageCollection aDLMessageCollection = this;
        synchronized (aDLMessageCollection) {
            this.mMessages.addAll(iMessages);
            if (this.isWaiting) {
                this.notifyAll();
                this.isWaiting = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LogMessage getMessage() {
        ADLMessageCollection aDLMessageCollection = this;
        synchronized (aDLMessageCollection) {
            return this.mMessages.remove(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasMessages() {
        ADLMessageCollection aDLMessageCollection = this;
        synchronized (aDLMessageCollection) {
            if (this.mMessages.isEmpty()) {
                try {
                    this.isWaiting = true;
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return !this.mMessages.isEmpty();
        }
    }

    public int getSize() {
        return this.mMessages.size();
    }
}

