/*
 * Decompiled with CFR 0.152.
 */
package org.adl.parsers.dom;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import org.adl.logging.DetailedLogMessageCollection;
import org.adl.parsers.dom.DOMTreeUtility;
import org.adl.util.LogMessage;
import org.adl.util.Messages;
import org.apache.xerces.dom.TextImpl;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ADLDOMParser
implements ErrorHandler {
    private DOMParser mParser = null;
    private Document mDocument = null;
    private boolean mIsXMLWellformed = false;
    private boolean mExtensionsFound = false;
    private boolean mIsXMLValidToSchema = false;
    private boolean mValidFlag = true;
    private String mSchemaLocation = null;
    private boolean mFirstTimeSchemaLocationFound = true;
    private boolean mStateIsValidating = false;
    private Logger mLogger = Logger.getLogger("org.adl.util.debug.validator");
    private boolean mSchemaLocExists = false;
    private List mDeclaredNamespaces = new ArrayList();

    public void setSchemaLocation(String iSchemaLocation) {
        this.mSchemaLocation = iSchemaLocation;
    }

    public Document getDocument() {
        return this.mDocument;
    }

    public boolean getSchemaLocExists() {
        return this.mSchemaLocExists;
    }

    public String getSchemaLocation() {
        return this.mSchemaLocation;
    }

    public List getDeclaredNamespaces() {
        return this.mDeclaredNamespaces;
    }

    public boolean getIsWellformed() {
        return this.mIsXMLWellformed;
    }

    public boolean getIsValidToSchema() {
        return this.mIsXMLValidToSchema;
    }

    public boolean isExtensionsFound() {
        return this.mExtensionsFound;
    }

    @Override
    public void warning(SAXParseException iSPE) {
        this.mLogger.entering("ADLDOMParser", "warning()");
        if (this.mStateIsValidating) {
            this.mValidFlag = false;
        } else {
            this.mIsXMLWellformed = false;
        }
        String msgText = iSPE.getMessage() + " line: " + iSPE.getLineNumber() + ", col: " + iSPE.getColumnNumber();
        this.mLogger.info("FAILED: " + msgText);
        DetailedLogMessageCollection.getInstance().addMessage(new LogMessage(3, msgText));
        this.mLogger.exiting("ADLDOMParser", "warning(SAXParseException)");
    }

    @Override
    public void error(SAXParseException iSPE) {
        this.mLogger.entering("ADLDOMParser", "error()");
        if (this.mStateIsValidating) {
            this.mValidFlag = false;
        } else {
            this.mIsXMLWellformed = false;
        }
        String msgText = iSPE.getMessage() + " line: " + iSPE.getLineNumber() + ", col: " + iSPE.getColumnNumber();
        this.mLogger.info("FAILED: " + msgText);
        DetailedLogMessageCollection.getInstance().addMessage(new LogMessage(3, msgText));
        this.mLogger.exiting("ADLDOMParser", "error()");
    }

    @Override
    public void fatalError(SAXParseException iSPE) {
        this.mLogger.entering("ADLDOMParser", "fatalError()");
        if (this.mStateIsValidating) {
            this.mValidFlag = false;
        } else {
            this.mIsXMLWellformed = false;
        }
        String msgText = iSPE.getMessage() + " line: " + iSPE.getLineNumber() + ", col: " + iSPE.getColumnNumber();
        this.mLogger.info("FAILED: " + msgText);
        DetailedLogMessageCollection.getInstance().addMessage(new LogMessage(3, msgText));
        this.mLogger.exiting("ADLDOMParser", "fatalError()");
    }

    private void configureParser() {
        this.mLogger.entering("ADLDOMParser", "configureParser()");
        this.mParser = new DOMParser();
        if (this.mParser != null) {
            if (this.mStateIsValidating) {
                if (this.mSchemaLocation != null) {
                    try {
                        this.mParser.setFeature("http://xml.org/sax/features/validation", true);
                        this.mParser.setFeature("http://apache.org/xml/features/validation/schema", true);
                        this.mParser.setFeature("http://xml.org/sax/features/namespaces", true);
                        this.mParser.setFeature("http://apache.org/xml/features/continue-after-fatal-error", false);
                        this.mLogger.finest("setting schemas to - " + this.mSchemaLocation);
                        this.mParser.setProperty("http://apache.org/xml/properties/schema/external-schemaLocation", this.mSchemaLocation);
                        this.mParser.setErrorHandler(this);
                    }
                    catch (SAXException se) {
                        String msgText = Messages.getString("ADLDOMParser.30", new Object[0]);
                        this.mLogger.severe(msgText);
                        DetailedLogMessageCollection.getInstance().addMessage(new LogMessage(4, msgText));
                    }
                } else {
                    String msgText = "Schema Location(s) not set";
                    this.mLogger.severe("SEVERE: " + msgText);
                    this.mValidFlag = false;
                }
            } else {
                try {
                    this.mParser.setFeature("http://xml.org/sax/features/validation", false);
                    this.mParser.setFeature("http://xml.org/sax/features/namespaces", true);
                    this.mParser.setFeature("http://apache.org/xml/features/continue-after-fatal-error", false);
                    this.mParser.setErrorHandler(this);
                }
                catch (SAXException se) {
                    String msgText = Messages.getString("ADLDOMParser.30", new Object[0]);
                    this.mLogger.severe("TERMINATE: " + msgText);
                    DetailedLogMessageCollection.getInstance().addMessage(new LogMessage(4, msgText));
                }
            }
        } else {
            String msgText = Messages.getString("ADLDOMParser.38", new Object[0]);
            this.mLogger.severe("TERMINATE: " + msgText);
            DetailedLogMessageCollection.getInstance().addMessage(new LogMessage(4, msgText));
        }
        this.mLogger.exiting("ADLDOMParser", "configureParser()");
    }

    public void parseForWellformedness(String iXMLFileName, boolean iLogRelated, boolean iControllingDocRelated) {
        this.mLogger.entering("ADLDOMParser", "parseForWellformedness()");
        this.mLogger.finest("   iXMLFileName coming in is " + iXMLFileName);
        this.mLogger.finest("   iLogRelated coming in is " + iLogRelated);
        this.configureParser();
        Document wellformednessDocument = null;
        String fileName = this.searchFile(iXMLFileName, "xml");
        File tempXMLfile = new File(fileName);
        String xsdLocation = "file:///" + tempXMLfile.getParent() + "/";
        xsdLocation = xsdLocation.replaceAll(" ", "%20");
        xsdLocation = xsdLocation.replace('\\', '/');
        if (!fileName.equals("") && this.mParser != null) {
            try {
                this.mParser.parse(this.setUpInputSource(fileName));
                wellformednessDocument = this.mParser.getDocument();
                if (wellformednessDocument != null) {
                    this.mIsXMLWellformed = true;
                }
            }
            catch (SAXException se) {
                String msgText = "SAXException thrown during non-validating parse";
                this.mLogger.severe(msgText);
            }
            catch (IOException ioe) {
                String msgText = "IOException thrown during non-validating parse";
                this.mLogger.severe(msgText);
            }
        }
        this.setDocumentAttribute(wellformednessDocument, iLogRelated, iXMLFileName, iControllingDocRelated);
        this.mLogger.finest("FINAL SCHEMA LOCATION:  " + this.mSchemaLocation);
        this.mLogger.finest("wellformed = " + this.getIsWellformed());
        this.mLogger.exiting("ADLDOMParser", "parseForWellformedness()");
    }

    public void parseForWellformedness(URL iXMLFileName, boolean iLogRelated, boolean iControllingDocRelated) {
        this.mLogger.entering("ADLDOMParser", "parseForWellformedness()");
        this.mLogger.finest("   iXMLFileName coming in is " + iXMLFileName);
        this.mLogger.finest("   iLogRelated coming in is " + iLogRelated);
        this.configureParser();
        Document wellformednessDocument = null;
        if (this.mParser != null) {
            try {
                this.mParser.parse(new InputSource(iXMLFileName.openStream()));
                wellformednessDocument = this.mParser.getDocument();
                if (wellformednessDocument != null) {
                    this.mIsXMLWellformed = true;
                }
            }
            catch (SAXException se) {
                String msgText = "SAXException thrown during non-validating parse";
                this.mLogger.severe(msgText);
            }
            catch (IOException ioe) {
                String msgText = "IOException thrown during non-validating parse";
                this.mLogger.severe(msgText);
            }
        }
        this.setDocumentAttribute(wellformednessDocument, iLogRelated, iXMLFileName.toString(), iControllingDocRelated);
        this.mLogger.finest("wellformed = " + this.getIsWellformed());
        this.mLogger.exiting("ADLDOMParser", "parseForWellformedness()");
    }

    public void parseForValidation(String iXMLFileName) {
        String msgText;
        this.mLogger.entering("ADLDOMParser", "parseForValidation()");
        this.mLogger.finest("   iXMLFileName coming in is " + iXMLFileName);
        this.configureParser();
        Document wellformednessDocument = null;
        String fileName = this.searchFile(iXMLFileName, "xml");
        if (!fileName.equals("")) {
            if (this.mParser != null) {
                try {
                    msgText = "Parsing for Well-Formedness first to obtain document";
                    this.mLogger.info(msgText);
                    this.mParser.parse(this.setUpInputSource(fileName));
                    wellformednessDocument = this.mParser.getDocument();
                    if (wellformednessDocument != null) {
                        this.mIsXMLWellformed = true;
                    }
                }
                catch (SAXException se) {
                    msgText = "SAXException thrown during non-validating parse";
                    this.mLogger.severe(msgText);
                }
                catch (IOException ioe) {
                    msgText = "IOException thrown during non-validating parse";
                    this.mLogger.severe(msgText);
                }
                catch (NullPointerException npe) {
                    msgText = "NullPointerException thrown during non-validating parse";
                    this.mLogger.severe(msgText);
                }
                if (this.mIsXMLWellformed) {
                    this.mStateIsValidating = true;
                    this.configureParser();
                    if (this.mParser != null) {
                        msgText = Messages.getString("ADLDOMParser.81", new Object[0]);
                        this.mLogger.info(msgText);
                        DetailedLogMessageCollection.getInstance().addMessage(new LogMessage(0, msgText));
                        if (this.mSchemaLocation == null) {
                            this.mValidFlag = false;
                        } else {
                            try {
                                this.mParser.parse(this.setUpInputSource(fileName));
                            }
                            catch (SAXException se) {
                                msgText = "SAXException thrown during validating parse";
                                this.mLogger.severe(msgText);
                            }
                            catch (IOException ioe) {
                                msgText = "IOException thrown during validating parse";
                                this.mLogger.severe(msgText);
                            }
                            catch (NullPointerException npe) {
                                msgText = "NullPointerException thrown during non-validating parse";
                                this.mLogger.severe(msgText);
                            }
                        }
                    } else {
                        this.mValidFlag = false;
                    }
                } else {
                    msgText = "The XML is not wellformed, cannot continue with validation against the Controlling Documents";
                    this.mLogger.finest(msgText);
                    this.mValidFlag = false;
                }
            } else {
                this.mValidFlag = false;
            }
        } else {
            this.mValidFlag = false;
        }
        this.setValidXMLToSchemaAttribute();
        this.mLogger.finest("valid = " + this.getIsValidToSchema());
        if (this.getIsValidToSchema()) {
            msgText = Messages.getString("ADLDOMParser.91", new Object[0]);
            this.mLogger.info(msgText);
            DetailedLogMessageCollection.getInstance().addMessage(new LogMessage(2, msgText));
        }
        this.mLogger.exiting("ADLDOMParser", "parseForValidation()");
    }

    private void pruneTree(Node iNode, String iXMLFileName) {
        if (iNode == null) {
            return;
        }
        switch (iNode.getNodeType()) {
            case 7: {
                break;
            }
            case 9: {
                this.pruneTree(((Document)iNode).getDocumentElement(), iXMLFileName);
                break;
            }
            case 1: {
                this.mLogger.finest("Processing Element Node: [" + iNode.getLocalName() + "]");
                this.mLogger.finest("************************************************");
                this.mLogger.finest("Processing Element Node: [" + iNode.getLocalName() + "]");
                this.checkForSchemaLocations(iNode, iXMLFileName);
                NamedNodeMap attrList = iNode.getAttributes();
                this.mLogger.finest("Processing " + attrList.getLength() + " attributes");
                for (int i = 0; i < attrList.getLength(); ++i) {
                    Attr currentAttribute = (Attr)attrList.item(i);
                    if (!DOMTreeUtility.isSCORMAppProfileNode(currentAttribute, iNode)) {
                        this.mLogger.finest("Extension attribute, removing: [" + currentAttribute.getNamespaceURI() + "] " + currentAttribute.getLocalName() + " from the its parent node [" + iNode.getNamespaceURI() + "] " + iNode.getLocalName());
                        attrList.removeNamedItemNS(currentAttribute.getNamespaceURI(), currentAttribute.getLocalName());
                        --i;
                        this.mExtensionsFound = true;
                        continue;
                    }
                    this.mLogger.finest("Valid SCORM attribute, keeping attribute: [" + currentAttribute.getNamespaceURI() + "] " + currentAttribute.getLocalName());
                }
                this.mLogger.finest("Done processing attributes for node: [" + iNode.getNamespaceURI() + "] " + iNode.getLocalName());
                this.mLogger.finest("************************************************");
                this.mLogger.finest("");
                this.mLogger.finest("************************************************");
                this.mLogger.finest("Processing direct-descendances for node: [" + iNode.getNamespaceURI() + "] " + iNode.getLocalName());
                NodeList children = iNode.getChildNodes();
                if (children != null) {
                    this.mLogger.finest("Processing " + children.getLength() + " elements");
                    for (int z = 0; z < children.getLength(); ++z) {
                        Node childNode = children.item(z);
                        if (childNode.getNodeType() == 1) {
                            this.mLogger.finest("Processing element: [" + childNode + "]");
                            this.mLogger.finest("Elements Namespace: [" + childNode.getNamespaceURI() + "]");
                            this.mLogger.finest("Elements Parent Node: [" + iNode.getLocalName() + "]");
                            this.mLogger.finest("Parent Nodes Namespace: [" + iNode.getNamespaceURI() + "]");
                            if (!DOMTreeUtility.isSCORMAppProfileNode(children.item(z), children.item(z).getParentNode())) {
                                this.checkForSchemaLocations(childNode, iXMLFileName);
                                this.mLogger.finest("Extension Element Found, removing from DOM Tree ");
                                children.item(z).getParentNode().removeChild(children.item(z));
                                --z;
                                this.mExtensionsFound = true;
                            } else {
                                this.mLogger.finest("ADL SCORM Element Found, leaving element in DOM Tree");
                                this.pruneTree(children.item(z), iXMLFileName);
                            }
                        }
                        if (childNode instanceof TextImpl) {
                            String value = new String(children.item(z).getNodeValue().trim());
                            if (((TextImpl)children.item(z)).isIgnorableWhitespace()) {
                                iNode.removeChild(children.item(z));
                                --z;
                                continue;
                            }
                            if (value.length() != 0) continue;
                            iNode.removeChild(children.item(z));
                            --z;
                            continue;
                        }
                        if (children.item(z).getNodeType() != 8) continue;
                        iNode.removeChild(children.item(z));
                        --z;
                    }
                }
                this.mLogger.finest("Done processing direct-descendants for node: [" + iNode.getNamespaceURI() + "] " + iNode.getLocalName());
                this.mLogger.finest("**************************************************");
                break;
            }
            case 5: {
                NodeList children = iNode.getChildNodes();
                if (children == null) break;
                int len = children.getLength();
                for (int i = 0; i < len; ++i) {
                    this.pruneTree(children.item(i), iXMLFileName);
                }
                break;
            }
            case 8: {
                break;
            }
            case 4: {
                break;
            }
            case 3: {
                break;
            }
        }
    }

    public void addSchemaLocationToList(String iSchemaLocation, String iXMLFileName) {
        this.mLogger.entering("ADLDOMParser", "addSchemaLocationToList()");
        this.mLogger.finest("Schema Location: " + iSchemaLocation);
        String fileName = this.searchFile(iXMLFileName, "xml");
        File tempXMLfile = new File(fileName);
        String xsdLocation = "file:///" + tempXMLfile.getParent() + "/";
        xsdLocation = xsdLocation.replaceAll(" ", "%20");
        xsdLocation = xsdLocation.replace('\\', '/');
        String schemaStr = "";
        StringTokenizer st = new StringTokenizer(iSchemaLocation, " ");
        while (st.hasMoreTokens()) {
            String namespace = st.nextToken();
            if (!this.isSchemaLocationPresent(namespace) || namespace.equals("http://ltsc.ieee.org/xsd/LOM")) {
                schemaStr = schemaStr + namespace + " ";
                if (!st.hasMoreTokens()) continue;
                String location = st.nextToken();
                if (location.substring(0, 5).equals("http:") || location.substring(0, 6).equals("https:") || location.substring(0, 4).equals("ftp:") || location.substring(0, 5).equals("ftps:")) {
                    schemaStr = schemaStr + location + " ";
                    continue;
                }
                schemaStr = schemaStr + xsdLocation + location + " ";
                continue;
            }
            st.nextToken();
        }
        this.mSchemaLocation = this.mSchemaLocation == null ? schemaStr : this.mSchemaLocation + schemaStr;
    }

    protected void printNodeInfo(String iNodeTypeString, Node iNode) {
        StringBuffer typeStr = new StringBuffer("(null)");
        StringBuffer nodeType = new StringBuffer("(null)");
        StringBuffer nodeName = new StringBuffer("(null)");
        StringBuffer nodeValue = new StringBuffer("(null)");
        String sp = new String(" -- ");
        if (iNode != null) {
            if (iNodeTypeString != null) {
                typeStr = new StringBuffer(iNodeTypeString);
            }
            nodeType = new StringBuffer(new Integer(iNode.getNodeType()).toString());
            if (iNode.getNodeName() != null) {
                nodeName = new StringBuffer(iNode.getNodeName());
            }
            if (iNode.getNodeValue() != null) {
                nodeValue = new StringBuffer(iNode.getNodeValue());
            }
        }
        while (typeStr.length() < 42) {
            typeStr.append(" ");
        }
        while (nodeName.length() < 15) {
            nodeName.append(" ");
        }
        while (nodeValue.length() < 10) {
            nodeValue.append(" ");
        }
        this.mLogger.finest(typeStr + sp + nodeType + sp + nodeName + sp + nodeValue);
    }

    private void setDocumentAttribute(Document ioWellformednessDoc, boolean iLogRelated, String iXMLFileName, boolean iControllingDocRelated) {
        this.mLogger.entering("ADLDOMParser", "setDocumentAttribute()");
        if (this.mIsXMLWellformed) {
            if (iLogRelated || iControllingDocRelated) {
                this.pruneTree(ioWellformednessDoc, iXMLFileName);
            }
            this.mDocument = ioWellformednessDoc;
        }
        this.mLogger.exiting("ADLDOMParser", "setDocumentAttribute()");
    }

    private void setValidXMLToSchemaAttribute() {
        this.mLogger.entering("ADLDOMParser", "setValidXMLSchemaAttribute()");
        this.mIsXMLValidToSchema = this.mValidFlag;
        this.mLogger.exiting("ADLDOMParser", "setValidXMLSchemaAttribute()");
    }

    private InputSource setUpInputSource(String iFileName) {
        this.mLogger.entering("ADLDOMParser", "setUpInputSource()");
        InputSource is = new InputSource();
        is = this.setupFileSource(iFileName);
        this.mLogger.exiting("ADLDOMParser", "setUpInputSource()");
        return is;
    }

    private InputSource setupFileSource(String iFileName) {
        this.mLogger.entering("ADLDOMParser", "setupFileSource()");
        boolean defaultEncoding = true;
        String encoding = null;
        try {
            File xmlFile = new File(iFileName);
            this.mLogger.info(xmlFile.getAbsolutePath());
            if (xmlFile.isFile()) {
                InputSource is = null;
                defaultEncoding = true;
                if (xmlFile.length() > 1L) {
                    int pushBack;
                    FileInputStream inFile = new FileInputStream(xmlFile);
                    PushbackInputStream inputStream = new PushbackInputStream(inFile, 4);
                    byte[] bom = new byte[4];
                    int n = inputStream.read(bom, 0, bom.length);
                    if (bom[0] == -17 && bom[1] == -69 && bom[2] == -65) {
                        encoding = "UTF-8";
                        defaultEncoding = false;
                        pushBack = n - 3;
                    } else if (bom[0] == -2 && bom[1] == -1) {
                        encoding = "UTF-16BE";
                        defaultEncoding = false;
                        pushBack = n - 2;
                    } else if (bom[0] == -1 && bom[1] == -2) {
                        encoding = "UTF-16LE";
                        defaultEncoding = false;
                        pushBack = n - 2;
                    } else {
                        pushBack = n;
                    }
                    if (pushBack > 0) {
                        inputStream.unread(bom, n - pushBack, pushBack);
                    }
                    if (defaultEncoding) {
                        FileReader fr = new FileReader(xmlFile);
                        is = new InputSource(fr);
                    } else {
                        BufferedReader inStream = new BufferedReader(new InputStreamReader((InputStream)inputStream, encoding));
                        StringBuffer dataString = new StringBuffer();
                        String s = "";
                        while ((s = inStream.readLine()) != null) {
                            dataString.append(s);
                        }
                        inStream.close();
                        inputStream.close();
                        inFile.close();
                        is = new InputSource(new StringReader(dataString.toString()));
                        is.setEncoding(encoding);
                    }
                }
                return is;
            }
            if (iFileName.length() > 6 && (iFileName.substring(0, 5).equals("http:") || iFileName.substring(0, 6).equals("https:"))) {
                URL xmlURL = new URL(iFileName);
                InputStream xmlIS = xmlURL.openStream();
                InputSource is = new InputSource(xmlIS);
                return is;
            }
            String msgText = "XML File: " + iFileName + " is not a file or URL";
            this.mLogger.severe(msgText);
        }
        catch (NullPointerException npe) {
            String msgText = "Null pointer exception" + npe;
            this.mLogger.severe(msgText);
        }
        catch (SecurityException se) {
            String msgText = "Security Exception" + se;
            this.mLogger.severe(msgText);
        }
        catch (FileNotFoundException fnfe) {
            String msgText = "File Not Found Exception" + fnfe;
            this.mLogger.severe(msgText);
        }
        catch (Exception e) {
            String msgText = "General Exception" + e;
            this.mLogger.severe(msgText);
        }
        this.mLogger.exiting("ADLDOMParser", "setUpFileSource()");
        return new InputSource();
    }

    private String searchFile(String iFileName, String iFileType) {
        this.mLogger.entering("ADLDOMParser", "searchFile()");
        this.mLogger.finest("   iFileName coming in is: " + iFileName);
        this.mLogger.finest("   iFileType coming in is: " + iFileType);
        boolean fileFound = false;
        String outFileName = new String("");
        try {
            if (iFileName.length() > 6 && (iFileName.substring(0, 5).equals("http:") || iFileName.substring(0, 6).equals("https:"))) {
                outFileName = iFileName;
            } else {
                File inFile = new File(iFileName);
                if (inFile.isFile()) {
                    fileFound = true;
                    outFileName = inFile.getAbsolutePath();
                } else {
                    String msgText = "File Not A Normal File";
                    this.mLogger.severe(msgText);
                }
            }
        }
        catch (NullPointerException npe) {
            String msgText = "File is Empty";
            this.mLogger.severe(msgText);
        }
        catch (SecurityException se) {
            String msgText = "File Not Accessible";
            this.mLogger.severe(msgText);
        }
        this.mLogger.exiting("ADLDOMParser", "searchFile()");
        return outFileName;
    }

    private void checkForSchemaLocations(Node iNode, String iXMLFileName) {
        this.mLogger.entering("ADLDOMParser", "checkForSchemaLocations()");
        this.mLogger.finest("Processing Node: [" + iNode.getLocalName() + "]");
        this.mLogger.finest("Processing Nodes Namespace: [" + iNode.getNamespaceURI() + "]");
        NamedNodeMap attrList = iNode.getAttributes();
        this.mLogger.finest("Processing " + attrList.getLength() + " attributes");
        for (int i = 0; i < attrList.getLength(); ++i) {
            Attr currentAttribute = (Attr)attrList.item(i);
            String parentNamespace = iNode.getNamespaceURI();
            String attributeNamespace = currentAttribute.getNamespaceURI();
            this.mLogger.finest("Processing attribute [" + i + "]: [" + currentAttribute.getLocalName() + "]");
            this.mLogger.finest("Attributes Namespace [" + i + "]: [" + attributeNamespace + "]");
            if (!this.mDeclaredNamespaces.contains(attributeNamespace) && attributeNamespace != null) {
                this.mDeclaredNamespaces.add(attributeNamespace);
            }
            this.mLogger.finest("Attributes Parent Node [" + i + "]: [" + iNode.getLocalName() + "]");
            this.mLogger.finest("Parent Nodes Namespace [" + i + "]: [" + parentNamespace + "]");
            if (!this.mDeclaredNamespaces.contains(attributeNamespace) && parentNamespace != null) {
                this.mDeclaredNamespaces.add(parentNamespace);
            }
            if (!currentAttribute.getLocalName().equals("schemaLocation") || !currentAttribute.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema-instance")) continue;
            if (this.mFirstTimeSchemaLocationFound) {
                this.mSchemaLocation = null;
                this.mFirstTimeSchemaLocationFound = false;
                this.mSchemaLocExists = true;
            }
            this.addSchemaLocationToList(currentAttribute.getValue(), iXMLFileName);
        }
        this.mLogger.exiting("ADLDOMParser", "checkForSchemaLocations()");
    }

    private boolean isSchemaLocationPresent(String iNamespace) {
        boolean result = false;
        if (this.mSchemaLocation != null) {
            StringTokenizer st = new StringTokenizer(this.mSchemaLocation, " ");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (!token.equals(iNamespace)) continue;
                result = true;
                break;
            }
        }
        return result;
    }
}

