/*
 * Decompiled with CFR 0.152.
 */
package org.adl.samplerte.client;

import java.applet.Applet;
import java.awt.Color;
import java.net.URL;
import netscape.javascript.JSObject;
import org.adl.api.ecmascript.APIErrorManager;
import org.adl.api.ecmascript.SCORM13APIInterface;
import org.adl.datamodels.DMInterface;
import org.adl.datamodels.DMProcessingInfo;
import org.adl.datamodels.SCODataManager;
import org.adl.datamodels.nav.SCORM_2004_NAV_DM;
import org.adl.samplerte.client.ServletProxy;
import org.adl.samplerte.server.LMSCMIServletRequest;
import org.adl.samplerte.server.LMSCMIServletResponse;
import org.adl.util.MessageCollection;
import org.adl.util.debug.DebugIndicator;

public class ClientRTS
extends Applet
implements SCORM13APIInterface {
    public static final String version = "1.0";
    private static final String COMPLETION_STATUS = "cmi.completion_status";
    private static final String SUCCESS_STATUS = "cmi.success_status";
    private static final String COMPLETION_THRESHOLD = "cmi.completion_threshold";
    private static final String PROGRESS_MEASURE = "cmi.progress_measure";
    private static final String SCALED_PASSING_SCORE = "cmi.scaled_passing_score";
    private static final String SCORE_SCALED = "cmi.score.scaled";
    private static final String STRING_FALSE = "false";
    private static final String STRING_TRUE = "true";
    private static final int NO_ERROR = 0;
    private static boolean _Debug = DebugIndicator.ON;
    private static boolean mInitializedState = false;
    public boolean logging_on = false;
    private APIErrorManager mLMSErrorManager = null;
    private SCODataManager mSCOData = null;
    private boolean mTerminatedState = false;
    private boolean mTerminateCalled = false;
    private URL mServletURL = null;
    private String mActivityID = null;
    private String mStateID = null;
    private String mUserID = null;
    private String mUserName = null;
    private String mCourseID = null;
    private long mNumAttempts = 0L;
    private boolean mScoVer2 = false;
    private boolean mLMSSuspendAllPushed = false;
    private boolean mQuitButtonPushed = false;
    private boolean mPreviousButtonPushed = false;
    private boolean mNextButtonPushed = false;
    private boolean mTOCPushed = false;
    private String mUserNavRequest = "_none_";

    @Override
    public void init() {
        this.setBackground(new Color(54, 60, 84));
        if (_Debug) {
            System.out.println("In API::init()(the applet Init method)");
        }
        this.mTerminatedState = false;
        mInitializedState = false;
        this.mTerminateCalled = false;
        this.mTOCPushed = false;
        this.mLMSErrorManager = new APIErrorManager(2);
        this.mScoVer2 = false;
        URL codebase = this.getCodeBase();
        String host = codebase.getHost();
        String protocol = codebase.getProtocol();
        int port = codebase.getPort();
        if (_Debug) {
            System.out.println("ClientRTS -> codebase url is " + codebase.getPath().toString());
        }
        try {
            this.mServletURL = new URL(protocol + "://" + host + ":" + port + "/adl/lmscmi");
            if (_Debug) {
                System.out.println("servlet url is " + this.mServletURL.toString());
            }
        }
        catch (Exception e) {
            if (_Debug) {
                System.out.println("ERROR in INIT");
            }
            e.printStackTrace();
            this.stop();
        }
    }

    @Override
    public String getAppletInfo() {
        return "Title: Sample RTE Client Component \nAuthor: ADL TT\nThis Applet contains an example implementation of the SCORM 2004 4th Edition API.";
    }

    @Override
    public String[][] getParameterInfo() {
        String[][] info = new String[][]{{"None", "", "This applet requires no parameters."}};
        return info;
    }

    private boolean isInitialized() {
        if (!mInitializedState && this.mScoVer2) {
            this.mLMSErrorManager.setCurrentErrorCode(301);
        }
        return mInitializedState;
    }

    @Override
    public String Initialize(String iParam) {
        if (_Debug) {
            System.out.println("*********************");
            System.out.println("In API::Initialize");
            System.out.println("*********************");
            System.out.println("");
        }
        String paramVal = new String();
        String evalVal = new String();
        if (this.logging_on) {
            paramVal = "Called Initialize ";
            evalVal = "display_log(\"" + paramVal + "\");";
            this.jsCall(evalVal);
        }
        String result = STRING_FALSE;
        if (this.mTerminatedState) {
            if (_Debug) {
                System.out.println("mTerminatedState = " + this.mTerminatedState);
            }
            this.mLMSErrorManager.setCurrentErrorCode(104);
            if (this.logging_on) {
                paramVal = "Initialize Returned Error Code 104";
                evalVal = "display_log(\"" + paramVal + "\");";
                this.jsCall(evalVal);
            }
            return result;
        }
        this.mTerminatedState = false;
        this.mTerminateCalled = false;
        this.mScoVer2 = false;
        String tempParm = String.valueOf(iParam);
        if (!(tempParm == null || tempParm.equals(""))) {
            this.mLMSErrorManager.setCurrentErrorCode(201);
        } else if (mInitializedState) {
            this.mLMSErrorManager.setCurrentErrorCode(103);
        } else {
            this.mLMSSuspendAllPushed = false;
            this.mQuitButtonPushed = false;
            this.mPreviousButtonPushed = false;
            this.mNextButtonPushed = false;
            this.mTOCPushed = false;
            this.mUserNavRequest = "_none_";
            LMSCMIServletRequest request = new LMSCMIServletRequest();
            request.mActivityID = this.mActivityID;
            request.mStateID = this.mStateID;
            request.mStudentID = this.mUserID;
            request.mUserName = this.mUserName;
            request.mCourseID = this.mCourseID;
            request.mRequestType = 1;
            Long longObj = new Long(this.mNumAttempts);
            request.mNumAttempt = longObj.toString();
            if (_Debug) {
                System.out.println("Trying to get SCO Data from servlet...");
                System.out.println("LMSCMIServlet Request contains: ");
                System.out.println("Activity ID: " + request.mActivityID);
                System.out.println("State ID: " + request.mStateID);
                System.out.println("User ID: " + request.mStudentID);
                System.out.println("Course ID: " + request.mCourseID);
            }
            ServletProxy proxy = new ServletProxy(this.mServletURL);
            LMSCMIServletResponse response = proxy.postLMSRequest(request);
            this.mSCOData = response.mActivityData;
            SCORM_2004_NAV_DM navDM = (SCORM_2004_NAV_DM)this.mSCOData.getDataModel("adl");
            navDM.setValidRequests(response.mValidRequests);
            mInitializedState = true;
            this.mLMSErrorManager.clearCurrentErrorCode();
            result = STRING_TRUE;
        }
        if (this.logging_on) {
            if (_Debug) {
                System.out.println("logging_on = " + this.logging_on);
            }
            paramVal = "Initialize Returned Error Code " + this.mLMSErrorManager.getCurrentErrorCode();
            evalVal = "display_log(\"" + paramVal + "\");";
            this.jsCall(evalVal);
        }
        if (_Debug) {
            System.out.println("");
            System.out.println("*******************************");
            System.out.println("Done Processing Initialize()");
            System.out.println("*******************************");
        }
        if (_Debug) {
            System.out.println("result to return is: " + result);
        }
        return result;
    }

    @Override
    public String Terminate(String iParam) {
        if (_Debug) {
            System.out.println("*****************");
            System.out.println("In API::Terminate");
            System.out.println("*****************");
            System.out.println("");
        }
        String paramVal = new String();
        String evalVal = new String();
        if (this.logging_on) {
            paramVal = "Called Terminate ";
            evalVal = "display_log(\"" + paramVal + "\");";
            this.jsCall(evalVal);
        }
        this.mTerminateCalled = true;
        String result = STRING_FALSE;
        if (this.mTerminatedState) {
            this.mLMSErrorManager.setCurrentErrorCode(113);
            if (this.logging_on) {
                paramVal = "Terminate Returned Error Code 113";
                evalVal = "display_log(\"" + paramVal + "\");";
                this.jsCall(evalVal);
            }
            return result;
        }
        if (!this.isInitialized()) {
            this.mLMSErrorManager.setCurrentErrorCode(112);
            if (this.logging_on) {
                paramVal = "Terminate Returned Error Code 112";
                evalVal = "display_log(\"" + paramVal + "\");";
                this.jsCall(evalVal);
            }
            return result;
        }
        String tempParm = String.valueOf(iParam);
        if (!(tempParm == null || tempParm.equals(""))) {
            this.mLMSErrorManager.setCurrentErrorCode(201);
        } else {
            DMProcessingInfo pi;
            int check;
            SCORM_2004_NAV_DM navDM;
            String event;
            if (this.mLMSSuspendAllPushed || this.mNextButtonPushed || this.mPreviousButtonPushed || this.mQuitButtonPushed || this.mTOCPushed) {
                int err = DMInterface.processSetValue("adl.nav.request", this.mUserNavRequest, true, this.mSCOData);
            }
            if (!(!(event = (navDM = (SCORM_2004_NAV_DM)this.mSCOData.getDataModel("adl")).getNavRequest()).equals("7") && !this.mLMSSuspendAllPushed || (check = DMInterface.processGetValue("cmi.exit", true, this.mSCOData, pi = new DMProcessingInfo())) == 0 && pi.mValue.equals("log-out"))) {
                DMInterface.processSetValue("cmi.exit", "suspend", true, this.mSCOData);
            }
            result = !event.equals("5") && !event.equals("6") ? this.Commit("") : STRING_TRUE;
            this.mTerminatedState = true;
            if (!result.equals(STRING_TRUE)) {
                if (_Debug) {
                    System.out.println("Commit failed causing Terminate to fail.");
                }
                this.mLMSErrorManager.setCurrentErrorCode(391);
            } else {
                mInitializedState = false;
                DMProcessingInfo dmInfo = new DMProcessingInfo();
                int dmErrorCode = 0;
                dmErrorCode = DMInterface.processGetValue("cmi.exit", true, true, this.mSCOData, dmInfo);
                String exitValue = dmInfo.mValue;
                String tempEvent = "_none_";
                boolean isChoice = false;
                boolean isJump = false;
                String evalValue = null;
                exitValue = dmErrorCode == 0 ? dmInfo.mValue : new String("");
                if (exitValue.equals("time-out")) {
                    tempEvent = "exitAll";
                } else if (exitValue.equals("logout")) {
                    tempEvent = "exitAll";
                } else if (event != null) {
                    if (event.equals("3")) {
                        tempEvent = "next";
                    } else if (event.equals("4")) {
                        tempEvent = "previous";
                    } else if (event.equals("5")) {
                        tempEvent = "abandon";
                    } else if (event.equals("6")) {
                        tempEvent = "abandonAll";
                    } else if (event.equals("8")) {
                        tempEvent = "exit";
                    } else if (event.equals("9")) {
                        tempEvent = "exitAll";
                    } else if (event.equals("7")) {
                        tempEvent = "suspendAll";
                    } else if (event.equals("0")) {
                        tempEvent = "_none_";
                    } else if (event.equals("10")) {
                        tempEvent = ((SCORM_2004_NAV_DM)this.mSCOData.getDataModel("adl")).getJumpLocation();
                        isJump = true;
                    } else {
                        tempEvent = event;
                        isChoice = true;
                    }
                }
                if (!(this.mLMSSuspendAllPushed || this.mPreviousButtonPushed || this.mNextButtonPushed || this.mTOCPushed || tempEvent.equals("_none_"))) {
                    if (_Debug) {
                        System.out.println("in finish - navRequest was set");
                        System.out.println("request " + tempEvent);
                    }
                    if (isChoice) {
                        evalValue = "doChoiceEvent(\"" + tempEvent + "\");";
                        if (_Debug) {
                            System.out.println("choice nav event  " + evalValue);
                        }
                    } else if (isJump) {
                        evalValue = "doJumpEvent (\"" + tempEvent + "\");";
                        if (_Debug) {
                            System.out.println("jump nav event  " + evalValue);
                        }
                    } else {
                        evalValue = "doNavEvent(\"" + tempEvent + "\");";
                    }
                    this.jsCall(evalValue);
                }
            }
        }
        if (this.logging_on) {
            paramVal = "Terminate Returned Error Code " + this.mLMSErrorManager.getCurrentErrorCode();
            evalVal = "display_log(\"" + paramVal + "\");";
            this.jsCall(evalVal);
        }
        if (_Debug) {
            System.out.println("");
            System.out.println("***************************");
            System.out.println("Done Processing Terminate()");
            System.out.println("***************************");
        }
        return result;
    }

    public String formatValue(String baseString) {
        int indexQuote = baseString.indexOf("\"");
        int indexSlash = baseString.indexOf("\\");
        baseString = baseString.replaceAll("\r\n", " ");
        baseString = baseString.replaceAll("\n", " ");
        baseString = baseString.replaceAll("\r", " ");
        baseString = baseString.replaceAll("\\r\\n", " ");
        baseString = baseString.replaceAll("\\n", " ");
        baseString = baseString.replaceAll("\\r", " ");
        if (indexQuote >= 0 || indexSlash >= 0) {
            int index = 0;
            String strFirst = new String();
            String strLast = new String();
            char insertValue = '\\';
            while (index < baseString.length()) {
                if (baseString.charAt(index) == '\"' || baseString.charAt(index) == '\\') {
                    strFirst = baseString.substring(0, index);
                    strLast = baseString.substring(index, baseString.length());
                    baseString = strFirst.concat(Character.toString(insertValue)).concat(strLast);
                    index += 2;
                    continue;
                }
                ++index;
            }
        }
        return baseString;
    }

    @Override
    public String GetValue(String iDataModelElement) {
        if (_Debug) {
            System.out.println("*******************");
            System.out.println("In API::GetValue");
            System.out.println("*******************");
            System.out.println("");
        }
        String paramVal = new String();
        String evalVal = new String();
        if (this.logging_on) {
            paramVal = "Called GetValue( " + iDataModelElement + ")";
            evalVal = "display_log(\"" + paramVal + "\");";
            this.jsCall(evalVal);
        }
        String result = "";
        if (this.mTerminatedState) {
            this.mLMSErrorManager.setCurrentErrorCode(123);
            if (this.logging_on) {
                paramVal = "GetValue Returned Error Code 123";
                evalVal = "display_log(\"" + paramVal + "\");";
                this.jsCall(evalVal);
            }
            return result;
        }
        if (iDataModelElement.length() == 0) {
            this.mLMSErrorManager.setCurrentErrorCode(301);
            if (this.logging_on) {
                paramVal = "GetValue Returned Error Code 301";
                evalVal = "display_log(\"" + paramVal + "\");";
                this.jsCall(evalVal);
            }
            return result;
        }
        if (this.isInitialized()) {
            if (_Debug) {
                System.out.println("Request being processed: GetValue(" + iDataModelElement + ")");
            }
            DMProcessingInfo dmInfo = new DMProcessingInfo();
            int dmErrorCode = 0;
            boolean done = false;
            this.mLMSErrorManager.clearCurrentErrorCode();
            if (iDataModelElement.equals(COMPLETION_STATUS)) {
                double completionThreshold = 0.0;
                double progressMeasure = 0.0;
                dmErrorCode = DMInterface.processGetValue(COMPLETION_THRESHOLD, false, this.mSCOData, dmInfo);
                if (dmErrorCode != 403) {
                    done = true;
                    completionThreshold = Double.parseDouble(dmInfo.mValue);
                    dmErrorCode = DMInterface.processGetValue(PROGRESS_MEASURE, false, this.mSCOData, dmInfo);
                    result = dmErrorCode != 403 ? ((progressMeasure = Double.parseDouble(dmInfo.mValue)) >= completionThreshold ? "completed" : "incomplete") : "unknown";
                    dmErrorCode = 0;
                }
            }
            if (iDataModelElement.equals(SUCCESS_STATUS)) {
                double scaledPassingScore = 0.0;
                double scoreScaled = 0.0;
                dmErrorCode = DMInterface.processGetValue(SCALED_PASSING_SCORE, false, this.mSCOData, dmInfo);
                if (dmErrorCode != 403) {
                    done = true;
                    scaledPassingScore = Double.parseDouble(dmInfo.mValue);
                    dmErrorCode = DMInterface.processGetValue(SCORE_SCALED, false, this.mSCOData, dmInfo);
                    result = dmErrorCode != 403 ? ((scoreScaled = Double.parseDouble(dmInfo.mValue)) >= scaledPassingScore ? "passed" : "failed") : "unknown";
                    dmErrorCode = 0;
                }
            }
            if (!done && (dmErrorCode = DMInterface.processGetValue(iDataModelElement, false, this.mSCOData, dmInfo)) == 0) {
                result = dmInfo.mValue;
            }
            this.mLMSErrorManager.setCurrentErrorCode(dmErrorCode);
            if (dmErrorCode == 0) {
                if (_Debug) {
                    System.out.println("GetValue() found!");
                    System.out.println("Returning: " + dmInfo.mValue);
                }
            } else {
                if (_Debug) {
                    System.out.println("Found the element, but the value was null");
                }
                result = new String("");
            }
            if (this.logging_on) {
                paramVal = "GetValue Returned the value " + this.formatValue(result);
                evalVal = "display_log(\"" + paramVal + "\");";
                this.jsCall(evalVal);
            }
        } else {
            this.mLMSErrorManager.setCurrentErrorCode(122);
        }
        if (_Debug) {
            System.out.println("");
            System.out.println("************************************");
            System.out.println("Processing done for API::LMSGetValue");
            System.out.println("************************************");
        }
        if (this.logging_on) {
            paramVal = "GetValue Returned Error Code " + this.mLMSErrorManager.getCurrentErrorCode();
            evalVal = "display_log(\"" + paramVal + "\");";
            this.jsCall(evalVal);
        }
        return result;
    }

    @Override
    public String SetValue(String iDataModelElement, String iValue) {
        String setValue;
        String result = STRING_FALSE;
        if (_Debug) {
            System.out.println("*******************");
            System.out.println("In API::SetValue");
            System.out.println("*******************");
            System.out.println("");
        }
        String paramVal = new String();
        String evalVal = new String();
        if (this.logging_on) {
            paramVal = "Called SetValue(" + iDataModelElement + ", " + this.formatValue(iValue) + ")";
            evalVal = "display_log(\"" + paramVal + "\");";
            this.jsCall(evalVal);
        }
        if (this.mTerminatedState) {
            this.mLMSErrorManager.setCurrentErrorCode(133);
            if (this.logging_on) {
                paramVal = "SetValue Returned Error Code 133";
                evalVal = "display_log(\"" + paramVal + "\");";
                this.jsCall(evalVal);
            }
            return result;
        }
        this.mLMSErrorManager.clearCurrentErrorCode();
        if (!this.isInitialized()) {
            this.mLMSErrorManager.setCurrentErrorCode(132);
            if (this.logging_on) {
                paramVal = "SetValue Returned Error Code 132";
                evalVal = "display_log(\"" + paramVal + "\");";
                this.jsCall(evalVal);
            }
            return result;
        }
        String string = setValue = iValue == null ? "" : String.valueOf(iValue);
        if (_Debug) {
            System.out.println("Request being processed: SetValue(" + iDataModelElement + "," + setValue + ")");
            System.out.println("Looking for the element " + iValue);
        }
        int dmErrorCode = DMInterface.processSetValue(iDataModelElement, setValue, false, this.mSCOData, true);
        this.mLMSErrorManager.setCurrentErrorCode(dmErrorCode);
        result = Boolean.toString(dmErrorCode == 0);
        MessageCollection.getInstance().clear();
        if (this.logging_on) {
            paramVal = "SetValue Returned Error Code " + this.mLMSErrorManager.getCurrentErrorCode();
            evalVal = "display_log(\"" + paramVal + "\");";
            this.jsCall(evalVal);
        }
        if (_Debug) {
            System.out.println("");
            System.out.println("************************************");
            System.out.println("Processing done for API::SetValue");
            System.out.println("************************************");
        }
        return result;
    }

    private void setUIState(boolean iState) {
        if (_Debug) {
            System.out.println(" ::Toggling UI State::-> " + iState);
        }
        String evalCmd = "setUIState(" + iState + ");";
        this.jsCall(evalCmd);
    }

    @Override
    public String Commit(String iParam) {
        if (_Debug) {
            System.out.println("*************************");
            System.out.println("Processing API::Commit");
            System.out.println("*************************");
            System.out.println("");
        }
        String paramVal = new String();
        String evalVal = new String();
        if (this.logging_on) {
            paramVal = "Called Commit";
            evalVal = "display_log(\"" + paramVal + "\");";
            this.jsCall(evalVal);
        }
        String result = STRING_FALSE;
        if (this.mTerminatedState) {
            this.mLMSErrorManager.setCurrentErrorCode(143);
            if (this.logging_on) {
                paramVal = "Commit Returned Error Code 143";
                evalVal = "display_log(\"" + paramVal + "\");";
                this.jsCall(evalVal);
            }
            return result;
        }
        this.setUIState(false);
        String tempParm = String.valueOf(iParam);
        if (!(tempParm == null || tempParm.equals(""))) {
            this.mLMSErrorManager.setCurrentErrorCode(201);
        } else {
            if (!this.isInitialized()) {
                this.mLMSErrorManager.setCurrentErrorCode(142);
                if (this.logging_on) {
                    paramVal = "Commit Returned Error Code 142";
                    evalVal = "display_log(\"" + paramVal + "\");";
                    this.jsCall(evalVal);
                }
                return result;
            }
            if (this.mTerminatedState) {
                this.mLMSErrorManager.setCurrentErrorCode(143);
                if (this.logging_on) {
                    paramVal = "Commit Returned Error Code 143";
                    evalVal = "display_log(\"" + paramVal + "\");";
                    this.jsCall(evalVal);
                }
                return result;
            }
            LMSCMIServletRequest request = new LMSCMIServletRequest();
            request.mActivityData = this.mSCOData;
            request.mIsFinished = this.mTerminateCalled;
            request.mRequestType = 4;
            request.mCourseID = this.mCourseID;
            request.mStudentID = this.mUserID;
            request.mUserName = this.mUserName;
            request.mStateID = this.mStateID;
            request.mActivityID = this.mActivityID;
            Long longObj = new Long(this.mNumAttempts);
            request.mNumAttempt = longObj.toString();
            request.mQuitPushed = this.mQuitButtonPushed;
            request.mSuspendPushed = this.mLMSSuspendAllPushed;
            ServletProxy proxy = new ServletProxy(this.mServletURL);
            LMSCMIServletResponse response = proxy.postLMSRequest(request);
            if (!response.mError.equals("OK")) {
                this.mLMSErrorManager.setCurrentErrorCode(101);
                if (_Debug) {
                    System.out.println("'SET' to server was NOT successful!");
                }
            } else {
                this.mLMSErrorManager.clearCurrentErrorCode();
                result = STRING_TRUE;
                SCORM_2004_NAV_DM navDM = (SCORM_2004_NAV_DM)this.mSCOData.getDataModel("adl");
                navDM.setValidRequests(response.mValidRequests);
                if (_Debug) {
                    System.out.println("'SET' to server succeeded!");
                }
            }
        }
        this.setUIState(true);
        this.jsCall("refreshMenu()");
        if (this.logging_on) {
            paramVal = " Commit Returned Error Code " + this.mLMSErrorManager.getCurrentErrorCode();
            evalVal = "display_log(\"" + paramVal + "\");";
            this.jsCall(evalVal);
        }
        if (_Debug) {
            System.out.println("");
            System.out.println("**********************************");
            System.out.println("Processing done for API::Commit");
            System.out.println("**********************************");
        }
        return result;
    }

    @Override
    public String GetLastError() {
        if (_Debug) {
            System.out.println("In API::GetLastError()");
        }
        String paramVal = "Called GetLastError() ";
        String evalVal = "display_log(\"" + paramVal + "\");";
        if (this.logging_on) {
            this.jsCall(evalVal);
        }
        paramVal = "GetLastError() Returned  " + this.mLMSErrorManager.getCurrentErrorCode();
        evalVal = "display_log(\"" + paramVal + "\");";
        if (this.logging_on) {
            this.jsCall(evalVal);
        }
        return this.mLMSErrorManager.getCurrentErrorCode();
    }

    @Override
    public String GetErrorString(String iErrorCode) {
        if (_Debug) {
            System.out.println("In API::GetErrorString()");
        }
        String paramVal = "Called GetErrorString(" + iErrorCode + ") ";
        String evalVal = "display_log(\"" + paramVal + "\");";
        if (this.logging_on) {
            this.jsCall(evalVal);
        }
        String errorCode = this.mLMSErrorManager.getErrorDescription(iErrorCode);
        paramVal = "GetErrorString Returned " + errorCode;
        evalVal = "display_log(\"" + paramVal + "\");";
        if (this.logging_on) {
            this.jsCall(evalVal);
        }
        return errorCode;
    }

    @Override
    public String GetDiagnostic(String iErrorCode) {
        if (_Debug) {
            System.out.println("In API::GetDiagnostic()");
        }
        String paramVal = "Called GetDiagnostic(" + iErrorCode + ") ";
        String evalVal = "display_log(\"" + paramVal + "\");";
        if (this.logging_on) {
            this.jsCall(evalVal);
        }
        String diagnostic = this.mLMSErrorManager.getErrorDiagnostic(iErrorCode);
        paramVal = "GetDiagnostic Returned " + diagnostic;
        evalVal = "display_log(\"" + paramVal + "\");";
        if (this.logging_on) {
            this.jsCall(evalVal);
        }
        return diagnostic;
    }

    public void setActivityID(String iActivityID) {
        this.mActivityID = iActivityID;
    }

    public void setCourseID(String iCourseID) {
        this.mCourseID = iCourseID;
    }

    public void setStateID(String iStateID) {
        this.mStateID = iStateID;
    }

    public void setUserID(String iUserID) {
        this.mUserID = iUserID;
    }

    public void setUserName(String iUserName) {
        this.mUserName = iUserName;
    }

    public void setNumAttempts(long iNumAttempts) {
        this.mNumAttempts = iNumAttempts;
    }

    public void setNumAttempts(String iNumAttempts) {
        Long tempLong = new Long(iNumAttempts);
        this.mNumAttempts = tempLong;
    }

    public void clearState() {
        mInitializedState = false;
        this.mTerminatedState = false;
        this.mTerminateCalled = false;
        this.mLMSErrorManager.clearCurrentErrorCode();
    }

    public void jsCall(String message) {
        JSObject.getWindow(this).eval(message);
    }

    public void suspendButtonPushed() {
        if (this.isInitialized()) {
            this.mLMSSuspendAllPushed = true;
            this.mUserNavRequest = "suspendAll";
            this.Commit("");
        }
    }

    public void quitButtonPushed() {
        if (this.isInitialized()) {
            this.mQuitButtonPushed = true;
            this.mUserNavRequest = "_none_";
            this.Commit("");
            boolean dmErrorCode = false;
            int n = DMInterface.processSetValue("adl.nav.request", "_none_", true, this.mSCOData);
        }
    }

    public void previousButtonPushed() {
        if (this.isInitialized()) {
            this.mPreviousButtonPushed = true;
            this.mUserNavRequest = "previous";
            boolean dmErrorCode = false;
            int n = DMInterface.processSetValue("adl.nav.request", "_none_", true, this.mSCOData);
        }
    }

    public void nextButtonPushed() {
        if (this.isInitialized()) {
            this.mNextButtonPushed = true;
            this.mUserNavRequest = "continue";
            boolean dmErrorCode = false;
            int n = DMInterface.processSetValue("adl.nav.request", "_none_", true, this.mSCOData);
        }
    }

    public void TOCPushed(String iScoID) {
        if (this.isInitialized()) {
            this.mTOCPushed = true;
            boolean dmErrorCode = false;
            this.mUserNavRequest = "{target=" + iScoID + "}choice";
            int n = DMInterface.processSetValue("adl.nav.request", "_none_", true, this.mSCOData);
        }
    }

    public void resetLoggingVariable() {
        this.logging_on = !this.logging_on;
    }
}

