/*
 * Decompiled with CFR 0.152.
 */
package org.adl.samplerte.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import org.adl.samplerte.server.CourseData;
import org.adl.samplerte.server.LMSManifestHandler;
import org.adl.samplerte.server.ObjectivesData;
import org.adl.samplerte.server.SCOData;
import org.adl.samplerte.util.LMSDBHandler;
import org.adl.samplerte.util.LMSDatabaseHandler;
import org.adl.samplerte.util.RTEFileHandler;
import org.adl.sequencer.ADLSeqUtilities;
import org.adl.sequencer.SeqActivityTree;
import org.adl.util.decode.decodeHandler;
import org.adl.validator.util.ResultCollection;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUpload;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;

public class CourseService {
    private static final String SRTEFILESDIR = "SCORM4EDSampleRTE111Files";
    String mUserID = "";
    boolean mOnlineValidation = true;
    String mCourseFileName = "";

    CourseService() {
    }

    public Vector getCourses(String iSortType, String iSortOrder) {
        String tempUserID = "";
        Vector tempVector = this.getCourses(tempUserID, iSortType, iSortOrder);
        return tempVector;
    }

    public Vector getManagedCourses(String iUserID, String iRegSortType, String iRegSortOrder, String iUnregSortType, String iUnregSortOrder) {
        Vector<CourseData> courseList = new Vector<CourseData>();
        Vector courses = this.getCourses(iUserID, iRegSortType, iRegSortOrder);
        for (CourseData cd : courses) {
            CourseData statusCd = new CourseData();
            cd.mRegistered = true;
            courseList.add(cd);
        }
        Vector unregCourses = this.getUnregisteredCourses(iUserID, iUnregSortType, iUnregSortOrder);
        for (CourseData cd : unregCourses) {
            cd.mRegistered = false;
            courseList.add(cd);
        }
        return courseList;
    }

    public Vector getUnregisteredCourses(String iUserID, String iSortType, String iSortOrder) {
        Vector<CourseData> courses = new Vector<CourseData>();
        Vector allCourses = this.getCourses(iSortType, iSortOrder);
        List regCourses = this.getRegCourses(iUserID);
        for (CourseData cd : allCourses) {
            if (regCourses.contains(cd.mCourseID)) continue;
            courses.add(cd);
        }
        return courses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getCourses(String iUserID, String iSortType, String iSortOrder) {
        Connection conn = LMSDatabaseHandler.getConnection();
        String sortType = iSortType.equals("timestamp") ? "ImportDateTime" : "CourseTitle";
        String sqlGetCourses = "";
        this.mUserID = iUserID;
        sqlGetCourses = this.mUserID.equals("") ? "SELECT * FROM CourseInfo WHERE Active = yes ORDER BY " + sortType + " " + iSortOrder : "SELECT CourseInfo.CourseID, CourseInfo.CourseTitle, CourseInfo.ImportDateTime, CourseInfo.Start, CourseInfo.TOC, UserCourseInfo.SuspendAll  FROM CourseInfo, UserCourseInfo WHERE UserCourseInfo.UserID = ? AND CourseInfo.CourseID = UserCourseInfo.CourseID AND CourseInfo.Active = yes ORDER BY CourseInfo." + sortType + " " + iSortOrder;
        Vector<CourseData> courses = new Vector<CourseData>();
        try {
            PreparedStatement stmtGetCourses = conn.prepareStatement(sqlGetCourses);
            ResultSet rsCourses = null;
            PreparedStatement preparedStatement = stmtGetCourses;
            synchronized (preparedStatement) {
                if (!this.mUserID.equals("")) {
                    stmtGetCourses.setString(1, this.mUserID);
                }
                rsCourses = stmtGetCourses.executeQuery();
            }
            while (rsCourses.next()) {
                CourseData cd = new CourseData();
                cd.mCourseID = rsCourses.getString("CourseID");
                cd.mCourseTitle = rsCourses.getString("CourseTitle");
                cd.mImportDateTime = rsCourses.getString("ImportDateTime");
                cd.mStart = rsCourses.getBoolean("Start");
                cd.mTOC = rsCourses.getBoolean("TOC");
                if (!this.mUserID.equals("")) {
                    cd.mSuspend = rsCourses.getBoolean("SuspendAll");
                }
                courses.add(cd);
            }
            rsCourses.close();
            stmtGetCourses.close();
            conn.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return courses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getSCOs(String iCourseID) {
        Connection conn = LMSDatabaseHandler.getConnection();
        String sqlGetSCOs = "SELECT * FROM ItemInfo WHERE CourseID = ? AND Type = 'sco'";
        Vector<SCOData> scos = new Vector<SCOData>();
        try {
            PreparedStatement stmtGetSCOs = conn.prepareStatement(sqlGetSCOs);
            ResultSet rsSCOs = null;
            PreparedStatement preparedStatement = stmtGetSCOs;
            synchronized (preparedStatement) {
                stmtGetSCOs.setString(1, iCourseID);
                rsSCOs = stmtGetSCOs.executeQuery();
            }
            while (rsSCOs.next()) {
                SCOData sd = new SCOData();
                sd = this.getSCO(rsSCOs.getInt("ActivityID"));
                scos.add(sd);
            }
            rsSCOs.close();
            stmtGetSCOs.close();
            conn.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return scos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SCOData getSCO(int iActivityID) {
        Connection conn = LMSDatabaseHandler.getConnection();
        String sqlGetSCO = "SELECT * FROM ItemInfo WHERE ActivityID = ?";
        SCOData sco = new SCOData();
        try {
            PreparedStatement stmtGetSCO = conn.prepareStatement(sqlGetSCO);
            ResultSet rsSCO = null;
            PreparedStatement preparedStatement = stmtGetSCO;
            synchronized (preparedStatement) {
                stmtGetSCO.setInt(1, iActivityID);
                rsSCO = stmtGetSCO.executeQuery();
            }
            while (rsSCO.next()) {
                sco.mActivityID = rsSCO.getString("ActivityID");
                sco.mItemTitle = rsSCO.getString("Title");
                sco.mComment = new Vector();
                sco.mDateTime = new Vector();
                sco.mLocation = new Vector();
                String sqlGetComments = "SELECT * FROM SCOComments WHERE ActivityID = " + sco.mActivityID;
                PreparedStatement stmtGetComments = conn.prepareStatement(sqlGetComments);
                ResultSet rsComments = null;
                PreparedStatement preparedStatement2 = stmtGetComments;
                synchronized (preparedStatement2) {
                    rsComments = stmtGetComments.executeQuery();
                }
                while (rsComments.next()) {
                    sco.mComment.add(rsComments.getString("Comment"));
                    sco.mDateTime.add(rsComments.getString("CommentDateTime"));
                    sco.mLocation.add(rsComments.getString("CommentLocation"));
                }
                rsComments.close();
                stmtGetComments.close();
            }
            rsSCO.close();
            stmtGetSCO.close();
            conn.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sco;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String updateSCO(int iActivityID, String iComments, String iUpdate, String iLocations) {
        String result = "true";
        Connection conn = LMSDatabaseHandler.getConnection();
        String sqlSetComment = "INSERT INTO SCOComments(ActivityID, Comment,  CommentDateTime, CommentLocation) VALUES(?,?,?,?)";
        String sqlDeleteComment = "DELETE FROM SCOComments WHERE ActivityID = ?";
        Vector comments = new Vector();
        comments = this.getCommentVector(iComments);
        Vector locations = new Vector();
        locations = this.getCommentVector(iLocations);
        try {
            PreparedStatement stmtSetComment = conn.prepareStatement(sqlSetComment);
            if (iUpdate.equals("false")) {
                PreparedStatement stmtDeleteComment;
                PreparedStatement preparedStatement = stmtDeleteComment = conn.prepareStatement(sqlDeleteComment);
                synchronized (preparedStatement) {
                    stmtDeleteComment.setInt(1, iActivityID);
                    stmtDeleteComment.executeUpdate();
                }
                stmtDeleteComment.close();
            }
            DateFormat date = DateFormat.getDateTimeInstance();
            if (iComments != null && !iComments.equals("")) {
                for (int i = 0; i < comments.size(); ++i) {
                    PreparedStatement preparedStatement;
                    if (locations.elementAt(i).equals("")) {
                        preparedStatement = stmtSetComment;
                        synchronized (preparedStatement) {
                            stmtSetComment.setInt(1, iActivityID);
                            stmtSetComment.setString(2, (String)comments.elementAt(i));
                            stmtSetComment.setString(3, date.format(new Date()));
                            stmtSetComment.executeUpdate();
                            continue;
                        }
                    }
                    preparedStatement = stmtSetComment;
                    synchronized (preparedStatement) {
                        stmtSetComment.setInt(1, iActivityID);
                        stmtSetComment.setString(2, (String)comments.elementAt(i));
                        stmtSetComment.setString(3, date.format(new Date()));
                        stmtSetComment.setString(4, (String)locations.elementAt(i));
                        stmtSetComment.executeUpdate();
                        continue;
                    }
                }
                stmtSetComment.close();
            }
            conn.close();
        }
        catch (Exception e) {
            result = "false";
            e.printStackTrace();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String deleteCourse(Vector iCourses) {
        String result = "true";
        String courseID = "";
        String sqlUpdateCourse = "UPDATE CourseInfo set Active = no where CourseID = ?";
        try {
            Connection conn = LMSDatabaseHandler.getConnection();
            PreparedStatement stmtUpdateCourse = conn.prepareStatement(sqlUpdateCourse);
            for (int i = 0; i < iCourses.size(); ++i) {
                courseID = (String)iCourses.elementAt(i);
                if (!courseID.startsWith("RE_") && !courseID.startsWith("UN_")) continue;
                courseID = courseID.substring(3, courseID.length());
                PreparedStatement preparedStatement = stmtUpdateCourse;
                synchronized (preparedStatement) {
                    stmtUpdateCourse.setString(1, courseID);
                    stmtUpdateCourse.executeUpdate();
                    continue;
                }
            }
            stmtUpdateCourse.close();
            conn.close();
        }
        catch (Exception e) {
            result = "false";
            e.printStackTrace();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getRegCourses(String iUserID) {
        ArrayList<String> userCourses = new ArrayList<String>();
        String sqlSelectUserCourse = "SELECT * FROM UserCourseInfo WHERE UserID = ?";
        try {
            Connection conn = LMSDatabaseHandler.getConnection();
            PreparedStatement stmtRegSelectUserCourse = conn.prepareStatement(sqlSelectUserCourse);
            this.mUserID = iUserID;
            ResultSet userCourseRS = null;
            PreparedStatement preparedStatement = stmtRegSelectUserCourse;
            synchronized (preparedStatement) {
                stmtRegSelectUserCourse.setString(1, this.mUserID);
                userCourseRS = stmtRegSelectUserCourse.executeQuery();
            }
            while (userCourseRS.next()) {
                userCourses.add(userCourseRS.getString("CourseID"));
            }
            userCourseRS.close();
            stmtRegSelectUserCourse.close();
            conn.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return userCourses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String updateRegCourses(Vector iCourseIDs, String iPath, String iUserID) {
        String result = "true";
        this.mUserID = iUserID;
        String sqlSelectUserCourse = "SELECT * FROM UserCourseInfo WHERE UserID = ? AND CourseID = ?";
        String sqlSelectCourse = "SELECT * FROM UserCourseInfo WHERE UserID = ?";
        String sqlInsertUserCourse = "INSERT INTO UserCourseInfo (UserID, CourseID) VALUES(?,?)";
        String sqlDeleteUserCourse = "DELETE FROM UserCourseInfo WHERE UserID = ? AND CourseID = ?";
        String sqlInsertCourseStatus = "INSERT INTO CourseStatus (learnerID, courseID) VALUES(?,?)";
        String sqlDeleteCourseStatus = "DELETE FROM CourseStatus WHERE learnerID = ? AND courseID = ?";
        String sqlDeleteCourseObjectives = "DELETE FROM Objectives WHERE learnerID = ? AND scopeID = ?";
        try {
            Connection conn = LMSDatabaseHandler.getConnection();
            Connection csConn = LMSDBHandler.getConnection();
            PreparedStatement stmtSelectCourse = conn.prepareStatement(sqlSelectCourse);
            PreparedStatement stmtSelectUserCourse = conn.prepareStatement(sqlSelectUserCourse);
            PreparedStatement stmtInsertUserCourse = conn.prepareStatement(sqlInsertUserCourse);
            PreparedStatement stmtDeleteUserCourse = conn.prepareStatement(sqlDeleteUserCourse);
            PreparedStatement stmtInsertCourseStatus = csConn.prepareStatement(sqlInsertCourseStatus);
            PreparedStatement stmtDeleteCourseStatus = csConn.prepareStatement(sqlDeleteCourseStatus);
            PreparedStatement stmtDeleteCourseObjectives = csConn.prepareStatement(sqlDeleteCourseObjectives);
            ArrayList<String> unregisterCourses = new ArrayList<String>();
            RTEFileHandler fileHandler = new RTEFileHandler();
            String regTestString = "UN_Course-";
            for (int i = 0; i < iCourseIDs.size(); ++i) {
                String userDir;
                File theRTESCODataDir;
                int locSkillId;
                String paramName = (String)iCourseIDs.elementAt(i);
                if (paramName.indexOf("RE_Course-") != -1) {
                    unregisterCourses.add(paramName.substring(3, paramName.length()));
                }
                if ((locSkillId = paramName.indexOf(regTestString)) == -1) continue;
                String courseID = paramName.substring(3, paramName.length());
                ResultSet userCourseRS = null;
                PreparedStatement preparedStatement = stmtSelectUserCourse;
                synchronized (preparedStatement) {
                    stmtSelectUserCourse.setString(1, this.mUserID);
                    stmtSelectUserCourse.setString(2, courseID);
                    userCourseRS = stmtSelectUserCourse.executeQuery();
                }
                if (userCourseRS.next()) continue;
                preparedStatement = stmtInsertUserCourse;
                synchronized (preparedStatement) {
                    stmtInsertUserCourse.setString(1, this.mUserID);
                    stmtInsertUserCourse.setString(2, courseID);
                    stmtInsertUserCourse.executeUpdate();
                }
                preparedStatement = stmtInsertCourseStatus;
                synchronized (preparedStatement) {
                    stmtInsertCourseStatus.setString(1, this.mUserID);
                    stmtInsertCourseStatus.setString(2, courseID);
                    stmtInsertCourseStatus.executeUpdate();
                }
                String tree = iPath + "CourseImports" + File.separator + courseID + File.separator + "serialize.obj";
                FileInputStream in = new FileInputStream(tree);
                ObjectInputStream ie = new ObjectInputStream(in);
                SeqActivityTree mySeqActivityTree = (SeqActivityTree)ie.readObject();
                ie.close();
                in.close();
                mySeqActivityTree.setLearnerID(this.mUserID);
                String scope = mySeqActivityTree.getScopeID();
                Vector theGobalObjectiveList = mySeqActivityTree.getGlobalObjectives();
                if (theGobalObjectiveList != null) {
                    ADLSeqUtilities.createGlobalObjs(this.mUserID, scope, theGobalObjectiveList);
                }
                if (!(theRTESCODataDir = new File(userDir = File.separator + SRTEFILESDIR + File.separator + this.mUserID + File.separator + courseID)).isDirectory()) {
                    theRTESCODataDir.mkdirs();
                }
                String sampleRTERoot = File.separator + SRTEFILESDIR;
                String serializeFileName = sampleRTERoot + File.separator + this.mUserID + File.separator + courseID + File.separator + "serialize.obj";
                FileOutputStream outFile = new FileOutputStream(serializeFileName);
                ObjectOutputStream s = new ObjectOutputStream(outFile);
                s.writeObject(mySeqActivityTree);
                s.flush();
                s.close();
                outFile.close();
                userCourseRS.close();
            }
            Iterator unregIter = unregisterCourses.iterator();
            while (unregIter.hasNext()) {
                String courseID = unregIter.next().toString();
                ResultSet userCourseRS = null;
                PreparedStatement preparedStatement = stmtSelectUserCourse;
                synchronized (preparedStatement) {
                    stmtSelectUserCourse.setString(1, this.mUserID);
                    stmtSelectUserCourse.setString(2, courseID);
                    userCourseRS = stmtSelectUserCourse.executeQuery();
                }
                if (!userCourseRS.next()) continue;
                preparedStatement = stmtDeleteUserCourse;
                synchronized (preparedStatement) {
                    stmtDeleteUserCourse.setString(1, this.mUserID);
                    stmtDeleteUserCourse.setString(2, courseID);
                    stmtDeleteUserCourse.executeUpdate();
                }
                preparedStatement = stmtDeleteCourseStatus;
                synchronized (preparedStatement) {
                    stmtDeleteCourseObjectives.setString(1, this.mUserID);
                    stmtDeleteCourseObjectives.setString(2, courseID);
                    stmtDeleteCourseObjectives.executeUpdate();
                    stmtDeleteCourseStatus.setString(1, this.mUserID);
                    stmtDeleteCourseStatus.setString(2, courseID);
                    stmtDeleteCourseStatus.executeUpdate();
                }
                fileHandler.deleteCourseFiles(courseID, this.mUserID);
            }
            stmtSelectCourse.close();
            stmtSelectUserCourse.close();
            stmtInsertUserCourse.close();
            stmtDeleteUserCourse.close();
            stmtInsertCourseStatus.close();
            stmtDeleteCourseStatus.close();
            conn.close();
            LMSDBHandler.closeConnection();
        }
        catch (Exception e) {
            result = "false";
        }
        return result;
    }

    public String resetCourses(Vector iCourseIDs, String iPath, String iUserID) {
        String result = "true";
        Vector<String> tempIDs = new Vector<String>();
        result = this.updateRegCourses(iCourseIDs, iPath, iUserID);
        if (result.equals("false")) {
            return result;
        }
        for (int i = 0; i < iCourseIDs.size(); ++i) {
            tempIDs.add(iCourseIDs.get(i).toString().replaceFirst("RE_", "UN_"));
        }
        result = this.updateRegCourses(tempIDs, iPath, iUserID);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CourseData showCourseStatus(String iCourseID, String iUserID) {
        String courseID = iCourseID;
        this.mUserID = iUserID;
        CourseData cs = new CourseData();
        try {
            ResultSet statusRS;
            PreparedStatement stmtSelectStatus;
            Connection conn = LMSDBHandler.getConnection();
            String sqlSelectStatus = "SELECT * FROM CourseStatus where learnerID = ? AND courseID = ?";
            PreparedStatement preparedStatement = stmtSelectStatus = conn.prepareStatement(sqlSelectStatus);
            synchronized (preparedStatement) {
                stmtSelectStatus.setString(1, this.mUserID);
                stmtSelectStatus.setString(2, courseID);
                statusRS = stmtSelectStatus.executeQuery();
            }
            while (statusRS.next()) {
                cs.mSatisfied = statusRS.getString("satisfied");
                cs.mMeasure = statusRS.getString("measure");
                cs.mCompleted = statusRS.getString("completed");
                cs.mProgMeasure = statusRS.getString("progmeasure");
            }
            statusRS.close();
            stmtSelectStatus.close();
            LMSDBHandler.closeConnection();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return cs;
    }

    public String getCourseFileName() {
        return this.mCourseFileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getName(String iUserID) {
        this.mUserID = iUserID;
        String name = "";
        String lastName = "";
        String firstName = "";
        try {
            ResultSet userRS;
            PreparedStatement stmtSelectUser;
            Connection conn = LMSDatabaseHandler.getConnection();
            String sqlSelectUser = "SELECT * FROM UserInfo WHERE UserID = ?";
            PreparedStatement preparedStatement = stmtSelectUser = conn.prepareStatement(sqlSelectUser);
            synchronized (preparedStatement) {
                stmtSelectUser.setString(1, this.mUserID);
                userRS = stmtSelectUser.executeQuery();
            }
            while (userRS.next()) {
                lastName = userRS.getString("LastName");
                firstName = userRS.getString("FirstName");
            }
            name = name + firstName + " " + lastName;
            userRS.close();
            stmtSelectUser.close();
            conn.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String clearDatabase(String iPath) {
        String result = "true";
        try {
            Connection conn = LMSDatabaseHandler.getConnection();
            String sqlGetUserList = "SELECT * FROM UserInfo";
            String sqlGetCourseList = "SELECT * FROM UserCourseInfo WHERE UserId = ?";
            String sqlGetCourses = "SELECT * FROM CourseInfo";
            String sqlDeleteCourseInfo = "Delete FROM CourseInfo";
            String sqlUpdateApplicationData = "UPDATE ApplicationData SET numberValue = '1' WHERE dataName = 'nextCourseID'";
            String sqlDeleteCourseObjs = "Delete FROM Objectives";
            String sqlDeleteCourseStatus = "Delete FROM CourseStatus";
            PreparedStatement stmtGetCourseList = conn.prepareStatement(sqlGetCourseList);
            PreparedStatement stmtGetUserIDList = conn.prepareStatement(sqlGetUserList);
            PreparedStatement stmtGetCourses = conn.prepareStatement(sqlGetCourses);
            PreparedStatement stmtDeleteCourseInfo = conn.prepareStatement(sqlDeleteCourseInfo);
            PreparedStatement stmtUpdateApplicationData = conn.prepareStatement(sqlUpdateApplicationData);
            RTEFileHandler fileHandler = new RTEFileHandler();
            ResultSet userRS = null;
            userRS = stmtGetUserIDList.executeQuery();
            ResultSet courseRS = null;
            String user = new String();
            while (userRS.next()) {
                user = userRS.getString("UserID");
                PreparedStatement preparedStatement = stmtGetCourseList;
                synchronized (preparedStatement) {
                    stmtGetCourseList.setString(1, user);
                    courseRS = stmtGetCourseList.executeQuery();
                }
                while (courseRS.next()) {
                    fileHandler.deleteCourseFiles(courseRS.getString("CourseID"), user);
                }
            }
            String theWebPath = iPath;
            String mCourseDir = theWebPath + "CourseImports" + File.separator;
            ResultSet courseListRS = null;
            courseListRS = stmtGetCourses.executeQuery();
            while (courseListRS.next()) {
                File mRTESCODataDir = new File(mCourseDir + File.separator + courseListRS.getString("CourseID"));
                File[] mScoFiles = mRTESCODataDir.listFiles();
                for (int i = 0; i < mScoFiles.length; ++i) {
                    this.deleteCourseFiles(mScoFiles[i]);
                }
                mRTESCODataDir.delete();
            }
            stmtDeleteCourseInfo.executeUpdate();
            stmtUpdateApplicationData.executeUpdate();
            stmtDeleteCourseInfo.close();
            stmtUpdateApplicationData.close();
            conn.close();
            Connection objConn = LMSDBHandler.getConnection();
            PreparedStatement stmtDeleteObj = objConn.prepareStatement(sqlDeleteCourseObjs);
            stmtDeleteObj.executeUpdate();
            stmtDeleteObj.close();
            PreparedStatement stmtDeleteStatus = objConn.prepareStatement(sqlDeleteCourseStatus);
            stmtDeleteStatus.executeUpdate();
            stmtDeleteStatus.close();
            LMSDBHandler.closeConnection();
        }
        catch (SQLException e) {
            System.out.println("sql exception in");
            result = "false";
            e.printStackTrace();
        }
        catch (Exception e) {
            result = "false";
            e.printStackTrace();
        }
        return result;
    }

    public void deleteCourseFiles(File iDeleteFile) {
        try {
            if (iDeleteFile.isDirectory()) {
                File[] mScoFiles = iDeleteFile.listFiles();
                for (int i = 0; i < mScoFiles.length; ++i) {
                    this.deleteCourseFiles(mScoFiles[i]);
                }
            }
            iDeleteFile.delete();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String addObj(ObjectivesData ioObject) {
        String result;
        block11: {
            result = "true";
            this.mUserID = ioObject.mUserID;
            String objectiveID = decodeHandler.encodeObjectiveID(ioObject.mObjectiveID);
            String satisfied = ioObject.mSatisfied;
            String satisfiedValue = new String(satisfied);
            String newCompletionStatus = new String(ioObject.mCompletionStatus);
            if (satisfied.equals("not satisfied")) {
                satisfiedValue = "notSatisfied";
            }
            if (newCompletionStatus.equals("not attempted")) {
                newCompletionStatus = "notAttempted";
            }
            String sqlSelectObjectives = "SELECT * FROM Objectives WHERE objID = ? AND learnerID = ? AND scopeID = ?";
            String sqlInsertObjective = "INSERT INTO Objectives VALUES(?,?,?,?,?,?,?,?,?,?)";
            ResultSet objectivesRS = null;
            try {
                PreparedStatement stmtInsertObjective;
                PreparedStatement stmtSelectObjectives;
                Connection conn = LMSDBHandler.getConnection();
                PreparedStatement preparedStatement = stmtSelectObjectives = conn.prepareStatement(sqlSelectObjectives);
                synchronized (preparedStatement) {
                    stmtSelectObjectives.setString(1, objectiveID);
                    stmtSelectObjectives.setString(2, this.mUserID);
                    stmtSelectObjectives.setString(3, "");
                    objectivesRS = stmtSelectObjectives.executeQuery();
                }
                if (objectivesRS.next()) {
                    ioObject.mObjErr = "dupobjid";
                    result = "false";
                    break block11;
                }
                preparedStatement = stmtInsertObjective = conn.prepareStatement(sqlInsertObjective);
                synchronized (preparedStatement) {
                    stmtInsertObjective.setString(1, objectiveID);
                    stmtInsertObjective.setString(2, this.mUserID);
                    stmtInsertObjective.setString(3, satisfiedValue);
                    stmtInsertObjective.setString(4, ioObject.mMeasure);
                    stmtInsertObjective.setString(5, "");
                    stmtInsertObjective.setString(6, ioObject.mRawScore);
                    stmtInsertObjective.setString(7, ioObject.mMinScore);
                    stmtInsertObjective.setString(8, ioObject.mMaxScore);
                    stmtInsertObjective.setString(9, ioObject.mProgressMeasure);
                    stmtInsertObjective.setString(10, newCompletionStatus);
                    stmtInsertObjective.executeUpdate();
                }
            }
            catch (Exception e) {
                result = "false";
                e.printStackTrace();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getGlobalObjs(String iUserID, Vector iObjs) {
        Vector obj = iObjs;
        try {
            PreparedStatement stmtSelectGlobals;
            Connection conn = LMSDBHandler.getConnection();
            String sqlSelectGlobals = "SELECT * FROM Objectives where learnerID = ? and scopeID = ''";
            PreparedStatement preparedStatement = stmtSelectGlobals = conn.prepareStatement(sqlSelectGlobals);
            synchronized (preparedStatement) {
                stmtSelectGlobals.setString(1, iUserID);
            }
            ResultSet globalsRS = stmtSelectGlobals.executeQuery();
            boolean foundObjective = false;
            boolean firstQueryEmpty = true;
            while (globalsRS.next()) {
                ObjectivesData od = new ObjectivesData();
                od.mObjectiveID = decodeHandler.decodeObjectiveID(decodeHandler.processWhitespace(globalsRS.getString("objID")));
                od.mUserID = globalsRS.getString("learnerID");
                od.mSatisfied = globalsRS.getString("satisfied");
                od.mMeasure = globalsRS.getString("measure");
                od.mRawScore = globalsRS.getString("rawscore");
                od.mMinScore = globalsRS.getString("minscore");
                od.mMaxScore = globalsRS.getString("maxscore");
                od.mProgressMeasure = globalsRS.getString("progressmeasure");
                od.mCompletionStatus = globalsRS.getString("completion");
                if (obj != null) {
                    for (int i = 0; i < obj.size(); ++i) {
                        firstQueryEmpty = false;
                        ObjectivesData od2 = (ObjectivesData)obj.elementAt(i);
                        if (!od.mObjectiveID.equals(od2.mObjectiveID)) continue;
                        foundObjective = true;
                        break;
                    }
                }
                if (!firstQueryEmpty && foundObjective) continue;
                obj.add(od);
            }
            globalsRS.close();
            stmtSelectGlobals.close();
            LMSDBHandler.closeConnection();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getObjs(String iCourseID, String iUserID) {
        this.mUserID = iUserID;
        String courseID = iCourseID;
        Vector<ObjectivesData> obj = new Vector<ObjectivesData>();
        try {
            PreparedStatement stmtSelectObjectives;
            Connection conn = LMSDBHandler.getConnection();
            String sqlSelectObjectives = "SELECT * FROM Objectives where learnerID = ? AND scopeID = ?";
            PreparedStatement preparedStatement = stmtSelectObjectives = conn.prepareStatement(sqlSelectObjectives);
            synchronized (preparedStatement) {
                stmtSelectObjectives.setString(1, this.mUserID);
                stmtSelectObjectives.setString(2, courseID);
            }
            ResultSet objectivesRS = stmtSelectObjectives.executeQuery();
            if (!courseID.equals("")) {
                while (objectivesRS.next()) {
                    ObjectivesData od = new ObjectivesData();
                    od.mObjectiveID = decodeHandler.decodeObjectiveID(decodeHandler.processWhitespace(objectivesRS.getString("objID")));
                    od.mUserID = objectivesRS.getString("learnerID");
                    od.mSatisfied = objectivesRS.getString("satisfied");
                    od.mMeasure = objectivesRS.getString("measure");
                    od.mRawScore = objectivesRS.getString("rawscore");
                    od.mMinScore = objectivesRS.getString("minscore");
                    od.mMaxScore = objectivesRS.getString("maxscore");
                    od.mProgressMeasure = objectivesRS.getString("progressmeasure");
                    od.mCompletionStatus = objectivesRS.getString("completion");
                    obj.add(od);
                }
            }
            objectivesRS.close();
            stmtSelectObjectives.close();
            LMSDBHandler.closeConnection();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String editObjs(Vector iParams) {
        String result = "true";
        Vector requestNames = iParams;
        try {
            Connection conn = LMSDBHandler.getConnection();
            String sqlUpdateObjective = "UPDATE Objectives SET satisfied = 'unknown', measure = 'unknown' , rawscore = 'unknown', minscore = 'unknown', maxscore = 'unknown', progressmeasure = 'unknown',completion = 'unknown' WHERE objID = ? AND learnerID = ?";
            String sqlDeleteObjective = "DELETE FROM Objectives WHERE objID = ? AND learnerID = ?";
            PreparedStatement stmtUpdateObjective = conn.prepareStatement(sqlUpdateObjective);
            PreparedStatement stmtDeleteObjective = conn.prepareStatement(sqlDeleteObjective);
            for (int i = 0; i < requestNames.size(); ++i) {
                PreparedStatement preparedStatement;
                String param = (String)requestNames.elementAt(i);
                param = param.substring(param.indexOf("~") + 1, param.length());
                int splitIndex = param.lastIndexOf(":");
                String paramName = param.substring(0, splitIndex);
                String paramValue = param.substring(splitIndex + 1, param.length());
                if (paramName.equals("submit")) continue;
                splitIndex = paramName.lastIndexOf(";");
                String objID = decodeHandler.encodeObjectiveID(paramName.substring(0, splitIndex));
                String learnerID = paramName.substring(splitIndex + 1, paramName.length());
                if (paramValue.equals("reset")) {
                    preparedStatement = stmtUpdateObjective;
                    synchronized (preparedStatement) {
                        stmtUpdateObjective.setString(1, objID);
                        stmtUpdateObjective.setString(2, learnerID);
                        stmtUpdateObjective.executeUpdate();
                        continue;
                    }
                }
                if (!paramValue.equals("delete")) continue;
                preparedStatement = stmtDeleteObjective;
                synchronized (preparedStatement) {
                    stmtDeleteObjective.setString(1, objID);
                    stmtDeleteObjective.setString(2, learnerID);
                    stmtDeleteObjective.executeUpdate();
                    continue;
                }
            }
            stmtUpdateObjective.close();
            stmtDeleteObjective.close();
            LMSDBHandler.closeConnection();
        }
        catch (Exception e) {
            result = "false";
            System.out.println(e);
        }
        return result;
    }

    public Vector getCommentVector(String iComments) {
        String[] commentArray = iComments.split("\n");
        Vector<String> commentVector = new Vector<String>();
        for (int i = 0; i < commentArray.length; ++i) {
            String cmt = commentArray[i].trim();
            commentVector.add(cmt);
        }
        return commentVector;
    }

    public ResultCollection importCourse(HttpServletRequest iRequest, String iWebPath, String iSessionID) {
        ResultCollection validationResults = new ResultCollection();
        String sessionID = "";
        String uploadDir = "";
        String fileName = "";
        String myFileName = "";
        String courseTitle = "";
        try {
            List items;
            Iterator iter;
            FileItem item;
            String name;
            sessionID = iSessionID;
            String fileSeparator = File.separator;
            String theWebPath = iWebPath;
            String mDrive = theWebPath.substring(0, 2);
            uploadDir = mDrive + fileSeparator + SRTEFILESDIR + fileSeparator + "tempUploads" + fileSeparator + sessionID;
            File theRTEUploadDir = new File(uploadDir);
            boolean isMultipart = FileUpload.isMultipartContent(iRequest);
            DiskFileItemFactory factory = new DiskFileItemFactory();
            ServletFileUpload upload = new ServletFileUpload(factory);
            if (!theRTEUploadDir.isDirectory()) {
                theRTEUploadDir.mkdirs();
            }
            if ((name = (item = (FileItem)(iter = (items = upload.parseRequest(iRequest)).iterator()).next()).getFieldName()).equals("coursezipfile")) {
                fileName = new File(fileName).getName();
                myFileName = item.getName().substring(item.getName().lastIndexOf(fileSeparator) + 1);
                File fNew = new File(uploadDir, myFileName);
                courseTitle = fileName;
                item.write(fNew);
            }
            FileItem item2 = (FileItem)iter.next();
            String validationValue = item2.getString();
            this.mCourseFileName = myFileName;
            this.mOnlineValidation = validationValue.equals("1");
            String zipFile = uploadDir + fileSeparator + myFileName;
            String theXSDPath = theWebPath.substring(0, theWebPath.lastIndexOf(fileSeparator));
            LMSManifestHandler myManifestHandler = new LMSManifestHandler(theXSDPath);
            myManifestHandler.setCourseName(courseTitle);
            myManifestHandler.setWebPath(theWebPath);
            validationResults = myManifestHandler.processPackage(zipFile, this.mOnlineValidation);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return validationResults;
    }

    public boolean isOnlineValidation() {
        return this.mOnlineValidation;
    }

    public boolean ZipCopy(File inFile, File outFile) {
        boolean success = false;
        try {
            FileInputStream fis = new FileInputStream(inFile);
            FileOutputStream fos = new FileOutputStream(outFile);
            byte[] buf = new byte[1024];
            int i = 0;
            while ((i = fis.read(buf)) != -1) {
                fos.write(buf, 0, i);
            }
            fis.close();
            fos.close();
            success = true;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return success;
    }

    public ResultCollection importMultipleCourses(String iFilename, String iZipFile, File iDirectory, String iWebPath, String iSessionID, String iValidation) {
        ResultCollection validationResults = new ResultCollection();
        String sessionID = "";
        String uploadDir = "";
        String fileName = "";
        String myFileName = "";
        String courseTitle = "";
        boolean validation = true;
        validation = iValidation.equals("1");
        try {
            sessionID = iSessionID;
            String fileSeparator = File.separator;
            String theWebPath = iWebPath;
            String mDrive = theWebPath.substring(0, 2);
            uploadDir = mDrive + fileSeparator + SRTEFILESDIR + fileSeparator + "tempUploads" + fileSeparator + sessionID;
            File theRTEUploadDir = new File(uploadDir);
            if (!theRTEUploadDir.isDirectory()) {
                theRTEUploadDir.mkdirs();
            }
            String zipFile = iZipFile;
            myFileName = iFilename;
            File fNew = new File(uploadDir, myFileName);
            courseTitle = fileName;
            File courseFile = new File(iZipFile);
            this.ZipCopy(courseFile, fNew);
            String theXSDPath = theWebPath.substring(0, theWebPath.lastIndexOf(fileSeparator));
            LMSManifestHandler myManifestHandler = new LMSManifestHandler(theXSDPath);
            myManifestHandler.setCourseName(courseTitle);
            myManifestHandler.setWebPath(theWebPath);
            validationResults = myManifestHandler.processPackage(zipFile, validation);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return validationResults;
    }
}

