/*
 * Decompiled with CFR 0.152.
 */
package org.adl.samplerte.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.adl.datamodels.DMInterface;
import org.adl.datamodels.DMProcessingInfo;
import org.adl.datamodels.DMRequest;
import org.adl.datamodels.SCODataManager;
import org.adl.samplerte.server.LMSCMIServletRequest;
import org.adl.samplerte.server.LMSCMIServletResponse;
import org.adl.samplerte.util.RTEFileHandler;
import org.adl.sequencer.ADLObjStatus;
import org.adl.sequencer.ADLSeqUtilities;
import org.adl.sequencer.ADLSequencer;
import org.adl.sequencer.ADLTracking;
import org.adl.sequencer.ADLValidRequests;
import org.adl.sequencer.SeqActivity;
import org.adl.sequencer.SeqActivityTree;
import org.adl.sequencer.SeqObjective;

public class LMSCMIServlet
extends HttpServlet {
    private final String mPRIMARY_OBJ_ID;
    private final String SRTEFILESDIR = "SCORM4EDSampleRTE111Files";

    public LMSCMIServlet() {
        this.mPRIMARY_OBJ_ID = null;
    }

    @Override
    public void doPost(HttpServletRequest iRequest, HttpServletResponse oResponse) throws ServletException, IOException {
        Logger logger = Logger.getLogger("org.adl.util.debug.samplerte");
        logger.entering("---LMSCMIServlet", "doPost()");
        logger.info("POST received by LMSCMIServlet");
        String scoFile = null;
        String userID = null;
        String userName = null;
        String courseID = null;
        String scoID = null;
        String numAttempt = null;
        String activityID = null;
        LMSCMIServletRequest request = null;
        LMSCMIServletResponse response = null;
        SCODataManager mSCOData = null;
        try {
            logger.info("Requested session: " + iRequest.getRequestedSessionId());
            logger.info("query string: " + iRequest.getQueryString());
            logger.info("header string: " + iRequest.getContextPath());
            Enumeration e = iRequest.getHeaderNames();
            while (e.hasMoreElements()) {
                logger.info(e.nextElement().toString());
            }
            HttpSession session = iRequest.getSession(false);
            if (session == null) {
                logger.severe("  ERROR - No session ID in LMSCMIServlet.");
            } else {
                logger.info("Session ID is: " + session.getId());
            }
            logger.info("Checking attributes");
            ObjectInputStream in = new ObjectInputStream(iRequest.getInputStream());
            logger.info("Created REQUEST object INPUT stream successfully");
            ObjectOutputStream out = new ObjectOutputStream(oResponse.getOutputStream());
            logger.info("Created RESPONSE object OUTPUT stream successfully");
            request = (LMSCMIServletRequest)in.readObject();
            scoID = request.mStateID;
            activityID = request.mActivityID;
            courseID = request.mCourseID;
            userID = request.mStudentID;
            numAttempt = request.mNumAttempt;
            userName = request.mUserName;
            logger.info("ScoID: " + scoID);
            if (numAttempt != null) {
                scoFile = File.separator + "SCORM4EDSampleRTE111Files" + File.separator + userID + File.separator + courseID + File.separator + scoID + "__" + numAttempt;
            } else {
                logger.fine("  ERROR: NULL # attempt");
                scoFile = File.separator + "SCORM4EDSampleRTE111Files" + File.separator + userID + File.separator + courseID + File.separator + scoID;
            }
            logger.info("Data model path:  " + scoFile);
            FileInputStream fi = null;
            ObjectInputStream fileIn = null;
            switch (request.mRequestType) {
                case 1: {
                    logger.info("CMI Servlet - doPost() - entering case INIT ");
                    logger.info("Processing 'init' request");
                    response = new LMSCMIServletResponse();
                    SeqActivityTree mSeqActivityTree = new SeqActivityTree();
                    SeqActivityTree.dataStoreLoc = File.separator + "SCORM4EDSampleRTE111Files" + File.separator + userID + File.separator + courseID + File.separator + "DS.obj";
                    String mTreePath = File.separator + "SCORM4EDSampleRTE111Files" + File.separator + userID + File.separator + courseID + File.separator + "serialize.obj";
                    FileInputStream mFileIn = new FileInputStream(mTreePath);
                    ObjectInputStream mObjectIn = new ObjectInputStream(mFileIn);
                    mSeqActivityTree = (SeqActivityTree)mObjectIn.readObject();
                    mObjectIn.close();
                    mFileIn.close();
                    boolean newFile = true;
                    RTEFileHandler fileHandler = new RTEFileHandler();
                    try {
                        fi = new FileInputStream(scoFile);
                        newFile = false;
                    }
                    catch (FileNotFoundException fnfe) {
                        logger.info("State file does not exist...");
                        logger.info("Created file handler");
                        logger.info("About to create file");
                        fileHandler.initializeStateFile(numAttempt, userID, userName, courseID, scoID, scoID);
                        logger.info("after initialize state file");
                        logger.info("State File Created");
                        fi = new FileInputStream(scoFile);
                    }
                    logger.info("Created LMSSCODataFile File input stream successfully");
                    fileIn = new ObjectInputStream(fi);
                    logger.info("Created OBJECT input stream successfully");
                    mSCOData = (SCODataManager)fileIn.readObject();
                    fileIn.close();
                    fi.close();
                    ADLSequencer mSequencer = new ADLSequencer();
                    ADLValidRequests mState = new ADLValidRequests();
                    SeqActivity mSeqActivity = mSeqActivityTree.getActivity(scoID);
                    mSequencer.setActivityTree(mSeqActivityTree);
                    mSequencer.getValidRequests(mState);
                    response.mValidRequests = mState;
                    logger.info("continue  " + response.mValidRequests.mContinue);
                    logger.info("previous  " + response.mValidRequests.mPrevious);
                    Vector mStatusVector = new Vector();
                    mStatusVector = mSequencer.getObjStatusSet(scoID);
                    ADLObjStatus mObjStatus = new ADLObjStatus();
                    boolean err = false;
                    String obj = new String();
                    if (mStatusVector != null) {
                        if (newFile) {
                            for (int i = 0; i < mStatusVector.size(); ++i) {
                                mObjStatus = (ADLObjStatus)mStatusVector.get(i);
                                this.initializeObjectives(mSCOData, mObjStatus, i);
                            }
                        } else {
                            for (int i = 0; i < mStatusVector.size(); ++i) {
                                int idx = -1;
                                mObjStatus = (ADLObjStatus)mStatusVector.get(i);
                                DMProcessingInfo pi = new DMProcessingInfo();
                                int result = DMInterface.processGetValue("cmi.objectives._count", true, mSCOData, pi);
                                int objCount = new Integer(pi.mValue);
                                for (int j = 0; j < objCount; ++j) {
                                    pi = new DMProcessingInfo();
                                    obj = "cmi.objectives." + j + ".id";
                                    result = DMInterface.processGetValue(obj, true, mSCOData, pi);
                                    if (!pi.mValue.equals(mObjStatus.mObjID)) continue;
                                    idx = j;
                                    break;
                                }
                                if (idx != -1) {
                                    this.initializeObjectives(mSCOData, mObjStatus, i);
                                    continue;
                                }
                                System.out.println("  OBJ NOT FOUND --> " + mObjStatus.mObjID);
                            }
                        }
                    }
                    try {
                        this.readDataStores(mSCOData, mSeqActivity);
                    }
                    catch (FileNotFoundException fnfe) {
                        this.initializeDataStores(mSCOData, mSeqActivity.getDataStores());
                    }
                    response.mActivityData = mSCOData;
                    out.writeObject(response);
                    logger.info("LMSCMIServlet processed init");
                    break;
                }
                case 2: {
                    logger.info("Processing 'get' request");
                    response = new LMSCMIServletResponse();
                    try {
                        fi = new FileInputStream(scoFile);
                        logger.info("Created SCO data file input stream successfully");
                        fileIn = new ObjectInputStream(fi);
                        logger.info("Created OBJECT input stream successfully");
                        response.mActivityData = (SCODataManager)fileIn.readObject();
                    }
                    catch (FileNotFoundException fnfe) {
                        logger.fine("ERROR == State data not created");
                        response.mError = "NO DATA";
                    }
                    fileIn.close();
                    fi.close();
                    out.writeObject(response);
                    logger.info("LMSCMIServlet processed get for SCO Data\n");
                    break;
                }
                case 4: {
                    logger.info("Processing 'set' request");
                    response = this.handleData(request.mActivityData, userID, courseID, response, request, activityID, scoID, scoFile);
                    out.writeObject(response);
                    logger.info("LMSCMIServlet processed set.");
                    break;
                }
                case 3: {
                    logger.info("Processing 'timeout' request");
                    logger.info("LMSCMIServlet processed 'timeout'");
                    break;
                }
                default: {
                    logger.severe("ERROR:  Bad Request Type.");
                }
            }
            in.close();
            out.close();
        }
        catch (Exception e) {
            logger.severe(" :: doPost :: EXCEPTION");
            logger.severe(e.toString());
            e.printStackTrace();
        }
    }

    private LMSCMIServletResponse handleData(SCODataManager iSCOData, String iUserID, String iCourseID, LMSCMIServletResponse iResponse, LMSCMIServletRequest iRequest, String iActivityID, String iScoID, String iScoFile) {
        Logger logger = Logger.getLogger("org.adl.util.debug.samplerte");
        logger.info("LMSCMIServlet - Entering handleData()");
        iResponse = new LMSCMIServletResponse();
        String sampleRTERoot = File.separator + "SCORM4EDSampleRTE111Files";
        String userDir = sampleRTERoot + File.separator + iUserID + File.separator + iCourseID;
        boolean setPrimaryObjScore = false;
        boolean suspended = false;
        try {
            block56: {
                ADLSequencer theSequencer;
                String actFile;
                block59: {
                    DMProcessingInfo dmInfo;
                    int err;
                    SCODataManager scoData;
                    block57: {
                        block58: {
                            FileInputStream fi;
                            String completionStatus = null;
                            String progressMeasure = null;
                            String scoEntry = null;
                            double normalScore = -1.0;
                            String masteryStatus = null;
                            String sessionTime = null;
                            String score = null;
                            scoData = iRequest.mActivityData;
                            err = 0;
                            dmInfo = new DMProcessingInfo();
                            err = DMInterface.processGetValue("cmi.exit", true, true, scoData, dmInfo);
                            scoEntry = dmInfo.mValue;
                            scoData.terminate();
                            err = DMInterface.processGetValue("cmi.completion_status", true, scoData, dmInfo);
                            completionStatus = dmInfo.mValue;
                            boolean completionSetBySCO = dmInfo.mSetBySCO;
                            if (completionStatus.equals("not attempted")) {
                                completionStatus = "incomplete";
                            }
                            if ((err = DMInterface.processGetValue("cmi.progress_measure", true, scoData, dmInfo = new DMProcessingInfo())) == 0) {
                                progressMeasure = dmInfo.mValue;
                            }
                            err = DMInterface.processGetValue("cmi.success_status", true, scoData, dmInfo);
                            masteryStatus = dmInfo.mValue;
                            boolean masterySetBySCO = dmInfo.mSetBySCO;
                            err = DMInterface.processGetValue("cmi.entry", true, true, scoData, dmInfo);
                            scoEntry = dmInfo.mValue;
                            err = DMInterface.processGetValue("cmi.score.scaled", true, scoData, dmInfo);
                            if (err == 0) {
                                logger.info("Got score, with no error");
                                score = dmInfo.mValue;
                            } else {
                                logger.info("Failed getting score, got err: " + err);
                                score = "";
                            }
                            err = DMInterface.processGetValue("cmi.session_time", true, scoData, dmInfo);
                            if (err == 0) {
                                sessionTime = dmInfo.mValue;
                            }
                            logger.info("Saving Data to the File ...  PRIOR TO SAVE");
                            logger.info("The SCO Data Manager for the current SCO contains the following:");
                            String theWebPath = this.getServletConfig().getServletContext().getRealPath("/");
                            actFile = userDir + File.separator + "serialize.obj";
                            if (!iRequest.mIsFinished && !iRequest.mQuitPushed && !iRequest.mSuspendPushed) break block56;
                            logger.info("About to get and update activity tree");
                            try {
                                fi = new FileInputStream(actFile);
                            }
                            catch (FileNotFoundException fnfe) {
                                logger.severe("Can not open Activity tree file");
                                fi = new FileInputStream(actFile);
                            }
                            logger.info("Created Activity FILE input stream successfully");
                            ObjectInputStream fileIn = new ObjectInputStream(fi);
                            logger.info("Created Activity Tree OBJECT input stream successfully");
                            SeqActivityTree theTree = (SeqActivityTree)fileIn.readObject();
                            fileIn.close();
                            fi.close();
                            logger.info("(*********DUMPING ActivityTree***********)");
                            if (theTree == null) {
                                logger.info("The activity tree is NULL");
                            } else {
                                theTree.dumpState();
                            }
                            if (theTree == null) break block56;
                            theSequencer = new ADLSequencer();
                            theSequencer.setActivityTree(theTree);
                            SeqActivity act = theTree.getActivity(iActivityID);
                            this.populateMap(iSCOData, act);
                            if (!act.getIsTracked()) break block57;
                            logger.info(act.getID() + " is TRACKED -- ");
                            logger.info("Performing default mapping to TM");
                            String primaryObjID = null;
                            boolean foundPrimaryObj = false;
                            boolean setPrimaryObjSuccess = false;
                            boolean sesPrimaryObjScore = false;
                            Vector objs = act.getObjectives();
                            if (objs != null) {
                                for (int j = 0; j < objs.size(); ++j) {
                                    SeqObjective obj = (SeqObjective)objs.elementAt(j);
                                    if (!obj.mContributesToRollup) continue;
                                    if (obj.mObjID == null) break;
                                    primaryObjID = obj.mObjID;
                                    break;
                                }
                            }
                            err = DMInterface.processGetValue("cmi.objectives._count", true, scoData, dmInfo);
                            Integer size = new Integer(dmInfo.mValue);
                            int numObjs = size;
                            for (int i = 0; i < numObjs; ++i) {
                                String objID;
                                block55: {
                                    logger.info("CMISerlet - IN MAP OBJ LOOP");
                                    objID = new String("");
                                    String objMS = new String("");
                                    String objScore = new String("");
                                    String obj = new String("");
                                    obj = "cmi.objectives." + i + ".id";
                                    err = DMInterface.processGetValue(obj, true, scoData, dmInfo);
                                    objID = dmInfo.mValue;
                                    foundPrimaryObj = primaryObjID != null && objID.equals(primaryObjID);
                                    obj = "cmi.objectives." + i + ".success_status";
                                    err = DMInterface.processGetValue(obj, true, scoData, dmInfo);
                                    objMS = dmInfo.mValue;
                                    if (objMS.equals("passed")) {
                                        theSequencer.setAttemptObjSatisfied(iActivityID, objID, "satisfied");
                                        if (foundPrimaryObj) {
                                            act.primaryStatusSetBySCO(dmInfo.mSetBySCO);
                                            setPrimaryObjSuccess = true;
                                            masteryStatus = objMS;
                                        }
                                    } else if (objMS.equals("failed")) {
                                        theSequencer.setAttemptObjSatisfied(iActivityID, objID, "notSatisfied");
                                        if (foundPrimaryObj) {
                                            act.primaryStatusSetBySCO(dmInfo.mSetBySCO);
                                            setPrimaryObjSuccess = true;
                                            masteryStatus = objMS;
                                        }
                                    } else if (dmInfo.mSetBySCO) {
                                        theSequencer.setAttemptObjSatisfied(iActivityID, objID, "unknown");
                                        Vector globs = act.getObjIDs(objID, false);
                                        if (globs != null) {
                                            for (int w = 0; w < globs.size(); ++w) {
                                                ADLSeqUtilities.setGlobalObjSatisfied((String)globs.get(w), iUserID, act.getScopeID(), ADLTracking.TRACK_UNKNOWN);
                                            }
                                        }
                                        if (foundPrimaryObj) {
                                            act.primaryStatusSetBySCO(dmInfo.mSetBySCO);
                                            setPrimaryObjSuccess = true;
                                            masteryStatus = objMS;
                                        }
                                    }
                                    if ((err = DMInterface.processGetValue(obj = "cmi.objectives." + i + ".score.scaled", true, scoData, dmInfo)) == 0) {
                                        objScore = dmInfo.mValue;
                                    }
                                    if (!objScore.equals("") && !objScore.equals("unknown")) {
                                        try {
                                            normalScore = new Double(objScore);
                                            theSequencer.setAttemptObjMeasure(iActivityID, objID, normalScore);
                                            if (foundPrimaryObj) {
                                                setPrimaryObjScore = true;
                                            }
                                        }
                                        catch (Exception e) {
                                            logger.severe("  ::--> ERROR: Invalid score");
                                            logger.severe("  ::  " + normalScore);
                                            logger.severe(e.toString());
                                            e.printStackTrace();
                                        }
                                    } else {
                                        theSequencer.clearAttemptObjMeasure(iActivityID, objID);
                                    }
                                    dmInfo = new DMProcessingInfo();
                                    obj = "cmi.objectives." + i + ".completion_status";
                                    err = DMInterface.processGetValue(obj, true, scoData, dmInfo);
                                    String completion = ADLTracking.TRACK_UNKNOWN;
                                    if (err == 0) {
                                        completion = dmInfo.mValue;
                                    }
                                    if (!completion.equals("") && !completion.equals(ADLTracking.TRACK_UNKNOWN) || completion.equals(ADLTracking.TRACK_UNKNOWN) && dmInfo.mSetBySCO) {
                                        if (foundPrimaryObj && !completionSetBySCO) {
                                            completionStatus = completion.equals("not attempted") ? "incomplete" : completion;
                                            completionSetBySCO = dmInfo.mSetBySCO;
                                        } else {
                                            theSequencer.setAttemptObjCompletionStatus(iActivityID, objID, completion);
                                        }
                                    } else {
                                        theSequencer.clearAttemptObjCompletionStatus(iActivityID, objID);
                                    }
                                    dmInfo = new DMProcessingInfo();
                                    objScore = "";
                                    obj = "cmi.objectives." + i + ".progress_measure";
                                    err = DMInterface.processGetValue(obj, true, scoData, dmInfo);
                                    if (err == 0) {
                                        objScore = dmInfo.mValue;
                                    }
                                    if (!objScore.equals("") && !objScore.equals("unknown")) {
                                        try {
                                            normalScore = Double.parseDouble(objScore);
                                            if (foundPrimaryObj && progressMeasure == null) {
                                                progressMeasure = objScore;
                                                break block55;
                                            }
                                            theSequencer.setAttemptObjProgressMeasure(iActivityID, objID, normalScore);
                                        }
                                        catch (NumberFormatException e) {
                                            logger.severe("  ::--> ERROR: Invalid min score");
                                            logger.severe("  ::  " + normalScore);
                                            logger.severe(e.toString());
                                            e.printStackTrace();
                                        }
                                    } else {
                                        theSequencer.clearAttemptObjProgressMeasure(iActivityID, objID);
                                    }
                                }
                                this.setObjectiveValues(theSequencer, logger, iActivityID, objID, scoData, i);
                            }
                            act.primaryProgressSetBySCO(completionSetBySCO);
                            theSequencer.setAttemptProgressStatus(iActivityID, completionStatus);
                            if (progressMeasure != null) {
                                theSequencer.setAttemptProgressMeasure(iActivityID, progressMeasure);
                            }
                            theSequencer.reportSuspension(iActivityID, scoEntry.equals("resume"));
                            if (masteryStatus.equals("passed")) {
                                theSequencer.setAttemptObjSatisfied(iActivityID, this.mPRIMARY_OBJ_ID, "satisfied");
                            } else if (masteryStatus.equals("failed")) {
                                theSequencer.setAttemptObjSatisfied(iActivityID, this.mPRIMARY_OBJ_ID, "notSatisfied");
                            } else if (masterySetBySCO) {
                                act.primaryStatusSetBySCO(masterySetBySCO);
                                theSequencer.setAttemptObjSatisfied(iActivityID, this.mPRIMARY_OBJ_ID, "unknown");
                                Vector globs = act.getObjIDs(this.mPRIMARY_OBJ_ID, false);
                                if (globs != null) {
                                    for (int w = 0; w < globs.size(); ++w) {
                                        ADLSeqUtilities.setGlobalObjSatisfied((String)globs.get(w), iUserID, act.getScopeID(), ADLTracking.TRACK_UNKNOWN);
                                    }
                                }
                            }
                            if (score.equals("") || score.equals("unknown")) break block58;
                            try {
                                normalScore = new Double(score);
                                theSequencer.setAttemptObjMeasure(iActivityID, this.mPRIMARY_OBJ_ID, normalScore);
                            }
                            catch (Exception e) {
                                logger.severe("  ::--> ERROR: Invalid score");
                                logger.severe("  ::  " + normalScore);
                                logger.severe(e.toString());
                                e.printStackTrace();
                            }
                            break block59;
                        }
                        if (setPrimaryObjScore) break block59;
                        theSequencer.clearAttemptObjMeasure(iActivityID, this.mPRIMARY_OBJ_ID);
                        break block59;
                    }
                    err = DMInterface.processGetValue("cmi.objectives._count", true, scoData, dmInfo);
                    Integer size = new Integer(dmInfo.mValue);
                    int numObjs = size;
                    for (int i = 0; i < numObjs; ++i) {
                        logger.info("CMISerlet - IN MAP OBJ LOOP - tracking == false");
                        String objID = new String("");
                        String objMS = new String("");
                        String objScore = new String("");
                        String obj = new String("");
                        obj = "cmi.objectives." + i + ".id";
                        err = DMInterface.processGetValue(obj, true, scoData, dmInfo);
                        objID = dmInfo.mValue;
                        this.setObjectiveValues(theSequencer, logger, iActivityID, objID, scoData, i);
                    }
                }
                iResponse.mValidRequests = new ADLValidRequests();
                theSequencer.getValidRequests(iResponse.mValidRequests);
                logger.info("Sequencer is initialized and statuses have been set");
                logger.info("Now re-serialize the file");
                FileOutputStream fo = new FileOutputStream(actFile);
                ObjectOutputStream outFile = new ObjectOutputStream(fo);
                SeqActivityTree theTempTree = theSequencer.getActivityTree();
                theTempTree.clearSessionState();
                outFile.writeObject(theTempTree);
                outFile.close();
            }
            FileOutputStream fo = new FileOutputStream(iScoFile);
            ObjectOutputStream outFile = new ObjectOutputStream(fo);
            outFile.writeObject(iRequest.mActivityData);
            outFile.close();
            fo.close();
        }
        catch (FileNotFoundException fnfe) {
            logger.severe(fnfe.toString());
            fnfe.printStackTrace();
        }
        catch (IOException ioe) {
            logger.severe(ioe.toString());
            ioe.printStackTrace();
        }
        catch (ClassNotFoundException cnfe) {
            logger.severe(cnfe.toString());
            cnfe.printStackTrace();
        }
        return iResponse;
    }

    private void setObjectiveValues(ADLSequencer ioSequencer, Logger ioLogger, String iActivityID, String iObjID, SCODataManager ioScoData, int iIndex) {
        DMProcessingInfo dmInfo = new DMProcessingInfo();
        String objScore = "";
        String obj = "cmi.objectives." + iIndex + ".score.raw";
        int err = DMInterface.processGetValue(obj, true, ioScoData, dmInfo);
        if (err == 0) {
            objScore = dmInfo.mValue;
        }
        double normalScore = -999.0;
        if (!objScore.equals("") && !objScore.equals("unknown")) {
            try {
                normalScore = Double.parseDouble(objScore);
                ioSequencer.setAttemptObjRawScore(iActivityID, iObjID, normalScore);
            }
            catch (NumberFormatException e) {
                ioLogger.severe("  ::--> ERROR: Invalid raw score");
                ioLogger.severe("  ::  " + normalScore);
                ioLogger.severe(e.toString());
                e.printStackTrace();
            }
        } else {
            ioSequencer.clearAttemptObjRawScore(iActivityID, iObjID);
        }
        dmInfo = new DMProcessingInfo();
        objScore = "";
        obj = "cmi.objectives." + iIndex + ".score.min";
        err = DMInterface.processGetValue(obj, true, ioScoData, dmInfo);
        if (err == 0) {
            objScore = dmInfo.mValue;
        }
        if (!objScore.equals("") && !objScore.equals("unknown")) {
            try {
                normalScore = Double.parseDouble(objScore);
                ioSequencer.setAttemptObjMinScore(iActivityID, iObjID, normalScore);
            }
            catch (NumberFormatException e) {
                ioLogger.severe("  ::--> ERROR: Invalid min score");
                ioLogger.severe("  ::  " + normalScore);
                ioLogger.severe(e.toString());
                e.printStackTrace();
            }
        } else {
            ioSequencer.clearAttemptObjMinScore(iActivityID, iObjID);
        }
        dmInfo = new DMProcessingInfo();
        objScore = "";
        obj = "cmi.objectives." + iIndex + ".score.max";
        err = DMInterface.processGetValue(obj, true, ioScoData, dmInfo);
        if (err == 0) {
            objScore = dmInfo.mValue;
        }
        if (!objScore.equals("") && !objScore.equals("unknown")) {
            try {
                normalScore = Double.parseDouble(objScore);
                ioSequencer.setAttemptObjMaxScore(iActivityID, iObjID, normalScore);
            }
            catch (NumberFormatException e) {
                ioLogger.severe("  ::--> ERROR: Invalid min score");
                ioLogger.severe("  ::  " + normalScore);
                ioLogger.severe(e.toString());
                e.printStackTrace();
            }
        } else {
            ioSequencer.clearAttemptObjMaxScore(iActivityID, iObjID);
        }
    }

    private void initializeObjectives(SCODataManager ioSCOData, ADLObjStatus ioObjStatus, int iIndex) {
        Double norm;
        String obj = "cmi.objectives." + iIndex + ".id";
        int err = DMInterface.processSetValue(obj, ioObjStatus.mObjID, true, ioSCOData);
        obj = "cmi.objectives." + iIndex + ".success_status";
        if (ioObjStatus.mStatus.equalsIgnoreCase("satisfied")) {
            err = DMInterface.processSetValue(obj, "passed", true, ioSCOData);
        } else if (ioObjStatus.mStatus.equalsIgnoreCase("notSatisfied")) {
            err = DMInterface.processSetValue(obj, "failed", true, ioSCOData);
        }
        obj = "cmi.objectives." + iIndex + ".completion_status";
        err = DMInterface.processSetValue(obj, ioObjStatus.mCompletionStatus, true, ioSCOData);
        obj = "cmi.objectives." + iIndex + ".score.scaled";
        if (ioObjStatus.mHasMeasure) {
            norm = new Double(ioObjStatus.mMeasure);
            err = DMInterface.processSetValue(obj, norm.toString(), true, ioSCOData);
        }
        obj = "cmi.objectives." + iIndex + ".score.raw";
        if (ioObjStatus.mHasRawScore) {
            norm = new Double(ioObjStatus.mRawScore);
            err = DMInterface.processSetValue(obj, norm.toString(), true, ioSCOData);
        }
        obj = "cmi.objectives." + iIndex + ".score.min";
        if (ioObjStatus.mHasMinScore) {
            norm = new Double(ioObjStatus.mMinScore);
            err = DMInterface.processSetValue(obj, norm.toString(), true, ioSCOData);
        }
        obj = "cmi.objectives." + iIndex + ".score.max";
        if (ioObjStatus.mHasMaxScore) {
            norm = new Double(ioObjStatus.mMaxScore);
            err = DMInterface.processSetValue(obj, norm.toString(), true, ioSCOData);
        }
        obj = "cmi.objectives." + iIndex + ".progress_measure";
        if (ioObjStatus.mHasProgressMeasure) {
            norm = new Double(ioObjStatus.mProgressMeasure);
            err = DMInterface.processSetValue(obj, norm.toString(), true, ioSCOData);
        }
    }

    private void populateMap(SCODataManager iSCOData, SeqActivity iSeqActivity) {
        if (iSeqActivity != null && SeqActivityTree.dsMap != null) {
            List dataStores = iSeqActivity.getDataStores();
            for (int i = 0; i < dataStores.size(); ++i) {
                SeqActivity.DataStore ds = (SeqActivity.DataStore)dataStores.get(i);
                if (!ds.isWriteable()) continue;
                String val = this.getValue(iSCOData, ds.getId());
                SeqActivityTree.dsMap.put(ds, val);
            }
        }
    }

    private String getValue(SCODataManager iSCOData, String iId) {
        String returnthis = null;
        DMProcessingInfo dminfo = new DMProcessingInfo();
        iSCOData.getValue(new DMRequest("adl.data._count"), dminfo);
        int count = Integer.parseInt(dminfo.mValue);
        for (int i = 0; i < count; ++i) {
            dminfo = new DMProcessingInfo();
            iSCOData.getValue(new DMRequest("adl.data." + i + ".id"), dminfo);
            if (!iId.equals(dminfo.mValue)) continue;
            dminfo = new DMProcessingInfo();
            iSCOData.getValue(new DMRequest("adl.data." + i + ".store", true, false), dminfo);
            returnthis = dminfo.mValue;
            break;
        }
        return returnthis;
    }

    private void restoreDataStores(SCODataManager ioSCOData, SeqActivity iSeqActivity) {
        List dataStores = iSeqActivity.getDataStores();
        this.initializeDataStores(ioSCOData, dataStores);
        for (int i = 0; i < dataStores.size(); ++i) {
            if (SeqActivityTree.dsMap.get(dataStores.get(i)) == null) continue;
            ioSCOData.setValue(new DMRequest("adl.data." + i + ".store", (String)SeqActivityTree.dsMap.get(dataStores.get(i)), true));
        }
    }

    private void initializeDataStores(SCODataManager ioSCOData, List iDataStores) {
        if (SeqActivityTree.dsMap == null) {
            SeqActivityTree.dsMap = new HashMap();
        }
        for (int i = 0; i < iDataStores.size(); ++i) {
            SeqActivity.DataStore ds = (SeqActivity.DataStore)iDataStores.get(i);
            ioSCOData.setValue(new DMRequest("adl.data." + i + ".id", ds.getId(), true));
            ioSCOData.setValue(new DMRequest("adl.data." + i + ".store._access", ds.isReadable() + "<>" + ds.isWriteable(), true));
            if (SeqActivityTree.dsMap.containsKey(ds)) continue;
            SeqActivityTree.dsMap.put(ds, null);
        }
    }

    private void readDataStores(SCODataManager iSCOData, SeqActivity iSeqActivity) throws FileNotFoundException, IOException, ClassNotFoundException {
        FileInputStream fin = new FileInputStream(SeqActivityTree.dataStoreLoc);
        ObjectInputStream oin = new ObjectInputStream(fin);
        SeqActivityTree.dsMap = (HashMap)oin.readObject();
        this.restoreDataStores(iSCOData, iSeqActivity);
        oin.close();
        fin.close();
    }
}

