/*
 * Decompiled with CFR 0.152.
 */
package org.adl.samplerte.server;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.adl.samplerte.server.CourseData;
import org.adl.samplerte.server.CourseService;
import org.adl.samplerte.server.ObjectivesData;
import org.adl.samplerte.server.SCOData;
import org.adl.samplerte.server.UserService;
import org.adl.util.decode.decodeHandler;
import org.adl.validator.util.ResultCollection;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.XMLOutputter;

public class LMSCourseAdmin
extends HttpServlet {
    private static final String DSP_COURSES = "/admin/dsp_courses.jsp";
    private static final String DSP_SCOS = "/admin/dsp_scos.jsp";
    private static final String DSP_SCO = "/admin/dsp_comments.jsp";
    private static final String DSP_OUTCOME = "/admin/dsp_outcome.jsp";
    private static final String DSP_MNG_COURSE = "/runtime/LMSHome.jsp";
    private static final String DSP_SELECTCOURSE = "/runtime/dsp_selectCourse.jsp";
    private static final String DSP_VIEWSTATUS = "/runtime/dsp_viewStatus.jsp";
    private static final String DSP_CREATEOBJ = "/admin/dsp_createObjective.jsp";
    private static final String DSP_SELECTUSER = "/admin/dsp_selectUser.jsp";
    private static final String DSP_SELECTCOURSEOBJ = "/admin/dsp_selectCourseObj.jsp";
    private static final String DSP_OBJECTIVEADMIN = "/admin/dsp_objectivesAdmin.jsp";
    private static final String IMPORT_RESULTS = "/import/dsp_importResults.jsp";
    private List mUserSettings = new ArrayList();

    @Override
    public void doPost(HttpServletRequest iRequest, HttpServletResponse oResponse) {
        this.processRequest(iRequest, oResponse);
    }

    @Override
    public void doGet(HttpServletRequest iRequest, HttpServletResponse oResponse) {
        if (iRequest.getParameter("type").equals("status")) {
            CourseData cd = new CourseService().showCourseStatus(iRequest.getParameter("courseID"), iRequest.getParameter("userID"));
            try {
                oResponse.setContentType("text/xml");
                Element root = new Element("courseData");
                Element satisfied = new Element("satisfied").setText(cd.mSatisfied == null ? "unknown" : cd.mSatisfied);
                Element measure = new Element("measure").setText(cd.mMeasure == null ? "unknown" : cd.mMeasure);
                Element completed = new Element("completed").setText(cd.mCompleted == null ? "unknown" : cd.mCompleted);
                Element progmeasure = new Element("progmeasure").setText(cd.mProgMeasure == null ? "unknown" : cd.mProgMeasure);
                root.addContent(satisfied);
                root.addContent(measure);
                root.addContent(completed);
                root.addContent(progmeasure);
                Document cdxml = new Document(root);
                XMLOutputter out = new XMLOutputter();
                out.output(cdxml, (Writer)oResponse.getWriter());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else if (iRequest.getParameter("type").equals("sessionInfo")) {
            String userID = iRequest.getParameter("userID");
            if (userID == null) {
                return;
            }
            if (iRequest.getParameter("adminDisplayStatus") != null) {
                this.updateAdminTableSettings(userID, iRequest.getParameter("adminDisplayStatus"));
            } else if (iRequest.getParameter("regDisplayStatus") != null) {
                this.updateRegTableSettings(userID, iRequest.getParameter("regDisplayStatus"));
            } else if (iRequest.getParameter("unregDisplayStatus") != null) {
                this.updateUnregTableSettings(userID, iRequest.getParameter("unregDisplayStatus"));
            }
        } else {
            this.processRequest(iRequest, oResponse);
        }
    }

    public void processRequest(HttpServletRequest iRequest, HttpServletResponse oResponse) {
        String userID = "";
        String courseID = "";
        String user = "";
        String reqOp = "";
        String result = "";
        try {
            iRequest.setCharacterEncoding("utf-8");
            oResponse.setCharacterEncoding("utf-8");
        }
        catch (Exception e) {
            System.out.println("LMSCourseAdmin:processRequest - encoding exception");
            e.printStackTrace();
        }
        String sType = iRequest.getParameter("type");
        if (sType == null) {
            sType = "999";
        }
        int type = Integer.parseInt(sType);
        switch (type) {
            case 1: {
                CourseService courseService = new CourseService();
                Vector courses = new Vector();
                courses = courseService.getCourses("timestamp", "DESC");
                String setProcess = iRequest.getParameter("setProcess");
                iRequest.setAttribute("setProcess", setProcess);
                iRequest.setAttribute("courses", courses);
                this.launchView(DSP_COURSES, iRequest, oResponse);
                break;
            }
            case 2: {
                CourseService courseService = new CourseService();
                Vector scos = new Vector();
                scos = courseService.getSCOs(iRequest.getParameter("courseID"));
                iRequest.setAttribute("scos", scos);
                this.launchView(DSP_SCOS, iRequest, oResponse);
                break;
            }
            case 3: {
                CourseService courseService = new CourseService();
                SCOData sco = new SCOData();
                int id = Integer.parseInt(iRequest.getParameter("scoID"));
                sco = courseService.getSCO(id);
                iRequest.setAttribute("sco", sco);
                this.launchView(DSP_SCO, iRequest, oResponse);
                break;
            }
            case 4: {
                CourseService courseService = new CourseService();
                result = "false";
                reqOp = "Updating Comments from LMS";
                int act = Integer.parseInt(iRequest.getParameter("scoID"));
                String txt = iRequest.getParameter("comments");
                String update = iRequest.getParameter("update");
                String locations = iRequest.getParameter("locations");
                result = courseService.updateSCO(act, txt, update, locations);
                iRequest.setAttribute("reqOp", reqOp);
                iRequest.setAttribute("result", result);
                this.launchView(DSP_OUTCOME, iRequest, oResponse);
                break;
            }
            case 30: 
            case 31: {
                CourseService courseService = new CourseService();
                result = "false";
                reqOp = "Delete course";
                Vector<String> thiscourseList = new Vector<String>();
                String prefix = type == 30 ? "UN_" : "RE_";
                Enumeration enumCourseList = iRequest.getParameterNames();
                while (enumCourseList.hasMoreElements()) {
                    String temp = enumCourseList.nextElement().toString();
                    if (!temp.startsWith(prefix)) continue;
                    thiscourseList.add(temp);
                }
                result = courseService.deleteCourse(thiscourseList);
                Vector courses = new Vector();
                userID = iRequest.getParameter("userID");
                UserSettings userSettings = this.getUserSettings(userID);
                courses = courseService.getManagedCourses(userID, userSettings.mRegSortType, userSettings.mRegSortOrder, userSettings.mUnregSortType, userSettings.mUnregSortOrder);
                iRequest.setAttribute("courses", courses);
                iRequest.setAttribute("reqOp", reqOp);
                iRequest.setAttribute("result", result);
                iRequest.setAttribute("showAdminTable", userSettings.mAdminDisplayStatus);
                iRequest.setAttribute("showRegTable", userSettings.mRegDisplayStatus);
                iRequest.setAttribute("showUnregTable", userSettings.mUnregDisplayStatus);
                this.launchView(DSP_MNG_COURSE, iRequest, oResponse);
                break;
            }
            case 11: {
                CourseService courseService = new CourseService();
                userID = iRequest.getParameter("userID");
                Vector courses = new Vector();
                UserSettings userSettings = this.getUserSettings(userID);
                courses = courseService.getManagedCourses(userID, userSettings.mRegSortType, userSettings.mRegSortOrder, userSettings.mUnregSortType, userSettings.mUnregSortOrder);
                iRequest.setAttribute("courses", courses);
                iRequest.setAttribute("showAdminTable", userSettings.mAdminDisplayStatus);
                iRequest.setAttribute("showRegTable", userSettings.mRegDisplayStatus);
                iRequest.setAttribute("showUnregTable", userSettings.mUnregDisplayStatus);
                this.launchView(DSP_MNG_COURSE, iRequest, oResponse);
                break;
            }
            case 12: 
            case 120: {
                result = "false";
                reqOp = "Register Course";
                CourseService courseService = new CourseService();
                Vector<String> courseList = new Vector<String>();
                String prefix = type == 12 ? "UN_" : "RE_";
                Enumeration enumCourses = iRequest.getParameterNames();
                String path = iRequest.getParameter("path");
                userID = iRequest.getParameter("userID");
                while (enumCourses.hasMoreElements()) {
                    String temp = enumCourses.nextElement().toString();
                    if (!temp.startsWith(prefix)) continue;
                    courseList.add(temp);
                }
                result = courseService.updateRegCourses(courseList, path, userID);
                Vector courses = new Vector();
                UserSettings userSettings = this.getUserSettings(userID);
                courses = courseService.getManagedCourses(userID, userSettings.mRegSortType, userSettings.mRegSortOrder, userSettings.mUnregSortType, userSettings.mUnregSortOrder);
                iRequest.setAttribute("courses", courses);
                iRequest.setAttribute("reqOp", reqOp);
                iRequest.setAttribute("result", result);
                iRequest.setAttribute("showAdminTable", userSettings.mAdminDisplayStatus);
                iRequest.setAttribute("showRegTable", userSettings.mRegDisplayStatus);
                iRequest.setAttribute("showUnregTable", userSettings.mUnregDisplayStatus);
                this.launchView(DSP_MNG_COURSE, iRequest, oResponse);
                break;
            }
            case 32: {
                result = "false";
                reqOp = "Reset Course";
                CourseService courseService = new CourseService();
                Vector<String> courseList = new Vector<String>();
                String prefix = "RE_";
                Enumeration enumCourses = iRequest.getParameterNames();
                String path = iRequest.getParameter("path");
                userID = iRequest.getParameter("userID");
                while (enumCourses.hasMoreElements()) {
                    String temp = enumCourses.nextElement().toString();
                    if (!temp.startsWith(prefix)) continue;
                    courseList.add(temp);
                }
                result = courseService.resetCourses(courseList, path, userID);
                Vector courses = new Vector();
                UserSettings userSettings = this.getUserSettings(userID);
                courses = courseService.getManagedCourses(userID, userSettings.mRegSortType, userSettings.mRegSortOrder, userSettings.mUnregSortType, userSettings.mUnregSortOrder);
                iRequest.setAttribute("reqOp", reqOp);
                iRequest.setAttribute("result", result);
                iRequest.setAttribute("courses", courses);
                iRequest.setAttribute("showAdminTable", userSettings.mAdminDisplayStatus);
                iRequest.setAttribute("showRegTable", userSettings.mRegDisplayStatus);
                iRequest.setAttribute("showUnregTable", userSettings.mUnregDisplayStatus);
                this.launchView(DSP_MNG_COURSE, iRequest, oResponse);
                break;
            }
            case 33: {
                CourseService courseService = new CourseService();
                Vector courseList = new Vector();
                String sortType = iRequest.getParameter("sortType");
                userID = iRequest.getParameter("userID");
                this.updateSortSettings(userID, sortType);
                Vector courses = new Vector();
                UserSettings userSettings = this.getUserSettings(userID);
                courses = courseService.getManagedCourses(userID, userSettings.mRegSortType, userSettings.mRegSortOrder, userSettings.mUnregSortType, userSettings.mUnregSortOrder);
                iRequest.setAttribute("courses", courses);
                iRequest.setAttribute("showAdminTable", userSettings.mAdminDisplayStatus);
                iRequest.setAttribute("showRegTable", userSettings.mRegDisplayStatus);
                iRequest.setAttribute("showUnregTable", userSettings.mUnregDisplayStatus);
                this.launchView(DSP_MNG_COURSE, iRequest, oResponse);
                break;
            }
            case 14: {
                CourseService courseService = new CourseService();
                userID = iRequest.getParameter("userId");
                String caller = iRequest.getParameter("caller");
                Vector courses = new Vector();
                courses = courseService.getCourses(userID, "timestamp", "DESC");
                iRequest.setAttribute("courses", courses);
                iRequest.setAttribute("userId", userID);
                iRequest.setAttribute("caller", caller);
                this.launchView(DSP_SELECTCOURSE, iRequest, oResponse);
                break;
            }
            case 15: {
                CourseService courseService = new CourseService();
                courseID = iRequest.getParameter("courseID");
                userID = iRequest.getParameter("userID");
                CourseData cd = courseService.showCourseStatus(courseID, userID);
                String name = courseService.getName(userID);
                iRequest.setAttribute("name", name);
                iRequest.setAttribute("status", cd);
                this.launchView(DSP_VIEWSTATUS, iRequest, oResponse);
                break;
            }
            case 16: {
                CourseService courseService = new CourseService();
                reqOp = "Clear Database";
                String path = iRequest.getParameter("path");
                userID = iRequest.getParameter("userID");
                result = courseService.clearDatabase(path);
                Vector courses = new Vector();
                UserSettings userSettings = this.getUserSettings(userID);
                courses = courseService.getManagedCourses(userID, userSettings.mRegSortType, userSettings.mRegSortOrder, userSettings.mUnregSortType, userSettings.mUnregSortOrder);
                iRequest.setAttribute("result", result);
                iRequest.setAttribute("reqOp", reqOp);
                iRequest.setAttribute("courses", courses);
                iRequest.setAttribute("showAdminTable", userSettings.mAdminDisplayStatus);
                iRequest.setAttribute("showRegTable", userSettings.mRegDisplayStatus);
                iRequest.setAttribute("showUnregTable", userSettings.mUnregDisplayStatus);
                this.launchView(DSP_MNG_COURSE, iRequest, oResponse);
                break;
            }
            case 17: {
                user = iRequest.getParameter("user");
                UserService userService = new UserService();
                Vector users = userService.getUsers(true);
                String objErr = "";
                iRequest.setAttribute("objErr", objErr);
                iRequest.setAttribute("users", users);
                iRequest.setAttribute("user", user);
                this.launchView(DSP_CREATEOBJ, iRequest, oResponse);
                break;
            }
            case 18: {
                UserService userService = new UserService();
                Vector users = userService.getUsers(true);
                String setOption = iRequest.getParameter("setOption");
                iRequest.setAttribute("setOption", setOption);
                iRequest.setAttribute("users", users);
                this.launchView(DSP_SELECTUSER, iRequest, oResponse);
                break;
            }
            case 19: {
                reqOp = "Add Objective";
                UserService userService = new UserService();
                CourseService courseService = new CourseService();
                ObjectivesData objData = new ObjectivesData();
                objData.mUserID = iRequest.getParameter("userID");
                objData.mObjectiveID = decodeHandler.processWhitespace(iRequest.getParameter("objectiveID"));
                objData.mSatisfied = iRequest.getParameter("satisfied");
                objData.mMeasure = iRequest.getParameter("measure");
                objData.mRawScore = iRequest.getParameter("rawscore");
                objData.mMinScore = iRequest.getParameter("minscore");
                objData.mMaxScore = iRequest.getParameter("maxscore");
                objData.mProgressMeasure = iRequest.getParameter("progressmeasure");
                objData.mCompletionStatus = iRequest.getParameter("completion");
                result = courseService.addObj(objData);
                Vector users = userService.getUsers(true);
                if (result.equalsIgnoreCase("true")) {
                    iRequest.setAttribute("result", result);
                    iRequest.setAttribute("reqOp", reqOp);
                    this.launchView(DSP_OUTCOME, iRequest, oResponse);
                    break;
                }
                iRequest.setAttribute("users", users);
                iRequest.setAttribute("userID", objData.mUserID);
                iRequest.setAttribute("objID", objData.mObjectiveID);
                iRequest.setAttribute("satisfied", objData.mSatisfied);
                iRequest.setAttribute("measure", objData.mMeasure);
                iRequest.setAttribute("rawscore", objData.mRawScore);
                iRequest.setAttribute("minscore", objData.mMinScore);
                iRequest.setAttribute("maxscore", objData.mMaxScore);
                iRequest.setAttribute("progressmeasure", objData.mProgressMeasure);
                iRequest.setAttribute("completion", objData.mCompletionStatus);
                iRequest.setAttribute("objErr", "dupobjid");
                this.launchView(DSP_CREATEOBJ, iRequest, oResponse);
                break;
            }
            case 20: {
                user = iRequest.getParameter("user");
                CourseService courseService = new CourseService();
                Vector courses = new Vector();
                courses = courseService.getCourses(user, "timestamp", "DESC");
                iRequest.setAttribute("courses", courses);
                iRequest.setAttribute("user", user);
                this.launchView(DSP_SELECTCOURSEOBJ, iRequest, oResponse);
                break;
            }
            case 21: {
                String course = iRequest.getParameter("course");
                user = iRequest.getParameter("user");
                CourseService courseService = new CourseService();
                Vector objectives = courseService.getObjs(course, user);
                objectives = courseService.getGlobalObjs(user, objectives);
                iRequest.setAttribute("objs", objectives);
                this.launchView(DSP_OBJECTIVEADMIN, iRequest, oResponse);
                break;
            }
            case 22: {
                reqOp = "Edit Objectives";
                Vector<String> requestList = new Vector<String>();
                Enumeration requestNames = iRequest.getParameterNames();
                while (requestNames.hasMoreElements()) {
                    String paramName = (String)requestNames.nextElement();
                    if (paramName.equals("submit") || paramName.equals("type")) continue;
                    String paramValue = iRequest.getParameter(paramName);
                    String param = paramName + ":" + paramValue;
                    requestList.add(param);
                }
                CourseService courseService = new CourseService();
                result = courseService.editObjs(requestList);
                iRequest.setAttribute("result", result);
                iRequest.setAttribute("reqOp", reqOp);
                this.launchView(DSP_OUTCOME, iRequest, oResponse);
                break;
            }
            case 23: {
                String sessionID = iRequest.getParameter("sessID");
                ArrayList<Object> resultList = new ArrayList<Object>();
                String courseFileName = "";
                String webPath = this.getServletConfig().getServletContext().getRealPath("/");
                CourseService courseService = new CourseService();
                ResultCollection validationResult = courseService.importCourse(iRequest, webPath, sessionID);
                courseFileName = courseService.getCourseFileName();
                resultList.add(courseFileName);
                resultList.add(validationResult);
                iRequest.setAttribute("result", resultList);
                iRequest.setAttribute("importAttempted", "true");
                iRequest.setAttribute("onlineValidation", courseService.isOnlineValidation());
                this.launchView(IMPORT_RESULTS, iRequest, oResponse);
                break;
            }
            case 29: {
                String mSessionID = iRequest.getParameter("sessionId");
                String validation = iRequest.getParameter("validate");
                String mWebPath = this.getServletConfig().getServletContext().getRealPath("/");
                String mDirectoryString = iRequest.getParameter("importfolder");
                String[] uploadFiles = null;
                String errorMsg = null;
                int numZipFiles = 0;
                boolean notADirectory = false;
                boolean onlineValidation = true;
                ArrayList<Object> importResultList = new ArrayList<Object>();
                String importAttempted = "false";
                File mDirectoryPath = new File(mDirectoryString);
                if (!mDirectoryPath.isDirectory()) {
                    notADirectory = true;
                } else {
                    uploadFiles = mDirectoryPath.list();
                    if (uploadFiles.length == 0) {
                        errorMsg = "The Folder That You Entered Did Not Contain Any Files.";
                        iRequest.setAttribute("errorMsg", errorMsg);
                    } else {
                        for (int i = 0; i < uploadFiles.length; ++i) {
                            String filename = uploadFiles[i];
                            if (filename.length() <= 4) continue;
                            int index = filename.length();
                            int start = index - 4;
                            String extension = filename.substring(start, index);
                            if (!(extension = extension.toLowerCase()).equals(".zip")) continue;
                            importAttempted = "true";
                            ++numZipFiles;
                            String zipFile = mDirectoryPath + File.separator + uploadFiles[i];
                            CourseService courseService = new CourseService();
                            ResultCollection multipleValidationResult = courseService.importMultipleCourses(filename, zipFile, mDirectoryPath, mWebPath, mSessionID, validation);
                            importResultList.add(filename);
                            importResultList.add(multipleValidationResult);
                            onlineValidation = courseService.isOnlineValidation();
                        }
                    }
                }
                if (notADirectory) {
                    errorMsg = "The Folder That You Entered Was Not Valid.";
                    iRequest.setAttribute("errorMsg", errorMsg);
                } else if (numZipFiles == 0) {
                    errorMsg = "The Folder That You Entered Did Not Contain Any Valid Course Files.";
                    iRequest.setAttribute("errorMsg", errorMsg);
                }
                iRequest.setAttribute("importAttempted", importAttempted);
                iRequest.setAttribute("result", importResultList);
                iRequest.setAttribute("onlineValidation", onlineValidation);
                this.launchView(IMPORT_RESULTS, iRequest, oResponse);
                break;
            }
            default: {
                System.out.println("Default Case -- LMSCourseAdmin.java -- Error");
            }
        }
    }

    private void launchView(String iJsp, HttpServletRequest iRequest, HttpServletResponse iResponse) {
        try {
            RequestDispatcher rd = this.getServletContext().getRequestDispatcher(iJsp);
            rd.forward(iRequest, iResponse);
        }
        catch (ServletException se) {
            System.out.println("LMSCourseAdmin:launchView - servlet exception");
            se.printStackTrace();
        }
        catch (IOException ioe) {
            System.out.println("LMSCourseAdmin:launchView - io exception");
            ioe.printStackTrace();
        }
    }

    private void updateAdminTableSettings(String iUserID, String iAdminDisplay) {
        UserSettings tempUserSettings = new UserSettings(iUserID, iAdminDisplay, null, null, null, null, null, null);
        for (int i = 0; i < this.mUserSettings.size(); ++i) {
            if (!((UserSettings)this.mUserSettings.get((int)i)).mUserID.equals(iUserID)) continue;
            tempUserSettings = (UserSettings)this.mUserSettings.get(i);
            this.mUserSettings.remove(i);
        }
        this.mUserSettings.add(new UserSettings(iUserID, iAdminDisplay, tempUserSettings.mRegDisplayStatus, tempUserSettings.mUnregDisplayStatus, tempUserSettings.mRegSortType, tempUserSettings.mRegSortOrder, tempUserSettings.mUnregSortType, tempUserSettings.mUnregSortOrder));
    }

    private void updateRegTableSettings(String iUserID, String iRegDisplay) {
        UserSettings tempUserSettings = new UserSettings(iUserID, null, iRegDisplay, null, null, null, null, null);
        for (int i = 0; i < this.mUserSettings.size(); ++i) {
            if (!((UserSettings)this.mUserSettings.get((int)i)).mUserID.equals(iUserID)) continue;
            tempUserSettings = (UserSettings)this.mUserSettings.get(i);
            this.mUserSettings.remove(i);
        }
        this.mUserSettings.add(new UserSettings(iUserID, tempUserSettings.mAdminDisplayStatus, iRegDisplay, tempUserSettings.mUnregDisplayStatus, tempUserSettings.mRegSortType, tempUserSettings.mRegSortOrder, tempUserSettings.mUnregSortType, tempUserSettings.mUnregSortOrder));
    }

    private void updateUnregTableSettings(String iUserID, String iUnregDisplay) {
        UserSettings tempUserSettings = new UserSettings(iUserID, null, null, iUnregDisplay, null, null, null, null);
        for (int i = 0; i < this.mUserSettings.size(); ++i) {
            if (!((UserSettings)this.mUserSettings.get((int)i)).mUserID.equals(iUserID)) continue;
            tempUserSettings = (UserSettings)this.mUserSettings.get(i);
            this.mUserSettings.remove(i);
        }
        this.mUserSettings.add(new UserSettings(iUserID, tempUserSettings.mAdminDisplayStatus, tempUserSettings.mRegDisplayStatus, iUnregDisplay, tempUserSettings.mRegSortType, tempUserSettings.mRegSortOrder, tempUserSettings.mUnregSortType, tempUserSettings.mUnregSortOrder));
    }

    private void updateSortSettings(String iUserID, String iSortType) {
        UserSettings tempUserSettings = new UserSettings(iUserID);
        for (int i = 0; i < this.mUserSettings.size(); ++i) {
            if (!((UserSettings)this.mUserSettings.get((int)i)).mUserID.equals(iUserID)) continue;
            tempUserSettings = (UserSettings)this.mUserSettings.get(i);
            this.mUserSettings.remove(i);
        }
        String sortTableName = iSortType.split("_")[0];
        String sortType = iSortType.split("_")[1];
        if (sortTableName.equals("RE")) {
            String sortOrder = tempUserSettings.mRegSortOrder.equals("DESC") ? "ASC" : "DESC";
            this.mUserSettings.add(new UserSettings(iUserID, tempUserSettings.mAdminDisplayStatus, tempUserSettings.mRegDisplayStatus, tempUserSettings.mUnregDisplayStatus, sortType, sortOrder, tempUserSettings.mUnregSortType, tempUserSettings.mUnregSortOrder));
        } else {
            String sortOrder = tempUserSettings.mUnregSortOrder.equals("DESC") ? "ASC" : "DESC";
            this.mUserSettings.add(new UserSettings(iUserID, tempUserSettings.mAdminDisplayStatus, tempUserSettings.mRegDisplayStatus, tempUserSettings.mUnregDisplayStatus, tempUserSettings.mRegSortType, tempUserSettings.mRegSortOrder, sortType, sortOrder));
        }
    }

    private UserSettings getUserSettings(String iUserID) {
        for (int i = 0; i < this.mUserSettings.size(); ++i) {
            if (!((UserSettings)this.mUserSettings.get((int)i)).mUserID.equals(iUserID)) continue;
            return (UserSettings)this.mUserSettings.get(i);
        }
        return new UserSettings(iUserID);
    }

    private class UserSettings {
        protected String mAdminDisplayStatus = "true";
        protected String mRegDisplayStatus = "true";
        protected String mUnregDisplayStatus = "true";
        protected String mUserID = "";
        protected String mRegSortType = "timestamp";
        protected String mRegSortOrder = "DESC";
        protected String mUnregSortType = "timestamp";
        protected String mUnregSortOrder = "DESC";

        public UserSettings(String iUserID) {
            this.mUserID = iUserID;
            this.mAdminDisplayStatus = "true";
            this.mRegDisplayStatus = "true";
            this.mUnregDisplayStatus = "true";
            this.mRegSortOrder = "DESC";
            this.mRegSortType = "timestamp";
            this.mUnregSortOrder = "DESC";
            this.mUnregSortType = "timestamp";
        }

        public UserSettings(String iUserID, String iAdmin, String iReg, String iUnreg, String iRegSortType, String iRegSortOrder, String iUnregSortType, String iUnregSortOrder) {
            this.mUserID = iUserID;
            this.mAdminDisplayStatus = iAdmin == null ? "true" : iAdmin;
            this.mRegDisplayStatus = iReg == null ? "true" : iReg;
            this.mUnregDisplayStatus = iUnreg == null ? "true" : iUnreg;
            this.mRegSortOrder = iRegSortOrder == null ? "DESC" : iRegSortOrder;
            this.mRegSortType = iRegSortType == null ? "timestamp" : iRegSortType;
            this.mUnregSortOrder = iUnregSortOrder == null ? "DESC" : iUnregSortOrder;
            this.mUnregSortType = iUnregSortType == null ? "timestamp" : iUnregSortType;
        }
    }
}

