/*
 * Decompiled with CFR 0.152.
 */
package org.adl.samplerte.server;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import org.adl.samplerte.server.packageimport.LMSImportHandler;
import org.adl.samplerte.server.packageimport.LaunchData;
import org.adl.samplerte.server.packageimport.ManifestHandler;
import org.adl.samplerte.server.packageimport.parsers.dom.ADLDOMParser;
import org.adl.samplerte.server.packageimport.parsers.dom.DOMTreeUtility;
import org.adl.samplerte.util.LMSDatabaseHandler;
import org.adl.samplerte.util.RTEFileHandler;
import org.adl.sequencer.ADLLaunch;
import org.adl.sequencer.ADLSeqUtilities;
import org.adl.sequencer.ADLSequencer;
import org.adl.sequencer.SeqActivityTree;
import org.adl.util.debug.DebugIndicator;
import org.adl.util.decode.decodeHandler;
import org.adl.validator.Validator;
import org.adl.validator.util.Result;
import org.adl.validator.util.ResultCollection;
import org.adl.validator.util.ValidatorMessage;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class LMSManifestHandler
implements Serializable {
    private String mCourseTitle = "";
    private String mCourseID = "";
    private String mWebPath;
    private Vector mOrganizationList;
    private Vector mLaunchDataList;
    private boolean mFileCopyResult = true;
    private boolean mLaunchableCourse = true;
    private Logger mLogger = Logger.getLogger("org.adl.util.debug.samplerte");
    private Node mManifest = null;
    private String mXSDLocation;
    private boolean mOnlineValidation = true;

    public LMSManifestHandler(String iXSDLocation) {
        this.mOrganizationList = new Vector();
        this.mLaunchDataList = new Vector();
        this.mXSDLocation = iXSDLocation;
        this.mWebPath = "";
    }

    public ResultCollection processPackage(String iFilePath, boolean iOnlineValidation) {
        this.mOnlineValidation = iOnlineValidation;
        RTEFileHandler fileHandler = new RTEFileHandler();
        ResultCollection results = new ResultCollection();
        LMSImportHandler importHandler = new LMSImportHandler();
        boolean dbUpdateResult = true;
        boolean zipExtractionResult = true;
        Document document = null;
        this.mLogger.entering("---LMSManifestHandler", "processManifest()");
        Validator scormValidator = new Validator(iFilePath, "contentaggregation", false);
        ArrayList<String> checkerList = new ArrayList<String>();
        checkerList.add("org.adl.validator.packagechecker.checks.IMSManifestAtRootChecker");
        checkerList.add("org.adl.validator.packagechecker.checks.WellformednessChecker");
        checkerList.add("org.adl.validator.packagechecker.checks.ManifestRootElementChecker");
        if (!iOnlineValidation) {
            checkerList.add("org.adl.samplerte.server.packageimport.sequencingOrderChecker.SequencingOrderChecker");
        }
        checkerList.add("org.adl.validator.packagechecker.checks.SubmanifestChecker");
        checkerList.add("org.adl.validator.packagechecker.checks.RequiredFilesChecker");
        checkerList.add("org.adl.validator.packagechecker.checks.SchemaValidationChecker");
        checkerList.add("org.adl.validator.packagechecker.checks.ResourceHrefChecker");
        checkerList.add("org.adl.validator.packagechecker.checks.ApplicationProfileChecker");
        checkerList.add("org.adl.validator.packagechecker.checks.ExcessBaggageChecker");
        scormValidator.setCheckerList(checkerList);
        scormValidator.validate();
        results = scormValidator.getResultCollection();
        boolean validationPassed = this.determineValidationStatus(results, iOnlineValidation);
        this.mLogger.info("Document parsing complete.");
        String packageLocation = "";
        String manifestFile = "";
        if (validationPassed) {
            packageLocation = LMSImportHandler.importContentPackage(this.mXSDLocation, iFilePath);
            if (packageLocation.equals("")) {
                Result zipResult = new Result();
                zipResult.setPackageCheckerPassed(false);
                String zipMessage = "Zip Extraction Error Has Occurred";
                zipResult.addPackageCheckerMessage(new ValidatorMessage(3, zipMessage));
                results.addPackageResult(zipResult);
                return results;
            }
            ADLDOMParser domParser = new ADLDOMParser();
            manifestFile = packageLocation + "\\imsmanifest.xml";
            boolean success = domParser.createDocument(manifestFile, true, false);
            if (!success) {
                Result parseResult = new Result();
                parseResult.setPackageCheckerPassed(false);
                String zipMessage = "Parser Error Has Occurred";
                parseResult.addPackageCheckerMessage(new ValidatorMessage(3, zipMessage));
                results.addPackageResult(parseResult);
                return results;
            }
            importHandler = new LMSImportHandler(domParser.getDocument());
            importHandler.applyXMLBase();
            document = importHandler.getDocument();
            this.mLaunchDataList = importHandler.getLaunchData(document, false, false);
            this.mManifest = document.getDocumentElement();
            this.mOrganizationList = this.getOrganizationList();
            dbUpdateResult = this.updateDB();
        } else {
            if (results.getPackageResult("WELLFORMEDNESS").isPackageCheckerPassed()) {
                this.mLogger.info("NOT WELL FORMED!!!");
            }
            if (results.getPackageResult("MANIFEST_AT_ROOT").isPackageCheckerPassed()) {
                this.mLogger.info("INVALID ROOT!!!");
            }
            if (results.getPackageResult("SCHEMA_VALIDATION").isPackageCheckerPassed()) {
                this.mLogger.info("NOT VALID TO SCHEMA!!!");
            }
            if (results.getPackageResult("APPLICATION_PROFILE").isPackageCheckerPassed()) {
                this.mLogger.info("NOT VALID TO APP PROFILE!!!");
            }
            if (results.getPackageResult("REQUIRED_FILES_AT_ROOT").isPackageCheckerPassed()) {
                this.mLogger.info("REQUIRED FILES DO NOT EXIST!!!");
            }
            this.mLogger.info("-----NOT CONFORMANT!!!----");
        }
        String message = "";
        Result processingResult = new Result();
        processingResult.setPackageCheckerName("PACKAGE_PROCESSING");
        if (!dbUpdateResult) {
            processingResult.setPackageCheckerPassed(false);
            message = "Database Update Error Has Occurred";
            processingResult.addPackageCheckerMessage(new ValidatorMessage(3, message));
        }
        if (!this.mFileCopyResult) {
            processingResult.setPackageCheckerPassed(false);
            message = "File Copy Error Has Occurred";
            processingResult.addPackageCheckerMessage(new ValidatorMessage(3, message));
        }
        if (!zipExtractionResult) {
            processingResult.setPackageCheckerPassed(false);
            message = "Zip Extraction Error Has Occurred";
            processingResult.addPackageCheckerMessage(new ValidatorMessage(3, message));
        }
        if (!this.mLaunchableCourse) {
            processingResult.setPackageCheckerPassed(false);
            message = "Control Modes defined in this course are not supported for launch in the SRTE";
            processingResult.addPackageCheckerMessage(new ValidatorMessage(1, message));
        }
        results.addPackageResult(processingResult);
        LMSImportHandler.cleanImportDirectory(this.mXSDLocation + File.separator + "PackageImport");
        fileHandler.deleteTempUloadFiles();
        this.mLogger.exiting("---LMSManifestHandler", "processManifest()");
        return results;
    }

    private boolean copyCourse(String iInFilePath, String iOutFilePath) {
        boolean result;
        block5: {
            result = true;
            try {
                String inDirName = iInFilePath;
                inDirName.replace('/', File.separatorChar);
                File tempFile = new File(inDirName);
                File[] fileNames = tempFile.listFiles();
                String outDirName = iOutFilePath;
                outDirName = outDirName.replace('/', File.separatorChar);
                File tempDir = new File(outDirName);
                tempDir.mkdirs();
                FileInputStream fi = null;
                FileOutputStream fo = null;
                BufferedInputStream in = null;
                BufferedOutputStream out = null;
                for (int i = 0; i < fileNames.length; ++i) {
                    int c;
                    String tempString = outDirName + File.separatorChar + fileNames[i].getName();
                    if (fileNames[i].isDirectory()) {
                        File dirToCreate = new File(tempString);
                        dirToCreate.mkdirs();
                        result = this.copyCourse(fileNames[i].getAbsolutePath(), tempString);
                        continue;
                    }
                    fi = new FileInputStream(fileNames[i]);
                    fo = new FileOutputStream(tempString);
                    in = new BufferedInputStream(fi);
                    out = new BufferedOutputStream(fo);
                    while ((c = in.read()) != -1) {
                        out.write(c);
                    }
                    in.close();
                    fi.close();
                    out.close();
                    fo.close();
                }
            }
            catch (IOException ioe) {
                result = false;
                if (!DebugIndicator.ON) break block5;
                ioe.printStackTrace();
            }
        }
        return result;
    }

    public String getCourseID() {
        return this.mCourseID;
    }

    protected Vector getOrganizationList() {
        return ManifestHandler.getOrganizationNodes(this.mManifest, false);
    }

    public Node getSeqCollection() {
        return DOMTreeUtility.getNode(this.mManifest, "sequencingCollection");
    }

    public void setCourseName(String iCourseTitle) {
        this.mCourseTitle = iCourseTitle;
    }

    public void setWebPath(String iWebPath) {
        this.mWebPath = iWebPath;
        this.mLogger.info("***MWEBPATH IS " + this.mWebPath + "***");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean updateDB() {
        boolean result;
        block43: {
            this.mLogger.entering("---LMSManifestHandler", "updateDB()  *********");
            result = true;
            try {
                Connection conn = LMSDatabaseHandler.getConnection();
                String sqlSelectCourseID = "SELECT * FROM ApplicationData WHERE dataName = ?";
                String sqlUpdateCourseID = "UPDATE ApplicationData SET numberValue = ? WHERE dataName = ?";
                String sqlUpdateCourse = "UPDATE CourseInfo SET Start = ?, TOC = ? WHERE CourseID = ?";
                String sqlInsertCourse = "INSERT INTO CourseInfo (CourseID, CourseTitle, Active, ImportDateTime) VALUES(?, ?, ?, ?)";
                String sqlInsertItem = "INSERT INTO ItemInfo (CourseID, OrganizationIdentifier, ItemIdentifier, Type, Title, Launch, ParameterString, DataFromLMS, TimeLimitAction, MinNormalizedMeasure, AttemptAbsoluteDurationLimit, CompletionThreshold, Next, Previous, Exit, ExitAll, Abandon, ResourceIdentifier, Suspend) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
                PreparedStatement stmtSelectCID = conn.prepareStatement(sqlSelectCourseID);
                PreparedStatement stmtUpdateCID = conn.prepareStatement(sqlUpdateCourseID);
                PreparedStatement stmtInsertCourse = conn.prepareStatement(sqlInsertCourse);
                PreparedStatement stmtInsertItem = conn.prepareStatement(sqlInsertItem);
                PreparedStatement stmtUpdateCourse = conn.prepareStatement(sqlUpdateCourse);
                ResultSet selectCourseIDRS = null;
                for (int j = 0; j < this.mOrganizationList.size(); ++j) {
                    PreparedStatement preparedStatement;
                    Node tempOrganization = (Node)this.mOrganizationList.elementAt(j);
                    String tempOrgIdentifier = DOMTreeUtility.getAttributeValue(tempOrganization, "identifier");
                    Node tempOrgTitleNode = DOMTreeUtility.getNode(tempOrganization, "title");
                    String tempOrgTitle = DOMTreeUtility.getNodeValue(tempOrgTitleNode);
                    PreparedStatement preparedStatement2 = stmtSelectCID;
                    synchronized (preparedStatement2) {
                        stmtSelectCID.setString(1, "nextCourseID");
                        selectCourseIDRS = stmtSelectCID.executeQuery();
                    }
                    if (selectCourseIDRS.next()) {
                        int idvalue = selectCourseIDRS.getInt("numberValue");
                        this.mCourseID = "Course-" + idvalue;
                        ++idvalue;
                        PreparedStatement preparedStatement3 = stmtUpdateCID;
                        synchronized (preparedStatement3) {
                            stmtUpdateCID.setInt(1, idvalue);
                            stmtUpdateCID.setString(2, "nextCourseID");
                            stmtUpdateCID.executeUpdate();
                        }
                        SimpleDateFormat date = new SimpleDateFormat("yyyy-MM-dd kk:mm:ss");
                        PreparedStatement preparedStatement4 = stmtInsertCourse;
                        synchronized (preparedStatement4) {
                            stmtInsertCourse.setString(1, this.mCourseID);
                            stmtInsertCourse.setString(2, tempOrgTitle);
                            stmtInsertCourse.setBoolean(3, true);
                            String temp = date.format(new Date());
                            temp = new String(temp.getBytes("UTF-16"), "UTF-16");
                            stmtInsertCourse.setString(4, temp);
                            stmtInsertCourse.executeUpdate();
                        }
                        LaunchData ld = new LaunchData();
                        for (int i = 0; i < this.mLaunchDataList.size(); ++i) {
                            ld = (LaunchData)this.mLaunchDataList.elementAt(i);
                            if (!ld.getOrganizationIdentifier().equals(tempOrgIdentifier)) continue;
                            decodeHandler decoder = new decodeHandler(ld.getLocation(), "UTF-8");
                            decoder.decodeName();
                            String alteredLocation = new String();
                            if (ld.getLocation().equals("") || ld.getLocation().startsWith("http://") || ld.getLocation().startsWith("https://")) {
                                alteredLocation = decoder.getDecodedFileName();
                                if (!ld.getParameters().equals("") && ld.getParameters() != null) {
                                    alteredLocation = this.addParameters(alteredLocation, ld.getParameters());
                                }
                            } else {
                                alteredLocation = "/adl/CourseImports/" + this.mCourseID + "/" + decoder.getDecodedFileName();
                                if (!ld.getParameters().equals("") && ld.getParameters() != null) {
                                    alteredLocation = this.addParameters(alteredLocation, ld.getParameters());
                                }
                            }
                            preparedStatement = stmtInsertItem;
                            synchronized (preparedStatement) {
                                stmtInsertItem.setString(1, this.mCourseID);
                                stmtInsertItem.setString(2, ld.getOrganizationIdentifier());
                                stmtInsertItem.setString(3, ld.getItemIdentifier());
                                stmtInsertItem.setString(4, ld.getSCORMType());
                                stmtInsertItem.setString(5, ld.getItemTitle());
                                stmtInsertItem.setString(6, alteredLocation);
                                stmtInsertItem.setString(7, ld.getParameters());
                                stmtInsertItem.setString(8, ld.getDataFromLMS());
                                stmtInsertItem.setString(9, ld.getTimeLimitAction());
                                stmtInsertItem.setString(10, ld.getMinNormalizedMeasure());
                                stmtInsertItem.setString(11, ld.getAttemptAbsoluteDurationLimit());
                                stmtInsertItem.setString(12, ld.getCompletionThreshold());
                                stmtInsertItem.setBoolean(13, ld.getContinue());
                                stmtInsertItem.setBoolean(14, ld.getPrevious());
                                stmtInsertItem.setBoolean(15, ld.getExit());
                                stmtInsertItem.setBoolean(16, ld.getExitAll());
                                stmtInsertItem.setBoolean(17, ld.getAbandon());
                                stmtInsertItem.setString(18, ld.getResourceIdentifier());
                                stmtInsertItem.setBoolean(19, ld.getSuspendAll());
                                stmtInsertItem.executeUpdate();
                                continue;
                            }
                        }
                    }
                    String copyInDirName = this.mWebPath + File.separatorChar + "PackageImport";
                    String copyOutDirName = this.mWebPath + File.separatorChar + "CourseImports" + File.separatorChar + this.mCourseID;
                    this.mFileCopyResult = this.copyCourse(copyInDirName, copyOutDirName);
                    if (!this.mFileCopyResult) {
                        String sqlDeleteCourse1 = "DELETE FROM CourseInfo WHERE CourseID = ?";
                        String sqlDeleteCourse2 = "DELETE FROM ItemInfo WHERE CourseID = ?";
                        conn = LMSDatabaseHandler.getConnection();
                        PreparedStatement stmtDeleteCourse1 = conn.prepareStatement(sqlDeleteCourse1);
                        PreparedStatement stmtDeleteCourse2 = conn.prepareStatement(sqlDeleteCourse2);
                        preparedStatement = stmtDeleteCourse1;
                        synchronized (preparedStatement) {
                            stmtDeleteCourse1.setString(1, this.mCourseID);
                            stmtDeleteCourse1.executeUpdate();
                        }
                        stmtDeleteCourse1.close();
                        preparedStatement = stmtDeleteCourse2;
                        synchronized (preparedStatement) {
                            stmtDeleteCourse2.setString(1, this.mCourseID);
                            stmtDeleteCourse2.executeUpdate();
                        }
                        stmtDeleteCourse2.close();
                    }
                    SeqActivityTree mySeqActivityTree = new SeqActivityTree();
                    String tempObjectivesGlobalToSystem = DOMTreeUtility.getAttributeValue(tempOrganization, "objectivesGlobalToSystem");
                    String tempDataScopeVal = DOMTreeUtility.getAttributeValue(tempOrganization, "sharedDataGlobalToSystem");
                    mySeqActivityTree = ADLSeqUtilities.buildActivityTree(tempOrganization, this.getSeqCollection());
                    if (tempObjectivesGlobalToSystem.equals("false")) {
                        mySeqActivityTree.setScopeID(this.mCourseID);
                    }
                    mySeqActivityTree.setCourseID(this.mCourseID);
                    mySeqActivityTree.setDataScopedForAllAttempts(tempDataScopeVal == null || !tempDataScopeVal.equals("false"));
                    String serializeFileName = this.mWebPath + "CourseImports" + File.separator + this.mCourseID + File.separator + "serialize.obj";
                    File serializeFile = new File(serializeFileName);
                    FileOutputStream outFile = new FileOutputStream(serializeFile);
                    ObjectOutputStream s = new ObjectOutputStream(outFile);
                    s.writeObject(mySeqActivityTree);
                    s.flush();
                    s.close();
                    outFile.close();
                    ADLSequencer theSequencer = new ADLSequencer();
                    ADLLaunch launch = new ADLLaunch();
                    theSequencer.setActivityTree(mySeqActivityTree);
                    launch = theSequencer.navigate(0);
                    if (this.mOnlineValidation && launch.mNavState.mTOC == null && !launch.mNavState.mStart) {
                        this.mLaunchableCourse = false;
                        String sqlDeleteCourse1 = "DELETE FROM CourseInfo WHERE CourseID = ?";
                        String sqlDeleteCourse2 = "DELETE FROM ItemInfo WHERE CourseID = ?";
                        PreparedStatement stmtDeleteCourse1 = conn.prepareStatement(sqlDeleteCourse1);
                        PreparedStatement stmtDeleteCourse2 = conn.prepareStatement(sqlDeleteCourse2);
                        PreparedStatement preparedStatement5 = stmtDeleteCourse1;
                        synchronized (preparedStatement5) {
                            stmtDeleteCourse1.setString(1, this.mCourseID);
                            stmtDeleteCourse1.executeUpdate();
                        }
                        stmtDeleteCourse1.close();
                        preparedStatement5 = stmtDeleteCourse2;
                        synchronized (preparedStatement5) {
                            stmtDeleteCourse2.setString(1, this.mCourseID);
                            stmtDeleteCourse2.executeUpdate();
                        }
                        stmtDeleteCourse2.close();
                    }
                    PreparedStatement preparedStatement6 = stmtUpdateCourse;
                    synchronized (preparedStatement6) {
                        stmtUpdateCourse.setBoolean(1, launch.mNavState.mStart);
                        stmtUpdateCourse.setBoolean(2, launch.mNavState.mTOC != null);
                        stmtUpdateCourse.setString(3, this.mCourseID);
                        stmtUpdateCourse.executeUpdate();
                        continue;
                    }
                }
                stmtSelectCID.close();
                stmtUpdateCID.close();
                stmtInsertCourse.close();
                stmtInsertItem.close();
                stmtUpdateCourse.close();
                conn.close();
            }
            catch (SQLException se) {
                result = false;
                if (DebugIndicator.ON) {
                    System.out.println(se.getSQLState());
                    System.out.println("error code: " + se.getErrorCode());
                    se.printStackTrace();
                }
            }
            catch (FileNotFoundException fne) {
                result = false;
                if (DebugIndicator.ON) {
                    fne.printStackTrace();
                }
            }
            catch (IOException ioe) {
                result = false;
                if (!DebugIndicator.ON) break block43;
                ioe.printStackTrace();
            }
        }
        return result;
    }

    public String addParameters(String iURL, String iParameters) {
        if (iURL.length() == 0 || iParameters.length() == 0) {
            return iURL;
        }
        while (iParameters.charAt(0) == '?' || iParameters.charAt(0) == '&') {
            iParameters = iParameters.substring(1);
        }
        if (iParameters.charAt(0) == '#' && (iURL.indexOf(35) != -1 || iURL.indexOf(63) != -1)) {
            return iURL;
        }
        iURL = iURL.indexOf(63) != -1 ? iURL + '&' : iURL + '?';
        iURL = iURL + iParameters;
        return iURL;
    }

    private boolean determineValidationStatus(ResultCollection iResCollection, boolean iOnline) {
        List resList = iResCollection.getPackageResultsCollection();
        Iterator resIter = resList.iterator();
        boolean validationStatus = true;
        boolean passed = true;
        Result subRes = iResCollection.getPackageResult("SUBMANIFEST");
        Result extRes = iResCollection.getPackageResult("RESOURCE_HREF");
        boolean stopImport = false;
        if (subRes != null && extRes != null) {
            stopImport = subRes.isTestStopped() || extRes.isTestStopped();
        }
        boolean bl = validationStatus = !stopImport;
        while (resIter.hasNext() && !stopImport) {
            Result tempRes = (Result)resIter.next();
            passed = !iOnline && (tempRes.getPackageCheckerName().equals("SCHEMA_VALIDATION") || tempRes.getPackageCheckerName().equals("RESOURCE_HREF")) ? true : tempRes.isPackageCheckerPassed();
            if (passed) continue;
            validationStatus = false;
        }
        return validationStatus;
    }
}

