/*
 * Decompiled with CFR 0.152.
 */
package org.adl.samplerte.server;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.adl.util.debug.DebugIndicator;

public class LMSPackageHandler {
    public static ZipFile zf;
    private static boolean _Debug;

    public static String version() {
        System.out.println("*************");
        System.out.println("in version()");
        System.out.println("*************\n");
        String versionId = new String("");
        versionId = "Version 1.03 For Live Site";
        return versionId;
    }

    public static void display(String iZipFileName) {
        if (_Debug) {
            System.out.println("*************");
            System.out.println("in display()");
            System.out.println("*************\n");
        }
        try {
            System.out.println("** " + iZipFileName + " **\n");
            System.out.println("*****************************************");
            System.out.println("The Package Contains the following files:");
            System.out.println("*****************************************\n");
            zf = new ZipFile(iZipFileName);
            Enumeration<? extends ZipEntry> entries = zf.entries();
            while (entries.hasMoreElements()) {
                System.out.println(entries.nextElement().getName());
            }
            zf.close();
        }
        catch (IOException e) {
            System.out.println("IO Exception Caught: " + e);
        }
        if (_Debug) {
            System.out.println("\n\n");
        }
    }

    public static String extract(String iZipFileName, String iExtractedFile, String iPathOfExtract) {
        String nameOfExtractedFile;
        block6: {
            if (_Debug) {
                System.out.println("***********************");
                System.out.println("in extract()           ");
                System.out.println("***********************");
                System.out.println("zip file: " + iZipFileName);
                System.out.println("file to extract: " + iExtractedFile);
            }
            nameOfExtractedFile = "";
            try {
                int len;
                String pathAndName = "";
                ZipInputStream in = new ZipInputStream(new FileInputStream(iZipFileName));
                int indexOfFileBeginning = iExtractedFile.lastIndexOf("/") + 1;
                nameOfExtractedFile = iExtractedFile.substring(indexOfFileBeginning);
                pathAndName = iPathOfExtract + "\\" + nameOfExtractedFile;
                FileOutputStream out = new FileOutputStream(pathAndName);
                byte[] buf = new byte[1024];
                boolean flag = false;
                while (!flag) {
                    ZipEntry entry = in.getNextEntry();
                    if (!entry.getName().equalsIgnoreCase(iExtractedFile)) continue;
                    if (_Debug) {
                        System.out.println("Found file to extract...  extracting to " + iPathOfExtract);
                    }
                    flag = true;
                }
                while ((len = in.read(buf)) > 0) {
                    ((OutputStream)out).write(buf, 0, len);
                }
                ((OutputStream)out).close();
                in.close();
            }
            catch (IOException e) {
                if (!_Debug) break block6;
                System.out.println("IO Exception Caught: " + e);
            }
        }
        return nameOfExtractedFile;
    }

    public static boolean findManifest(String iZipFileName) {
        boolean rtn;
        block5: {
            if (_Debug) {
                System.out.println("***********************");
                System.out.println("in findManifest()      ");
                System.out.println("***********************\n");
            }
            rtn = false;
            try {
                ZipInputStream in = new ZipInputStream(new FileInputStream(iZipFileName));
                boolean flag = false;
                while (!flag && in.available() != 0) {
                    ZipEntry entry = in.getNextEntry();
                    if (in.available() == 0 || !entry.getName().equalsIgnoreCase("imsmanifest.xml")) continue;
                    if (_Debug) {
                        System.out.println("Located manifest.... returning true");
                    }
                    flag = true;
                    rtn = true;
                }
                in.close();
            }
            catch (IOException e) {
                if (!_Debug) break block5;
                System.out.println("IO Exception Caught: " + e);
            }
        }
        return rtn;
    }

    public static boolean findMetadata(String iZipFileName) {
        boolean rtn;
        block4: {
            if (_Debug) {
                System.out.println("***********************");
                System.out.println("in findMetadata()      ");
                System.out.println("***********************\n");
            }
            rtn = false;
            String suffix = ".xml";
            try {
                ZipInputStream in = new ZipInputStream(new FileInputStream(iZipFileName));
                while (in.available() != 0) {
                    ZipEntry entry = in.getNextEntry();
                    if (in.available() == 0 || !entry.getName().endsWith(suffix)) continue;
                    rtn = true;
                    if (!_Debug) continue;
                    System.out.println("Other Metadata located... returning true");
                }
                in.close();
            }
            catch (IOException e) {
                if (!_Debug) break block4;
                System.out.println("IO Exception Caught: " + e);
            }
        }
        return rtn;
    }

    public static Vector locateMetadata(String iZipFileName) {
        Vector<String> metaDataVector;
        block6: {
            if (_Debug) {
                System.out.println("***********************");
                System.out.println("in locateMetadata()    ");
                System.out.println("***********************\n");
            }
            metaDataVector = new Vector<String>();
            String suffix = ".xml";
            try {
                ZipInputStream in = new ZipInputStream(new FileInputStream(iZipFileName));
                if (_Debug) {
                    System.out.println("Other metadata located:");
                }
                while (in.available() != 0) {
                    ZipEntry entry = in.getNextEntry();
                    if (in.available() == 0 || !entry.getName().endsWith(suffix)) continue;
                    if (_Debug) {
                        System.out.println(entry.getName());
                    }
                    metaDataVector.addElement(entry.getName());
                }
                in.close();
            }
            catch (IOException e) {
                if (!_Debug) break block6;
                System.out.println("IO Exception Caught: " + e);
            }
        }
        return metaDataVector;
    }

    public static String getListOfMetadata(String iZipFile) {
        if (_Debug) {
            System.out.println("***********************");
            System.out.println("in getListOfMetadata() ");
            System.out.println("***********************\n");
        }
        Vector mdVector = new Vector();
        mdVector = LMSPackageHandler.locateMetadata(iZipFile);
        String mdString = new String();
        mdString = mdVector.toString();
        if (_Debug) {
            System.out.println("**********************************************");
            System.out.println("in getListOfMetadata(): String is " + mdString);
            System.out.println("**********************************************\n");
        }
        return mdString;
    }

    static {
        _Debug = DebugIndicator.ON;
    }
}

