/*
 * Decompiled with CFR 0.152.
 */
package org.adl.samplerte.server;

import java.io.IOException;
import java.util.Vector;
import java.util.logging.Logger;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.adl.datamodels.datatypes.LangStringValidator;
import org.adl.datamodels.datatypes.RealRangeValidator;
import org.adl.samplerte.server.UserProfile;
import org.adl.samplerte.server.UserService;

public class LMSUserAdmin
extends HttpServlet {
    private static final String DSP_USERS = "/admin/dsp_users.jsp";
    private static final String DSP_USERPROFILE = "/admin/dsp_userProfile.jsp";
    private static final String DSP_NEWUSER = "/admin/newUser.jsp";
    private static final String DSP_OUTCOME = "/admin/dsp_outcome.jsp";
    private Logger mLogger = Logger.getLogger("org.adl.util.debug.samplerte");

    @Override
    public void doPost(HttpServletRequest iRequest, HttpServletResponse oResponse) {
        this.mLogger.entering("---LMSAdmin", "doPost()");
        this.mLogger.info("POST received by LMSAdmin");
        this.processRequest(iRequest, oResponse);
    }

    @Override
    public void doGet(HttpServletRequest iRequest, HttpServletResponse oResponse) {
        this.processRequest(iRequest, oResponse);
    }

    private void processRequest(HttpServletRequest iRequest, HttpServletResponse oResponse) {
        this.mLogger.info("LMSAdmin - Entering processRequest()");
        String reqOp = "";
        String result = "";
        try {
            iRequest.setCharacterEncoding("utf-8");
            oResponse.setCharacterEncoding("utf-8");
        }
        catch (Exception e) {
            System.out.println("LMSUserAdmin:processRequest - encoding exception");
            e.printStackTrace();
        }
        String sType = iRequest.getParameter("type");
        String caller = iRequest.getParameter("caller");
        if (sType == null) {
            sType = "999";
        }
        int type = Integer.parseInt(sType);
        switch (type) {
            case 6: {
                UserService userService = new UserService();
                UserProfile userProfile = new UserProfile();
                userProfile = userService.getUser(iRequest.getParameter("userId"));
                iRequest.setAttribute("userProfile", userProfile);
                iRequest.setAttribute("caller", caller);
                this.launchView(DSP_USERPROFILE, iRequest, oResponse);
                break;
            }
            case 5: {
                UserService userService = new UserService();
                Vector userProfiles = new Vector();
                userProfiles = userService.getUsers(true);
                String setProcess = iRequest.getParameter("setProcess");
                iRequest.setAttribute("setProcess", setProcess);
                iRequest.setAttribute("caller", caller);
                iRequest.setAttribute("userProfiles", userProfiles);
                this.launchView(DSP_USERS, iRequest, oResponse);
                break;
            }
            case 24: {
                reqOp = "new_user";
                iRequest.setAttribute("result", "true");
                iRequest.setAttribute("reqOp", reqOp);
                this.launchView(DSP_NEWUSER, iRequest, oResponse);
                break;
            }
            case 8: {
                UserService userService = new UserService();
                result = "";
                reqOp = "Add User";
                Vector currentProfiles = new Vector();
                currentProfiles = userService.getUsers(false);
                boolean duplicate = false;
                UserProfile userProfile = new UserProfile();
                userProfile.mAdmin = iRequest.getParameter("admin").equalsIgnoreCase("true");
                userProfile.mFirstName = iRequest.getParameter("firstName");
                userProfile.mLastName = iRequest.getParameter("lastName");
                userProfile.mPassword = iRequest.getParameter("password");
                userProfile.mUserID = iRequest.getParameter("userID");
                int i = 0;
                String oldID = new String();
                UserProfile iUserProfile = new UserProfile();
                while (!duplicate && i < currentProfiles.size()) {
                    iUserProfile = (UserProfile)currentProfiles.elementAt(i++);
                    oldID = iUserProfile.mUserID;
                    if (!oldID.equals(userProfile.mUserID)) continue;
                    duplicate = true;
                }
                if (duplicate) {
                    reqOp = "duplicate_user";
                    iRequest.setAttribute("result", "false");
                    iRequest.setAttribute("reqOp", reqOp);
                    iRequest.setAttribute("userProfile", userProfile);
                    this.launchView(DSP_NEWUSER, iRequest, oResponse);
                    break;
                }
                result = userService.addUser(userProfile);
                iRequest.setAttribute("result", result);
                iRequest.setAttribute("reqOp", reqOp);
                this.launchView(DSP_OUTCOME, iRequest, oResponse);
                break;
            }
            case 7: {
                boolean validationError = false;
                result = "false";
                String errorHeader = "Please correct the following fields:  ";
                String errorMsg = "";
                UserProfile userProfile = new UserProfile();
                reqOp = "Update Profile";
                userProfile.mFirstName = iRequest.getParameter("firstName");
                userProfile.mLastName = iRequest.getParameter("lastName");
                userProfile.mUserID = iRequest.getParameter("userID");
                userProfile.mAudioLevel = iRequest.getParameter("audioLevel");
                userProfile.mAudioCaptioning = iRequest.getParameter("audioCaptioning");
                userProfile.mDeliverySpeed = iRequest.getParameter("deliverySpeed");
                userProfile.mLanguage = iRequest.getParameter("language");
                userProfile.mPassword = iRequest.getParameter("password");
                String mAdminString = iRequest.getParameter("admin");
                userProfile.mAdmin = mAdminString.equals("true");
                RealRangeValidator rrv = new RealRangeValidator(new Double(0.0), null);
                if (userProfile.mAudioLevel == null || userProfile.mAudioLevel.length() == 0 || rrv.validate(userProfile.mAudioLevel) != 0) {
                    validationError = true;
                    errorMsg = errorMsg + "<br>cmi.learner_preference.audio_level must be ";
                    errorMsg = errorMsg + "a real number greater than or equal to 0.";
                }
                if (userProfile.mDeliverySpeed == null || userProfile.mDeliverySpeed.length() == 0 || rrv.validate(userProfile.mDeliverySpeed) != 0) {
                    validationError = true;
                    errorMsg = errorMsg + "<br>cmi.learner_preference.delivery_speed must";
                    errorMsg = errorMsg + " be a real number greater than or equal to 0.";
                }
                LangStringValidator lsv = new LangStringValidator();
                if (!userProfile.mLanguage.trim().equals("") && lsv.validate(userProfile.mLanguage) != 0) {
                    validationError = true;
                    errorMsg = errorMsg + "<br>cmi.learner_preference.language must be ";
                    errorMsg = errorMsg + "a valid SCORM 2004 4th Edition language type or blank.";
                }
                if (userProfile.mAudioCaptioning == null || userProfile.mAudioCaptioning.length() == 0 || userProfile.mAudioCaptioning.compareTo("0") != 0 && userProfile.mAudioCaptioning.compareTo("1") != 0 && userProfile.mAudioCaptioning.compareTo("-1") != 0) {
                    validationError = true;
                    errorMsg = errorMsg + "<br>cmi.learner_preference.audio_captioning ";
                    errorMsg = errorMsg + "can only contain the values -1, 0, 1.";
                }
                if (userProfile.mPassword == null || userProfile.mPassword.length() == 0 || userProfile.mPassword.trim().equals("")) {
                    validationError = true;
                    errorMsg = errorMsg + "<br>Password cannot be empty";
                }
                if (validationError) {
                    iRequest.setAttribute("errorMsg", errorMsg);
                    iRequest.setAttribute("errorHeader", errorHeader);
                    iRequest.setAttribute("userProfile", userProfile);
                    this.launchView(DSP_USERPROFILE, iRequest, oResponse);
                    break;
                }
                UserService userService = new UserService();
                result = userService.updateUser(userProfile);
                iRequest.setAttribute("reqOp", reqOp);
                iRequest.setAttribute("result", result);
                this.launchView(DSP_OUTCOME, iRequest, oResponse);
                break;
            }
            case 9: {
                UserService userService = new UserService();
                reqOp = "Delete user";
                String uID = iRequest.getParameter("userId");
                String delRes = userService.deleteUser(uID);
                iRequest.setAttribute("reqOp", reqOp);
                iRequest.setAttribute("result", delRes);
                this.launchView(DSP_OUTCOME, iRequest, oResponse);
                break;
            }
            default: {
                System.out.println("Default Case -- LMSUserAdmin.java -- Error");
            }
        }
    }

    private void launchView(String iJsp, HttpServletRequest iRequest, HttpServletResponse iResponse) {
        try {
            RequestDispatcher rd = this.getServletContext().getRequestDispatcher(iJsp);
            rd.forward(iRequest, iResponse);
        }
        catch (ServletException se) {
            System.out.println("LMSCourseAdmin:launchView - servlet exception");
            se.printStackTrace();
        }
        catch (IOException ioe) {
            System.out.println("LMSCourseAdmin:launchView - io exception");
            ioe.printStackTrace();
        }
    }
}

