/*
 * Decompiled with CFR 0.152.
 */
package org.adl.samplerte.server;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Vector;
import org.adl.samplerte.server.UserProfile;
import org.adl.samplerte.util.LMSDatabaseHandler;

public class UserService {
    UserService() {
    }

    public Vector getUsers(boolean iOnlyActive) {
        Vector<UserProfile> mUserVector = new Vector<UserProfile>();
        String sqlSelectUser = "SELECT * FROM UserInfo";
        if (iOnlyActive) {
            sqlSelectUser = sqlSelectUser + " WHERE Active = yes";
        }
        try {
            Connection conn = LMSDatabaseHandler.getConnection();
            PreparedStatement stmtSelectUser = conn.prepareStatement(sqlSelectUser);
            ResultSet userRS = null;
            userRS = stmtSelectUser.executeQuery();
            while (userRS.next()) {
                UserProfile mUserProfile = new UserProfile();
                mUserProfile.mUserID = userRS.getString("UserID");
                mUserProfile.mLastName = userRS.getString("LastName");
                mUserProfile.mFirstName = userRS.getString("FirstName");
                mUserVector.add(mUserProfile);
            }
            userRS.close();
            stmtSelectUser.close();
            conn.close();
        }
        catch (Exception e) {
            System.out.println("This failed in UserService::getUsers()");
            e.printStackTrace();
        }
        return mUserVector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserProfile getUser(String iUserID) {
        String sqlSelectUser = "SELECT * FROM UserInfo WHERE UserId = ?";
        UserProfile mUserProfile = new UserProfile();
        try {
            Connection conn = LMSDatabaseHandler.getConnection();
            PreparedStatement stmtSelectUser = conn.prepareStatement(sqlSelectUser);
            ResultSet userRS = null;
            PreparedStatement preparedStatement = stmtSelectUser;
            synchronized (preparedStatement) {
                stmtSelectUser.setString(1, iUserID);
                userRS = stmtSelectUser.executeQuery();
            }
            while (userRS.next()) {
                mUserProfile.mUserID = userRS.getString("UserID");
                mUserProfile.mLastName = userRS.getString("LastName");
                mUserProfile.mFirstName = userRS.getString("FirstName");
                mUserProfile.mPassword = userRS.getString("Password");
                mUserProfile.mAudioLevel = userRS.getString("AudioLevel");
                mUserProfile.mAudioCaptioning = userRS.getString("AudioCaptioning");
                mUserProfile.mDeliverySpeed = userRS.getString("DeliverySpeed");
                mUserProfile.mLanguage = userRS.getString("Language");
                mUserProfile.mAdmin = userRS.getBoolean("Admin");
            }
            userRS.close();
            stmtSelectUser.close();
            conn.close();
        }
        catch (Exception e) {
            System.out.println("Error in UserService::getUser()");
            e.printStackTrace();
        }
        return mUserProfile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String updateUser(UserProfile iUser) {
        String result = "true";
        Connection conn = LMSDatabaseHandler.getConnection();
        String sqlSetUserInfo = "UPDATE UserInfo SET Password = ?,AudioLevel = ?, AudioCaptioning = ?,DeliverySpeed = ?, Language = ?, Admin = ? WHERE UserID = ?";
        try {
            PreparedStatement stmtSetUserInfo;
            PreparedStatement preparedStatement = stmtSetUserInfo = conn.prepareStatement(sqlSetUserInfo);
            synchronized (preparedStatement) {
                stmtSetUserInfo.setString(1, iUser.mPassword);
                stmtSetUserInfo.setString(2, iUser.mAudioLevel);
                stmtSetUserInfo.setString(3, iUser.mAudioCaptioning);
                stmtSetUserInfo.setString(4, iUser.mDeliverySpeed);
                stmtSetUserInfo.setString(5, iUser.mLanguage);
                stmtSetUserInfo.setBoolean(6, iUser.mAdmin);
                stmtSetUserInfo.setString(7, iUser.mUserID);
                stmtSetUserInfo.executeUpdate();
            }
            conn.close();
        }
        catch (Exception e) {
            System.out.println("error in db update in UserService::updateUser()");
            result = "false";
            e.printStackTrace();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String addUser(UserProfile iUser) {
        String result = "true";
        String sqlInsertUserInfo = "INSERT INTO UserInfo VALUES (?, ?, ?, ?, ?,'1','1','0','1','')";
        try {
            PreparedStatement stmtInsertUserInfo;
            Connection conn = LMSDatabaseHandler.getConnection();
            PreparedStatement preparedStatement = stmtInsertUserInfo = conn.prepareStatement(sqlInsertUserInfo);
            synchronized (preparedStatement) {
                stmtInsertUserInfo.setString(1, iUser.mUserID);
                stmtInsertUserInfo.setString(2, iUser.mLastName);
                stmtInsertUserInfo.setString(3, iUser.mFirstName);
                stmtInsertUserInfo.setBoolean(4, iUser.mAdmin);
                stmtInsertUserInfo.setString(5, iUser.mPassword);
                stmtInsertUserInfo.executeUpdate();
            }
            stmtInsertUserInfo.close();
            conn.close();
        }
        catch (Exception e) {
            System.out.println("error updating db in UserService::addUser()");
            result = "false";
            e.printStackTrace();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String deleteUser(String iUser) {
        String result = "true";
        try {
            PreparedStatement stmtUpdateUser;
            Connection conn = LMSDatabaseHandler.getConnection();
            String sqlUpdateUser = "UPDATE UserInfo set Active = no where UserID = ?";
            PreparedStatement preparedStatement = stmtUpdateUser = conn.prepareStatement(sqlUpdateUser);
            synchronized (preparedStatement) {
                stmtUpdateUser.setString(1, iUser);
                stmtUpdateUser.executeUpdate();
            }
            stmtUpdateUser.close();
            conn.close();
        }
        catch (Exception e) {
            result = "false";
            System.out.println("error updating db in UserService::deleteUser()");
            e.printStackTrace();
        }
        return result;
    }
}

